package cn.gtmap.gtc.common.properties.search;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;


/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @date V1.0, 2019/6/5 20:15
 * @description
 */
@Configuration
@ConfigurationProperties(prefix = "spring.elasticsearch")
public class ElasticProperties {

    private String username;

    private String password;

    private String hosts;

    private String templateLoaderPath = "classpath:dsl/*Dsl.xml";

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHosts() {
        return hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getTemplateLoaderPath() {
        return templateLoaderPath;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPath = templateLoaderPath;
    }
}
