package cn.gtmap.gtc.common.http.result;

import lombok.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
public class PageResult<T> extends ClassicResult<List<T>, ClassicMetaWrapper, ClassicLinkWrapper> {
    public static <R> PageResult<R> from(Page<R> page) {
        return new PageResult<>(page.getContent(), new ClassicMetaWrapper(new PageMeta(page)));
    }

    public static <R> PageResult<R> from(List<R> list) {
        PageResult<R> pageResult = new PageResult<>();
        if (list != null) {
            pageResult.setData(list);
            int size = list.size();
            PageMeta pageMeta = size == 0 ?
                new PageMeta(0, 0, 0, 0L) :
                new PageMeta(1, size, 1, (long) size);
            pageResult.setMeta(new ClassicMetaWrapper(pageMeta));
        }
        return pageResult;
    }

    public PageResult(Collection<T> collection, PageMetaWrapper pageMetaWrapper) {
        if (collection != null) {
            data = new ArrayList<>(collection);
        }
        if (pageMetaWrapper != null) {
            meta = pageMetaWrapper instanceof ClassicMetaWrapper ?
                (ClassicMetaWrapper) pageMetaWrapper :
                new ClassicMetaWrapper(pageMetaWrapper.getPage());
        }
    }

    public Page<T> toPage() {
        PageMeta pageMeta = meta.getPage();
        if (pageMeta == null) return null;
        return new PageImpl<>(data, pageMeta.toPageable(), Optional.of(pageMeta.getTotalElements()).orElse(0L));
    }
}
