package cn.gtmap.gtc.common.http.result;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import java.util.Optional;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageMeta {
    private Integer number;
    private Integer size;
    private Integer totalPages;
    private Long totalElements;

    public PageMeta(Page<?> page) {
        if (page == null) return;

        size = page.getSize();
        totalElements = page.getTotalElements();
        number = page.getNumber();
        totalPages = page.getTotalPages();
    }

    public Pageable toPageable() {
        return new PageRequest(Optional.of(number).orElse(1),Optional.of(size).orElse(10));
    }
}
