/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.bpmnio.common.domain.es.incidents;

import cn.gtmap.gtc.bpmnio.common.domain.es.incidents.IncidentByWorkflowStatisticsDto;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class IncidentsByErrorMsgStatisticsDto {
    public static final Comparator<IncidentsByErrorMsgStatisticsDto> COMPARATOR = new IncidentsByErrorMsgStatisticsDtoComparator();
    private String errorMessage;
    private long instancesWithErrorCount;
    @JsonDeserialize(as=TreeSet.class)
    private Set<IncidentByWorkflowStatisticsDto> workflows = new TreeSet<IncidentByWorkflowStatisticsDto>();

    public IncidentsByErrorMsgStatisticsDto() {
    }

    public IncidentsByErrorMsgStatisticsDto(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getInstancesWithErrorCount() {
        return this.instancesWithErrorCount;
    }

    public void setInstancesWithErrorCount(long instancesWithErrorCount) {
        this.instancesWithErrorCount = instancesWithErrorCount;
    }

    public Set<IncidentByWorkflowStatisticsDto> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Set<IncidentByWorkflowStatisticsDto> workflows) {
        this.workflows = workflows;
    }

    public void recordInstancesCount(long count) {
        this.instancesWithErrorCount += count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IncidentsByErrorMsgStatisticsDto that = (IncidentsByErrorMsgStatisticsDto)o;
            if (this.instancesWithErrorCount != that.instancesWithErrorCount) {
                return false;
            }
            if (this.errorMessage != null ? this.errorMessage.equals(that.errorMessage) : that.errorMessage == null) {
                return this.workflows != null ? this.workflows.equals(that.workflows) : that.workflows == null;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = this.errorMessage != null ? this.errorMessage.hashCode() : 0;
        result = 31 * result + (int)(this.instancesWithErrorCount ^ this.instancesWithErrorCount >>> 32);
        result = 31 * result + (this.workflows != null ? this.workflows.hashCode() : 0);
        return result;
    }

    public static class IncidentsByErrorMsgStatisticsDtoComparator
    implements Comparator<IncidentsByErrorMsgStatisticsDto> {
        @Override
        public int compare(IncidentsByErrorMsgStatisticsDto o1, IncidentsByErrorMsgStatisticsDto o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Long.compare(o2.getInstancesWithErrorCount(), o1.getInstancesWithErrorCount());
            if (result == 0) {
                result = o1.getErrorMessage().compareTo(o2.getErrorMessage());
            }
            return result;
        }
    }
}

