/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.bpmnio.common.domain.es.incidents;

import cn.gtmap.gtc.bpmnio.common.domain.es.OperationDto;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IncidentDto {
    public static final Comparator<IncidentDto> INCIDENT_DEFAULT_COMPARATOR = (o1, o2) -> o1.getErrorType().equals(o2.getErrorType()) ? o1.getId().compareTo(o2.getId()) : o1.getErrorType().compareTo(o2.getErrorType());
    private String id;
    private String errorType;
    private String errorMessage;
    private String flowNodeId;
    private String flowNodeInstanceId;
    private Long jobId;
    private OffsetDateTime creationTime;
    private boolean hasActiveOperation = false;
    private OperationDto lastOperation;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public String getFlowNodeInstanceId() {
        return this.flowNodeInstanceId;
    }

    public void setFlowNodeInstanceId(String flowNodeInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId != null ? Long.valueOf(jobId) : null;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public boolean isHasActiveOperation() {
        return this.hasActiveOperation;
    }

    public void setHasActiveOperation(boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
    }

    public OperationDto getLastOperation() {
        return this.lastOperation;
    }

    public void setLastOperation(OperationDto lastOperation) {
        this.lastOperation = lastOperation;
    }

    public static List<IncidentDto> sortDefault(List<IncidentDto> incidents) {
        Collections.sort(incidents, INCIDENT_DEFAULT_COMPARATOR);
        return incidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IncidentDto that = (IncidentDto)o;
            if (this.hasActiveOperation != that.hasActiveOperation) {
                return false;
            }
            if (!(this.id != null ? this.id.equals(that.id) : that.id == null)) {
                return false;
            }
            if (this.errorType != null ? !this.errorType.equals(that.errorType) : that.errorType != null) {
                return false;
            }
            if (!(this.errorMessage != null ? this.errorMessage.equals(that.errorMessage) : that.errorMessage == null)) {
                return false;
            }
            if (this.flowNodeId != null ? !this.flowNodeId.equals(that.flowNodeId) : that.flowNodeId != null) {
                return false;
            }
            if (this.flowNodeInstanceId != null ? !this.flowNodeInstanceId.equals(that.flowNodeInstanceId) : that.flowNodeInstanceId != null) {
                return false;
            }
            if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
                return false;
            }
            if (this.creationTime != null ? this.creationTime.equals(that.creationTime) : that.creationTime == null) {
                return this.lastOperation != null ? this.lastOperation.equals(that.lastOperation) : that.lastOperation == null;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.errorType != null ? this.errorType.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + (this.flowNodeId != null ? this.flowNodeId.hashCode() : 0);
        result = 31 * result + (this.flowNodeInstanceId != null ? this.flowNodeInstanceId.hashCode() : 0);
        result = 31 * result + (this.jobId != null ? this.jobId.hashCode() : 0);
        result = 31 * result + (this.creationTime != null ? this.creationTime.hashCode() : 0);
        result = 31 * result + (this.hasActiveOperation ? 1 : 0);
        result = 31 * result + (this.lastOperation != null ? this.lastOperation.hashCode() : 0);
        return result;
    }
}

