package cn.gtmap.gtc.bpmnio.common.domain.es;

import cn.gtmap.gtc.bpmnio.common.exception.InvalidRequestException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: bpmnio
 * @description:
 * @author: zhouk
 * @create: 2019-10-29 15:41
 **/
@ApiModel("Sorting")
public class SortingDto {
    public static final String SORT_ORDER_ASC_VALUE = "asc";
    public static final String SORT_ORDER_DESC_VALUE = "desc";
    public static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList();
    private String sortBy;
    private String sortOrder = "asc";

    public SortingDto() {
    }

    @ApiModelProperty(
            value = "要排序的数据字段",
            required = true
    )
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @ApiModelProperty(
            value = "Sort order, default: asc",
            allowableValues = "asc,desc",
            required = false
    )
    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException("sortorder参数的值无效: " + sortOrder);
        } else {
            this.sortOrder = sortOrder;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            SortingDto that = (SortingDto)o;
            if (this.sortBy != null) {
                if (this.sortBy.equals(that.sortBy)) {
                    return this.sortOrder != null ? this.sortOrder.equals(that.sortOrder) : that.sortOrder == null;
                }
            } else if (that.sortBy == null) {
                return this.sortOrder != null ? this.sortOrder.equals(that.sortOrder) : that.sortOrder == null;
            }

            return false;
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.sortBy != null ? this.sortBy.hashCode() : 0;
        result = 31 * result + (this.sortOrder != null ? this.sortOrder.hashCode() : 0);
        return result;
    }

    static {
        VALID_SORT_ORDER_VALUES.add("asc");
        VALID_SORT_ORDER_VALUES.add("desc");
    }
}
