<@com.html title="不动产登记业务系统" import="ace,public">
<style>
    .tab-content {
        overflow-y: auto;
        height: auto;
    }
</style>
<script type="text/javascript">
    $(function () {
        /*判断浏览器是否是ie8  解决ie8弹出框居中问题*/
        var ua = navigator.userAgent.toLowerCase();
        if (window.ActiveXObject) {
            if (ua.match(/msie ([\d.]+)/)[1] == '8.0') {
                $(window).resize(function () {
                    $.each($(".moveModel > .modal-dialog"), function () {
                        $(this).css("left", ($(window).width() - $(this).width()) / 2);
                        $(this).css("top", "40px");
                    })
                })
            }
        }
        /*   文字水印  */
        $(".watermarkText").watermark();
        //初始化表格
        djsjInitTable();

        $("#djsj_search_btn").click( function() {
            var qsdwdm  = $("#djsj_search").val();
            var Url = "${serverUrl}/lpb/getDjsjQsdwdmPagesJson?bdclx=${bdclx}";
            tableReload("djsj-grid-table", Url, {qsdwdm:qsdwdm});
        })
    });

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container:'body'});
        $(table).find('.ui-pg-div').tooltip({container:'body'});
    }

    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first':'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev':'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next':'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end':'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }
    //地籍数据
    function djsjInitTable(){
        var grid_selector = "#djsj-grid-table";
        var pager_selector = "#djsj-grid-pager";

        //绑定回车键
        $('#djsj_search').keydown(function (event) {
            if (event.keyCode == 13) {
                $("#djsj_search_btn").click();
            }
        });
        //resize to fit page size
        $(window).on('resize.jqGrid', function () {
            $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
        });
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });

        jQuery(grid_selector).jqGrid({
            datatype:"local",
            height:'auto',
            jsonReader:{id:'QSDWDM'},
            colNames:['村组代码', '不动产类型'],
            colModel:[
                {name:'QSDWDM', index:'QSDWDM', width:'50%', sortable:false, formatter:function (cellvalue, options, rowObject) {
                    if (cellvalue != null && cellvalue != '')
                        cell = '<a href="javascript:djsjEditXm(\'' + rowObject.QSDWDM + '\')" title="' + cellvalue + '" >' + cellvalue + "</a>";
                    else
                        cell = '';
                    return cell;
                }},
                {name:'BDCLX', index:'BDCLX', width:'50%', sortable:false}
            ],
            viewrecords:true,
            rowNum:10,
            rowList:[10, 20, 30],
            pager:pager_selector,
            pagerpos:"left",
            altRows:false,
            loadComplete:function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    //resize
                    $(grid_selector).jqGrid('setGridWidth', $("#mainContent").width());
                }, 0);
                //如果7条设置宽度为auto,如果少于7条就设置固定高度
                if ($(grid_selector).jqGrid("getRowData").length == 7) {
                    $(grid_selector).jqGrid("setGridHeight", "100%");
                } else {
                    $(grid_selector).jqGrid("setGridHeight", "275px");
                }
            },
            editurl:"", //nothing is saved
            caption:"",
            autowidth:true
        });
    }

    function tableReload(table, Url, data) {
        var jqgrid = $("#" + table);
        jqgrid.setGridParam({url:Url, datatype:'json', page:1, postData:data});
        jqgrid.trigger("reloadGrid");//重新加载JqGrid
    }

    function djsjEditXm(qsdwdm){
        debugger;
        $.blockUI({ message:"请稍等……" });
        if (qsdwdm != null && qsdwdm !=''){
            $.ajax({
                url:'${bdcdjUrl}/lpb/getMzfztjBdcdy?bdclx=${bdclx}',
                type:'post',
                dataType:'json',
                data:{qsdwdm:qsdwdm},
                success:function (data){
                    if(isNotBlank(data) && data.bdcdyhs != null && data.bdcdyhs != ''){
                        debugger;
                        var bdcdyhs = "";
                        var djids = "";
                        for(var i = 0; i< data.bdcdyhs.length;i++){
                            if (i==0) {
                                  bdcdyhs = data.bdcdyhs[i];
                            } else {
                                bdcdyhs =bdcdyhs+ "$"+data.bdcdyhs[i];
                            }
                        };
                        if (data.djids != null && data.djids != '') {
                            for (var a=0;a<data.djids.length;a++) {
                                if (a==0) {
                                    djids = data.djids[a];
                                } else {
                                    djids =djids+ "$"+data.djids[a];
                                }
                            }
                        }
                        $.ajax({
                            url:'${bdcdjUrl}/lpb/checkMzfztjBdcdy?bdclx=${bdclx}&proid=${proid!}',
                            type:'post',
                            dataType:'json',
                            data:{qsdwdm:qsdwdm},
                            success:function (data){
                                if (isNotBlank(data) && isNotBlank(data.msg)) {
                                    alert("验证项目失败" + data.msg);
                                    return;
                                }
                                var alertSize = 0;
                                var confirmSize = 0;
                                if (data.length > 0){
                                    $("#csdjAlertInfo,#csdjConfirmInfo").html("");
                                    var islw = false;
                                    $.each(data, function (i, item) {
                                        //去掉遮罩
                                        setTimeout($.unblockUI, 10);
                                        if (item.checkModel == "confirm") {
                                            confirmSize++;
                                            $("#csdjConfirmInfo").append('<div class="alert alert-warning"><span style="cursor:pointer" class="pull-right label label-sm label-primary arrowed-in" data-dismiss="alert" name="hlBtn">忽略</span><span style="cursor:pointer" class="label label-sm label-primary arrowed-right pull-right" onclick="openProjectInfo(\'' + item.info[0] + '\')">查看</span>' + item.checkMsg + '</div>');
                                        } else if (item.checkModel == "alert") {
                                            alertSize++;
                                            if (isNotBlank(item.wiid)) {
                                                islw = true;
                                                confirmCreateLw(item, "${bdcdjUrl}", "${sflw}");
                                            } else {
                                                $("#csdjAlertInfo").append('<div class="alert alert-danger"><span style="cursor:pointer" class="label label-sm label-primary arrowed arrowed-right pull-right" onclick="openProjectInfo(\'' + item.info[0] + '\')" >查看</span>' + item.checkMsg + '</div>');
                                            }
                                        }
                                    })
                                    if(!islw){
                                        $("#tipPop").show();
                                        $("#modal-backdrop").show();
                                    }
                                }
                                if (alertSize == 0 && confirmSize == 0) {
                                    djsjInitVoFromOldData(djids,bdcdyhs);
                                } else if (alertSize == 0 && confirmSize > 0) {
                                    $("span[name='hlBtn']").click(function () {
                                        $(this).parent().remove();
                                        if ($("#csdjConfirmInfo > div").size() == 0) {
                                            djsjInitVoFromOldData(djids,bdcdyhs);
                                        }
                                    })
                                }
                            },
                            error:function(){
                                //去掉遮罩
                                setTimeout($.unblockUI, 10);
                            }
                        });
                    }else{
                        tipInfo("该村组未获取到满足发证条件的不动产单元！");
                        setTimeout($.unblockUI, 10);
                    }
                },
                error:function(){
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                }
            })
        }
    }

    function djsjInitVoFromOldData(djids,bdcdyhs) {
        debugger;
        $.ajax({
            type: 'POST',
            url: '${bdcdjUrl}/wfProject/initVoFromOldData?proid=${proid}',
            data:{bdcdyhs:bdcdyhs,djIds:djids},
            success: function (data) {
                if (data == '成功') {
                    $.ajax({
                        type: 'get',
                        async: true,
                        url: '${bdcdjUrl}/wfProject/updateWorkFlow?proid=${proid}',
                        success: function (data) {
                        }
                    });
                    $(".mulSelectPop").parent().hide();
                    window.parent.hideModel();
                    window.parent.resourceRefresh();
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                } else {
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                    alert(data);
                }
                $("#modal-backdrop-mul").hide();
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (XMLHttpRequest.readyState == 4) {
                    alert("保存失败!");
                }
                //去掉遮罩
                setTimeout($.unblockUI, 10);
                $("#modal-backdrop-mul").hide();
            }
        });
    }
</script>

<div class="main-container">
    <div class="space-10"></div>
    <div class="page-content">
        <div class="simpleSearch">
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <input type="text" class="SSinput watermarkText" id="djsj_search" data-watermark="请输入村组代码">
                    </td>
                    <td style="border: 0px">&nbsp;&nbsp;&nbsp;</td>
                    <td class="Search">
                        <a href="#" id="djsj_search_btn">
                            搜索
                            <i class="ace-icon fa fa-search bigger-130"></i>
                        </a>
                    </td>
                </tr>
            </table>
        </div>
        <!-- 搜索结果 -->
        <table id="djsj-grid-table"></table>
        <div id="djsj-grid-pager"></div>
    </div>
</div>
<!--错误提示-->
<div class="Pop-upBox moveModel" style="display: none;" id="tipPop">
    <div class="modal-dialog tipPop-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><#--<i class="ace-icon fa fa-search bigger-110"></i>-->提示信息</h4>
                <button type="button" id="tipHide" class="proHide"><i
                        class="ace-icon glyphicon glyphicon-remove"></i>
                </button>
            </div>
            <div class="bootbox-body" style="background: #fafafa;">
                <div id="csdjAlertInfo"></div>
                <div id="csdjConfirmInfo"></div>
            </div>
            <div class="modelFooter">
                <button type="button" class="btn btn-sm btn-primary" id="tipCloseBtn">关闭</button>
            </div>
        </div>
    </div>
</div>

<div class="modal-backdrop fade in Pop" style="display:none" id="modal-backdrop"></div>
<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
</@com.html>