<@com.html title="推送信息" import="ace">
<style>
    .new-modal {
        width: 600px;
    }

    .modal-dialog {
        width: 650px;
        margin: 30px auto;
    }

    .bootbox {
        overflow: auto;
    }

    /*高级搜索的样式修改*/
    .btn01:hover {
        background-color: #c7c7c7;
        text-decoration: none;
        color: #333;
    }

    .btn01 {
        display: inline-block;
        padding: 4px 12px;
        margin-bottom: 0;
        font-size: 14px;
        color: #333333;
        text-align: center;
        vertical-align: middle;
        cursor: pointer;
        background-color: #f2f2f2;
        border: 1px solid #aaa;
        webkit-border-radius: 0px !important;
        -moz-border-radius: 0px !important;
        border-radius: 0px !important;
    }

    /*移动modal样式*/
    #gjSearchPop .modal-dialog {
        width: 650px;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }

    /*表单样式重写*/
    form input[type='text'], select, textarea {
        border-radius: 4px !important;
        width;
        100% !important;
    }

    .modelFooter {
        background: none;
        border-top: 1px solid #e5e5e5;
        padding: 10px;
        text-align: center;
    }

    .form .row {
        margin: 10px 0px 10px 0px;
    }

    .form .row .col-xs-2 {
        padding-left: 0px;
        padding-right: 4px;
        text-align: right;
    }

    .form .row .col-xs-4 {
        padding-left: 0px;
        padding-right: 0px;
    }

    label {
        font-weight: bold;
    }
</style>
<script>
    //多选数据
    $mulData=new Array();
    $mulRowid=new Array();
    $(function () {
        //生成表格
        accessTableGrid();
        $("#getResult").click(function () {
            var ids = $('#access-grid-table').jqGrid('getGridParam', 'selarrrow');
            var isTsslbh = true;
            if ($mulData.length >0 && ids.length >0) {
                for(var i=0;i<$mulData.length;i++){
                    var spxtblzt =  $mulData[i].SPXTBLZT;
                    if (spxtblzt != undefined && (spxtblzt.indexOf("推送成功")  > -1)) {
                        tipInfo("选择数据中包含已经推送成功的数据，请重新选择");
                        return;
                    }
                }
                if (isTsslbh) {
                    tsSlbh(ids);
                    return;
                }
            } else {
                tipInfo("请至少选择一条数据");
                isTsslbh = false;
                return;
            }
        });

        // 清空已选
        $("#delSelect").click(function () {
           clean();
        });

        function clean() {
            $mulData.splice(0, $mulData.length);
            $mulRowid.splice(0, $mulRowid.length);
            $("#access-grid-table").trigger("reloadGrid");
        }

        //resize to fit page size
        $(window).on('resize.jqGrid', function () {
            var contentWidth;
            if ($("#accessContent").width() > 0) {
                contentWidth = $("#accessContent").width();
            }
            $("#access-grid-table").jqGrid('setGridWidth', contentWidth);
        });
        /*判断浏览器是否是ie8  解决ie8弹出框居中问题*/
        var ua = navigator.userAgent.toLowerCase();
        if (window.ActiveXObject) {
            if (ua.match(/msie ([\d.]+)/)[1] == '8.0') {
                $(window).resize(function () {
                    $.each($(".moveModel > .modal-dialog"), function () {
                        $(this).css("left", ($(window).width() - $(this).width()) / 2);
                        $(this).css("top", "40px");
                    })
                })
            }
        }
        Array.prototype.remove = function(index) {
            if (index > -1) {
                this.splice(index, 1);
            }
        };
        /*   文字水印  */
        $(".watermarkText").watermark();

        //拖拽功能
        $(".modal-header").mouseover(function () {
            $(this).css("cursor", "move");//改变鼠标指针的形状
        })
        $(".modal-header").mouseout(function () {
            $(this).css("cursor", "default");
        })
        $(".gjSearchPop-modal").draggable({opacity: 0.7, handle: 'div.modal-header'});

        //项目表搜索事件
        $("#searchBtn").click(function () {
            var search = $("#search").val();
            $("#gjSearchForm")[0].reset();
            clean();
            var Url = "${bdcdjUrl}/fuPingBdcGxjy/getBdcGxjyJgDataPagesJson?";
            tableReload("access-grid-table", Url, {dcxc: search,cxlx:"cx"});
        })
        //项目表高级查询的搜索按钮事件
        $("#gjSearchBtn").click(function () {
            clean();
            var bjqssj = $("#bjqssj").val();
            var bjjssj = $("#bjjssj").val();
            if (bjqssj != undefined && bjqssj != null && bjjssj != undefined && bjjssj != null && bjjssj < bjqssj) {
                 tipInfo("办结时间段选择错误，请重新选择");
                 return;
            }
            var Url = "${bdcdjUrl}/fuPingBdcGxjy/getBdcGxjyJgDataPagesJson?" + $("#gjSearchForm").serialize();
            tableReload("access-grid-table", Url, {dcxc: "",cxlx:"gjcx"});
        })
        //项目高级查询按钮点击事件
        $("#show").click(function () {
            $("#gjSearchPop").show();
        });
        //项目高级搜索关闭事件
        $("#proHide").click(function () {
            $("#gjSearchPop").hide();
            $("#gjSearchForm")[0].reset();
        });
        //登记类型变换事件
        $("#djlxSelect").change(function () {
            getSqlxByDjlx();
        })
    })


    //单个推送
    function tsSlbh(ids) {
        $.blockUI({message: "推送中，请稍等…"});
        var options = {
            url: '${bdcdjUrl}/fuPingBdcGxjy/postBdcxxToGxjy?proid=' + ids,
            type: 'get',
            dataType: 'json',
            success: function (result) {
                if (result != '') {
                    tipInfo(result);
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                } else {
                    tipInfo("推送失败");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            },
            error: function (result) {
                tipInfo("推送失败，请重试");
                $('#access-grid-table').trigger("reloadGrid");
                setTimeout($.unblockUI, 10);
            }
        };
        $.ajax(options);
    }

    function tableReload(table, Url, data) {
        var jqgrid = $("#" + table);
        jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
        jqgrid.trigger("reloadGrid");//重新加载JqGrid
    }

    function tipInfo(msg) {
        bootbox.dialog({
            message: "<h3><b>" + msg + "</b></h3>",
            title: "",
            buttons: {
                main: {
                    label: "关闭",
                    className: "btn-primary"
                }
            }
        });
        return;
    }

    //auth表格初始化
    function accessTableGrid() {
        var grid_selector = "#access-grid-table";
        var pager_selector = "#access-grid-pager";
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        jQuery(grid_selector).jqGrid({
            url: "${bdcdjUrl}/fuPingBdcGxjy/getBdcGxjyJgDataPagesJson",
            datatype: "json",
            height: 'auto',
            jsonReader: {id: 'PROID'},
            colNames: ['受理号', '不动产单元号', '登记类型', '申请类型', '坐落', '办结时间', '推送状态', '房产业务号','PROID'],
            colModel: [
                {name: 'BH', index: 'BH', width: '12%', sortable: false},
                {name: 'BDCDYH', index: 'BDCDYH', width: '20%', sortable: false},
                {name: 'DJLX', index: 'DJLX', width: '10%', sortable: false},
                {name: 'SQLX', index: 'SQLX', width: '18%', sortable: false},
                {name: 'ZL', index: 'ZL', width: '28%', sortable: false},
                {
                    name: 'BJSJ',
                    index: 'BJSJ',
                    width: '10%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        if (!cellvalue) {
                            return "";
                        }
                        var value = cellvalue;
                        var data = new Date(value).Format("yyyy-MM-dd");
                        return data;
                    }
                },
                {
                    name: 'SPXTBLZT',
                    index: 'SPXTBLZT',
                    width: '8%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        if (!cellvalue) {
                            return '<span class="label label-warning">未推送</span>';
                        }
                        var tszt = cellvalue;
                        if (tszt!=undefined && tszt !='' && tszt == '1') {
                            return '<span class="label label-success">推送成功</span>';
                        } else {
                            return '<span class="label label-danger">推送失败</span>';
                        }
                    }
                },
                {name: 'SPXTYWH', index: 'SPXTYWH', width: '0%',hidden:true,sortable: false},
                {name: 'PROID', index: 'PROID', width: '0%',hidden:true,sortable: false}
            ],
            viewrecords: true,
            rowNum: 10,
            rowList: [10, 20, 30],
            pagerpos: "left",
            pager: pager_selector,
            altRows: false,
            multiboxonly: true,
            multiselect: true,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    //resize
                    $(grid_selector).jqGrid('setGridWidth', $("#accessContent").width());
                }, 0);
                for(var i=0;i<=$mulRowid.length;i++){
                    $(grid_selector).jqGrid('setSelection',$mulRowid[i]);
                }
            },
            onSelectRow: function (rowid,status) {
                var $myGrid = $(this);
                var cm = $myGrid.jqGrid('getRowData',rowid);
                //判断是已选择界面还是原界面
                if(cm.PROID==rowid){
                    var index=$.inArray(rowid,$mulRowid);
                    if(status && index<0){
                        $mulData.push(cm);
                        $mulRowid.push(rowid);
                    }else if(!status && index>=0){
                        $mulData.remove(index);
                        $mulRowid.remove(index);
                    }
                    //赋值数量
                    $("#djsjMulXx").html("<span>已选择("+$mulRowid.length+")</span>");
                }
            },
            onSelectAll: function(aRowids,status){
                var $myGrid = $(this);
                $.each(aRowids,function(i,e){
                    var cm = $myGrid.jqGrid('getRowData', e);
                    //判断是已选择界面还是原界面
                    if(cm.PROID==e) {
                        var index = $.inArray(e, $mulRowid);
                        if (status && index < 0) {
                            $mulData.push(cm);
                            $mulRowid.push(e);
                        } else if (!status && index >= 0) {
                            $mulData.remove(index);
                            $mulRowid.remove(index);
                        }
                    }
                })
                //赋值数量
                $("#djsjMulXx").html("<span>已选择("+$mulRowid.length+")</span>");
            },
           /* onSelectRow:function(rowid,status){

            },*/
            caption: "",
            autowidth: true
        });
        //时间控件
        $('.date-picker').datepicker({
            autoclose:true,
            todayHighlight:true,
            language:'zh-CN'
        }).next().on(ace.click_event, function () {
            $(this).prev().focus();
        });
        Date.prototype.Format = function (fmt) {
            var o = {
                "M+": this.getMonth() + 1, //月份
                "d+": this.getDate(), //日
                "h+": this.getHours(), //小时
                "m+": this.getMinutes(), //分
                "s+": this.getSeconds(), //秒
                "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                "S": this.getMilliseconds()             //毫秒
            };
            if (/(y+)/.test(fmt))
                fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o)
                if (new RegExp("(" + k + ")").test(fmt))
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            return fmt;
        }
    }

    //replace icons with FontAwesome icons like above
    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    function getSqlxByDjlx () {
       var djlx = $("#djlxSelect  option:selected").val();
        $.ajax({
            type: "GET",
            url: "${bdcdjUrl}/fuPingBdcGxjy/getSqlxByDjlx",
            data: {djlx: djlx},
            dataType: "json",
            success: function (result) {
                //清空
                $("#sqlxSelect").html("");
                if (result != null && result != '') {
                    $("#sqlxSelect").append('<option value="" ></option>');
                    $.each(result, function (index, data) {
                        $("#sqlxSelect").append('<option value="' + data.dm + '" >' + data.mc + '</option>');
                    })
                }
                $("#sqlxSelect").trigger("chosen:updated");
            },
            error: function (data) {
            }
        });
    }


</script>
<div class="space-6"></div>
<div class="main-container">
    <div class="page-content" id="accessContent">
        <div class="simpleSearch">
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <input type="text" class="SSinput watermarkText" id="search" data-watermark="请输入受理号/不动产单元号">
                    </td>
                    <td class="Search">
                        <a href="#" id="searchBtn">
                            搜索
                            <i class="ace-icon fa fa-search bigger-130"></i>
                        </a>
                    </td>
                    <td style="border: 0px">&nbsp;</td>
                    <td>
                        <button type="button" class="btn01 AdvancedButton" id="show">高级搜索</button>
                    </td>
                </tr>
            </table>
        </div>
        <div class="tableHeader">
            <ul>
                <li>
                    <button type="button" id="getResult">
                        <i class="ace-icon fa fa-file"></i>
                        <span>推送</span>
                    </button>
                </li>
                <li>
                    <button type="button" id="delSelect">
                        <i class="ace-icon fa fa-file"></i>
                        <span>清空</span>
                    </button>
                </li>
            </ul>
        </div>
        <table id="access-grid-table"></table>

        <div id="access-grid-pager"></div>

    </div>
</div>
<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
<!--高级搜索-->
<div class="Pop-upBox moveModel" style="display: none;" id="gjSearchPop">
    <div class="modal-dialog gjSearchPop-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ace-icon fa fa-search bigger-110"></i>高级搜索</h4>
                <button type="button" id="proHide" class="proHide"><i class="ace-icon glyphicon glyphicon-remove"></i>
                </button>
            </div>
            <div class="bootbox-body" style="background: #fafafa;">
                <form class="form advancedSearchTable" id="gjSearchForm">
                    <div class="row">
                        <div class="col-xs-2">
                            <label>受理号：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" name="slbh" class="form-control">
                        </div>
                        <div class="col-xs-2">
                            <label>不动产单元号：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" name="bdcdyh" class="form-control">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>登记类型：</label>
                        </div>
                        <div class="col-xs-4">
                            <select id="djlxSelect" name="djlx" class="form-control">
                                <option value="">所有</option>
                                <#list djlxList! as djlx>
                                    <option value="${djlx.dm!}">${djlx.mc}</option>
                                </#list>
                            </select>
                        </div>
                        <div class="col-xs-2">
                            <label>申请类型：</label>
                        </div>
                        <div class="col-xs-4">
                            <select id="sqlxSelect" name="sqlx" class="form-control">
                                <option value="">所有</option>
                                <#list sqlxList! as sqlx>
                                    <option value="${sqlx.dm!}">${sqlx.mc}</option>
                                </#list>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>办结时间起：</label>
                        </div>
                        <div class="col-xs-4">
                            <input  class="date-picker form-control" id="bjqssj" name="bjqssj" data-date-format="yyyy-mm-dd">
                        </div>
                        <div class="col-xs-2">
                            <label>至：</label>
                        </div>
                        <div class="col-xs-4">
                            <input class="date-picker form-control" id="bjjssj" name="bjjssj" data-date-format="yyyy-mm-dd">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>推送状态：</label>
                        </div>
                        <div class="col-xs-4">
                            <select name="spxtblzt" class="form-control">
                                <option value="all" selected>请选择</option>
                                <option value="">未推送</option>
                                <option value="1">推送成功</option>
                                <option value="-1">推送失败</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modelFooter">
                <button type="button" class="btn btn-sm btn-primary" id="gjSearchBtn">搜索</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade in Pop" style="display:none;" id="modal-backdrop-pop"></div>
</@com.html>