--liquibase formatted sql
--preconditions dbms:oracle
--changeset wenyuanwu:1 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (YFCZH VARCHAR2(4000));
COMMENT ON COLUMN bdc_xm.YFCZH IS '原房产证号';
--changeset wenyuanwu:2 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (YTDZH VARCHAR2(4000));
COMMENT ON COLUMN bdc_xm.YTDZH IS '原土地证号';
--changeset wenyuanwu:3 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (CQGS VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.CQGS IS '产权归属';
--changeset wenyuanwu:4 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (LZRQ DATE);
COMMENT ON COLUMN bdc_xm.LZRQ IS '领证日期';
--changeset wenyuanwu:5 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (EWMNR VARCHAR2(2000));
COMMENT ON COLUMN BDC_ZS.EWMNR IS '二维码内容';
--changeset wenyuanwu:6 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (FCGHYT VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.FCGHYT IS '房产规划用途';
--changeset wenyuanwu:7 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (ZDZHYT2 VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.ZDZHYT2 IS '宗地宗海用途2';
--changeset wenyuanwu:8 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (ZDZHYT3 VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.ZDZHYT3 IS '宗地宗海用途3';
--changeset wenyuanwu:9 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (ZDZHYT3 VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.ZDZHYT3 IS '宗地宗海用途3';
--changeset wenyuanwu:10 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD (SFXXID VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXM.SFXXID IS '收费单信息';
--changeset wenyuanwu:11 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD (FPH VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXM.FPH IS '发票号';
--changeset wenyuanwu:12 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD (JSFF VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXM.JSFF IS '计算方法';
--changeset wenyuanwu:13 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD (QLRLX VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXM.QLRLX IS '权利人类型';
--changeset wenyuanwu:14 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SYKSQX2 DATE);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SYKSQX2 IS '使用开始期限2';
--changeset wenyuanwu:15 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SYJSQX2 DATE);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SYJSQX2 IS '使用结束期限2';
--changeset wenyuanwu:16 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SYKSQX3 DATE);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SYKSQX3 IS '使用开始期限3';
--changeset wenyuanwu:17 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SYJSQX3 DATE);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SYJSQX3 IS '使用结束期限3';
--changeset wenyuanwu:18 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FDCQ
  ADD (CG NUMBER(10, 2));
COMMENT ON COLUMN BDC_FDCQ.CG IS '层高';
--changeset wenyuanwu:19 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (FDCJYHTH VARCHAR2(200));
COMMENT ON COLUMN BDC_FDCQ.FDCJYHTH IS '房地产交易合同号';
--changeset wenyuanwu:20 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FWPGJG NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.FWPGJG IS '房屋评估价格';
--changeset wenyuanwu:21 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (TDPGJG NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.TDPGJG IS '土地评估价格';
--changeset wenyuanwu:22 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (YSXKZMH VARCHAR2(100));
COMMENT ON COLUMN BDC_DYAQ.YSXKZMH IS '预售许可证明号';
--changeset wenyuanwu:23 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FTTDMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_DYAQ.FTTDMJ IS '分摊土地面积';
--changeset wenyuanwu:24 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FWDYJG NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.FWDYJG IS '房屋抵押价格';
--changeset wenyuanwu:25 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (TDDYJG NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.TDDYJG IS '土地抵押价格';
--changeset wenyuanwu:26 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (TDDYMJ NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.TDDYMJ IS '土地抵押面积';
--changeset wenyuanwu:27 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FWDYMJ NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.FWDYMJ IS '房屋抵押面积';
--changeset wenyuanwu:28 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (FTTDMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_YG.FTTDMJ IS '分摊土地面积';
--changeset wenyuanwu:29 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (YSXKZMH VARCHAR2(200));
COMMENT ON COLUMN BDC_CF.YSXKZMH IS '预售许可证明号';
--changeset wenyuanwu:30 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDY
  ADD (YDJH VARCHAR2(4000));
COMMENT ON COLUMN BDC_BDCDY.YDJH IS '原地籍号';
--changeset wenyuanwu:31 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDYSD
  ADD (PROID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCDYSD.PROID IS '项目ID';
--changeset wenyuanwu:32 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDYSD
  ADD (WIID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCDYSD.WIID IS '工作流ID';
--changeset wenyuanwu:33 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_CF.GXR IS '更新人';
--changeset wenyuanwu:34 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (JFWJ VARCHAR2(100));
COMMENT ON COLUMN GD_CF.JFWJ IS '解封文件';
--changeset wenyuanwu:35 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (JFWH VARCHAR2(100));
COMMENT ON COLUMN GD_CF.JFWH IS '解封文号';
--changeset wenyuanwu:36 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (JFJG VARCHAR2(100));
COMMENT ON COLUMN GD_CF.JFJG IS '解封机关';
--changeset wenyuanwu:37 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (JFSJ DATE);
COMMENT ON COLUMN GD_CF.JFSJ IS '解封时间';
--changeset wenyuanwu:38 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_DY.GXR IS '更新人';
--changeset wenyuanwu:39 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (ZXR VARCHAR2(100));
COMMENT ON COLUMN GD_DY.ZXR IS '注销人';
--changeset wenyuanwu:40 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (ZXRQ DATE);
COMMENT ON COLUMN GD_DY.ZXRQ IS '注销日期';
--changeset wenyuanwu:41 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_CQ.GXR IS '更新人';
--changeset wenyuanwu:42 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.GXR IS '更新人';
--changeset wenyuanwu:43 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_LQ.GXR IS '更新人';
--changeset wenyuanwu:44 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_TDSYQ.GXR IS '更新人';
--changeset wenyuanwu:45 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_YG.GXR IS '更新人';
--changeset wenyuanwu:46 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (DYKSRQ DATE);
COMMENT ON COLUMN GD_YG.DYKSRQ IS '抵押开始日期';
--changeset wenyuanwu:47 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (DYJSRQ DATE);
COMMENT ON COLUMN GD_YG.DYJSRQ IS '抵押结束日期';
--changeset wenyuanwu:48 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_YY.GXR IS '更新人';
--changeset wenyuanwu:49 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_FW_QL
(
  qlid  VARCHAR2(32),
  proid VARCHAR2(32),
  fczh  VARCHAR2(200),
  qlr   VARCHAR2(2000),
  fwzl  VARCHAR2(4000),
  djlx  VARCHAR2(100),
  zslx  VARCHAR2(100)
);
COMMENT ON TABLE GD_FW_QL
IS '房屋权利查询属性结构描述';
COMMENT ON COLUMN GD_FW_QL.qlid
IS '权利ID';
COMMENT ON COLUMN GD_FW_QL.proid
IS '项目ID';
COMMENT ON COLUMN GD_FW_QL.fczh
IS '房产证（明）号';
COMMENT ON COLUMN GD_FW_QL.qlr
IS '权利人';
COMMENT ON COLUMN GD_FW_QL.fwzl
IS '土地坐落';
COMMENT ON COLUMN GD_FW_QL.djlx
IS '登记类型';
COMMENT ON COLUMN GD_FW_QL.zslx
IS '证书类型';
CREATE INDEX INDEX_GDFWQL_FCZH
  ON GD_FW_QL (FCZH);
CREATE INDEX INDEX_GDFWQL_FWZL
  ON GD_FW_QL (FWZL);
CREATE INDEX INDEX_GDFWQL_FWZL_QLR_FCZH
  ON GD_FW_QL (FWZL, QLR, FCZH);
CREATE INDEX INDEX_GDFWQL_QLR
  ON GD_FW_QL (QLR);
CREATE INDEX STUNAME
  ON GD_FW_QL (QLID);
--changeset wenyuanwu:50 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_TD_QL
(
  qlid  VARCHAR2(100),
  proid VARCHAR2(100),
  tdzh  VARCHAR2(200),
  qlr   VARCHAR2(2000),
  tdzl  VARCHAR2(4000),
  djlx  VARCHAR2(100),
  zslx  VARCHAR2(100),
  djh   VARCHAR2(100),
  tdid  VARCHAR2(100)
);
COMMENT ON TABLE GD_TD_QL
IS '土地权利查询属性结构描述';
COMMENT ON COLUMN GD_TD_QL.qlid
IS '权利ID';
COMMENT ON COLUMN GD_TD_QL.proid
IS '项目ID';
COMMENT ON COLUMN GD_TD_QL.tdzh
IS '土地证（明）号';
COMMENT ON COLUMN GD_TD_QL.qlr
IS '权利人';
COMMENT ON COLUMN GD_TD_QL.tdzl
IS '土地坐落';
COMMENT ON COLUMN GD_TD_QL.djlx
IS '登记类型';
COMMENT ON COLUMN GD_TD_QL.zslx
IS '证书类型';
COMMENT ON COLUMN GD_TD_QL.djh
IS '地籍号';
COMMENT ON COLUMN GD_TD_QL.tdid
IS '土地id';
CREATE INDEX INDEX_GDTDQL_QLID
  ON GD_TD_QL (QLID);
CREATE INDEX INDEX_GDTDQL_QLR
  ON GD_TD_QL (QLR);
CREATE INDEX INDEX_GDTDQL_TDZH
  ON GD_TD_QL (TDZH);
CREATE INDEX INDEX_GDTDQL_TDZL
  ON GD_TD_QL (TDZL);
CREATE INDEX INDEX_GDTDQL_TDZL_QLR_TDZH
  ON GD_TD_QL (TDZL, QLR, TDZH);
--changeset wenyuanwu:51 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_BDCSD
(
  sdid   VARCHAR2(100) NOT NULL,
  cqzh   VARCHAR2(100) NOT NULL,
  qlid   VARCHAR2(1000),
  bdclx  VARCHAR2(100),
  proid  VARCHAR2(100),
  xzzt   NUMBER,
  xzyy   VARCHAR2(500),
  xztype VARCHAR2(100),
  sdr    VARCHAR2(100),
  sdsj   DATE,
  jsr    VARCHAR2(100),
  jssj   DATE,
  wiid   VARCHAR2(100)
);
COMMENT ON TABLE GD_BDCSD
IS '过渡不动产数据锁定';
COMMENT ON COLUMN GD_BDCSD.sdid
IS '锁定id';
COMMENT ON COLUMN GD_BDCSD.cqzh
IS '产权证号';
COMMENT ON COLUMN GD_BDCSD.qlid
IS '权利id';
COMMENT ON COLUMN GD_BDCSD.bdclx
IS '不动产类型';
COMMENT ON COLUMN GD_BDCSD.proid
IS '项目id';
COMMENT ON COLUMN GD_BDCSD.xzzt
IS '限制状态';
COMMENT ON COLUMN GD_BDCSD.xzyy
IS '限制原因';
COMMENT ON COLUMN GD_BDCSD.xztype
IS '限制类型';
COMMENT ON COLUMN GD_BDCSD.sdr
IS '锁定人';
COMMENT ON COLUMN GD_BDCSD.sdsj
IS '锁定时间';
COMMENT ON COLUMN GD_BDCSD.jsr
IS '解锁人';
COMMENT ON COLUMN GD_BDCSD.jssj
IS '解锁时间';
COMMENT ON COLUMN GD_BDCSD.wiid
IS '工作流id';
--changeset wenyuanwu:52 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_QL_DYH_REL
(
  relid  VARCHAR2(32),
  bdcdyh VARCHAR2(4000),
  qlid   VARCHAR2(100),
  bdclx  VARCHAR2(5),
  tdqlid VARCHAR2(100),
  djid   VARCHAR2(4000)
);
COMMENT ON TABLE GD_QL_DYH_REL
IS '过渡权利与不动产单元关系';
COMMENT ON COLUMN GD_QL_DYH_REL.relid
IS '主键';
COMMENT ON COLUMN GD_QL_DYH_REL.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN GD_QL_DYH_REL.qlid
IS '权利id';
COMMENT ON COLUMN GD_QL_DYH_REL.bdclx
IS '不动产类型';
COMMENT ON COLUMN GD_QL_DYH_REL.tdqlid
IS '土地权利id';
COMMENT ON COLUMN GD_QL_DYH_REL.djid
IS '权籍id';
--changeset wenyuanwu:53 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CJLB
(
  CJID VARCHAR2(32 BYTE) NOT NULL ENABLE,
  BH   VARCHAR2(100 BYTE),
  ZL   VARCHAR2(1000 BYTE),
  CYR  VARCHAR2(100 BYTE),
  CYSJ DATE,
  BZ   VARCHAR2(2000 BYTE),
  SQR  VARCHAR2(100 BYTE),
  PC   VARCHAR2(14 BYTE),
  CONSTRAINT "PK_CJID" PRIMARY KEY ("CJID")
);
COMMENT ON COLUMN BDC_CJLB.BH IS '编号';
COMMENT ON COLUMN BDC_CJLB.ZL IS '坐落';
COMMENT ON COLUMN BDC_CJLB.CYR IS '持有人';
COMMENT ON COLUMN BDC_CJLB.CYSJ IS '持有时间';
COMMENT ON COLUMN BDC_CJLB.BZ IS '备注';
COMMENT ON COLUMN BDC_CJLB.SQR IS '申请人';
COMMENT ON COLUMN BDC_CJLB.PC IS '批次';
COMMENT ON TABLE BDC_CJLB IS '持件列表';

--changeset wenyuanwu:54 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (QLRDLRZJZL VARCHAR2(100));
COMMENT ON COLUMN BDC_QLR.QLRDLRZJZL IS '代理人证件种类';
--changeset wenyuanwu:1505 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (QLRDLRZJH VARCHAR2(100));
COMMENT ON COLUMN BDC_QLR.QLRDLRZJH IS '代理人证件号';
--changeset wenyuanwu:1206 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (XB VARCHAR2(5));
COMMENT ON COLUMN BDC_QLR.XB IS '性别';
--changeset wenyuanwu:55 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (TXDZ VARCHAR2(200));
COMMENT ON COLUMN BDC_XT_YH.TXDZ IS '通讯地址';
--changeset wenyuanwu:1207 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (YB VARCHAR2(10));
COMMENT ON COLUMN BDC_XT_YH.YB IS '邮编';
--changeset wenyuanwu:1232 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (FZR VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.FZR IS '负责人';
--changeset wenyuanwu:1208 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (FZRLXDH VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.FZRLXDH IS '负责人联系电话';
--changeset wenyuanwu:56 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_DY
  ADD (BDCJG NUMBER(20, 2));
COMMENT ON COLUMN GD_DY.BDCJG IS '不动产价格';
--changeset wenyuanwu:57 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (DKFS VARCHAR2(50));
COMMENT ON COLUMN GD_DY.DKFS IS '贷款方式';
--changeset wenyuanwu:58 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (GXR VARCHAR2(100));
COMMENT ON COLUMN GD_DY.GXR IS '更新人';
--changeset wenyuanwu:59 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (ZXR VARCHAR2(100));
COMMENT ON COLUMN GD_DY.ZXR IS '注销人';
--changeset wenyuanwu:60 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (DYMJ NUMBER(20, 2));
COMMENT ON COLUMN GD_DY.DYMJ IS '抵押面积';
--changeset wenyuanwu:61 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (PGJG NUMBER(20, 2));
COMMENT ON COLUMN GD_DY.PGJG IS '评估价格';
--changeset wenyuanwu:62 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (QLRDLR VARCHAR2(100));
COMMENT ON COLUMN GD_QLR.QLRDLR IS '代理人';
--changeset wenyuanwu:63 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (QLRDLRZJH VARCHAR2(30));
COMMENT ON COLUMN GD_QLR.QLRDLRZJH IS '代理人证件号';
--changeset wenyuanwu:64 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (QLRDLRZJLX VARCHAR2(50));
COMMENT ON COLUMN GD_QLR.QLRDLRZJLX IS '代理人证件号';
--changeset wenyuanwu:65 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_FWFSSS
(
  fwfsssid VARCHAR2(200) NOT NULL,
  jyjg     NUMBER(20, 4),
  ghyt     VARCHAR2(100),
  dw       VARCHAR2(100),
  jzmj     NUMBER(20, 4),
  dwdm     VARCHAR2(100),
  bz       VARCHAR2(100),
  cg       NUMBER(10, 5),
  proid    VARCHAR2(100),
  bdcdyid  VARCHAR2(100)
);

COMMENT ON TABLE BDC_FWFSSS
IS '房屋附属设施';
COMMENT ON COLUMN BDC_FWFSSS.fwfsssid
IS '房屋附属设施id';
COMMENT ON COLUMN BDC_FWFSSS.jyjg
IS '交易价格';
COMMENT ON COLUMN BDC_FWFSSS.ghyt
IS '规划用途';
COMMENT ON COLUMN BDC_FWFSSS.dw
IS '单位';
COMMENT ON COLUMN BDC_FWFSSS.jzmj
IS '建筑面积';
COMMENT ON COLUMN BDC_FWFSSS.dwdm
IS '单位代码';
COMMENT ON COLUMN BDC_FWFSSS.bz
IS '备注';
COMMENT ON COLUMN BDC_FWFSSS.cg
IS '层高';
COMMENT ON COLUMN BDC_FWFSSS.proid
IS '项目id';
COMMENT ON COLUMN BDC_FWFSSS.bdcdyid
IS '不动产单元id';
--changeset wenyuanwu:66 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFZXX
  ADD (FWXZ VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.FWXZ IS '房屋性质';
--changeset wenyuanwu:67 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (ISFSSS VARCHAR2(10));
COMMENT ON COLUMN GD_FW.ISFSSS IS '是否附属设施（0或空：否，1：是）';
--changeset wenyuanwu:68 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFSSS
  ADD (FWZL VARCHAR2(200));
COMMENT ON COLUMN BDC_FWFSSS.FWZL IS '房屋坐落';
--changeset wenyuanwu:69 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFSSS
  ADD (TNJZMJ NUMBER(20, 4));
COMMENT ON COLUMN BDC_FWFSSS.TNJZMJ IS '套内建筑面积';
--changeset wenyuanwu:70 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_CF.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:71 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_DY.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:72 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_YY.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:73 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_YG.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:74 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_FWSYQ.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:75 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN GD_TDSYQ.BZ IS '备注，不记在证书上，存放附记以外的信息';
--changeset wenyuanwu:76 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (YT2 VARCHAR2(50));
COMMENT ON COLUMN BDC_SPXX.YT2 IS '定着物用途2';
--changeset wenyuanwu:77 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (YT3 VARCHAR2(50));
COMMENT ON COLUMN BDC_SPXX.YT3 IS '定着物用途3';
--changeset wenyuanwu:78 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (tdsyksqx2 DATE);
COMMENT ON COLUMN bdc_fdcq.tdsyksqx2 IS '土地使用开始期限2';
--changeset wenyuanwu:79 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (tdsyjsqx2 DATE);
COMMENT ON COLUMN bdc_fdcq.tdsyjsqx2 IS '土地使用结束期限2';
--changeset wenyuanwu:80 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (tdsyksqx3 DATE);
COMMENT ON COLUMN bdc_fdcq.tdsyksqx3 IS '土地使用开始期限3';
--changeset wenyuanwu:81 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (tdsyjsqx3 DATE);
COMMENT ON COLUMN bdc_fdcq.tdsyjsqx3 IS '土地使用结束期限3';
--changeset wenyuanwu:82 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (DYHTBH VARCHAR2(50));
COMMENT ON COLUMN GD_DY.DYHTBH IS '抵押合同编号';
--changeset wenyuanwu:83 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (ZWR VARCHAR2(50));
COMMENT ON COLUMN GD_DY.ZWR IS '债务人';
--changeset wenyuanwu:84 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_dyaq
  ADD (DYHTBH VARCHAR2(50));
COMMENT ON COLUMN bdc_dyaq.DYHTBH IS '抵押合同编号';
--changeset wenyuanwu:85 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_dyaq
  ADD (DYHTBH VARCHAR2(50));
COMMENT ON COLUMN bdc_dyaq.DYHTBH IS '抵押合同编号';
--changeset wenyuanwu:86 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_sfxm
  ADD (sfxmdm VARCHAR2(50));
COMMENT ON COLUMN bdc_sfxm.sfxmdm IS '收费项目代码';
--changeset wenyuanwu:87 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xt_sfxm
  ADD (sfxmdm VARCHAR2(50));
COMMENT ON COLUMN bdc_xt_sfxm.sfxmdm IS '收费项目代码';
--changeset wenyuanwu:88 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fw
  ADD (myzcs VARCHAR2(50));
COMMENT ON COLUMN gd_fw.myzcs IS '名义总层数';
--changeset wenyuanwu:89 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (myzcs VARCHAR2(50));
COMMENT ON COLUMN bdc_fdcq.myzcs IS '名义总层数';
--changeset wenyuanwu:90 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (tdsyqmj NUMBER(15, 2));
COMMENT ON COLUMN bdc_fdcq.tdsyqmj IS '土地使用权面积';
--changeset wenyuanwu:91 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq_dz
  ADD (tdsyqmj NUMBER(15, 2));
COMMENT ON COLUMN bdc_fdcq_dz.tdsyqmj IS '土地使用权面积';
--changeset wenyuanwu:92 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_xm
  ADD (sffbcz VARCHAR2(1));
COMMENT ON COLUMN gd_fw.sffbcz IS '是否分别持证';
--changeset wenyuanwu:93 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (dytdmj NUMBER(15, 2));
COMMENT ON COLUMN gd_fwsyq.dytdmj IS '独用土地面积';
--changeset wenyuanwu:94 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (fttdmj NUMBER(15, 2));
COMMENT ON COLUMN gd_fwsyq.fttdmj IS '分摊土地面积';
--changeset wenyuanwu:95 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdsyqmj NUMBER(15, 2));
COMMENT ON COLUMN gd_fwsyq.tdsyqmj IS '土地使用权面积';
--changeset wenyuanwu:96 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fw
  ADD (cg NUMBER(10, 2));
COMMENT ON COLUMN gd_fw.cg IS '层高';
--changeset wenyuanwu:97 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XXCXJL
(
  jlid   VARCHAR2(32),
  cxbh   VARCHAR2(100),
  cxrmc  VARCHAR2(100),
  cxrzjh VARCHAR2(100),
  cxzl   VARCHAR2(500),
  czrmc  VARCHAR2(100),
  czsj   DATE,
  cxlb   VARCHAR2(2),
  cxmd   VARCHAR2(1000)
);
COMMENT ON TABLE BDC_XXCXJL
IS '不动产信息查询记录表';
COMMENT ON COLUMN BDC_XXCXJL.jlid
IS '记录id';
COMMENT ON COLUMN BDC_XXCXJL.cxbh
IS '查询编号';
COMMENT ON COLUMN BDC_XXCXJL.cxrmc
IS '查询人名称';
COMMENT ON COLUMN BDC_XXCXJL.cxrzjh
IS '查询人证件号';
COMMENT ON COLUMN BDC_XXCXJL.cxzl
IS '查询坐落';
COMMENT ON COLUMN BDC_XXCXJL.czrmc
IS '操作人名称';
COMMENT ON COLUMN BDC_XXCXJL.czsj
IS '操作时间';
COMMENT ON COLUMN BDC_XXCXJL.cxlb
IS '查询类别';
COMMENT ON COLUMN BDC_XXCXJL.cxmd
IS '查询目的';
--changeset wenyuanwu:98 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdqsxz VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.tdqsxz IS '土地权属性质';
--changeset wenyuanwu:99 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdyt VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.tdyt IS '土地用途';
--changeset wenyuanwu:100 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdsyksrq VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.tdsyksrq IS '土地使用权开始日期';
--changeset wenyuanwu:101 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdsyjsrq VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.tdsyjsrq IS '土地使用权结束日期';
--changeset wenyuanwu:102 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (tdsyqlx VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.tdsyqlx IS '土地使用权类型';
--changeset wenyuanwu:103 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fwfsss
  ADD (ftjzmj NUMBER(15, 2));
COMMENT ON COLUMN bdc_fwfsss.ftjzmj IS '分摊建筑面积';
--changeset wenyuanwu:104 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_dy
  ADD (sfgtdb VARCHAR2(20));
COMMENT ON COLUMN gd_dy.sfgtdb IS '是否共同担保';
--changeset wenyuanwu:105 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_dyaq
  ADD (sfgtdb VARCHAR2(20));
COMMENT ON COLUMN bdc_dyaq.sfgtdb IS '是否共同担保';
--changeset wenyuanwu:107 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (wlc NUMBER);
COMMENT ON COLUMN BDC_FDCQ.wlc IS '物理层';
--changeset wenyuanwu:108 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_yg
  ADD (wlc NUMBER);
COMMENT ON COLUMN bdc_yg.wlc IS '物理层';
--changeset wenyuanwu:109 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_xm
  ADD (csrq DATE);
COMMENT ON COLUMN gd_xm.csrq IS '物理层';
--changeset wenyuanwu:106 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_dyaq
  ADD (dytdmj NUMBER(15, 4));
COMMENT ON COLUMN bdc_dyaq.dytdmj IS '独用土地面积';
--changeset wenyuanwu:110 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XXCXJG
(
  JGID   VARCHAR2(32) NOT NULL,
  BDCDYH VARCHAR2(50),
  CZQH   VARCHAR2(100),
  QLR    VARCHAR2(200),
  DYZT   VARCHAR2(1),
  DYSJ   DATE,
  JBR    VARCHAR2(100),
  XXNR   CLOB,
  JLID   VARCHAR2(32)
);
COMMENT ON TABLE BDC_XXCXJG
IS '不动产信息查询结果';
COMMENT ON COLUMN BDC_XXCXJG.JGID
IS '结果ID';
COMMENT ON COLUMN BDC_XXCXJG.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_XXCXJG.CZQH
IS '产权证号';
COMMENT ON COLUMN BDC_XXCXJG.QLR
IS '权利人';
COMMENT ON COLUMN BDC_XXCXJG.DYZT
IS '打印状态，0：未打印，1：已打印';
COMMENT ON COLUMN BDC_XXCXJG.DYSJ
IS '打印时间';
COMMENT ON COLUMN BDC_XXCXJG.JBR
IS '经办人';
COMMENT ON COLUMN BDC_XXCXJG.XXNR
IS '查询结果详细内容';
COMMENT ON COLUMN BDC_XXCXJG.JLID
IS '查询记录ID';
--changeset wenyuanwu:111 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD CONSTRAINT PK_BDC_XXCXJG_JGID PRIMARY KEY (JGID);
--changeset wenyuanwu:112 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD (CZIP VARCHAR2(20));
COMMENT ON COLUMN BDC_XXCXJL.CZIP IS '操作IP地址';
--changeset wenyuanwu:113 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (TDDYMJSUM NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.TDDYMJSUM IS '土地抵押面积汇总（用于批量抵押）';
--changeset wenyuanwu:114 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FWDYMJSUM NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.FWDYMJSUM IS '房屋抵押面积汇总（用于批量抵押）';
--changeset wenyuanwu:115 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fwfsss
  ADD (fwbm VARCHAR2(50));
COMMENT ON COLUMN bdc_fwfsss.fwbm IS '房屋编码';
--changeset wenyuanwu:116 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_sjcl
  ADD (wjzxid NUMBER(12));
COMMENT ON COLUMN bdc_sjcl.wjzxid IS '文件中心NodeId';
--changeset wenyuanwu:117 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_spxx
  ADD (qlqtzk VARCHAR2(1000));
COMMENT ON COLUMN bdc_spxx.qlqtzk IS '权利其他状况';
--changeset wenyuanwu:118 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (djzch VARCHAR2(10));
COMMENT ON COLUMN bdc_fdcq.djzch IS '所有权登记注册号';
--changeset wenyuanwu:119 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_tdsyq
  ADD (fj VARCHAR2(500));
COMMENT ON COLUMN gd_tdsyq.fj IS '附记';
--changeset wenyuanwu:120 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fwfsss
  ADD (bdcdyh VARCHAR2(50));
COMMENT ON COLUMN bdc_fwfsss.bdcdyh IS '不动产单元号';
--changeset wenyuanwu:121 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD (DYZT VARCHAR2(1));
COMMENT ON COLUMN BDC_ZJJZWXX.DYZT IS '0或者空未注销，1注销';
--changeset wenyuanwu:122 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFZXX
  ADD (szc VARCHAR2(20));
COMMENT ON COLUMN BDC_FWFZXX.szc IS '所在层';
--changeset wenyuanwu:123 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (fjh VARCHAR2(20));
COMMENT ON COLUMN GD_FW.fjh IS '房间号';
--changeset wenyuanwu:124 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD (fjh VARCHAR2(20));
COMMENT ON COLUMN GD_FW_QL.fjh IS '房间号';
--changeset wenyuanwu:125 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFSSS
  ADD (ZFBDCDYH VARCHAR2(200));
COMMENT ON COLUMN BDC_FWFSSS.ZFBDCDYH IS '主房不动产单元号';
--changeset wenyuanwu:126 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_FWZL
(
  qlid    VARCHAR2(32)  NOT NULL,
  bdcdyid VARCHAR2(32),
  dw      VARCHAR2(100),
  zxywh   VARCHAR2(100),
  zxdjsj  DATE,
  zxdbr   VARCHAR2(200),
  zxyy    VARCHAR2(1000),
  zlksqx  DATE,
  zljsqx  DATE,
  ywh     VARCHAR2(100) NOT NULL,
  qllx    VARCHAR2(2),
  proid   VARCHAR2(32)  NOT NULL,
  gyqk    VARCHAR2(200),
  djsj    DATE,
  dbr     VARCHAR2(200),
  fj      VARCHAR2(1000),
  qszt    NUMBER(1) DEFAULT 0,
  bz      VARCHAR2(100)
);
COMMENT ON COLUMN BDC_FWZL.qlid
IS '权利id';
COMMENT ON COLUMN BDC_FWZL.bdcdyid
IS '不动产单元ID';
COMMENT ON COLUMN BDC_FWZL.dw
IS '单位';
COMMENT ON COLUMN BDC_FWZL.zxywh
IS '注销业务号';
COMMENT ON COLUMN BDC_FWZL.zxdjsj
IS '注销登记时间';
COMMENT ON COLUMN BDC_FWZL.zxdbr
IS '注销登簿人';
COMMENT ON COLUMN BDC_FWZL.zxyy
IS '注销原因';
COMMENT ON COLUMN BDC_FWZL.zlksqx
IS '租赁开始期限';
COMMENT ON COLUMN BDC_FWZL.zljsqx
IS '租赁结束期限';
COMMENT ON COLUMN BDC_FWZL.ywh
IS '业务号';
COMMENT ON COLUMN BDC_FWZL.qllx
IS '权利类型';
COMMENT ON COLUMN BDC_FWZL.proid
IS '项目ID';
COMMENT ON COLUMN BDC_FWZL.gyqk
IS '共有情况';
COMMENT ON COLUMN BDC_FWZL.djsj
IS '登记时间';
COMMENT ON COLUMN BDC_FWZL.dbr
IS '登簿人';
COMMENT ON COLUMN BDC_FWZL.fj
IS '附记';
COMMENT ON COLUMN BDC_FWZL.qszt
IS '权属状态';
COMMENT ON COLUMN BDC_FWZL.bz
IS '备注';
--changeset wenyuanwu:127 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fwfsss
  ADD (fttdmj NUMBER(15, 2));
COMMENT ON COLUMN bdc_fwfsss.fttdmj IS '分摊建筑面积';
--changeset wenyuanwu:128 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_BDCDY_CF_REL
(
  BDCDYID VARCHAR2(32) NOT NULL,
  CFID    VARCHAR2(32) NOT NULL,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_BDCDY_CF_REL.BDCDYID
IS '不动产单元主键';
COMMENT ON COLUMN BDC_LS_BDCDY_CF_REL.CFID
IS '查封主键';
COMMENT ON COLUMN BDC_LS_BDCDY_CF_REL.BDCLX
IS '不动产类型';
--changeset wenyuanwu:129 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_CF_REL
  ADD CONSTRAINT PK_BDC_LS_BDCDY_CF_ID PRIMARY KEY (BDCDYID, CFID)
  USING INDEX;
--changeset wenyuanwu:130 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_BDCDY_DY_REL
(
  BDCDYID VARCHAR2(32) NOT NULL,
  DYID    VARCHAR2(32) NOT NULL,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_BDCDY_DY_REL.BDCDYID
IS '不动产单元主键';
COMMENT ON COLUMN BDC_LS_BDCDY_DY_REL.DYID
IS '抵押主键';
COMMENT ON COLUMN BDC_LS_BDCDY_DY_REL.BDCLX
IS '不动产类型';
--changeset wenyuanwu:131 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_DY_REL
  ADD CONSTRAINT PK_BDC_LS_BDCDY_DY_ID PRIMARY KEY (BDCDYID, DYID)
  USING INDEX;

--changeset wenyuanwu:132 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_BDCDY_TDFW_BH
(
  BDCDYID  VARCHAR2(32) NOT NULL,
  BDCDYH   VARCHAR2(29),
  FWBH     VARCHAR2(100),
  YBDCDYID VARCHAR2(32) NOT NULL,
  YBDCDYH  VARCHAR2(29),
  YFWBH    VARCHAR2(100),
  ZL       VARCHAR2(500),
  BGSJ     DATE
);
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.BDCDYID
IS '不动产单元主键';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.FWBH
IS '房屋编号';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.YBDCDYID
IS '原不动产单元主键主键';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.YBDCDYH
IS '原不动产单元号';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.YFWBH
IS '原房屋编号';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.ZL
IS '坐落';
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.BGSJ
IS '变更时间';
--changeset wenyuanwu:133 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_TDFW_BH
  ADD CONSTRAINT PK_BDC_LS_BDCDY_TDFW_BH_ID PRIMARY KEY (BDCDYID, YBDCDYID)
  USING INDEX;
--changeset wenyuanwu:134 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_BDC_LS_BDCDY_TDFW_BDCDYH
  ON BDC_LS_BDCDY_TDFW_BH (BDCDYH);
CREATE INDEX IDX_BDC_LS_BDCDY_TDFW_FWBH
  ON BDC_LS_BDCDY_TDFW_BH (FWBH);
CREATE INDEX IDX_BDC_LS_BDCDY_TDFW_YBDCDYH
  ON BDC_LS_BDCDY_TDFW_BH (YBDCDYH);
CREATE INDEX IDX_BDC_LS_BDCDY_TDFW_YFWBH
  ON BDC_LS_BDCDY_TDFW_BH (YFWBH);
CREATE INDEX IDX_BDC_LS_BDCDY_TDFW_ZL
  ON BDC_LS_BDCDY_TDFW_BH (ZL);
--changeset wenyuanwu:135 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_BDCDY_TD_BH
(
  BDCDYID  VARCHAR2(32) NOT NULL,
  BDCDYH   VARCHAR2(29),
  DJH      VARCHAR2(100),
  YBDCDYID VARCHAR2(32) NOT NULL,
  YBDCDYH  VARCHAR2(29),
  YDJH     VARCHAR2(100),
  ZL       VARCHAR2(500),
  BGSJ     DATE
);
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.BDCDYID
IS '不动产单元主键';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.DJH
IS '地籍号';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.YBDCDYID
IS '原不动产单元主键主键';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.YBDCDYH
IS '原不动产单元号';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.YDJH
IS '原地籍号';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.ZL
IS '坐落';
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.BGSJ
IS '变更时间';
--changeset wenyuanwu:1210 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_TD_BH
  ADD CONSTRAINT PK_BDC_LS_BDCDY_TD_ID PRIMARY KEY (BDCDYID, YBDCDYID)
  USING INDEX;
--changeset wenyuanwu:1211 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_BDC_LS_BDCDY_TD_BDCDYH
  ON BDC_LS_BDCDY_TD_BH (BDCDYH);
CREATE INDEX IDX_BDC_LS_BDCDY_TD_DJH
  ON BDC_LS_BDCDY_TD_BH (DJH);
CREATE INDEX IDX_BDC_LS_BDCDY_TD_YBDCDYH
  ON BDC_LS_BDCDY_TD_BH (YBDCDYH);
CREATE INDEX IDX_BDC_LS_BDCDY_TD_YDJH
  ON BDC_LS_BDCDY_TD_BH (YDJH);
CREATE INDEX IDX_BDC_LS_BDCDY_TD_ZL
  ON BDC_LS_BDCDY_TD_BH (ZL);

--changeset wenyuanwu:136 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_CF_BH
(
  CFID    VARCHAR2(32) NOT NULL,
  YCFID   VARCHAR2(32) NOT NULL,
  CFWH    VARCHAR2(100),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(500),
  YCFWH   VARCHAR2(100),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(500),
  DBSJ    DATE,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_CF_BH.CFID
IS '查封主键';
COMMENT ON COLUMN BDC_LS_CF_BH.YCFID
IS '原查封主键';
COMMENT ON COLUMN BDC_LS_CF_BH.CFWH
IS '查封文号';
COMMENT ON COLUMN BDC_LS_CF_BH.QLR
IS '权利人';
COMMENT ON COLUMN BDC_LS_CF_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN BDC_LS_CF_BH.ZL
IS '坐落';
COMMENT ON COLUMN BDC_LS_CF_BH.YCFWH
IS '原查封文号';
COMMENT ON COLUMN BDC_LS_CF_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN BDC_LS_CF_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN BDC_LS_CF_BH.YZL
IS '原坐落';
COMMENT ON COLUMN BDC_LS_CF_BH.DBSJ
IS '登薄时间';
COMMENT ON COLUMN BDC_LS_CF_BH.BDCLX
IS '不动产类型';
--changeset wenyuanwu:137 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_CF_BH
  ADD CONSTRAINT PK_BDC_LS_CF_BH_ID PRIMARY KEY (CFID, YCFID)
  USING INDEX;
--changeset wenyuanwu:1216 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_BDC_LS_CF_CFWH
  ON BDC_LS_CF_BH (CFWH);
CREATE INDEX IDX_BDC_LS_CF_QLR
  ON BDC_LS_CF_BH (QLR);
CREATE INDEX IDX_BDC_LS_CF_ZL
  ON BDC_LS_CF_BH (ZL);
--changeset wenyuanwu:138 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_DY_BH
(
  DYID    VARCHAR2(32) NOT NULL,
  YDYID   VARCHAR2(32) NOT NULL,
  CQZH    VARCHAR2(100),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(2000),
  YCQZH   VARCHAR2(100),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(2000),
  DBSJ    DATE,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_DY_BH.DYID
IS '抵押ID';
COMMENT ON COLUMN BDC_LS_DY_BH.YDYID
IS '原抵押ID';
COMMENT ON COLUMN BDC_LS_DY_BH.CQZH
IS '产权证号';
COMMENT ON COLUMN BDC_LS_DY_BH.QLR
IS '权利人';
COMMENT ON COLUMN BDC_LS_DY_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN BDC_LS_DY_BH.ZL
IS '坐落';
COMMENT ON COLUMN BDC_LS_DY_BH.YCQZH
IS '原产权证号';
COMMENT ON COLUMN BDC_LS_DY_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN BDC_LS_DY_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN BDC_LS_DY_BH.YZL
IS '原坐落';
COMMENT ON COLUMN BDC_LS_DY_BH.DBSJ
IS '登薄时间';
COMMENT ON COLUMN BDC_LS_DY_BH.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1217 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_DY_BH
  ADD CONSTRAINT PK_BDC_LS_DY_BH_ID PRIMARY KEY (DYID, YDYID)
  USING INDEX;
--changeset wenyuanwu:1218 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_BDC_LS_DY_CQZH
  ON BDC_LS_DY_BH (CQZH);
CREATE INDEX IDX_BDC_LS_DY_QLR
  ON BDC_LS_DY_BH (QLR);
CREATE INDEX IDX_BDC_LS_DY_QLRZJH
  ON BDC_LS_DY_BH (QLRZJH);
CREATE INDEX IDX_BDC_LS_DY_ZL
  ON BDC_LS_DY_BH (ZL);

--changeset wenyuanwu:139 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_QL_BH
(
  QLID    VARCHAR2(32) NOT NULL,
  YQLID   VARCHAR2(32) NOT NULL,
  CQZH    VARCHAR2(1000),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(2000),
  YCQZH   VARCHAR2(1000),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(2000),
  DBSJ    DATE,
  BDCDYH  VARCHAR2(4000),
  BDCLX   VARCHAR2(10),
  QLLX    VARCHAR2(3),
  QSZT    VARCHAR2(1)
);
COMMENT ON COLUMN BDC_LS_QL_BH.QLID
IS '权利ID';
COMMENT ON COLUMN BDC_LS_QL_BH.YQLID
IS '原权利ID';
COMMENT ON COLUMN BDC_LS_QL_BH.CQZH
IS '产权证号';
COMMENT ON COLUMN BDC_LS_QL_BH.QLR
IS '权利人';
COMMENT ON COLUMN BDC_LS_QL_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN BDC_LS_QL_BH.ZL
IS '坐落';
COMMENT ON COLUMN BDC_LS_QL_BH.YCQZH
IS '原产权证号';
COMMENT ON COLUMN BDC_LS_QL_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN BDC_LS_QL_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN BDC_LS_QL_BH.YZL
IS '原坐落';
COMMENT ON COLUMN BDC_LS_QL_BH.DBSJ
IS '登薄时间';
COMMENT ON COLUMN BDC_LS_QL_BH.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_LS_QL_BH.BDCLX
IS '不动产类型';
COMMENT ON COLUMN BDC_LS_QL_BH.QLLX
IS '权利类型';
COMMENT ON COLUMN BDC_LS_QL_BH.QSZT
IS '权属状态';
--changeset wenyuanwu:1300 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_QL_BH
  ADD CONSTRAINT PK_BDC_LS_QL_BH_ID PRIMARY KEY (QLID, YQLID)
  USING INDEX;
--changeset wenyuanwu:1301 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_BDC_LS_QL_CQZH
  ON BDC_LS_QL_BH (CQZH);
CREATE INDEX IDX_BDC_LS_QL_QLR
  ON BDC_LS_QL_BH (QLR);
CREATE INDEX IDX_BDC_LS_QL_QLRZJH
  ON BDC_LS_QL_BH (QLRZJH);
CREATE INDEX IDX_BDC_LS_QL_ZL
  ON BDC_LS_QL_BH (ZL);

--changeset wenyuanwu:140 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_QL_DY_REL
(
  DYID  VARCHAR2(32) NOT NULL,
  QLID  VARCHAR2(32) NOT NULL,
  BDCLX VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_QL_DY_REL.DYID
IS '抵押主键';
COMMENT ON COLUMN BDC_LS_QL_DY_REL.QLID
IS '权利主键';
COMMENT ON COLUMN BDC_LS_QL_DY_REL.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1302 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_QL_DY_REL
  ADD CONSTRAINT PK_BDC_LS_QL_DY_REL_ID PRIMARY KEY (DYID, QLID)
  USING INDEX;

--changeset wenyuanwu:141 failOnError:false runOnChange:true runAlways:true

CREATE TABLE GD_LS_CF_BH
(
  CFID    VARCHAR2(32) NOT NULL,
  YCFID   VARCHAR2(32) NOT NULL,
  CFWH    VARCHAR2(100),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(500),
  YCFWH   VARCHAR2(100),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(500),
  DBSJ    DATE,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN GD_LS_CF_BH.CFID
IS '查封主键';
COMMENT ON COLUMN GD_LS_CF_BH.YCFID
IS '原查封主键';
COMMENT ON COLUMN GD_LS_CF_BH.CFWH
IS '查封文号';
COMMENT ON COLUMN GD_LS_CF_BH.QLR
IS '权利人';
COMMENT ON COLUMN GD_LS_CF_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN GD_LS_CF_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_CF_BH.YCFWH
IS '原查封文号';
COMMENT ON COLUMN GD_LS_CF_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN GD_LS_CF_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN GD_LS_CF_BH.YZL
IS '原坐落';
COMMENT ON COLUMN GD_LS_CF_BH.DBSJ
IS '登薄时间';
COMMENT ON COLUMN GD_LS_CF_BH.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1303 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_CF_BH
  ADD CONSTRAINT PK_GD_LS_CF_BH_ID PRIMARY KEY (CFID, YCFID)
  USING INDEX;
--changeset wenyuanwu:1304 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_CF_BH_CFWH
  ON GD_LS_CF_BH (CFWH);
CREATE INDEX IDX_GD_LS_CF_BH_QLR
  ON GD_LS_CF_BH (QLR);
CREATE INDEX IDX_GD_LS_CF_BH_QLRZJH
  ON GD_LS_CF_BH (QLRZJH);
CREATE INDEX IDX_GD_LS_CF_BH_ZL
  ON GD_LS_CF_BH (ZL);

--changeset wenyuanwu:142 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_DY_BH
(
  DYID    VARCHAR2(32) NOT NULL,
  YDYID   VARCHAR2(32) NOT NULL,
  CQZH    VARCHAR2(100),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(2000),
  YCQZH   VARCHAR2(100),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(2000),
  DBSJ    DATE,
  BDCLX   VARCHAR2(10)
);
COMMENT ON COLUMN GD_LS_DY_BH.DYID
IS '抵押ID';
COMMENT ON COLUMN GD_LS_DY_BH.YDYID
IS '原抵押ID';
COMMENT ON COLUMN GD_LS_DY_BH.CQZH
IS '产权证号';
COMMENT ON COLUMN GD_LS_DY_BH.QLR
IS '权利人';
COMMENT ON COLUMN GD_LS_DY_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN GD_LS_DY_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_DY_BH.YCQZH
IS '原产权证号';
COMMENT ON COLUMN GD_LS_DY_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN GD_LS_DY_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN GD_LS_DY_BH.YZL
IS '原坐落';
COMMENT ON COLUMN GD_LS_DY_BH.DBSJ
IS '登薄时间';
COMMENT ON COLUMN GD_LS_DY_BH.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1305 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_DY_BH
  ADD CONSTRAINT PK_GD_LS_DY_BH_ID PRIMARY KEY (DYID, YDYID)
  USING INDEX;
--changeset wenyuanwu:1306 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_DY_BH_CZQH
  ON GD_LS_DY_BH (CQZH);
CREATE INDEX IDX_GD_LS_DY_BH_QLR
  ON GD_LS_DY_BH (QLR);
CREATE INDEX IDX_GD_LS_DY_BH_QLRZJH
  ON GD_LS_DY_BH (QLRZJH);
CREATE INDEX IDX_GD_LS_DY_BH_ZL
  ON GD_LS_DY_BH (ZL);
--changeset wenyuanwu:143 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_FW_BH
(
  FWID  VARCHAR2(32) NOT NULL,
  FWBH  VARCHAR2(100),
  YFWID VARCHAR2(32) NOT NULL,
  YFWBH VARCHAR2(100),
  ZL    VARCHAR2(500),
  BGSJ  DATE
);
COMMENT ON COLUMN GD_LS_FW_BH.FWID
IS '房屋主键';
COMMENT ON COLUMN GD_LS_FW_BH.FWBH
IS '房屋编号';
COMMENT ON COLUMN GD_LS_FW_BH.YFWID
IS '原房屋主键';
COMMENT ON COLUMN GD_LS_FW_BH.YFWBH
IS '原房屋编号';
COMMENT ON COLUMN GD_LS_FW_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_FW_BH.BGSJ
IS '变更时间';
--changeset wenyuanwu:1307 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_FW_BH
  ADD CONSTRAINT PK_GD_LS_FW_BH_ID PRIMARY KEY (FWID, YFWID)
  USING INDEX;
--changeset wenyuanwu:1308 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_FW_BH_FWBH
  ON GD_LS_FW_BH (FWBH);
CREATE INDEX IDX_GD_LS_FW_BH_ZL
  ON GD_LS_FW_BH (ZL);

--changeset wenyuanwu:144 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_FW_QL_BH
(
  QLID    VARCHAR2(32) NOT NULL,
  YQLID   VARCHAR2(32) NOT NULL,
  CQZH    VARCHAR2(1000),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(2000),
  YCQZH   VARCHAR2(1000),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(2000),
  DBSJ    DATE
);
COMMENT ON COLUMN GD_LS_FW_QL_BH.QLID
IS '权利ID';
COMMENT ON COLUMN GD_LS_FW_QL_BH.YQLID
IS '原权利ID';
COMMENT ON COLUMN GD_LS_FW_QL_BH.CQZH
IS '产权证号';
COMMENT ON COLUMN GD_LS_FW_QL_BH.QLR
IS '权利人';
COMMENT ON COLUMN GD_LS_FW_QL_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN GD_LS_FW_QL_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_FW_QL_BH.YCQZH
IS '原产权证号';
COMMENT ON COLUMN GD_LS_FW_QL_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN GD_LS_FW_QL_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN GD_LS_FW_QL_BH.YZL
IS '原坐落';
COMMENT ON COLUMN GD_LS_FW_QL_BH.DBSJ
IS '登薄时间';
--changeset wenyuanwu:1310 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_FW_QL_BH
  ADD CONSTRAINT PK_GD_LS_FW_QL_BH_ID PRIMARY KEY (QLID, YQLID)
  USING INDEX;
--changeset wenyuanwu:1311 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_FW_QL_BH_CQZH
  ON GD_LS_FW_QL_BH (CQZH);
CREATE INDEX IDX_GD_LS_FW_QL_BH_QLR
  ON GD_LS_FW_QL_BH (QLR);
CREATE INDEX IDX_GD_LS_FW_QL_BH_QLRZJH
  ON GD_LS_FW_QL_BH (QLRZJH);
CREATE INDEX IDX_GD_LS_FW_QL_BH_ZL
  ON GD_LS_FW_QL_BH (ZL);

--changeset wenyuanwu:145 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_FW_QL_REL
(
  FWID VARCHAR2(32) NOT NULL,
  QLID VARCHAR2(32) NOT NULL,
  QLLX VARCHAR2(1)
);
COMMENT ON COLUMN GD_LS_FW_QL_REL.FWID
IS '房屋主键';
COMMENT ON COLUMN GD_LS_FW_QL_REL.QLID
IS '权利ID';
COMMENT ON COLUMN GD_LS_FW_QL_REL.QLLX
IS '权利类型';
--changeset wenyuanwu:1312 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_FW_QL_REL
  ADD CONSTRAINT PK_GD_LS_FW_QL_REL_ID PRIMARY KEY (FWID, QLID)
  USING INDEX;

--changeset wenyuanwu:146 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_QL_CF_REL
(
  CFID  VARCHAR2(32) NOT NULL,
  QLID  VARCHAR2(32) NOT NULL,
  BDCLX VARCHAR2(10)
);
COMMENT ON COLUMN GD_LS_QL_CF_REL.CFID
IS '查封主键';
COMMENT ON COLUMN GD_LS_QL_CF_REL.QLID
IS '权利主键';
COMMENT ON COLUMN GD_LS_QL_CF_REL.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1313 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_QL_CF_REL
  ADD CONSTRAINT PK_GD_LS_QL_CF_REL_ID PRIMARY KEY (CFID, QLID)
  USING INDEX;

--changeset wenyuanwu:147 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_QL_DY_REL
(
  DYID  VARCHAR2(32) NOT NULL,
  QLID  VARCHAR2(32) NOT NULL,
  BDCLX VARCHAR2(10)
);
COMMENT ON COLUMN GD_LS_QL_DY_REL.DYID
IS '抵押主键';
COMMENT ON COLUMN GD_LS_QL_DY_REL.QLID
IS '权利主键';
COMMENT ON COLUMN GD_LS_QL_DY_REL.BDCLX
IS '不动产类型';
--changeset wenyuanwu:1314 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_QL_DY_REL
  ADD CONSTRAINT PK_GD_LS_QL_DY_REL_ID PRIMARY KEY (DYID, QLID)
  USING INDEX;

--changeset wenyuanwu:148 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_TD_BH
(
  TDID  VARCHAR2(32) NOT NULL,
  DJH   VARCHAR2(100),
  YTDID VARCHAR2(32) NOT NULL,
  YDJH  VARCHAR2(100),
  ZL    VARCHAR2(500),
  BGSJ  DATE
);
COMMENT ON COLUMN GD_LS_TD_BH.TDID
IS '宗地主键';
COMMENT ON COLUMN GD_LS_TD_BH.DJH
IS '地籍号';
COMMENT ON COLUMN GD_LS_TD_BH.YTDID
IS '原宗地主键';
COMMENT ON COLUMN GD_LS_TD_BH.YDJH
IS '原地籍号';
COMMENT ON COLUMN GD_LS_TD_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_TD_BH.BGSJ
IS '变更时间';
--changeset wenyuanwu:1315 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_TD_BH
  ADD CONSTRAINT PK_GD_LS_TD_BH_ID PRIMARY KEY (TDID, YTDID)
  USING INDEX;
CREATE INDEX IDX_GD_LS_TD_BH_DJH
  ON GD_LS_TD_BH (DJH);
CREATE INDEX IDX_GD_LS_TD_BH_ZL
  ON GD_LS_TD_BH (ZL);
--changeset wenyuanwu:149 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_TD_QL_BH
(
  QLID    VARCHAR2(32) NOT NULL,
  YQLID   VARCHAR2(32) NOT NULL,
  CQZH    VARCHAR2(100),
  QLR     VARCHAR2(500),
  QLRZJH  VARCHAR2(500),
  ZL      VARCHAR2(500),
  YCQZH   VARCHAR2(100),
  YQLR    VARCHAR2(500),
  YQLRZJH VARCHAR2(500),
  YZL     VARCHAR2(500),
  DBSJ    DATE
);
COMMENT ON COLUMN GD_LS_TD_QL_BH.QLID
IS '权利ID';
COMMENT ON COLUMN GD_LS_TD_QL_BH.YQLID
IS '原权利ID';
COMMENT ON COLUMN GD_LS_TD_QL_BH.CQZH
IS '产权证号';
COMMENT ON COLUMN GD_LS_TD_QL_BH.QLR
IS '权利人';
COMMENT ON COLUMN GD_LS_TD_QL_BH.QLRZJH
IS '权利人证件号';
COMMENT ON COLUMN GD_LS_TD_QL_BH.ZL
IS '坐落';
COMMENT ON COLUMN GD_LS_TD_QL_BH.YCQZH
IS '原产权证号';
COMMENT ON COLUMN GD_LS_TD_QL_BH.YQLR
IS '原权利人';
COMMENT ON COLUMN GD_LS_TD_QL_BH.YQLRZJH
IS '原权利人证件号';
COMMENT ON COLUMN GD_LS_TD_QL_BH.YZL
IS '原坐落';
COMMENT ON COLUMN GD_LS_TD_QL_BH.DBSJ
IS '登薄时间';
--changeset wenyuanwu:1317 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_TD_QL_BH
  ADD CONSTRAINT PK_GD_LS_TD_QL_BH_ID PRIMARY KEY (QLID, YQLID)
  USING INDEX;
--changeset wenyuanwu:1318 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_TD_QL_BH_CQZH
  ON GD_LS_TD_QL_BH (CQZH);
CREATE INDEX IDX_GD_LS_TD_QL_BH_QLR
  ON GD_LS_TD_QL_BH (QLR);
CREATE INDEX IDX_GD_LS_TD_QL_BH_QLRZJH
  ON GD_LS_TD_QL_BH (QLRZJH);
CREATE INDEX IDX_GD_LS_TD_QL_BH_ZL
  ON GD_LS_TD_QL_BH (ZL);
--changeset wenyuanwu:150 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_TD_QL_REL
(
  TDID VARCHAR2(32) NOT NULL,
  QLID VARCHAR2(32) NOT NULL,
  QLLX VARCHAR2(1)
);
COMMENT ON COLUMN GD_LS_TD_QL_REL.TDID
IS '宗地主键';
COMMENT ON COLUMN GD_LS_TD_QL_REL.QLID
IS '权利ID';
COMMENT ON COLUMN GD_LS_TD_QL_REL.QLLX
IS '权利类型';
--changeset wenyuanwu:1319 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_TD_QL_REL
  ADD CONSTRAINT PK_GD_LS_TD_QL_REL_ID PRIMARY KEY (TDID, QLID)
  USING INDEX;

--changeset wenyuanwu:151 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_tdsyq
  ADD (sffgw VARCHAR2(1));
COMMENT ON COLUMN gd_tdsyq.sffgw IS '办结时是否分割完,0不注销,1注销';
--changeset wenyuanwu:152 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_tdsyq
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_tdsyq.daywh IS '档案业务号';
--changeset wenyuanwu:153 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.daywh IS '档案业务号';

--changeset wenyuanwu:154 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (djsj DATE);
COMMENT ON COLUMN gd_fwsyq.djsj IS '登记时间';
--changeset wenyuanwu:155 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_fwsyq
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_fwsyq.dbr IS '登薄人';
--changeset wenyuanwu:156 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_tdsyq
  ADD (djsj DATE);
COMMENT ON COLUMN gd_tdsyq.djsj IS '登记时间';
--changeset wenyuanwu:157 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_tdsyq
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_tdsyq.dbr IS '登薄人';
--changeset wenyuanwu:158 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (djsj DATE);
COMMENT ON COLUMN gd_cf.djsj IS '登记时间';
--changeset wenyuanwu:159 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_cf.dbr IS '登薄人';
--changeset wenyuanwu:160 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_dy
  ADD (djsj DATE);
COMMENT ON COLUMN gd_dy.djsj IS '登记时间';
--changeset wenyuanwu:161 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_dy
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_dy.dbr IS '登薄人';
--changeset wenyuanwu:162 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yg
  ADD (djsj DATE);
COMMENT ON COLUMN gd_yg.djsj IS '登记时间';
--changeset wenyuanwu:163 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yg
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_yg.dbr IS '登薄人';
--changeset wenyuanwu:164 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yy
  ADD (djsj DATE);
COMMENT ON COLUMN gd_yy.djsj IS '登记时间';
--changeset wenyuanwu:165 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yy
  ADD (dbr VARCHAR2(100));
COMMENT ON COLUMN gd_yy.dbr IS '登薄人';
--changeset wenyuanwu:166 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DYWQD
(
  dywid  VARCHAR2(32) NOT NULL,
  qlid   VARCHAR2(32) NOT NULL,
  proid  VARCHAR2(32),
  bdcdyh VARCHAR2(100),
  fwbm   VARCHAR2(100),
  zl     VARCHAR2(1000),
  tddymj NUMBER(15, 2),
  fwdymj NUMBER(15, 2),
  dzwyt  VARCHAR2(100),
  ybdczh VARCHAR2(100),
  djsj   DATE,
  dbr    VARCHAR2(200),
  qszt   NUMBER
);
COMMENT ON TABLE BDC_DYWQD
IS '不动产抵押物清单';
COMMENT ON COLUMN BDC_DYWQD.dywid
IS '抵押物id';
COMMENT ON COLUMN BDC_DYWQD.qlid
IS '权利id';
COMMENT ON COLUMN BDC_DYWQD.proid
IS '项目id';
COMMENT ON COLUMN BDC_DYWQD.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_DYWQD.fwbm
IS '房屋编码';
COMMENT ON COLUMN BDC_DYWQD.zl
IS '坐落';
COMMENT ON COLUMN BDC_DYWQD.tddymj
IS '土地抵押面积';
COMMENT ON COLUMN BDC_DYWQD.fwdymj
IS '房屋抵押面积';
COMMENT ON COLUMN BDC_DYWQD.dzwyt
IS '定着物用途';
COMMENT ON COLUMN BDC_DYWQD.ybdczh
IS '原不动产证号';
COMMENT ON COLUMN BDC_DYWQD.djsj
IS '登记时间';
COMMENT ON COLUMN BDC_DYWQD.dbr
IS '登簿人';
COMMENT ON COLUMN BDC_DYWQD.qszt
IS '1：现势 2：历史';
--changeset wenyuanwu:167 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_fdcq
  ADD (ytzx VARCHAR2(100));
COMMENT ON COLUMN bdc_fdcq.ytzx IS '用途子项';

--changeset wenyuanwu:168 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (FJ VARCHAR2(4000));
COMMENT ON COLUMN BDC_ZS.FJ IS '附记';
--changeset wenyuanwu:169 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (BDCDYH VARCHAR2(2000));
COMMENT ON COLUMN BDC_ZS.BDCDYH IS '不动产单元号';
--changeset wenyuanwu:170 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (ZL VARCHAR2(4000));
COMMENT ON COLUMN BDC_ZS.ZL IS '坐落';
--changeset wenyuanwu:171 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (ZMQLSX VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.ZMQLSX IS '证明权利或事项';
--changeset wenyuanwu:172 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (QLR VARCHAR2(4000));
COMMENT ON COLUMN BDC_ZS.QLR IS '权利人';
--changeset wenyuanwu:173 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (YWR VARCHAR2(4000));
COMMENT ON COLUMN BDC_ZS.YWR IS '义务人';
--changeset wenyuanwu:174 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (GYQK VARCHAR2(4000));
COMMENT ON COLUMN BDC_ZS.GYQK IS '共有情况';
--changeset wenyuanwu:175 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (QLLX VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.QLLX IS '权利类型';
--changeset wenyuanwu:176 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (QLXZ VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.QLXZ IS '权利性质';
--changeset wenyuanwu:177 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (YT VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.YT IS '用途';
--changeset wenyuanwu:178 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (MJ VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.MJ IS '面积';
--changeset wenyuanwu:179 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (SYQX VARCHAR2(200));
COMMENT ON COLUMN BDC_ZS.SYQX IS '使用期限';

--changeset wenyuanwu:180 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (TDSYKSQX DATE);
COMMENT ON COLUMN BDC_YG.TDSYKSQX IS '土地使用开始期限';
--changeset wenyuanwu:181 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (TDSYJSQX DATE);
COMMENT ON COLUMN BDC_YG.TDSYJSQX IS '土地使用结束期限';
--changeset wenyuanwu:182 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_DAMLH
(
  ZSLX  VARCHAR2(50),
  MLH   NUMBER,
  ID    VARCHAR2(50),
  BDCLX VARCHAR2(20)
);
--changeset wenyuanwu:183 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (DYFS VARCHAR2(2));
COMMENT ON COLUMN BDC_YG.DYFS IS '抵押方式';
--changeset wenyuanwu:184 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_FY
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_FY
IS '法院字典表';
--changeset wenyuanwu:185 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (fysdrzjhm VARCHAR2(20));
COMMENT ON COLUMN BDC_CF.fysdrzjhm IS '法院送达人证件号码';

--changeset wenyuanwu:186 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (PTH VARCHAR2(55));
COMMENT ON COLUMN GD_FW.PTH IS '配图号';
--changeset wenyuanwu:187 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (PTH VARCHAR2(55));
COMMENT ON COLUMN BDC_FDCQ.PTH IS '配图号';

--changeset wenyuanwu:188 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_ZJJZWXX
  ADD (jyyy VARCHAR2(2000));
COMMENT ON COLUMN BDC_ZJJZWXX.jyyy IS '解押原因';
--changeset wenyuanwu:189 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD (jyr VARCHAR2(200));
COMMENT ON COLUMN BDC_ZJJZWXX.jyr IS '解押人';
--changeset wenyuanwu:190 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD (jyrq DATE);
COMMENT ON COLUMN BDC_ZJJZWXX.jyrq IS '解押日期';
--changeset wenyuanwu:191 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (sfzt VARCHAR2(1));
COMMENT ON COLUMN BDC_SFXX.sfzt IS '收费状态 1：转结';
--changeset wenyuanwu:192 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (QLQSSJ DATE);
COMMENT ON COLUMN BDC_FWZL.QLQSSJ IS '权利起始时间';
--changeset wenyuanwu:193 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (QLJSSJ DATE);
COMMENT ON COLUMN BDC_FWZL.QLJSSJ IS '权利结束时间';
--changeset wenyuanwu:194 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (ZLXYSDSJ DATE);
COMMENT ON COLUMN BDC_FWZL.ZLXYSDSJ IS '租赁协议送达时间';
--changeset wenyuanwu:195 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_DYAQ
  ADD (DBFW VARCHAR2(1000));
COMMENT ON COLUMN BDC_DYAQ.DBFW IS '担保范围';
--changeset wenyuanwu:196 failOnError:false runOnChange:true runAlways:true
CREATE TABLE NATIONAL_ACCESS
(
  biz_msg_id       VARCHAR2(22) NOT NULL,
  asid             VARCHAR2(5),
  area_code        VARCHAR2(12),
  rec_type         VARCHAR2(7),
  right_type       VARCHAR2(2),
  reg_type         VARCHAR2(8),
  create_date      DATE,
  rec_flow_id      VARCHAR2(50),
  reg_org_id       VARCHAR2(200),
  parcel_id        VARCHAR2(19),
  estate_num       VARCHAR2(28),
  pre_estate_num   VARCHAR2(256),
  pre_cert_id      VARCHAR2(256),
  cert_count       VARCHAR2(3),
  proof_count      VARCHAR2(3),
  success_flag     NUMBER,
  response_code    VARCHAR2(4),
  response_info    VARCHAR2(256),
  cert_id          VARCHAR2(128),
  additional_data  VARCHAR2(512),
  additional_data2 VARCHAR2(512),
  qr_code          CLOB,
  access_date      DATE
);
COMMENT ON TABLE NATIONAL_ACCESS
IS '数据汇交响应';
COMMENT ON COLUMN NATIONAL_ACCESS.biz_msg_id
IS '业务报文ID';
COMMENT ON COLUMN NATIONAL_ACCESS.asid
IS '接入标准ID';
COMMENT ON COLUMN NATIONAL_ACCESS.area_code
IS '行政区划编码';
COMMENT ON COLUMN NATIONAL_ACCESS.rec_type
IS '业务编码';
COMMENT ON COLUMN NATIONAL_ACCESS.right_type
IS '权利类型';
COMMENT ON COLUMN NATIONAL_ACCESS.reg_type
IS '登记类型';
COMMENT ON COLUMN NATIONAL_ACCESS.create_date
IS '创建时间';
COMMENT ON COLUMN NATIONAL_ACCESS.rec_flow_id
IS '业务流水号';
COMMENT ON COLUMN NATIONAL_ACCESS.reg_org_id
IS '登记机构';
COMMENT ON COLUMN NATIONAL_ACCESS.parcel_id
IS '宗地宗海代码';
COMMENT ON COLUMN NATIONAL_ACCESS.estate_num
IS '不动产单元号';
COMMENT ON COLUMN NATIONAL_ACCESS.pre_estate_num
IS '上次不动产单元号';
COMMENT ON COLUMN NATIONAL_ACCESS.pre_cert_id
IS '上次不动产权证号/不动产权证明号';
COMMENT ON COLUMN NATIONAL_ACCESS.cert_count
IS '不动产权证号码数量';
COMMENT ON COLUMN NATIONAL_ACCESS.proof_count
IS '证明号码数量';
COMMENT ON COLUMN NATIONAL_ACCESS.success_flag
IS '成功标识';
COMMENT ON COLUMN NATIONAL_ACCESS.response_code
IS '响应编码';
COMMENT ON COLUMN NATIONAL_ACCESS.response_info
IS '报文响应信息';
COMMENT ON COLUMN NATIONAL_ACCESS.cert_id
IS '配号：不动产证书编号';
COMMENT ON COLUMN NATIONAL_ACCESS.additional_data
IS '附加信息';
COMMENT ON COLUMN NATIONAL_ACCESS.additional_data2
IS '附加信息,扩展字段';
COMMENT ON COLUMN NATIONAL_ACCESS.qr_code
IS '防伪二维码';
COMMENT ON COLUMN NATIONAL_ACCESS.access_date
IS '汇交时间';
--changeset wenyuanwu:1320 failOnError:false runOnChange:true runAlways:true
ALTER TABLE NATIONAL_ACCESS
  ADD CONSTRAINT PK_NATIONAL_ACCESS PRIMARY KEY (BIZ_MSG_ID);

--changeset wenyuanwu:197 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_EXCHANGE_ZDDZ
(
  bdcdjdm VARCHAR2(100),
  bdcdjmc VARCHAR2(100),
  zdlx    VARCHAR2(100),
  stddm   VARCHAR2(100),
  stdmc   VARCHAR2(100),
  id      VARCHAR2(32) NOT NULL
);
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.bdcdjdm
IS '不动产本地代码';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.bdcdjmc
IS '不动产本地名称';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.zdlx
IS '字典类型fwyt（房屋用途）、qllx（权利类型）、fwjg(房屋结构)';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.stddm
IS '国家标准代码';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.stdmc
IS '国家标准名称';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.id
IS '主键';
--changeset wenyuanwu:1321 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_EXCHANGE_ZDDZ
  ADD CONSTRAINT PK_EXCHANGE_ID PRIMARY KEY (ID);
--changeset wenyuanwu:198 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_XT_CFJG
(
  cfjgid  VARCHAR2(32) NOT NULL,
  cfjg    VARCHAR2(100),
  bz      VARCHAR2(1000),
  txdz    VARCHAR2(200),
  yb      VARCHAR2(10),
  fzr     VARCHAR2(100),
  fzrlxdh VARCHAR2(100)
);
COMMENT ON TABLE BDC_XT_CFJG
IS '不动产查封机关';
COMMENT ON COLUMN BDC_XT_CFJG.cfjgid
IS 'id';
COMMENT ON COLUMN BDC_XT_CFJG.cfjg
IS '查封机关';
COMMENT ON COLUMN BDC_XT_CFJG.bz
IS '备注';
COMMENT ON COLUMN BDC_XT_CFJG.txdz
IS '通讯地址';
COMMENT ON COLUMN BDC_XT_CFJG.yb
IS '邮编';
COMMENT ON COLUMN BDC_XT_CFJG.fzr
IS '负责人';
COMMENT ON COLUMN BDC_XT_CFJG.fzrlxdh
IS '负责人联系电话';
--changeset wenyuanwu:199 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (TSXX VARCHAR(500));
COMMENT ON COLUMN BDC_ZS.TSXX IS '提示信息';
--changeset wenyuanwu:200 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (SFTQSCZS VARCHAR2(10));
COMMENT ON COLUMN BDC_XM.SFTQSCZS IS '是否提前生成证书（1：是0：否）';

--changeset wenyuanwu:201 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (SYDYJE NUMBER(15, 4));
COMMENT ON COLUMN BDC_DYAQ.SYDYJE IS '剩余抵押金额';
--changeset wenyuanwu:202 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (SYDYMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_DYAQ.SYDYMJ IS '剩余抵押面积';
--changeset wenyuanwu:203 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (SYDYJE NUMBER(15, 4));
COMMENT ON COLUMN GD_DY.SYDYJE IS '剩余抵押金额';
--changeset wenyuanwu:204 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (SYDYMJ NUMBER(15, 2));
COMMENT ON COLUMN GD_DY.SYDYMJ IS '剩余抵押面积';
--changeset wenyuanwu:205 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SYFTTDMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SYFTTDMJ IS '剩余分摊土地面积';
--changeset wenyuanwu:206 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (SYFTTDMJ NUMBER(15, 2));
COMMENT ON COLUMN GD_TDSYQ.SYFTTDMJ IS '剩余分摊土地面积';
--changeset wenyuanwu:207 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SPF_ZD_HJGX
(
  relid    VARCHAR2(32) NOT NULL,
  proid    VARCHAR2(32),
  zdbdcdyh VARCHAR2(28),
  djh      VARCHAR2(19),
  tdzl     VARCHAR2(1000),
  fwbdcdyh VARCHAR2(28),
  fwzl     VARCHAR2(1000),
  fwhjtdmj NUMBER(15, 2),
  hjsj     DATE,
  fwhjdyje NUMBER(15, 4),
  bz       VARCHAR2(2000),
  xmhjdyje NUMBER(15, 4)
);
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.relid
IS '关系ID';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.proid
IS '项目ID';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.zdbdcdyh
IS '宗地不动产单元号';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.djh
IS '地籍号';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.tdzl
IS '土地坐落';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.fwbdcdyh
IS '房屋不动产单元号';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.fwzl
IS '房屋坐落';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.fwhjtdmj
IS '房屋核减土地面积';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.hjsj
IS '核减时间';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.fwhjdyje
IS '房屋核减抵押金额';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.bz
IS '备注';
COMMENT ON COLUMN BDC_SPF_ZD_HJGX.xmhjdyje
IS '项目核减抵押金额';
--changeset wenyuanwu:1322 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPF_ZD_HJGX
  ADD CONSTRAINT PK_BDC_SPF_ZD_HJGX PRIMARY KEY (RELID);
--changeset wenyuanwu:208 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_OPINION
  ADD (DJZXDM VARCHAR(100));
COMMENT ON COLUMN BDC_XT_OPINION.DJZXDM IS '登记子项';

--changeset wenyuanwu:209 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_BDCZSSD
(
  "SDID"   VARCHAR2(32 BYTE),
  "CQZH"   VARCHAR2(100 BYTE),
  "ZSID"   VARCHAR2(100 BYTE),
  "BDCLX"  VARCHAR2(100 BYTE),
  "PROID"  VARCHAR2(32 BYTE),
  "XZZT"   VARCHAR2(100 BYTE),
  "XZYY"   VARCHAR2(500 BYTE),
  "XZTYPE" VARCHAR2(100 BYTE),
  "SDR"    VARCHAR2(100 BYTE),
  "SDSJ"   DATE,
  "JSR"    VARCHAR2(100 BYTE),
  "JSSJ"   DATE
);


COMMENT ON COLUMN "BDC_BDCZSSD"."SDID" IS '锁定id';

COMMENT ON COLUMN "BDC_BDCZSSD"."CQZH" IS '产权证号';

COMMENT ON COLUMN "BDC_BDCZSSD"."ZSID" IS '证书ID';

COMMENT ON COLUMN "BDC_BDCZSSD"."BDCLX" IS '不动产类型';

COMMENT ON COLUMN "BDC_BDCZSSD"."PROID" IS '项目id';

COMMENT ON COLUMN "BDC_BDCZSSD"."XZZT" IS '限制状态';

COMMENT ON COLUMN "BDC_BDCZSSD"."XZYY" IS '限制原因';

COMMENT ON COLUMN "BDC_BDCZSSD"."XZTYPE" IS '限制类型';

COMMENT ON COLUMN "BDC_BDCZSSD"."SDR" IS '锁定人';

COMMENT ON COLUMN "BDC_BDCZSSD"."SDSJ" IS '锁定时间';

COMMENT ON COLUMN "BDC_BDCZSSD"."JSR" IS '解锁人';

COMMENT ON COLUMN "BDC_BDCZSSD"."JSSJ" IS '解锁时间';

COMMENT ON TABLE "BDC_BDCZSSD" IS '不动产证书锁定';

--changeset wenyuanwu:210 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (YHBH VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.YHBH IS '银行编号';
--changeset wenyuanwu:211 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (SJYHID VARCHAR2(32));
COMMENT ON COLUMN BDC_XT_YH.SJYHID IS '上级银行ID';
--changeset wenyuanwu:212 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD CONSTRAINT UNK_BDC_XT_YH_YHBH UNIQUE (YHBH);
--changeset wenyuanwu:213 failOnError:false runOnChange:true runAlways:true
ALTER TABLE national_access
  ADD (xml CLOB);
COMMENT ON COLUMN national_access.xml IS '报文xml';
--changeset wenyuanwu:214 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (CFSX NUMBER(2));
COMMENT ON COLUMN GD_CF.CFSX IS '查封顺序';
--changeset wenyuanwu:215 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_SFXX
  ADD (JKR VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.JKR IS '缴费人';
--changeset wenyuanwu:216 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (JKRZH VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.JKRZH IS '缴款人账号';
--changeset wenyuanwu:217 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (JKRKHYH VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.JKRKHYH IS '缴款人开户银行';
--changeset wenyuanwu:218 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SKR VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.SKR IS '收款人';
--changeset wenyuanwu:219 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SKRZH VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.SKRZH IS '收款人账号';
--changeset wenyuanwu:220 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SKRKHYH VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.SKRKHYH IS '收款人开户银行';
--changeset wenyuanwu:221 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SFDWDM VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.SFDWDM IS '收费单位代码';

--changeset wenyuanwu:222 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (JFLX VARCHAR(50));
COMMENT ON COLUMN BDC_CF.JFLX IS '解封类型';
--changeset wenyuanwu:223 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (FZLX VARCHAR(50));
COMMENT ON COLUMN BDC_FDCQ.FZLX IS '发证类型';
--changeset wenyuanwu:224 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_FZLX
(
  dm VARCHAR2(10),
  mc VARCHAR2(10)
);
--changeset wenyuanwu:225 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD (JBR VARCHAR(50));
COMMENT ON COLUMN BDC_BDCZSSD.JBR IS '经办人';
--changeset wenyuanwu:226 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD (JSYY VARCHAR(500));
COMMENT ON COLUMN BDC_BDCZSSD.JSYY IS '解锁原因';
--changeset wenyuanwu:227 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_bdcsd
  ADD JBR VARCHAR2(100);
COMMENT ON COLUMN gd_bdcsd.jbr
IS '经办人';
--changeset wenyuanwu:228 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_bdcsd
  ADD JSYY VARCHAR2(500);
COMMENT ON COLUMN gd_bdcsd.jsyy
IS '解锁原因';
--changeset wenyuanwu:229 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD upload VARCHAR2(1);
COMMENT ON COLUMN BDC_XXCXJG.upload
IS '是否上传附件0未上传，1已上传 ';
--changeset wenyuanwu:230 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD CONSTRAINT PrimaryKey PRIMARY KEY (jgid);

--changeset wenyuanwu:231 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD DWDM VARCHAR2(50);
COMMENT ON COLUMN BDC_XT_YH.DWDM IS '单位代码';

--changeset wenyuanwu:232 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_FC_ARCHIVE_REL
(
  fc_node_id      NUMBER(5)    NOT NULL,
  archive_file_id VARCHAR2(32) NOT NULL,
  bz              VARCHAR2(1000)
);
COMMENT ON COLUMN BDC_FC_ARCHIVE_REL.fc_node_id
IS '文件中心（t_fc_node）node_id';
COMMENT ON COLUMN BDC_FC_ARCHIVE_REL.archive_file_id
IS '档案返回的doc或者file的id';
COMMENT ON COLUMN BDC_FC_ARCHIVE_REL.bz
IS '备注';
--changeset wenyuanwu:233 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD CRHTBH VARCHAR2(100);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.CRHTBH IS '出让合同编号';
--changeset wenyuanwu:234 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD DJJG VARCHAR2(100);
COMMENT ON COLUMN BDC_XM.DJJG IS '登记机构';
--changeset wenyuanwu:235 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BYDJ_JDS
  RENAME TO BDC_BYDJ_DJD;
--changeset wenyuanwu:236 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BYDJ_DJD
  ADD LSH VARCHAR2(100);
COMMENT ON COLUMN BDC_BYDJ_DJD.LSH IS '流水号';
--changeset wenyuanwu:237 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BYDJ_DJD
  ADD NF VARCHAR2(4);
COMMENT ON COLUMN BDC_BYDJ_DJD.NF IS '年份';

--changeset wenyuanwu:238 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_CF.BSM IS '标示码';
--changeset wenyuanwu:239 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_DY.BSM IS '标示码';
--changeset wenyuanwu:240 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_CQ.BSM IS '标示码';
--changeset wenyuanwu:1212 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_FW.BSM IS '标示码';
--changeset wenyuanwu:1202 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.BSM IS '标示码';
--changeset wenyuanwu:242 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_LQ.BSM IS '标示码';
--changeset wenyuanwu:243 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_QLR.BSM IS '标示码';
--changeset wenyuanwu:245 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_TD.BSM IS '标示码';
--changeset wenyuanwu:246 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_TDSYQ.BSM IS '标示码';
--changeset wenyuanwu:241 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_XM.BSM IS '标示码';
--changeset wenyuanwu:247 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_YG.BSM IS '标示码';
--changeset wenyuanwu:248 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_YY.BSM IS '标示码';
--changeset wenyuanwu:249 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_FW_QL.BSM IS '标示码';
--changeset wenyuanwu:1204 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD BSM VARCHAR2(100);
COMMENT ON COLUMN GD_TD_QL.BSM IS '标示码';
--changeset wenyuanwu:250 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_CQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN GD_CQ.ZXYY IS '注销原因';
--changeset wenyuanwu:251 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_CQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:252 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_CQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:253 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN GD_FWSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:254 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:255 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_FWSYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:256 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN GD_LQ.ZXYY IS '注销原因';
--changeset wenyuanwu:257 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_LQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:258 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_LQ.ZXDBSJ IS '注销登簿时间';

--changeset wenyuanwu:259 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN GD_TDSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:260 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_TDSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_TDSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:266 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_TDSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_TDSYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:267 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN GD_YG.ZXYY IS '注销原因';
--changeset wenyuanwu:268 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_YG.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:269 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_YG.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:270 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_TDSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:271 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_TDSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:272 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_TDSYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:273 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:274 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:275 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_JSYDZJDSYQ.ZXDBSJ IS '注销登簿时间';

--changeset wenyuanwu:276 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_FDCQ_DZ.ZXYY IS '注销原因';
--changeset wenyuanwu:277 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ_DZ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:278 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_FDCQ_DZ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:279 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FDCQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_FDCQ.ZXYY IS '注销原因';
--changeset wenyuanwu:280 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:281 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_FDCQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:282 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWGY
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_JZWGY.ZXYY IS '注销原因';
--changeset wenyuanwu:283 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWGY
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_JZWGY.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:284 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWGY
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_JZWGY.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:285 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_JZWSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:286 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_JZWSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:287 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_JZWSYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:288 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_HYSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:289 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_HYSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:290 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_HYSYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:291 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:292 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:293 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ZXDBSJ IS '注销登簿时间';

--changeset wenyuanwu:294 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_QTXGQL.ZXYY IS '注销原因';
--changeset wenyuanwu:295 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_QTXGQL.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:296 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_QTXGQL.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:300 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_LQ.ZXYY IS '注销原因';
--changeset wenyuanwu:301 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_LQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:302 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_LQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:303 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYQ.ZXYY IS '注销原因';
--changeset wenyuanwu:304 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_DYQ.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:305 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_DYQ.ZXDBSJ IS '注销登簿时间';
--changeset wenyuanwu:306 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD ZXYY VARCHAR2(1000);
COMMENT ON COLUMN BDC_YG.ZXYY IS '注销原因';
--changeset wenyuanwu:307 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_YG.ZXDBR IS '注销登簿人';
--changeset wenyuanwu:308 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN BDC_YG.ZXDBSJ IS '注销登簿时间';

--changeset wenyuanwu:309 failOnError:false runOnChange:true runAlways:true


ALTER TABLE GD_FWSYQ
  ADD CQXZ VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.CQXZ IS '产权性质';
--changeset wenyuanwu:310 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD XKZH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.XKZH IS '产权性质';
--changeset wenyuanwu:311 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD CQXZ VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ.CQXZ IS '产权性质';
--changeset wenyuanwu:312 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FDCQ
  ADD XKZH VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ.XKZH IS '许可证号';
--changeset wenyuanwu:313 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD XKZH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.XKZH IS '许可证号';
--changeset wenyuanwu:314 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QLMJ NUMBER(20, 2);
COMMENT ON COLUMN BDC_QLR.QLMJ IS '权利面积';
--changeset wenyuanwu:315 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD QLMJ NUMBER(20, 2);
COMMENT ON COLUMN GD_QLR.QLMJ IS '权利面积';
--changeset wenyuanwu:316 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD CJR VARCHAR2(100);
COMMENT ON COLUMN GD_XM.CJR IS '创建人';
--changeset wenyuanwu:317 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD SZR VARCHAR2(100);
COMMENT ON COLUMN GD_XM.SZR IS '缮证人';
--changeset wenyuanwu:318 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD SZRQ DATE;
COMMENT ON COLUMN GD_XM.SZRQ IS '缮证日期';
--changeset wenyuanwu:319 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD SFFZ VARCHAR2(2);
COMMENT ON COLUMN GD_XM.SFFZ IS '是否发证';
--changeset wenyuanwu:320 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD FZSJ DATE;
COMMENT ON COLUMN GD_XM.FZSJ IS '发证时间';
--changeset wenyuanwu:321 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD QLLX VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.QLLX IS '权利类型';
--changeset wenyuanwu:322 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD QQH VARCHAR2(100);
COMMENT ON COLUMN GD_FW.QQH IS '丘权号';
--changeset wenyuanwu:323 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD DBFW VARCHAR2(1000);
COMMENT ON COLUMN GD_YG.DBFW IS '担保范围';
--changeset wenyuanwu:324 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD QQH VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ.QQH IS '丘权号';
--changeset wenyuanwu:325 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD QLLX VARCHAR2(100);
COMMENT ON COLUMN GD_TDSYQ.QLLX IS '权利类型';
--changeset wenyuanwu:326 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD (BDCDYH VARCHAR2(29));
COMMENT ON COLUMN BDC_ZJJZWXX.BDCDYH IS '不动产单元号';
--changeset wenyuanwu:327 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD (FWBM VARCHAR2(100));
COMMENT ON COLUMN BDC_ZJJZWXX.FWBM IS '房屋编码';
--changeset wenyuanwu:328 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD XKZH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.XKZH IS '许可证号';
--changeset wenyuanwu:329 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD QLLX VARCHAR2(100);
COMMENT ON COLUMN GD_DY.QLLX IS '权利类型';
--changeset wenyuanwu:330 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_CF_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN BDC_LS_CF_BH.QSZT IS '权属状态';
--changeset wenyuanwu:331 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_DY_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN BDC_LS_DY_BH.QSZT IS '权属状态';
--changeset wenyuanwu:332 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_TD_BH
  ADD ZT VARCHAR2(1);
COMMENT ON COLUMN BDC_LS_BDCDY_TD_BH.ZT IS '状态';
--changeset wenyuanwu:333 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_BDCDY_TDFW_BH
  ADD ZT VARCHAR2(1);
COMMENT ON COLUMN BDC_LS_BDCDY_TDFW_BH.ZT IS '状态';
--changeset wenyuanwu:334 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DEL_ZSZH
  ADD PROID VARCHAR2(32);
COMMENT ON COLUMN BDC_DEL_ZSZH.PROID IS '项目id';
--changeset wenyuanwu:335 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD XBCLFS NUMBER;
COMMENT ON COLUMN BDC_SJCL.XBCLFS IS '需补材料份数';
--changeset wenyuanwu:336 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD SFZT VARCHAR2(1);
COMMENT ON COLUMN BDC_SFXX.SFZT IS '收费状态';
--changeset wenyuanwu:337 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD JKR VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.JKR IS '缴款人';
--changeset wenyuanwu:338 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD JKRZH VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.JKRZH IS '缴款人账号';
--changeset wenyuanwu:339 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD JKRKHYH VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.JKRKHYH IS '缴款人开户银行';
--changeset wenyuanwu:340 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD SKR VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.SKR IS '收款人';
--changeset wenyuanwu:341 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD SKRZH VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.SKRZH IS '收款人账号';
--changeset wenyuanwu:342 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD SKRKHYH VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.SKRKHYH IS '收款人开户银行';
--changeset wenyuanwu:343 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD SFDWDM VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.SFDWDM IS '收费单位代码';
--changeset wenyuanwu:344 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SJHJ (
  BIZ_MSG_ID       VARCHAR2(32),
  ASID             VARCHAR2(5),
  AREA_CODE        VARCHAR2(12),
  REC_TYPE         VARCHAR2(7),
  RIGHT_TYPE       VARCHAR2(2),
  REG_TYPE         VARCHAR2(8),
  CREATE_DATE      DATE,
  REC_FLOW_ID      VARCHAR2(50),
  REG_ORG_ID       VARCHAR2(200),
  PARCEL_ID        VARCHAR2(19),
  ESTATE_NUM       VARCHAR2(28),
  PRE_ESTATE_NUM   VARCHAR2(256),
  PRE_CERT_ID      VARCHAR2(256),
  CERT_COUNT       VARCHAR2(3),
  PROOF_COUNT      VARCHAR2(3),
  SUCCESS_FLAG     NUMBER,
  RESPONSE_CODE    VARCHAR2(4),
  RESPONSE_INFO    VARCHAR2(256),
  CERT_ID          VARCHAR2(128),
  ADDITIONAL_DATA  VARCHAR2(512),
  ADDITIONAL_DATA2 VARCHAR2(512),
  QR_CODE          CLOB,
  ACCESS_DATE      DATE,
  PRIMARY KEY (BIZ_MSG_ID)
);
COMMENT ON COLUMN BDC_SJHJ.biz_msg_id
IS '业务报文ID';
COMMENT ON COLUMN BDC_SJHJ.asid
IS '接入标准ID';
COMMENT ON COLUMN BDC_SJHJ.area_code
IS '行政区划编码';
COMMENT ON COLUMN BDC_SJHJ.rec_type
IS '业务编码';
COMMENT ON COLUMN BDC_SJHJ.right_type
IS '权利类型';
COMMENT ON COLUMN BDC_SJHJ.reg_type
IS '登记类型';
COMMENT ON COLUMN BDC_SJHJ.create_date
IS '创建时间';
COMMENT ON COLUMN BDC_SJHJ.rec_flow_id
IS '业务流水号';
COMMENT ON COLUMN BDC_SJHJ.reg_org_id
IS '登记机构';
COMMENT ON COLUMN BDC_SJHJ.parcel_id
IS '宗地宗海代码';
COMMENT ON COLUMN BDC_SJHJ.estate_num
IS '不动产单元号';
COMMENT ON COLUMN BDC_SJHJ.pre_estate_num
IS '上次不动产单元号';
COMMENT ON COLUMN BDC_SJHJ.pre_cert_id
IS '上次不动产权证号/不动产权证明号';
COMMENT ON COLUMN BDC_SJHJ.cert_count
IS '不动产权证号码数量';
COMMENT ON COLUMN BDC_SJHJ.proof_count
IS '证明号码数量';
COMMENT ON COLUMN BDC_SJHJ.success_flag
IS '成功标识';
COMMENT ON COLUMN BDC_SJHJ.response_code
IS '响应编码';
COMMENT ON COLUMN BDC_SJHJ.response_info
IS '报文响应信息';
COMMENT ON COLUMN BDC_SJHJ.cert_id
IS '配号：不动产证书编号';
COMMENT ON COLUMN BDC_SJHJ.additional_data
IS '附加信息';
COMMENT ON COLUMN BDC_SJHJ.additional_data2
IS '附加信息,扩展字段';
COMMENT ON COLUMN BDC_SJHJ.qr_code
IS '防伪二维码';
COMMENT ON COLUMN BDC_SJHJ.access_date
IS '汇交时间';
--changeset wenyuanwu:345 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD DJZX NUMBER;
COMMENT ON COLUMN BDC_XT_SJCL.DJZX IS '登记子项';
--changeset wenyuanwu:346 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_BYSL_TZS
(
  tzsid  VARCHAR2(32) NOT NULL,
  tzdx   VARCHAR2(100),
  tzsj   DATE,
  zl     VARCHAR2(100),
  sqlxdm VARCHAR2(100),
  bh     VARCHAR2(100),
  tzyy   VARCHAR2(100),
  bz     VARCHAR2(100),
  ftzsj  DATE,
  sjr    VARCHAR2(100),
  sqr    VARCHAR2(100),
  wiid   VARCHAR2(32),
  proid  VARCHAR2(32),
  lsh    VARCHAR2(100),
  nf     VARCHAR2(4)
);
COMMENT ON COLUMN BDC_BYSL_TZS.tzsid
IS '通知书id';
COMMENT ON COLUMN BDC_BYSL_TZS.tzdx
IS '通知对象';
COMMENT ON COLUMN BDC_BYSL_TZS.tzsj
IS '通知时间';
COMMENT ON COLUMN BDC_BYSL_TZS.zl
IS '坐落';
COMMENT ON COLUMN BDC_BYSL_TZS.sqlxdm
IS '申请类型代码';
COMMENT ON COLUMN BDC_BYSL_TZS.bh
IS '编号';
COMMENT ON COLUMN BDC_BYSL_TZS.tzyy
IS '通知原因';
COMMENT ON COLUMN BDC_BYSL_TZS.bz
IS '备注';
COMMENT ON COLUMN BDC_BYSL_TZS.ftzsj
IS '发通知时间';
COMMENT ON COLUMN BDC_BYSL_TZS.sjr
IS '收件人';
COMMENT ON COLUMN BDC_BYSL_TZS.sqr
IS '申请人';
COMMENT ON COLUMN BDC_BYSL_TZS.wiid
IS '流程id';
COMMENT ON COLUMN BDC_BYSL_TZS.proid
IS '项目id';
COMMENT ON COLUMN BDC_BYSL_TZS.lsh
IS '流水号';
COMMENT ON COLUMN BDC_BYSL_TZS.nf
IS '年份';
--changeset wenyuanwu:347--  failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GZDJ_TZS
(
  tzsid VARCHAR2(32) NOT NULL,
  tzdx  VARCHAR2(100),
  tzsj  DATE,
  bh    VARCHAR2(100),
  gznr  VARCHAR2(100),
  proid VARCHAR2(32),
  wiid  VARCHAR2(100)
);
COMMENT ON COLUMN BDC_GZDJ_TZS.tzsid
IS '通知书id';
COMMENT ON COLUMN BDC_GZDJ_TZS.tzdx
IS '通知对象';
COMMENT ON COLUMN BDC_GZDJ_TZS.tzsj
IS '通知时间';
COMMENT ON COLUMN BDC_GZDJ_TZS.bh
IS '编号';
COMMENT ON COLUMN BDC_GZDJ_TZS.gznr
IS '更正内容';
COMMENT ON COLUMN BDC_GZDJ_TZS.proid
IS '项目id';
COMMENT ON COLUMN BDC_GZDJ_TZS.wiid
IS '流程id';
--changeset wenyuanwu:348 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XWBL
(
  xwblid       VARCHAR2(32) NOT NULL,
  proid        VARCHAR2(32),
  xwr          VARCHAR2(100),
  xwsj         DATE,
  bxwr         VARCHAR2(100),
  bxwrzjh      VARCHAR2(100),
  sfdjsx       NUMBER(1),
  sfgydd       VARCHAR2(100),
  sdafgygtgy   VARCHAR2(100),
  gyfeqk       VARCHAR2(3000),
  sfsjcl       NUMBER(1),
  qtsx         VARCHAR2(3000),
  sfczsfxzqlxz NUMBER(1),
  sfczyyygqsjf NUMBER(1),
  sflrcqfw     NUMBER(1),
  sfczyxgyr    NUMBER(1)
);
COMMENT ON COLUMN BDC_XWBL.xwblid
IS '询问笔录id';
COMMENT ON COLUMN BDC_XWBL.proid
IS '项目id';
COMMENT ON COLUMN BDC_XWBL.xwr
IS '询问人';
COMMENT ON COLUMN BDC_XWBL.xwsj
IS '询问时间';
COMMENT ON COLUMN BDC_XWBL.bxwr
IS '被询问人';
COMMENT ON COLUMN BDC_XWBL.bxwrzjh
IS '被询问人证件号';
COMMENT ON COLUMN BDC_XWBL.sfdjsx
IS '是否正确登记事项';
COMMENT ON COLUMN BDC_XWBL.sfgydd
IS '是否为共有或单独';
COMMENT ON COLUMN BDC_XWBL.sdafgygtgy
IS '是否为按份共有或共同共有';
COMMENT ON COLUMN BDC_XWBL.gyfeqk
IS '共有份额情况';
COMMENT ON COLUMN BDC_XWBL.sfsjcl
IS '是否收件材料正确';
COMMENT ON COLUMN BDC_XWBL.qtsx
IS '其他事项';
COMMENT ON COLUMN BDC_XWBL.sfczsfxzqlxz
IS '是否存在司法、行政权利限制';
COMMENT ON COLUMN BDC_XWBL.sfczyyygqsjf
IS '是否存在异议、预告及权属纠纷';
COMMENT ON COLUMN BDC_XWBL.sflrcqfw
IS '是否列入拆迁范围';
COMMENT ON COLUMN BDC_XWBL.sfczyxgyr
IS '否存在隐性共有人';
--changeset wenyuanwu:349 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZSDYJL
(
  jlid  VARCHAR2(32) NOT NULL,
  zsid  VARCHAR2(32),
  dyr   VARCHAR2(100),
  dyrid VARCHAR2(100),
  dysj  DATE,
  xgr   VARCHAR2(100),
  xgrid VARCHAR2(100),
  xgsj  DATE,
  xgyy  VARCHAR2(100)
);
COMMENT ON COLUMN BDC_ZSDYJL.jlid
IS '记录id';
COMMENT ON COLUMN BDC_ZSDYJL.zsid
IS '证书id';
COMMENT ON COLUMN BDC_ZSDYJL.dyr
IS '打印人';
COMMENT ON COLUMN BDC_ZSDYJL.dyrid
IS '打印人id';
COMMENT ON COLUMN BDC_ZSDYJL.dysj
IS '打印时间';
COMMENT ON COLUMN BDC_ZSDYJL.xgr
IS '修改人';
COMMENT ON COLUMN BDC_ZSDYJL.xgrid
IS '修改人id';
COMMENT ON COLUMN BDC_ZSDYJL.xgsj
IS '修改时间';
COMMENT ON COLUMN BDC_ZSDYJL.xgyy
IS '修改原因';
--changeset wenyuanwu:350 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD UPLOAD VARCHAR2(1);
COMMENT ON COLUMN BDC_XXCXJG.UPLOAD IS '是否上传附件0未上传，1已上传';
--changeset wenyuanwu:354 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GL_REL
(
  relid   VARCHAR2(32) NOT NULL,
  proid   VARCHAR2(32),
  yproid  VARCHAR2(32),
  ydjxmly VARCHAR2(1),
  yqlid   VARCHAR2(32)
);
COMMENT ON COLUMN BDC_GL_REL.relid
IS '关系ID';
COMMENT ON COLUMN BDC_GL_REL.proid
IS '登记项目ID';
COMMENT ON COLUMN BDC_GL_REL.yproid
IS '原登记项目ID';
COMMENT ON COLUMN BDC_GL_REL.ydjxmly
IS '原登记项目来源';
COMMENT ON COLUMN BDC_GL_REL.yqlid
IS '原权利ID';
--changeset wenyuanwu:356 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_TDSYQ.BZ IS '备注';
--changeset wenyuanwu:357 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.BZ IS '备注';
--changeset wenyuanwu:358 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.BZ IS '备注';
--changeset wenyuanwu:359 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.BZ IS '备注';
--changeset wenyuanwu:360 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_JZWSYQ.BZ IS '备注';
--changeset wenyuanwu:361 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.BZ IS '备注';
--changeset wenyuanwu:362 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_LQ.BZ IS '备注';
--changeset wenyuanwu:363 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.BZ IS '备注';
--changeset wenyuanwu:364 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD DBFW VARCHAR2(1000);
COMMENT ON COLUMN BDC_YG.DBFW IS '担保范围';
--changeset wenyuanwu:365 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_YY.BZ IS '备注';
--changeset wenyuanwu:366 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD BZ VARCHAR2(4000);
COMMENT ON COLUMN BDC_CF.BZ IS '备注';
--changeset wenyuanwu:367 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD FYSDRZJHM VARCHAR2(100);
COMMENT ON COLUMN BDC_CF.FYSDRZJHM IS '法院送达人证件号码';
--changeset wenyuanwu:368 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD JFLX VARCHAR2(100);
COMMENT ON COLUMN BDC_CF.JFLX IS '解封类型';
--changeset wenyuanwu:369 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QLRFDDBRZJZL VARCHAR2(100);
COMMENT ON COLUMN BDC_QLR.QLRFDDBRZJZL IS '权利人法定代表人证件种类';
--changeset wenyuanwu:370 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QLRFDDBRZJH VARCHAR2(100);
COMMENT ON COLUMN BDC_QLR.QLRFDDBRZJH IS '权利人法定代表人证件号';
--changeset wenyuanwu:371 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_QL_BH
  ADD SJLY VARCHAR2(1);
COMMENT ON COLUMN BDC_LS_QL_BH.SJLY IS '数据来源';
--changeset wenyuanwu:372 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_QL_CF_REL
(
  qlid  VARCHAR2(32) NOT NULL,
  cfid  VARCHAR2(20),
  bdclx VARCHAR2(10)
);
COMMENT ON COLUMN BDC_LS_QL_CF_REL.qlid
IS '权利主键';
COMMENT ON COLUMN BDC_LS_QL_CF_REL.cfid
IS '查封主键';
COMMENT ON COLUMN BDC_LS_QL_CF_REL.bdclx
IS '不动产类型';
COMMENT ON COLUMN BDC_XT_DAMLH.MLH IS '目录号';
COMMENT ON COLUMN BDC_XT_DAMLH.ID IS '主键';
COMMENT ON COLUMN BDC_XT_DAMLH.BDCLX IS '不动产类型';
COMMENT ON COLUMN BDC_XT_DAMLH.DJLX IS '登记类型';
--changeset wenyuanwu:373 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_QY
(
  qyid VARCHAR2(32) NOT NULL,
  qymc VARCHAR2(200),
  zjlx VARCHAR2(100),
  zjbh VARCHAR2(100),
  bz   VARCHAR2(1000)
);
COMMENT ON COLUMN BDC_XT_QY.qyid
IS '企业ID';
COMMENT ON COLUMN BDC_XT_QY.qymc
IS '企业名称';
COMMENT ON COLUMN BDC_XT_QY.zjlx
IS '证件类型';
COMMENT ON COLUMN BDC_XT_QY.zjbh
IS '证件编号';
COMMENT ON COLUMN BDC_XT_QY.bz
IS '备注';
;
--changeset wenyuanwu:374 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD DWDM VARCHAR2(50);
COMMENT ON COLUMN BDC_XT_QY.DWDM IS '单位代码';
--changeset wenyuanwu:375 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD CZLB VARCHAR2(2);
COMMENT ON COLUMN BDC_XXCXJL.CZLB IS '操作类别';
--changeset wenyuanwu:376 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD CXCQZH VARCHAR2(100);
COMMENT ON COLUMN BDC_XXCXJL.CXCQZH IS '查询产权证号';
--changeset wenyuanwu:377 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_TDDJKXB
(
  tddjkxbid VARCHAR2(32) NOT NULL,
  proid     VARCHAR2(32),
  qlid      VARCHAR2(32),
  xh        VARCHAR2(3),
  djlx      VARCHAR2(50),
  tdzh      VARCHAR2(100),
  djh       VARCHAR2(19),
  jbr       VARCHAR2(100),
  jbrq      DATE,
  shr       VARCHAR2(100),
  xbnr      VARCHAR2(4000),
  bz        VARCHAR2(2000),
  gxr       VARCHAR2(100),
  gxrq      DATE,
  bsm       VARCHAR2(100)
);
COMMENT ON COLUMN GD_TDDJKXB.tddjkxbid
IS '土地登记卡续表ID';
COMMENT ON COLUMN GD_TDDJKXB.proid
IS '项目ID';
COMMENT ON COLUMN GD_TDDJKXB.qlid
IS '土地权利id';
COMMENT ON COLUMN GD_TDDJKXB.xh
IS '序号';
COMMENT ON COLUMN GD_TDDJKXB.djlx
IS '登记类型';
COMMENT ON COLUMN GD_TDDJKXB.tdzh
IS '土地证号';
COMMENT ON COLUMN GD_TDDJKXB.djh
IS '地籍号';
COMMENT ON COLUMN GD_TDDJKXB.jbr
IS '经办人';
COMMENT ON COLUMN GD_TDDJKXB.jbrq
IS '经办日期';
COMMENT ON COLUMN GD_TDDJKXB.shr
IS '审核人';
COMMENT ON COLUMN GD_TDDJKXB.xbnr
IS '续表内容';
COMMENT ON COLUMN GD_TDDJKXB.bz
IS '备注';
COMMENT ON COLUMN GD_TDDJKXB.gxr
IS '更新人';
COMMENT ON COLUMN GD_TDDJKXB.gxrq
IS '更新日期';
COMMENT ON COLUMN GD_TDDJKXB.bsm
IS '标识码';
--changeset wenyuanwu:378 failOnError:false runOnChange:true runAlways:true
DROP TABLE gd_ls_cf;
DROP TABLE gd_ls_cq;
DROP TABLE gd_ls_dy;
DROP TABLE gd_ls_fw;
DROP TABLE gd_ls_fwsyq;
DROP TABLE gd_ls_lq;
DROP TABLE gd_ls_qlr;
DROP TABLE gd_ls_td;
DROP TABLE gd_ls_tdsyq;
DROP TABLE gd_ls_xm;
DROP TABLE gd_ls_yg;
DROP TABLE gd_ls_yy;
--changeset wenyuanwu:379 failOnError:false runOnChange:true runAlways:true
CREATE TABLE bdc_gzxx (
  gzid   VARCHAR2(32),
  gzcode VARCHAR2(50),
  jctype VARCHAR2(10),
  gzlx   VARCHAR2(10),
  bhsqlx VARCHAR2(100),
  qcsqlx VARCHAR2(100),
  tsxx   VARCHAR2(100),
  gzdj   VARCHAR2(10)
);
COMMENT ON COLUMN bdc_gzxx.gzid IS '规则编码';
COMMENT ON COLUMN bdc_gzxx.gzcode IS '规则Code';
COMMENT ON COLUMN bdc_gzxx.jctype IS '检查类型（CF,DY）';
COMMENT ON COLUMN bdc_gzxx.gzlx IS '规则类型（sql,code）';
COMMENT ON COLUMN bdc_gzxx.bhsqlx IS '包含申请类型';
COMMENT ON COLUMN bdc_gzxx.qcsqlx IS '去除申请类型';
COMMENT ON COLUMN bdc_gzxx.tsxx IS '提示信息';
COMMENT ON COLUMN bdc_gzxx.gzdj IS '规则等级';
--changeset wenyuanwu:380 failOnError:false runOnChange:true runAlways:true
CREATE TABLE bdc_gzjclog (
  logid  VARCHAR2(32),
  proid  VARCHAR2(32),
  xmbh   VARCHAR2(50),
  bdcdyh VARCHAR2(28),
  xzwh   VARCHAR2(100),
  gzid   VARCHAR2(32),
  fxsj   DATE,
  jctype VARCHAR2(10),
  jcdj   VARCHAR2(10),
  jcxx   VARCHAR2(100),
  jjzt   VARCHAR2(1),
  jjsj   DATE,
  jjfs   VARCHAR2(100),
  gxsj   DATE
);
COMMENT ON COLUMN bdc_gzjclog.logid IS '日志编号';
COMMENT ON COLUMN bdc_gzjclog.proid IS '项目proid';
COMMENT ON COLUMN bdc_gzjclog.xmbh IS '项目编号';
COMMENT ON COLUMN bdc_gzjclog.bdcdyh IS '不动产单元号';
COMMENT ON COLUMN bdc_gzjclog.xzwh IS '限制文号';
COMMENT ON COLUMN bdc_gzjclog.gzid IS '规则编号';
COMMENT ON COLUMN bdc_gzjclog.fxsj IS '发现时间';
COMMENT ON COLUMN bdc_gzjclog.jctype IS '检查类型';
COMMENT ON COLUMN bdc_gzjclog.jcdj IS '检查等级';
COMMENT ON COLUMN bdc_gzjclog.jcxx IS '检查信息';
COMMENT ON COLUMN bdc_gzjclog.jjzt IS '解决状态 0：未解决 1：已解决';
COMMENT ON COLUMN bdc_gzjclog.jjsj IS '解决时间';
COMMENT ON COLUMN bdc_gzjclog.jjfs IS '解决方式';
COMMENT ON COLUMN bdc_gzjclog.gxsj IS '更新执行时间';
--changeset wenyuanwu:381 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD CFSQR VARCHAR2(50);
COMMENT ON COLUMN GD_CF.CFSQR IS '查封申请人';
--changeset wenyuanwu:382 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_TD_CF_REL
(
  tdid VARCHAR2(32) NOT NULL,
  cfid VARCHAR2(32) NOT NULL
);
COMMENT ON TABLE GD_LS_TD_CF_REL
IS '历史宗地与查封关系（预查封）';
COMMENT ON COLUMN GD_LS_TD_CF_REL.tdid
IS '宗地主键';
COMMENT ON COLUMN GD_LS_TD_CF_REL.cfid
IS '查封主键';
--changeset wenyuanwu:383 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_FW_CF_REL
(
  fwid VARCHAR2(32) NOT NULL,
  cfid VARCHAR2(32) NOT NULL
);
COMMENT ON TABLE GD_LS_FW_CF_REL
IS '历史房屋与查封关系（预查封）';
COMMENT ON COLUMN GD_LS_FW_CF_REL.fwid
IS '房屋主键';
COMMENT ON COLUMN GD_LS_FW_CF_REL.cfid
IS '查封主键';
CREATE TABLE GD_LS_FW_DY_REL
(
  fwid VARCHAR2(32) NOT NULL,
  dyid VARCHAR2(32) NOT NULL
);
COMMENT ON TABLE GD_LS_FW_DY_REL
IS '历史房屋与抵押关系（在建工程抵押）';
COMMENT ON COLUMN GD_LS_FW_DY_REL.fwid
IS '房屋主键';
COMMENT ON COLUMN GD_LS_FW_DY_REL.dyid
IS '抵押主键';
--changeset wenyuanwu:384 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_jsydzjdsyq
  ADD zrqyh VARCHAR2(50);
COMMENT ON COLUMN bdc_jsydzjdsyq.zrqyh IS '转让契约号';
--changeset wenyuanwu:385 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_jsydzjdsyq
  ADD zrjg NUMBER(10, 2);
COMMENT ON COLUMN bdc_jsydzjdsyq.zrjg IS '转让价格';
--changeset wenyuanwu:386 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_BH
(
  bhid    VARCHAR2(32) NOT NULL,
  slbhlsh VARCHAR2(100),
  zhlsh   VARCHAR2(100),
  cjsj    DATE
);
COMMENT ON TABLE BDC_BH
IS '不动产编号表';
COMMENT ON COLUMN BDC_BH.bhid
IS '编号ID';
COMMENT ON COLUMN BDC_BH.slbhlsh
IS '受理编号流水号';
COMMENT ON COLUMN BDC_BH.zhlsh
IS '证号流水号';
COMMENT ON COLUMN BDC_BH.cjsj
IS '创建时间';

--changeset wenyuanwu:387 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GG
(
  ggid   VARCHAR2(32) NOT NULL,
  proid  VARCHAR2(32) NOT NULL,
  ggbh   VARCHAR2(100),
  gglx   VARCHAR2(100),
  ggmc   VARCHAR2(100),
  ggnr   VARCHAR2(1000),
  cjrid  VARCHAR2(100),
  cjrmc  VARCHAR2(100),
  cjsj   DATE,
  kssj   DATE,
  jssj   DATE,
  ggqx   NUMBER,
  bz     VARCHAR2(500),
  wiid   VARCHAR2(50),
  sqr    VARCHAR2(100),
  sffb   VARCHAR2(10),
  clsddz VARCHAR2(100),
  ggdw   VARCHAR2(100)
);
COMMENT ON TABLE BDC_GG
IS '不动产公告';
COMMENT ON COLUMN BDC_GG.ggid
IS '公告id';
COMMENT ON COLUMN BDC_GG.proid
IS '项目id';
COMMENT ON COLUMN BDC_GG.ggbh
IS '公告 编号';
COMMENT ON COLUMN BDC_GG.gglx
IS '公告类型';
COMMENT ON COLUMN BDC_GG.ggmc
IS '公告名称';
COMMENT ON COLUMN BDC_GG.ggnr
IS '公告内容';
COMMENT ON COLUMN BDC_GG.cjrid
IS '创建人id';
COMMENT ON COLUMN BDC_GG.cjrmc
IS '创建人名称';
COMMENT ON COLUMN BDC_GG.cjsj
IS '创建时间';
COMMENT ON COLUMN BDC_GG.kssj
IS '开始时间';
COMMENT ON COLUMN BDC_GG.jssj
IS '结束时间';
COMMENT ON COLUMN BDC_GG.ggqx
IS '公告期限';
COMMENT ON COLUMN BDC_GG.bz
IS '备注';
COMMENT ON COLUMN BDC_GG.wiid
IS '工作流id';
COMMENT ON COLUMN BDC_GG.sqr
IS '申请人';
COMMENT ON COLUMN BDC_GG.sffb
IS '是否发布（0：未发布，1已发布）';
COMMENT ON COLUMN BDC_GG.clsddz
IS '材料送达地址';
COMMENT ON COLUMN BDC_GG.ggdw
IS '公告单位';
--changeset wenyuanwu:388 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_GGLX
(
  mc VARCHAR2(100),
  dm VARCHAR2(100)
);
COMMENT ON TABLE BDC_ZD_GGLX
IS '公告类型字典项';
COMMENT ON COLUMN BDC_ZD_GGLX.mc
IS '代码';
COMMENT ON COLUMN BDC_ZD_GGLX.dm
IS '名称';
--changeset wenyuanwu:389 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD SFBL NUMBER(10, 2);
COMMENT ON COLUMN BDC_SFXM.SFBL IS '收费比例';
--changeset wenyuanwu:390 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_TD_QL_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN GD_LS_TD_QL_BH.QSZT IS '权属状态';
--changeset wenyuanwu:391 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_FW_QL_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN GD_LS_FW_QL_BH.QSZT IS '权属状态';
--changeset wenyuanwu:392 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_CF_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN GD_LS_CF_BH.QSZT IS '权属状态';
--changeset wenyuanwu:393 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_DY_BH
  ADD QSZT VARCHAR2(1);
COMMENT ON COLUMN GD_LS_DY_BH.QSZT IS '权属状态';
--changeset wenyuanwu:394 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZJJZWXX
  ADD FTMJ NUMBER(15, 4);
COMMENT ON COLUMN BDC_ZJJZWXX.FTMJ IS '分摊面积';
--changeset wenyuanwu:395 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_RYXX
(
  ryxxid VARCHAR2(32) NOT NULL,
  rymc   VARCHAR2(200),
  zjlx   VARCHAR2(100),
  zjbh   VARCHAR2(100),
  txdz   VARCHAR2(200),
  yb     VARCHAR2(100),
  lxdh   VARCHAR2(100),
  yx     VARCHAR2(100),
  bz     VARCHAR2(1000)
);
COMMENT ON TABLE BDC_RYXX
IS '不动产信用管理表';
COMMENT ON COLUMN BDC_RYXX.ryxxid
IS '人员信息id';
COMMENT ON COLUMN BDC_RYXX.rymc
IS '人员名称';
COMMENT ON COLUMN BDC_RYXX.zjlx
IS '证件类型';
COMMENT ON COLUMN BDC_RYXX.zjbh
IS '证件编号';
COMMENT ON COLUMN BDC_RYXX.txdz
IS '通讯地址';
COMMENT ON COLUMN BDC_RYXX.yb
IS '邮编';
COMMENT ON COLUMN BDC_RYXX.lxdh
IS '联系电话';
COMMENT ON COLUMN BDC_RYXX.yx
IS '邮箱';
COMMENT ON COLUMN BDC_RYXX.bz
IS '备注';
--changeset wenyuanwu:396 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD RYXXID VARCHAR2(32);
COMMENT ON COLUMN BDC_QLR.RYXXID IS '人员信息ID';
--changeset wenyuanwu:397 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SLLSH
(
  bhid    VARCHAR2(32) NOT NULL,
  slbhlsh VARCHAR2(100),
  cjsj    DATE
);
COMMENT ON TABLE BDC_SLLSH
IS '不动产受理流水号表';
COMMENT ON COLUMN BDC_SLLSH.bhid
IS '编号ID';
COMMENT ON COLUMN BDC_SLLSH.slbhlsh
IS '受理编号流水号';
COMMENT ON COLUMN BDC_SLLSH.cjsj
IS '创建时间';
--changeset wenyuanwu:398 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD DH VARCHAR2(100);
COMMENT ON COLUMN GD_QLR.DH IS '电话';
--changeset wenyuanwu:399 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_zjjzwxx
  ADD zxproid VARCHAR2(32);
COMMENT ON COLUMN bdc_zjjzwxx.zxproid IS '注销proid';
--changeset wenyuanwu:400 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDYSD
  ADD (JSYY VARCHAR2(500));
COMMENT ON COLUMN BDC_BDCDYSD.JSYY IS '解锁原因';
--changeset wenyuanwu:401 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_LOG
  ADD (IP VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_LOG.IP IS 'IP';
--changeset wenyuanwu:402 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_LOG
  ADD (MAC VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_LOG.MAC IS '机器码';
--changeset wenyuanwu:403 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_LOG
  ADD (COMPUTERNAME VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_LOG.COMPUTERNAME IS '计算机名';
--changeset wenyuanwu:404 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_LOG
  ADD (REASON VARCHAR2(1000));
COMMENT ON COLUMN BDC_XT_LOG.REASON IS '操作原因';
--changeset wenyuanwu:405 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_XMZT
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_XMZT
IS '项目状态字典表';
--changeset wenyuanwu:1401 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  MODIFY ywh NULL;
--changeset wenyuanwu:406 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_XZTYPE
(
  dm VARCHAR2(10),
  mc VARCHAR2(20)
);
--changeset wenyuanwu:407 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (SFZJTG VARCHAR2(1));
COMMENT ON COLUMN BDC_XM.SFZJTG IS '0:否，1:是';
--changeset wenyuanwu:408 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (ISSX VARCHAR2(1));
COMMENT ON COLUMN BDC_CF.ISSX IS '是否失效,0:否，1:是';
--changeset wenyuanwu:409 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (ISCD VARCHAR2(1));
COMMENT ON COLUMN BDC_CF.ISCD IS '是否裁定,0:否，1:是';
--changeset wenyuanwu:410 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (ISSX VARCHAR2(1));
COMMENT ON COLUMN GD_CF.ISSX IS '是否失效,0:否，1:是';
--changeset wenyuanwu:411 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (ISCD VARCHAR2(1));
COMMENT ON COLUMN GD_CF.ISCD IS '是否裁定,0:否，1:是';
--changeset wenyuanwu:412 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XYGL
(
  xyglid    VARCHAR2(32) NOT NULL,
  qlrmc     VARCHAR2(200),
  qlrsfzjzl VARCHAR2(100),
  qlrzjh    VARCHAR2(100),
  qlrtxdz   VARCHAR2(200),
  bz        VARCHAR2(1000),
  ryxxid    VARCHAR2(32)
);
COMMENT ON TABLE BDC_XYGL
IS '不动产信用管理表';
COMMENT ON COLUMN BDC_XYGL.xyglid
IS '管理id';
COMMENT ON COLUMN BDC_XYGL.qlrmc
IS '权利人';
COMMENT ON COLUMN BDC_XYGL.qlrsfzjzl
IS '证件类型';
COMMENT ON COLUMN BDC_XYGL.qlrzjh
IS '证件编号';
COMMENT ON COLUMN BDC_XYGL.qlrtxdz
IS '通讯地址';
COMMENT ON COLUMN BDC_XYGL.bz
IS '备注';
COMMENT ON COLUMN BDC_XYGL.ryxxid
IS '人员信息ID';
--changeset wenyuanwu:413 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XYMX
(
  xymxid VARCHAR2(32) NOT NULL,
  xyglid VARCHAR2(32),
  nr     VARCHAR2(1000),
  cjsj   DATE,
  gxdwid VARCHAR2(100),
  shr    VARCHAR2(100),
  shsj   DATE,
  sfsx   VARCHAR2(1)
);
COMMENT ON TABLE BDC_XYMX
IS '不动产信息明细表';
COMMENT ON COLUMN BDC_XYMX.xymxid
IS '信用明细id';
COMMENT ON COLUMN BDC_XYMX.xyglid
IS '信用管理id';
COMMENT ON COLUMN BDC_XYMX.nr
IS '内容';
COMMENT ON COLUMN BDC_XYMX.cjsj
IS '创建时间';
COMMENT ON COLUMN BDC_XYMX.gxdwid
IS '共享单位id';
COMMENT ON COLUMN BDC_XYMX.shr
IS '审核人';
COMMENT ON COLUMN BDC_XYMX.shsj
IS '审核时间';
COMMENT ON COLUMN BDC_XYMX.sfsx
IS '字典选项：0:否/1:是';
--changeset wenyuanwu:414 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JSXX
(
  jsid   VARCHAR2(32) NOT NULL,
  cqzh   VARCHAR2(100),
  bdcdyh VARCHAR2(28),
  zsid   VARCHAR2(100),
  qlr    VARCHAR2(100),
  bdclx  VARCHAR2(100),
  jszt   VARCHAR2(1),
  jsyy   VARCHAR2(500),
  jssj   DATE,
  jbr    VARCHAR2(100),
  qxr    VARCHAR2(100),
  qxsj   DATE,
  qxyy   VARCHAR2(500),
  zl     VARCHAR2(500)
);
COMMENT ON TABLE BDC_JSXX
IS '不动产警示信息';
COMMENT ON COLUMN BDC_JSXX.jsid
IS '警示id';
COMMENT ON COLUMN BDC_JSXX.cqzh
IS '产权证号';
COMMENT ON COLUMN BDC_JSXX.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_JSXX.zsid
IS '证书ID';
COMMENT ON COLUMN BDC_JSXX.qlr
IS '权利人';
COMMENT ON COLUMN BDC_JSXX.bdclx
IS '不动产类型';
COMMENT ON COLUMN BDC_JSXX.jszt
IS '警示状态';
COMMENT ON COLUMN BDC_JSXX.jsyy
IS '警示原因';
COMMENT ON COLUMN BDC_JSXX.jssj
IS '警示时间';
COMMENT ON COLUMN BDC_JSXX.jbr
IS '经办人';
COMMENT ON COLUMN BDC_JSXX.qxr
IS '取消人';
COMMENT ON COLUMN BDC_JSXX.qxsj
IS '取消时间';
COMMENT ON COLUMN BDC_JSXX.qxyy
IS '取消原因';
COMMENT ON COLUMN BDC_JSXX.zl
IS '坐落';
--changeset wenyuanwu:415 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LSH
(
  lshid  VARCHAR2(32) NOT NULL,
  lsh    VARCHAR2(100),
  nf     VARCHAR2(100),
  qh     VARCHAR2(100),
  bhlxdm VARCHAR2(100)
);
COMMENT ON COLUMN BDC_LSH.lshid
IS '流水号ID';
COMMENT ON COLUMN BDC_LSH.lsh
IS '流水号';
COMMENT ON COLUMN BDC_LSH.nf
IS '年份';
COMMENT ON COLUMN BDC_LSH.qh
IS '区号';
COMMENT ON COLUMN BDC_LSH.bhlxdm
IS '编号类型代码';
--changeset wenyuanwu:416 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_BHLX
(
  dm VARCHAR2(10),
  mc VARCHAR2(10)
);
COMMENT ON TABLE BDC_ZD_BHLX
IS '编号类型字典表';
COMMENT ON COLUMN BDC_ZD_BHLX.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_BHLX.mc
IS '名称';
--changeset wenyuanwu:417 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_QH
(
  dm VARCHAR2(10),
  mc VARCHAR2(10)
);
COMMENT ON TABLE BDC_ZD_QH
IS '区号字典表';
COMMENT ON COLUMN BDC_ZD_QH.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_QH.mc
IS '名称';
--changeset wenyuanwu:418 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_BH
(
  bhid   VARCHAR2(32) NOT NULL,
  bh     VARCHAR2(100),
  bhlxdm VARCHAR2(100),
  lshws  NUMBER
);
COMMENT ON TABLE BDC_XT_BH
IS '编号配置表';
COMMENT ON COLUMN BDC_XT_BH.bhid
IS '编号id';
COMMENT ON COLUMN BDC_XT_BH.bh
IS '编号';
COMMENT ON COLUMN BDC_XT_BH.bhlxdm
IS '编号类型代码';
COMMENT ON COLUMN BDC_XT_BH.lshws
IS '流水号位数';
--changeset wenyuanwu:419 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LW_RY
(
  CZRYID VARCHAR2(32) NOT NULL,
  CZRY   VARCHAR2(100),
  CZRYMM VARCHAR2(100)
);
COMMENT ON COLUMN BDC_LW_RY.CZRYID
IS '人员id';
COMMENT ON COLUMN BDC_LW_RY.CZRY
IS '人员';
COMMENT ON COLUMN BDC_LW_RY.CZRYMM
IS '人员密码';
--changeset wenyuanwu:420 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XZYZ_LW
(
  LWID   VARCHAR2(32)          NOT NULL,
  IP     VARCHAR2(100),
  CZRYID VARCHAR2(100)         NOT NULL,
  CZSJ   DATE                  NOT NULL,
  LWLX   VARCHAR2(1) DEFAULT 1 NOT NULL,
  WIID   VARCHAR2(32),
  XZWH   VARCHAR2(200),
  LWYY   VARCHAR2(1000)
);
COMMENT ON TABLE BDC_XZYZ_LW
IS '不动产验证特权表';
COMMENT ON COLUMN BDC_XZYZ_LW.LWID
IS '例外id';
COMMENT ON COLUMN BDC_XZYZ_LW.IP
IS '操作机器ip';
COMMENT ON COLUMN BDC_XZYZ_LW.CZRYID
IS '操作人员';
COMMENT ON COLUMN BDC_XZYZ_LW.CZSJ
IS '操作时间';
COMMENT ON COLUMN BDC_XZYZ_LW.LWLX
IS '特权类型(1:跳过查封)';
COMMENT ON COLUMN BDC_XZYZ_LW.WIID
IS '工作流ID';
COMMENT ON COLUMN BDC_XZYZ_LW.XZWH
IS '限制文号';
COMMENT ON COLUMN BDC_XZYZ_LW.LWYY
IS '例外原因';
--changeset wenyuanwu:421 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (CFSDSJ DATE);
COMMENT ON COLUMN GD_CF.CFSDSJ IS '查封送达时间';
--changeset wenyuanwu:422 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD (ISSX VARCHAR2(1));
COMMENT ON COLUMN GD_YY.ISSX IS '是否失效,0:否，1:是';
--changeset wenyuanwu:423 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD (ISSX VARCHAR2(1));
COMMENT ON COLUMN BDC_YY.ISSX IS '是否失效,0:否，1:是';
--changeset wenyuanwu:424 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDYSD
  ADD (BH VARCHAR2(100));
COMMENT ON COLUMN BDC_BDCDYSD.BH IS '受理编号';
--changeset wenyuanwu:425 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_EXCHANGE_ZDDZ
(
  bdcdjdm VARCHAR2(100),
  bdcdjmc VARCHAR2(100),
  zdlx    VARCHAR2(100),
  stddm   VARCHAR2(100),
  stdmc   VARCHAR2(100),
  id      VARCHAR2(32) NOT NULL
);
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.bdcdjdm
IS '不动产本地代码';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.bdcdjmc
IS '不动产本地名称';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.zdlx
IS '字典类型ghyt（房屋用途）、qllx（权利类型）、fwjg(房屋结构)';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.stddm
IS '国家标准代码';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.stdmc
IS '国家标准名称';
COMMENT ON COLUMN BDC_EXCHANGE_ZDDZ.id
IS '主键';
--changeset wenyuanwu:426 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (WIID VARCHAR2(32));
COMMENT ON COLUMN BDC_SQR.WIID IS '工作流id';
--changeset wenyuanwu:427 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (DYFS VARCHAR2(20));
COMMENT ON COLUMN GD_YG.DYFS IS '抵押方式';
--changeset wenyuanwu:428 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (JYHTH VARCHAR2(500));
COMMENT ON COLUMN GD_YG.JYHTH IS '交易合同号';
--changeset wenyuanwu:429 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (JYJE NUMBER(15));
COMMENT ON COLUMN GD_YG.JYJE IS '交易金额';
--changeset wenyuanwu:430 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD (BZ VARCHAR2(1000));
COMMENT ON COLUMN BDC_BDCZSSD.BZ IS '备注';
--changeset wenyuanwu:431 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_BDCSD
  ADD (BZ VARCHAR2(1000));
COMMENT ON COLUMN GD_BDCSD.BZ IS '备注';
--changeset wenyuanwu:432 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (JZND NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ.JZND IS '建筑年代';
--changeset wenyuanwu:433 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (JZND NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ_DZ.JZND IS '建筑年代';
--changeset wenyuanwu:434 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (XH NUMBER(10));
COMMENT ON COLUMN BDC_XT_SJCL.XH IS '序号';
--changeset wenyuanwu:435 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD TXDZ VARCHAR2(200);
COMMENT ON COLUMN BDC_XT_QY.TXDZ IS '通讯地址';
--changeset wenyuanwu:436 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD YB VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.YB IS '邮编';
--changeset wenyuanwu:437 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD FZR VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.FZR IS '负责人';
--changeset wenyuanwu:438 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD FZRLXDH VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.FZRLXDH IS '负责人联系电话';
--changeset wenyuanwu:439 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QY
  ADD DWDM VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.DWDM IS '单位代码';
--changeset wenyuanwu:440 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_XT_QY
  ADD DWXZ VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.DWXZ IS '单位性质';
--changeset wenyuanwu:441 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_XT_QY
  ADD FDDBR VARCHAR2(100);
COMMENT ON COLUMN BDC_XT_QY.FDDBR IS '法定代表人';
--changeset wenyuanwu:442 failOnError:false runOnChange:true runAlways:true


ALTER TABLE BDC_XT_YH
  ADD (YHFR VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.YHFR IS '银行法人';
--changeset wenyuanwu:443 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DJZX_DJYY_REL
(
  djzxdm VARCHAR2(2),
  djyy   VARCHAR2(100),
  id     VARCHAR2(10)
);
COMMENT ON TABLE BDC_DJZX_DJYY_REL
IS '登记子项登记原因关系表';
COMMENT ON COLUMN BDC_DJZX_DJYY_REL.djzxdm
IS '登记子项代码';
COMMENT ON COLUMN BDC_DJZX_DJYY_REL.djyy
IS '登记原因';
--changeset wenyuanwu:444 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_CQLY
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);

--changeset wenyuanwu:445 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (SFCZR VARCHAR2(1));
COMMENT ON COLUMN BDC_SQR.SFCZR IS '是否持证人';
--changeset wenyuanwu:446 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (GYFS VARCHAR2(100));
COMMENT ON COLUMN BDC_SQR.GYFS IS '共有方式';
--changeset wenyuanwu:447 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (QLBL VARCHAR2(100));
COMMENT ON COLUMN BDC_SQR.QLBL IS '权利比例';
--changeset wenyuanwu:448 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (XB VARCHAR2(10));
COMMENT ON COLUMN BDC_SQR.XB IS '性别';
--changeset wenyuanwu:449 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (SSHY VARCHAR2(100));
COMMENT ON COLUMN BDC_SQR.SSHY IS '所属行业';
--changeset wenyuanwu:450 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (LXDH VARCHAR2(100));
COMMENT ON COLUMN BDC_SQR.LXDH IS '联系电话';
--changeset wenyuanwu:451 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (QLMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_SQR.QLMJ IS '权利面积';
--changeset wenyuanwu:452 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SQR
  ADD (QYGYR VARCHAR2(100));
COMMENT ON COLUMN BDC_SQR.QYGYR IS '其余共有人';
--changeset wenyuanwu:453 failOnError:false runOnChange:true runAlways:true
CREATE TABLE OA_JCYZXX
(
  jcyzxxid VARCHAR2(32) NOT NULL,
  proid    VARCHAR2(32),
  wiid     VARCHAR2(32),
  gsh      VARCHAR2(32),
  sqrq     DATE,
  sqcl     VARCHAR2(500),
  jcyzlx   VARCHAR2(2),
  nf       NUMBER(4),
  lsh      VARCHAR2(10),
  djjg_jzr VARCHAR2(100),
  dy_smssj DATE,
  dy_jjssj DATE,
  dy_gssj  DATE,
  CONSTRAINT PK_OA_JCYZXX PRIMARY KEY (JCYZXXID)
);
COMMENT ON COLUMN OA_JCYZXX.jcyzxxid
IS '主键';
COMMENT ON COLUMN OA_JCYZXX.proid
IS '项目主键';
COMMENT ON COLUMN OA_JCYZXX.wiid
IS '工作流实例主键';
COMMENT ON COLUMN OA_JCYZXX.gsh
IS '公示号';
COMMENT ON COLUMN OA_JCYZXX.sqrq
IS '申请日期';
COMMENT ON COLUMN OA_JCYZXX.sqcl
IS '申请材料';
COMMENT ON COLUMN OA_JCYZXX.jcyzlx
IS 'JC:继承,YZ:遗赠';
COMMENT ON COLUMN OA_JCYZXX.nf
IS '年份';
COMMENT ON COLUMN OA_JCYZXX.lsh
IS '流水号';
COMMENT ON COLUMN OA_JCYZXX.djjg_jzr
IS '登记机构见证人';
COMMENT ON COLUMN OA_JCYZXX.dy_smssj
IS '打印声明书时间';
COMMENT ON COLUMN OA_JCYZXX.dy_jjssj
IS '打印具结书时间';
COMMENT ON COLUMN OA_JCYZXX.dy_gssj
IS '打印公示时间';

--changeset wenyuanwu:454 failOnError:false runOnChange:true runAlways:true
CREATE TABLE OA_JCYZR
(
  jcyzrid VARCHAR2(32) NOT NULL,
  proid   VARCHAR2(32),
  mc      VARCHAR2(100),
  xb      VARCHAR2(2),
  zjlx    VARCHAR2(10),
  zjh     VARCHAR2(100),
  csrq    DATE,
  swrq    DATE,
  txdz    VARCHAR2(500),
  swdz    VARCHAR2(500),
  jcyzrlx VARCHAR2(6),
  jcsx    NUMBER(10),
  CONSTRAINT PK_OA_JCYZR PRIMARY KEY (JCYZRID)
);
COMMENT ON COLUMN OA_JCYZR.jcyzrid
IS '主键';
COMMENT ON COLUMN OA_JCYZR.proid
IS '项目主键';
COMMENT ON COLUMN OA_JCYZR.mc
IS '姓名';
COMMENT ON COLUMN OA_JCYZR.xb
IS '性别(男 女 其他)';
COMMENT ON COLUMN OA_JCYZR.zjlx
IS '证件类型';
COMMENT ON COLUMN OA_JCYZR.zjh
IS '证件号码';
COMMENT ON COLUMN OA_JCYZR.csrq
IS '出生日期';
COMMENT ON COLUMN OA_JCYZR.swrq
IS '死亡日期';
COMMENT ON COLUMN OA_JCYZR.txdz
IS '居住地';
COMMENT ON COLUMN OA_JCYZR.swdz
IS '死亡地址';
COMMENT ON COLUMN OA_JCYZR.jcyzrlx
IS '类型(JCR:继承(被遗赠)人
BJCR:遗赠(被继承)人 FQJCR:放弃继承人)';
COMMENT ON COLUMN OA_JCYZR.jcsx
IS '继承顺序';

--changeset wenyuanwu:455 failOnError:false runOnChange:true runAlways:true
CREATE TABLE OA_XM
(
  proid   VARCHAR2(32) NOT NULL,
  bh      VARCHAR2(100),
  djlx    VARCHAR2(3),
  djyy    VARCHAR2(2000),
  bz      VARCHAR2(2000),
  xmzt    VARCHAR2(1),
  dwdm    VARCHAR2(12),
  cjsj    DATE,
  cjr     VARCHAR2(20),
  bjsj    DATE,
  lsh     VARCHAR2(100),
  nf      VARCHAR2(4),
  xmmc    VARCHAR2(2000),
  sqlx    VARCHAR2(10),
  bdcdyh  VARCHAR2(28),
  zdzhh   VARCHAR2(19),
  djsy    VARCHAR2(100),
  zl      VARCHAR2(2000),
  ybdcqzh VARCHAR2(2000),
  wiid    VARCHAR2(32),
  djzx    VARCHAR2(100),
  yfczh   VARCHAR2(2000),
  ytdzh   VARCHAR2(2000),
  djjg    VARCHAR2(100),
  CONSTRAINT PK_OA_XM_PROID PRIMARY KEY (PROID)
);
COMMENT ON COLUMN OA_XM.proid
IS '项目ID';
COMMENT ON COLUMN OA_XM.bh
IS '受理编号';
COMMENT ON COLUMN OA_XM.djlx
IS '登记类型';
COMMENT ON COLUMN OA_XM.djyy
IS '登记原因';
COMMENT ON COLUMN OA_XM.bz
IS '备注';
COMMENT ON COLUMN OA_XM.xmzt
IS '项目状态';
COMMENT ON COLUMN OA_XM.dwdm
IS '单位代码';
COMMENT ON COLUMN OA_XM.cjsj
IS '项目创建时间';
COMMENT ON COLUMN OA_XM.cjr
IS '项目创建人';
COMMENT ON COLUMN OA_XM.bjsj
IS '办结时间';
COMMENT ON COLUMN OA_XM.lsh
IS '流水号';
COMMENT ON COLUMN OA_XM.nf
IS '年份';
COMMENT ON COLUMN OA_XM.xmmc
IS '项目名称';
COMMENT ON COLUMN OA_XM.sqlx
IS '申请类型';
COMMENT ON COLUMN OA_XM.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN OA_XM.zdzhh
IS '宗地宗海号';
COMMENT ON COLUMN OA_XM.djsy
IS '登记事由';
COMMENT ON COLUMN OA_XM.zl
IS '坐落';
COMMENT ON COLUMN OA_XM.ybdcqzh
IS '原不动产权证号';
COMMENT ON COLUMN OA_XM.wiid
IS '工作流项目ID';
COMMENT ON COLUMN OA_XM.djzx
IS '登记子项';
COMMENT ON COLUMN OA_XM.yfczh
IS '原房产证号';
COMMENT ON COLUMN OA_XM.ytdzh
IS '原土地证号';
COMMENT ON COLUMN OA_XM.djjg
IS '登记机构';
--changeset wenyuanwu:456 failOnError:false runOnChange:true runAlways:true
CREATE TABLE OA_SQR
(
  sqrid VARCHAR2(32) NOT NULL,
  proid VARCHAR2(32),
  sqrmc VARCHAR2(2000),
  zjzl  VARCHAR2(2),
  zjh   VARCHAR2(50),
  txdz  VARCHAR2(100),
  csrq  DATE,
  dlrmc VARCHAR2(100),
  dlrdh VARCHAR2(50),
  dljg  VARCHAR2(100),
  sqrlb VARCHAR2(2),
  xh    NUMBER(2),
  bz    VARCHAR2(2000),
  wiid  VARCHAR2(32),
  xb    VARCHAR2(10),
  sshy  VARCHAR2(100),
  lxdh  VARCHAR2(100),
  CONSTRAINT PK_OA_SQR_SQRID PRIMARY KEY (SQRID)
);
COMMENT ON COLUMN OA_SQR.sqrid
IS '申请人ID';
COMMENT ON COLUMN OA_SQR.proid
IS '项目ID';
COMMENT ON COLUMN OA_SQR.sqrmc
IS '申请人名称';
COMMENT ON COLUMN OA_SQR.zjzl
IS '证件种类';
COMMENT ON COLUMN OA_SQR.zjh
IS '证件号';
COMMENT ON COLUMN OA_SQR.txdz
IS '通讯地址';
COMMENT ON COLUMN OA_SQR.csrq
IS '出生日期';
COMMENT ON COLUMN OA_SQR.dlrmc
IS '代理人名称';
COMMENT ON COLUMN OA_SQR.dlrdh
IS '代理人电话';
COMMENT ON COLUMN OA_SQR.dljg
IS '代理机构';
COMMENT ON COLUMN OA_SQR.sqrlb
IS '申请人类别';
COMMENT ON COLUMN OA_SQR.xh
IS '序号';
COMMENT ON COLUMN OA_SQR.bz
IS '备注';
COMMENT ON COLUMN OA_SQR.wiid
IS '工作流id';
COMMENT ON COLUMN OA_SQR.xb
IS '性别';
COMMENT ON COLUMN OA_SQR.sshy
IS '所属行业';
COMMENT ON COLUMN OA_SQR.lxdh
IS '联系电话';

--changeset wenyuanwu:457 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JTCY
(
  jtcyid VARCHAR2(32) NOT NULL,
  qlrid  VARCHAR2(32),
  jtcymc VARCHAR2(100),
  sfzjzl VARCHAR2(10),
  zjh    VARCHAR2(100),
  txdz   VARCHAR2(200),
  xb     VARCHAR2(10),
  lxdh   VARCHAR2(100),
  xh     NUMBER(10),
  yhzgx  VARCHAR2(100),
  gxsj   DATE,
  hkszd  VARCHAR2(500)
);
COMMENT ON TABLE BDC_JTCY
IS '家庭成员';
COMMENT ON COLUMN BDC_JTCY.jtcyid
IS '家庭成员ID';
COMMENT ON COLUMN BDC_JTCY.qlrid
IS '权利人ID';
COMMENT ON COLUMN BDC_JTCY.jtcymc
IS '家庭成员名称';
COMMENT ON COLUMN BDC_JTCY.sfzjzl
IS '身份证件种类';
COMMENT ON COLUMN BDC_JTCY.zjh
IS '证件号';
COMMENT ON COLUMN BDC_JTCY.txdz
IS '通讯地址';
COMMENT ON COLUMN BDC_JTCY.xb
IS '性别';
COMMENT ON COLUMN BDC_JTCY.lxdh
IS '联系电话';
COMMENT ON COLUMN BDC_JTCY.xh
IS '序号';
COMMENT ON COLUMN BDC_JTCY.yhzgx
IS '与户主关系';
COMMENT ON COLUMN BDC_JTCY.gxsj
IS '更新时间';
COMMENT ON COLUMN BDC_JTCY.hkszd
IS '户口所在地';

--changeset wenyuanwu:458 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYMX
  ADD (JCSXYY VARCHAR2(100));
COMMENT ON COLUMN BDC_XYMX.JCSXYY IS '解除生效原因';
--changeset wenyuanwu:459 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYMX
  ADD (JCSXSJ DATE);
COMMENT ON COLUMN BDC_XYMX.JCSXSJ IS '解除生效时间';
--changeset wenyuanwu:460 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYMX
  ADD (JCSXR VARCHAR2(100));
COMMENT ON COLUMN BDC_XYMX.JCSXR IS '解除生效人员';
--changeset wenyuanwu:461 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYMX
  ADD (BZ VARCHAR2(500));
COMMENT ON COLUMN BDC_XYMX.BZ IS '备注';
--changeset wenyuanwu:462 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yy
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_yy.daywh IS '档案业务号';
--changeset wenyuanwu:463 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_dy
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_dy.daywh IS '档案业务号';
--changeset wenyuanwu:464 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_cf.daywh IS '档案业务号';
--changeset wenyuanwu:465 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_yy
  ADD (daywh VARCHAR2(100));
COMMENT ON COLUMN gd_yg.daywh IS '档案业务号';
--changeset wenyuanwu:467 failOnError:false runOnChange:true runAlways:true

ALTER TABLE bdc_qlr
  ADD (qygyr VARCHAR2(200));
COMMENT ON COLUMN bdc_qlr.qygyr IS '其余共有人';
--changeset wenyuanwu:468 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD jgbz VARCHAR2(1000);
COMMENT ON COLUMN BDC_XXCXJG.jgbz IS '结果备注 ';
--changeset wenyuanwu:469 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD dyfs VARCHAR2(1);
COMMENT ON COLUMN BDC_XXCXJG.UPLOAD IS '0,1 ';
--changeset wenyuanwu:470 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJG
  ADD jgwjlj VARCHAR2(100);
COMMENT ON COLUMN BDC_XXCXJG.UPLOAD IS '结果文件路径 ';
--changeset wenyuanwu:471 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_SLLSH
  ADD QH VARCHAR2(100);
COMMENT ON COLUMN BDC_SLLSH.QH IS '区号 ';
--changeset wenyuanwu:472 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD FZJLDYZT VARCHAR2(1);
COMMENT ON COLUMN BDC_XM.FZJLDYZT IS '发证记录打印状态 ';

--changeset wenyuanwu:473 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD CLRQ DATE;
COMMENT ON COLUMN BDC_SJCL.CLRQ IS '材料日期 ';
--changeset wenyuanwu:474 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFSSS
  ADD (WIID VARCHAR2(32));
COMMENT ON COLUMN BDC_FWFSSS.WIID IS '流程实例id';
--changeset wenyuanwu:475 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DXFSJL
(
  id    VARCHAR2(32) NOT NULL,
  proid VARCHAR2(32),
  wiid  VARCHAR2(32),
  sqlx  VARCHAR2(10),
  lxdh  VARCHAR2(100),
  dxnr  VARCHAR2(100),
  fssj  DATE,
  fszt  VARCHAR2(2),
  dxid  VARCHAR2(100)
);
COMMENT ON TABLE BDC_DXFSJL
IS '短信发送记录表';
COMMENT ON COLUMN BDC_DXFSJL.id
IS '主键';
COMMENT ON COLUMN BDC_DXFSJL.proid
IS '项目主键';
COMMENT ON COLUMN BDC_DXFSJL.wiid
IS '实例主键';
COMMENT ON COLUMN BDC_DXFSJL.sqlx
IS '申请类型';
COMMENT ON COLUMN BDC_DXFSJL.lxdh
IS '联系电话';
COMMENT ON COLUMN BDC_DXFSJL.dxnr
IS '短信内容';
COMMENT ON COLUMN BDC_DXFSJL.fssj
IS '发送时间';
COMMENT ON COLUMN BDC_DXFSJL.fszt
IS '发送状态';
COMMENT ON COLUMN BDC_DXFSJL.dxid
IS '短信ID';

--changeset wenyuanwu:476 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_TD_QL_BH
  ADD (DJSX NUMBER(10));
COMMENT ON COLUMN GD_LS_TD_QL_BH.DJSX IS '登记顺序';
--changeset wenyuanwu:477 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_FW_QL_BH
  ADD (DJSX NUMBER(10));
COMMENT ON COLUMN GD_LS_FW_QL_BH.DJSX IS '登记顺序';
--changeset wenyuanwu:478 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_DY_BH
  ADD (DJSX NUMBER(10));
COMMENT ON COLUMN GD_LS_DY_BH.DJSX IS '登记顺序';
--changeset wenyuanwu:479 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LS_CF_BH
  ADD (DJSX NUMBER(10));
COMMENT ON COLUMN GD_LS_CF_BH.DJSX IS '登记顺序';
--changeset wenyuanwu:480 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (XMSX NUMBER(10));
COMMENT ON COLUMN GD_XM.XMSX IS '项目顺序';
--changeset wenyuanwu:481 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FWFSSS
  ADD (WIID VARCHAR2(32));
COMMENT ON COLUMN BDC_FWFSSS.WIID IS '工作流ID';

--changeset wenyuanwu:482 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CXSQ
(
  cxsqid  VARCHAR2(32) NOT NULL,
  proid   VARCHAR2(32),
  wiid    VARCHAR2(32),
  sqr     VARCHAR2(100),
  sqrzjhm VARCHAR2(100),
  cxmd    VARCHAR2(100),
  cxtj    VARCHAR2(100),
  cxnr    VARCHAR2(100),
  cxpz    VARCHAR2(100),
  cxjg    VARCHAR2(100),
  sqsj    DATE,
  bz      VARCHAR2(400)
);
COMMENT ON TABLE BDC_CXSQ
IS '不动产查询申请';
COMMENT ON COLUMN BDC_CXSQ.cxsqid
IS '查询申请主键';
COMMENT ON COLUMN BDC_CXSQ.proid
IS '项目主键';
COMMENT ON COLUMN BDC_CXSQ.wiid
IS '工作流ID';
COMMENT ON COLUMN BDC_CXSQ.sqr
IS '申请人';
COMMENT ON COLUMN BDC_CXSQ.sqrzjhm
IS '申请人证件号码';
COMMENT ON COLUMN BDC_CXSQ.cxmd
IS '查询目的';
COMMENT ON COLUMN BDC_CXSQ.cxtj
IS '查询条件';
COMMENT ON COLUMN BDC_CXSQ.cxnr
IS '查询内容';
COMMENT ON COLUMN BDC_CXSQ.cxpz
IS '查询凭证';
COMMENT ON COLUMN BDC_CXSQ.cxjg
IS '查询结果';
COMMENT ON COLUMN BDC_CXSQ.sqsj
IS '申请时间';
COMMENT ON COLUMN BDC_CXSQ.bz
IS '备注';

--changeset wenyuanwu:483 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DAH
(
  dahid  VARCHAR2(32) NOT NULL,
  dah    VARCHAR2(21) NOT NULL,
  lsh    VARCHAR2(10) NOT NULL,
  dahlx  VARCHAR2(4),
  syqk   VARCHAR2(1),
  cjr    VARCHAR2(100),
  cjsj   DATE,
  syr    VARCHAR2(100),
  sysj   DATE,
  bdcdyh VARCHAR2(28),
  zfr    VARCHAR2(100),
  zfsj   DATE,
  bfyy   VARCHAR2(500),
  wiid   VARCHAR2(32)
);

COMMENT ON COLUMN BDC_DAH.dahid
IS '档案号ID';
COMMENT ON COLUMN BDC_DAH.dah
IS '档案号';
COMMENT ON COLUMN BDC_DAH.lsh
IS '流水号';
COMMENT ON COLUMN BDC_DAH.dahlx
IS '档案号类型 （淮、淮单）';
COMMENT ON COLUMN BDC_DAH.syqk
IS '使用情况 0：未使用
1：已使用
2：报废';
COMMENT ON COLUMN BDC_DAH.cjr
IS '创建人';
COMMENT ON COLUMN BDC_DAH.cjsj
IS '创建时间';
COMMENT ON COLUMN BDC_DAH.syr
IS '使用人';
COMMENT ON COLUMN BDC_DAH.sysj
IS '使用时间';
COMMENT ON COLUMN BDC_DAH.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_DAH.zfr
IS '作废人';
COMMENT ON COLUMN BDC_DAH.zfsj
IS '作废时间';
COMMENT ON COLUMN BDC_DAH.bfyy
IS '报废原因';
COMMENT ON COLUMN BDC_DAH.wiid
IS '工作流id';
--changeset wenyuanwu:484 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CX_BDCDY_ZT
(
  ztid    VARCHAR2(32) NOT NULL,
  bdcdyh  VARCHAR2(28),
  bdcdybh VARCHAR2(50),
  bdclx   VARCHAR2(10),
  bdcdyzt VARCHAR2(1),
  djzt    VARCHAR2(1),
  qlr     VARCHAR2(100),
  zl      VARCHAR2(500),
  mj      NUMBER,
  yt      VARCHAR2(100),
  cqzh    VARCHAR2(100),
  zjgcdy  NUMBER,
  yg      NUMBER,
  ydya    NUMBER,
  dya     NUMBER,
  ycf     NUMBER,
  cf      NUMBER,
  yy      NUMBER,
  dyi     NUMBER,
  sd      NUMBER
);
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.ztid
IS '主键';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.bdcdyh
IS '可为空，唯一约束，未关联不动产单元的房屋或土地，其值为空';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.bdcdybh
IS '不可为空，唯一约束，房屋编号或地籍号';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.bdclx
IS 'TD：土地
TDFW：房屋
TDSL：森林';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.bdcdyzt
IS '0:无效，1：有效';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.djzt
IS '0：未登记
1：登记
2：注销';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.qlr
IS '多个权利人用逗号相隔';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.zl
IS '土地是土地坐落，房屋是房屋坐落';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.mj
IS '土地是宗地面积，房屋是建筑面积';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.yt
IS '多个用途用逗号相隔';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.cqzh
IS '多本证书用逗号相隔';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.zjgcdy
IS '多次抵押或解押，其值自增长或减少，步长为1';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.ydya
IS '多次抵押或解押，其值自增长或减少，步长为1';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.dya
IS '多次查封或解封，其值自增长或减少，步长为1';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.ycf
IS '多次查封或解封，其值自增长或减少，步长为1';
COMMENT ON COLUMN BDC_CX_BDCDY_ZT.cf
IS '多次查封或解封，其值自增长或减少，步长为1';

--changeset wenyuanwu:485 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DXFSJL
  ADD (JSRMC VARCHAR2(100));
COMMENT ON COLUMN BDC_DXFSJL.JSRMC IS '接收人名称';
--changeset wenyuanwu:486 failOnError:false runOnChange:true runAlways:true
CREATE TABLE PROVINCE_ACCESS
(
  biz_msg_id       VARCHAR2(22) NOT NULL,
  asid             VARCHAR2(5),
  area_code        VARCHAR2(12),
  rec_type         VARCHAR2(7),
  right_type       VARCHAR2(2),
  reg_type         VARCHAR2(8),
  create_date      DATE,
  rec_flow_id      VARCHAR2(50),
  reg_org_id       VARCHAR2(200),
  parcel_id        VARCHAR2(19),
  estate_num       VARCHAR2(28),
  pre_estate_num   VARCHAR2(256),
  pre_cert_id      VARCHAR2(256),
  cert_count       VARCHAR2(3),
  proof_count      VARCHAR2(3),
  success_flag     NUMBER,
  response_code    VARCHAR2(4),
  response_info    VARCHAR2(256),
  cert_id          VARCHAR2(128),
  additional_data  VARCHAR2(512),
  additional_data2 VARCHAR2(512),
  qr_code          CLOB,
  access_date      DATE,
  xml              CLOB
);
COMMENT ON TABLE PROVINCE_ACCESS
IS '数据汇交响应';
COMMENT ON COLUMN PROVINCE_ACCESS.biz_msg_id
IS '业务报文ID';
COMMENT ON COLUMN PROVINCE_ACCESS.asid
IS '接入标准ID';
COMMENT ON COLUMN PROVINCE_ACCESS.area_code
IS '行政区划编码';
COMMENT ON COLUMN PROVINCE_ACCESS.rec_type
IS '业务编码';
COMMENT ON COLUMN PROVINCE_ACCESS.right_type
IS '权利类型';
COMMENT ON COLUMN PROVINCE_ACCESS.reg_type
IS '登记类型';
COMMENT ON COLUMN PROVINCE_ACCESS.create_date
IS '创建时间';
COMMENT ON COLUMN PROVINCE_ACCESS.rec_flow_id
IS '业务流水号';
COMMENT ON COLUMN PROVINCE_ACCESS.reg_org_id
IS '登记机构';
COMMENT ON COLUMN PROVINCE_ACCESS.parcel_id
IS '宗地宗海代码';
COMMENT ON COLUMN PROVINCE_ACCESS.estate_num
IS '不动产单元号';
COMMENT ON COLUMN PROVINCE_ACCESS.pre_estate_num
IS '上次不动产单元号';
COMMENT ON COLUMN PROVINCE_ACCESS.pre_cert_id
IS '上次不动产权证号/不动产权证明号';
COMMENT ON COLUMN PROVINCE_ACCESS.cert_count
IS '不动产权证号码数量';
COMMENT ON COLUMN PROVINCE_ACCESS.proof_count
IS '证明号码数量';
COMMENT ON COLUMN PROVINCE_ACCESS.success_flag
IS '成功标识';
COMMENT ON COLUMN PROVINCE_ACCESS.response_code
IS '响应编码';
COMMENT ON COLUMN PROVINCE_ACCESS.response_info
IS '报文响应信息';
COMMENT ON COLUMN PROVINCE_ACCESS.cert_id
IS '配号：不动产证书编号';
COMMENT ON COLUMN PROVINCE_ACCESS.additional_data
IS '附加信息';
COMMENT ON COLUMN PROVINCE_ACCESS.additional_data2
IS '附加信息,扩展字段';
COMMENT ON COLUMN PROVINCE_ACCESS.qr_code
IS '防伪二维码';
COMMENT ON COLUMN PROVINCE_ACCESS.access_date
IS '汇交时间';
COMMENT ON COLUMN PROVINCE_ACCESS.xml
IS '报文xml';

--changeset wenyuanwu:487 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GG
  ADD (GGYJ VARCHAR2(100));
COMMENT ON COLUMN BDC_GG.GGYJ IS '公告意见';
--changeset wenyuanwu:488 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (LZQX NUMBER(10));
COMMENT ON COLUMN BDC_XM.LZQX IS '领证期限';
--changeset wenyuanwu:489 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DAH_XM
(
  "DAHID" VARCHAR2(32) NOT NULL ENABLE,
  "DAH"   VARCHAR2(21) NOT NULL ENABLE,
  "LSH"   VARCHAR2(10) NOT NULL ENABLE,
  "DAHLX" VARCHAR2(4),
  "SYQK"  VARCHAR2(1),
  "CJR"   VARCHAR2(100),
  "CJSJ"  DATE,
  "SYR"   VARCHAR2(100),
  "SYSJ"  DATE,
  "ZFR"   VARCHAR2(100),
  "ZFSJ"  DATE,
  "BFYY"  VARCHAR2(500),
  "WIID"  VARCHAR2(32)
);
--changeset wenyuanwu:490 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DAH_BDCDY
(
  "DAHID"  VARCHAR2(32) NOT NULL ENABLE,
  "DAH"    VARCHAR2(21) NOT NULL ENABLE,
  "LSH"    VARCHAR2(10) NOT NULL ENABLE,
  "DAHLX"  VARCHAR2(4),
  "SYQK"   VARCHAR2(1),
  "CJR"    VARCHAR2(100),
  "CJSJ"   DATE,
  "SYR"    VARCHAR2(100),
  "SYSJ"   DATE,
  "ZFR"    VARCHAR2(100),
  "ZFSJ"   DATE,
  "BFYY"   VARCHAR2(500),
  "BDCDYH" VARCHAR2(100)
);
--changeset wenyuanwu:491 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (YHSQYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.YHSQYWH IS '银行申请业务号';
--changeset wenyuanwu:492 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SQLX_DZB
(
  id         VARCHAR2(32) NOT NULL,
  bdcsqlxdm  VARCHAR2(100),
  bdcsqlxmc  VARCHAR2(100),
  xtlx       VARCHAR2(100),
  qtxtsqlxdm VARCHAR2(100),
  qtxtsqlxmc VARCHAR2(100)
);
COMMENT ON COLUMN BDC_SQLX_DZB.id
IS '主键';
COMMENT ON COLUMN BDC_SQLX_DZB.bdcsqlxdm
IS '不动产申请类型代码';
COMMENT ON COLUMN BDC_SQLX_DZB.bdcsqlxmc
IS '不动产申请类型名称';
COMMENT ON COLUMN BDC_SQLX_DZB.xtlx
IS '系统类型（1：银行申请2、开发商申请）';
COMMENT ON COLUMN BDC_SQLX_DZB.qtxtsqlxdm
IS '其他系统申请类型代码';
COMMENT ON COLUMN BDC_SQLX_DZB.qtxtsqlxmc
IS '其他系统申请类型名称';

--changeset wenyuanwu:493 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XH VARCHAR2(10));
COMMENT ON COLUMN BDC_ZSBH.XH IS '箱号';
--changeset wenyuanwu:494 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHKSBH VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.XHKSBH IS '箱号开始编号';
--changeset wenyuanwu:495 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHJSBH VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.XHJSBH IS '箱号结束编号';
--changeset wenyuanwu:496 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (CJRID VARCHAR2(32));
COMMENT ON COLUMN BDC_ZSBH.CJRID IS '创建人ID';
--changeset wenyuanwu:497 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (LQDW VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.LQDW IS '领取单位';
--changeset wenyuanwu:498 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (LQSJ DATE);
COMMENT ON COLUMN BDC_ZSBH.LQSJ IS '领取时间';
--changeset wenyuanwu:499 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (YSCZR VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.YSCZR IS '遗失操作人';
--changeset wenyuanwu:500 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (YSCZRID VARCHAR2(32));
COMMENT ON COLUMN BDC_ZSBH.YSCZRID IS '遗失操作人ID';
--changeset wenyuanwu:501 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (YSSJ DATE);
COMMENT ON COLUMN BDC_ZSBH.YSSJ IS '遗失时间';
--changeset wenyuanwu:502 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (YSYY VARCHAR2(500));
COMMENT ON COLUMN BDC_ZSBH.YSYY IS '遗失原因';
--changeset wenyuanwu:503 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHR VARCHAR2(10));
COMMENT ON COLUMN BDC_ZSBH.XHR IS '销毁人';
--changeset wenyuanwu:504 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHRID VARCHAR2(32));
COMMENT ON COLUMN BDC_ZSBH.XHRID IS '销毁人ID';
--changeset wenyuanwu:505 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHJZR VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.XHJZR IS '销毁见证人';
--changeset wenyuanwu:506 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHSJ DATE);
COMMENT ON COLUMN BDC_ZSBH.XHSJ IS '销毁时间';
--changeset wenyuanwu:507 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (QTQKSM VARCHAR2(400));
COMMENT ON COLUMN BDC_ZSBH.QTQKSM IS '其他情况说明';
--changeset wenyuanwu:508 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (BZ VARCHAR2(400));
COMMENT ON COLUMN BDC_ZSBH.BZ IS '备注';
--changeset wenyuanwu:509 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (SCCS VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.SCCS IS '生产厂商';
--changeset wenyuanwu:510 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_XM
  ADD (LZR VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.LZR IS '领证人';
--changeset wenyuanwu:511 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (WSZT VARCHAR2(2));
COMMENT ON COLUMN BDC_XM.WSZT IS '完税状态';
--changeset wenyuanwu:512 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (DSXTYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.DSXTYWH IS '地税系统业务号';
--changeset wenyuanwu:513 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (TXFS VARCHAR2(2));
COMMENT ON COLUMN BDC_QLR.TXFS IS '填写方式';
--changeset wenyuanwu:514 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GD_REL
(
  RELID   VARCHAR2(32),
  BDCDYH  VARCHAR2(28),
  GDHTH   VARCHAR2(100),
  GDDKID  VARCHAR2(100),
  GDXMID  VARCHAR2(32),
  BDCXMID VARCHAR2(32)
);
COMMENT ON COLUMN BDC_GD_REL.RELID
IS '关系id';
COMMENT ON COLUMN BDC_GD_REL.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_GD_REL.GDHTH
IS '供地合同号';
COMMENT ON COLUMN BDC_GD_REL.GDDKID
IS '供地地块ID';
COMMENT ON COLUMN BDC_GD_REL.GDXMID
IS '供地项目ID';
COMMENT ON COLUMN BDC_GD_REL.BDCXMID
IS '不动产项目ID';

--changeset wenyuanwu:515 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_FW
  ADD (FJH VARCHAR2(100));
COMMENT ON COLUMN GD_FW.FJH IS '房间号';
--changeset wenyuanwu:516 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (YGHYT VARCHAR2(100));
COMMENT ON COLUMN GD_FW.YGHYT IS '原规划用途';
--changeset wenyuanwu:517 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (YFWXZ VARCHAR2(100));
COMMENT ON COLUMN GD_FW.YFWXZ IS '原房屋性质';
--changeset wenyuanwu:518 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (YFWZL VARCHAR2(100));
COMMENT ON COLUMN GD_FW.YFWZL IS '原房屋坐落';
--changeset wenyuanwu:519 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (TDZH VARCHAR2(4000));
COMMENT ON COLUMN GD_FWSYQ.TDZH IS '土地证号';
--changeset wenyuanwu:520 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (WXJJ_DH VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.WXJJ_DH IS '维修基金单号';
--changeset wenyuanwu:521 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (WXJJ_DW VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.WXJJ_DW IS '维修基金单位';
--changeset wenyuanwu:522 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (WXJJ_JE NUMBER(15, 4));
COMMENT ON COLUMN GD_FWSYQ.WXJJ_JE IS '维修基金金额';
--changeset wenyuanwu:523 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (DH VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.DH IS '地籍号';
--changeset wenyuanwu:524 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (YTDYT VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.YTDYT IS '原土地用途';
--changeset wenyuanwu:525 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (KFSFR VARCHAR2(100));
COMMENT ON COLUMN GD_QLR.KFSFR IS '开发商法人';
--changeset wenyuanwu:526 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (KFS VARCHAR2(100));
COMMENT ON COLUMN GD_QLR.KFS IS '开发商';
--changeset wenyuanwu:527 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (PZMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TD.PZMJ IS '批准面积';
--changeset wenyuanwu:528 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (YYT VARCHAR2(100));
COMMENT ON COLUMN GD_TD.YYT IS '原用途';
--changeset wenyuanwu:529 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (YYT2 VARCHAR2(100));
COMMENT ON COLUMN GD_TD.YYT2 IS '原用途2';
--changeset wenyuanwu:530 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (YYT3 VARCHAR2(100));
COMMENT ON COLUMN GD_TD.YYT3 IS '原用途3';
--changeset wenyuanwu:531 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (YQSXZ VARCHAR2(100));
COMMENT ON COLUMN GD_TD.YQSXZ IS '原权属性质';
--changeset wenyuanwu:532 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD
  ADD (YZL VARCHAR2(100));
COMMENT ON COLUMN GD_TD.YZL IS '原坐落';
--changeset wenyuanwu:533 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (GYSYQMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.GYSYQMJ IS '共有使用权面积';
--changeset wenyuanwu:534 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (SJSYMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.SJSYMJ IS '实际使用面积';
--changeset wenyuanwu:535 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (DJMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.DJMJ IS '登记面积';
--changeset wenyuanwu:536 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (FCZH VARCHAR2(4000));
COMMENT ON COLUMN GD_TDSYQ.FCZH IS '房产证号';
--changeset wenyuanwu:537 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (FJMSJTSYDMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.FJMSJTSYDMJ IS '风景名胜及特殊用地面积';
--changeset wenyuanwu:538 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (JTYSYDMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.JTYSYDMJ IS '交通运输用地面积';
--changeset wenyuanwu:539 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (SYJSLSSYDMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.SYJSLSSYDMJ IS '交通运输用地面积';
--changeset wenyuanwu:540 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (QTYDMJ NUMBER(10, 2));
COMMENT ON COLUMN GD_TDSYQ.QTYDMJ IS '交通运输用地面积';
--changeset wenyuanwu:541 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (DASPSJ VARCHAR2(100));
COMMENT ON COLUMN GD_XM.DASPSJ IS '档案审批数据';
--changeset wenyuanwu:542 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (YDJSJ DATE);
COMMENT ON COLUMN GD_XM.YDJSJ IS '原登记时间';
--changeset wenyuanwu:543 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (YDJLX VARCHAR2(100));
COMMENT ON COLUMN GD_XM.YDJLX IS '原登记类型';
--changeset wenyuanwu:544 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (YZL VARCHAR2(100));
COMMENT ON COLUMN GD_XM.YZL IS '原坐落';
--changeset wenyuanwu:545 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FWFSSS
  ADD (YQLID VARCHAR2(100));
COMMENT ON COLUMN BDC_FWFSSS.YQLID IS '原权利id';
--changeset wenyuanwu:546 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFSSS
  ADD (YPROID VARCHAR2(32));
COMMENT ON COLUMN BDC_FWFSSS.YPROID IS '原项目id';
--changeset wenyuanwu:547 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_FW_QL
  ADD (QLRZJH VARCHAR2(100));
COMMENT ON COLUMN GD_FW_QL.QLRZJH IS '权利人证件号';
--changeset wenyuanwu:548 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD (QLRZJH VARCHAR2(32));
COMMENT ON COLUMN GD_TD_QL.QLRZJH IS '权利人证件号';
--changeset wenyuanwu:549 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_SYQK
(
  dm VARCHAR2(10),
  mc VARCHAR2(10)
);
COMMENT ON TABLE BDC_ZD_SYQK
IS '使用情况字典表';
COMMENT ON COLUMN BDC_ZD_SYQK.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_SYQK.mc
IS '名称';
--changeset wenyuanwu:550 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (QTCZR VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.QTCZR IS '其他操作人';
--changeset wenyuanwu:551 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (QTCZRID VARCHAR2(100));
COMMENT ON COLUMN BDC_ZSBH.QTCZRID IS '其他操作人ID';
--changeset wenyuanwu:552 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (QTCZSJ DATE);
COMMENT ON COLUMN BDC_ZSBH.QTCZSJ IS '其他操作时间';
--changeset wenyuanwu:553 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (XHYY VARCHAR2(400));
COMMENT ON COLUMN BDC_ZSBH.XHYY IS '销毁原因';

--changeset wenyuanwu:554 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDCDJ_EXCHANGE_ZDSQLX
(
  id              VARCHAR2(32)  NOT NULL,
  bdcsqlxdm       VARCHAR2(20)  NOT NULL,
  bdcsqlxmc       VARCHAR2(200) NOT NULL,
  bdcqllxdm       VARCHAR2(20)  NOT NULL,
  bdcqllxmc       VARCHAR2(200) NOT NULL,
  bdclx           VARCHAR2(20)  NOT NULL,
  nationalywdm    VARCHAR2(20)  NOT NULL,
  nationalservice VARCHAR2(50)  NOT NULL,
  specialtype     VARCHAR2(50),
  sfdz            VARCHAR2(20)
);
COMMENT ON TABLE BDCDJ_EXCHANGE_ZDSQLX
IS '数据接入申请类型服务表';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.id
IS '主键';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.bdcsqlxdm
IS '不动产申请类型代码';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.bdcsqlxmc
IS '不动产申请类型名称';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.bdcqllxdm
IS '不动产权利类型代码';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.bdcqllxmc
IS '不动产权利类型名称';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.bdclx
IS '不动产类型';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.nationalywdm
IS '国家业务代码（参考汇交文档）';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.nationalservice
IS '每种业务的服务实现（参考字典表）';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.specialtype
IS '特殊类别';
COMMENT ON COLUMN BDCDJ_EXCHANGE_ZDSQLX.sfdz
IS '是否项目内多幢';

--changeset wenyuanwu:555 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDCDJ_ZD_NATIONALSERVICE
(
  nationaldm      VARCHAR2(20),
  nationalservice VARCHAR2(50)
);
COMMENT ON TABLE BDCDJ_ZD_NATIONALSERVICE
IS '数据接入服务字典表';
COMMENT ON COLUMN BDCDJ_ZD_NATIONALSERVICE.nationaldm
IS '代码';
COMMENT ON COLUMN BDCDJ_ZD_NATIONALSERVICE.nationalservice
IS '服务';
--changeset wenyuanwu:556 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SFZTCZR VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.SFZTCZR IS '收费状态操作人';
--changeset wenyuanwu:557 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (SFZTCZRQ DATE);
COMMENT ON COLUMN BDC_SFXX.SFZTCZRQ IS '收费状态操作日期';

--changeset wenyuanwu:558 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (sfyjzs VARCHAR2(1));
COMMENT ON COLUMN bdc_xm.sfyjzs IS '是否邮寄证书';
--changeset wenyuanwu:559 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GD_REL
  ADD (YDPZH VARCHAR2(100));
COMMENT ON COLUMN BDC_GD_REL.YDPZH IS '用地批准号';
--changeset wenyuanwu:560 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZJ
(
  proid VARCHAR2(32) NOT NULL,
  zjid  VARCHAR2(32) NOT NULL,
  zjbh  VARCHAR2(100),
  zjrq  DATE,
  zjr   VARCHAR2(100),
  zjyy  VARCHAR2(2000),
  bz    VARCHAR2(2000),
  zjzt  VARCHAR2(2),
  zjpf  NUMBER(10, 2)
);
COMMENT ON TABLE BDC_ZJ
IS '质检表';
COMMENT ON COLUMN BDC_ZJ.proid
IS '项目id';
COMMENT ON COLUMN BDC_ZJ.zjid
IS '质检id';
COMMENT ON COLUMN BDC_ZJ.zjbh
IS '质检编号';
COMMENT ON COLUMN BDC_ZJ.zjrq
IS '质检日期';
COMMENT ON COLUMN BDC_ZJ.zjr
IS '质检人';
COMMENT ON COLUMN BDC_ZJ.zjyy
IS '质检原因';
COMMENT ON COLUMN BDC_ZJ.bz
IS '备注';
COMMENT ON COLUMN BDC_ZJ.zjzt
IS '质检状态（0：未通过，1：通过）';
COMMENT ON COLUMN BDC_ZJ.zjpf
IS '质检评分';

--changeset wenyuanwu:561 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZJMX
(
  zjmxid VARCHAR2(32) NOT NULL,
  zjid   VARCHAR2(32) NOT NULL,
  zjnr   VARCHAR2(2000),
  sftg   VARCHAR2(2),
  zjqk   VARCHAR2(2000),
  bz     VARCHAR2(2000)
);
COMMENT ON TABLE BDC_ZJMX
IS '质检明细';
COMMENT ON COLUMN BDC_ZJMX.zjmxid
IS '主键';
COMMENT ON COLUMN BDC_ZJMX.zjid
IS '质检id';
COMMENT ON COLUMN BDC_ZJMX.zjnr
IS '质检内容';
COMMENT ON COLUMN BDC_ZJMX.sftg
IS '是否通过';
COMMENT ON COLUMN BDC_ZJMX.zjqk
IS '质检情况';
COMMENT ON COLUMN BDC_ZJMX.bz
IS '备注';

--changeset wenyuanwu:562 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GG
  ADD (ZXCDS VARCHAR2(100));
COMMENT ON COLUMN BDC_GG.ZXCDS IS '执行裁定书';
--changeset wenyuanwu:563 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GG
  ADD (XZZXTZS VARCHAR2(100));
COMMENT ON COLUMN BDC_GG.XZZXTZS IS '协助执行通知书';

--changeset wenyuanwu:564 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JSYDSYQ_LHXX
(
  lhid      VARCHAR2(38) NOT NULL,
  proid     VARCHAR2(32),
  wiid      VARCHAR2(32),
  zdbdcdyh  VARCHAR2(28),
  djh       VARCHAR2(19),
  xmmc      VARCHAR2(100),
  kfqymc    VARCHAR2(100),
  tdzl      VARCHAR2(1000),
  tdmj      NUMBER(10, 2),
  zrzh      VARCHAR2(100),
  lzbdcdyh  VARCHAR2(28),
  gcjd      VARCHAR2(100),
  ghjzmj    NUMBER(10, 6),
  bzghmjzbl NUMBER(10, 6),
  scjzmj    NUMBER(10, 6),
  bz        VARCHAR2(2000)
);
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.lhid
IS '量化ID';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.proid
IS '项目ID';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.wiid
IS '工作流id';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.zdbdcdyh
IS '宗地不动产单元号';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.djh
IS '地籍号';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.xmmc
IS '项目名称';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.kfqymc
IS '开发企业名称';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.tdzl
IS '土地坐落';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.tdmj
IS '土地面积';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.zrzh
IS '幢号';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.lzbdcdyh
IS '楼幢不动产单元号';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.gcjd
IS '工程进度';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.ghjzmj
IS '规划建筑面积';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.bzghmjzbl
IS '本幢规划面积占比例（万分比）';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.scjzmj
IS '实测建筑面积';
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.bz
IS '备注';

--changeset wenyuanwu:565 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD (CXJQBH VARCHAR2(100));
COMMENT ON COLUMN BDC_XXCXJL.CXJQBH IS '查询机器编号';
--changeset wenyuanwu:566 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD (CXRZPLJ VARCHAR2(100));
COMMENT ON COLUMN BDC_XXCXJL.CXRZPLJ IS '查询人照片路径';
--changeset wenyuanwu:567 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (FPH VARCHAR2(100));

COMMENT ON COLUMN BDC_SFXX.FPH IS '发票号';
--changeset wenyuanwu:568 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_XT_GD
(
  id     VARCHAR2(32)  NOT NULL,
  dm     VARCHAR2(100) NOT NULL,
  gdlx   VARCHAR2(100) NOT NULL,
  gdmbmc VARCHAR2(100) NOT NULL
);
COMMENT ON TABLE BDC_XT_GD
IS '归档配置';
COMMENT ON COLUMN BDC_XT_GD.id
IS '主键';
COMMENT ON COLUMN BDC_XT_GD.dm
IS '代码';
COMMENT ON COLUMN BDC_XT_GD.gdlx
IS '归档类型：sqlx、qllx、bdclx';
COMMENT ON COLUMN BDC_XT_GD.gdmbmc
IS '归档模板名称';

--changeset wenyuanwu:569 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (YHSPDW VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.YHSPDW IS '用海审批单位';
--changeset wenyuanwu:570 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (PZWH VARCHAR2(100));
COMMENT ON COLUMN BDC_SPXX.PZWH IS '批准文号';
--changeset wenyuanwu:571 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD (XMMC VARCHAR2(100));
COMMENT ON COLUMN BDC_HYSYQ.XMMC IS '项目名称';
--changeset wenyuanwu:572 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (jfywh VARCHAR2(100));
COMMENT ON COLUMN gd_cf.jfywh IS '解封业务号';
--changeset wenyuanwu:573 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (jfdbr VARCHAR2(100));
COMMENT ON COLUMN gd_cf.jfdbr IS '解封登簿人';
--changeset wenyuanwu:574 failOnError:false runOnChange:true runAlways:true
ALTER TABLE gd_cf
  ADD (jfdbsj DATE);
COMMENT ON COLUMN gd_cf.jfdbsj IS '解封登簿时间';
--changeset wenyuanwu:575 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZDPJJL
(
  pjjlid VARCHAR2(32) NOT NULL,
  yhid   VARCHAR2(32),
  yhmc   VARCHAR2(100),
  pjsl   NUMBER(10)  DEFAULT 0,
  gzlid  VARCHAR2(100),
  jdid   VARCHAR2(100),
  pjsx   NUMBER(10)  DEFAULT 1,
  kqzt   VARCHAR2(2) DEFAULT 1,
  jdmc   VARCHAR2(100),
  gzlmc  VARCHAR2(100)
);
COMMENT ON TABLE BDC_ZDPJJL
IS '自动派件记录';
COMMENT ON COLUMN BDC_ZDPJJL.pjjlid
IS '派件记录id';
COMMENT ON COLUMN BDC_ZDPJJL.yhid
IS '用户id';
COMMENT ON COLUMN BDC_ZDPJJL.yhmc
IS '用户名称';
COMMENT ON COLUMN BDC_ZDPJJL.pjsl
IS '派件数量';
COMMENT ON COLUMN BDC_ZDPJJL.gzlid
IS '工作流id';
COMMENT ON COLUMN BDC_ZDPJJL.jdid
IS '节点id';
COMMENT ON COLUMN BDC_ZDPJJL.pjsx
IS '派件顺序';
COMMENT ON COLUMN BDC_ZDPJJL.kqzt
IS '考勤状态';
COMMENT ON COLUMN BDC_ZDPJJL.jdmc
IS '节点名称';
COMMENT ON COLUMN BDC_ZDPJJL.gzlmc
IS '工作流名称';
--changeset wenyuanwu:576 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZDPJJL
  ADD CONSTRAINT PK_BDC_ZDPJJL_KEY PRIMARY KEY (PJJLID);
--changeset wenyuanwu:577 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (QLSX VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.QLSX IS '权利顺序';
--changeset wenyuanwu:578 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD (QLSX VARCHAR2(100));
COMMENT ON COLUMN GD_CF.QLSX IS '权利顺序';
--changeset wenyuanwu:579 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (QLSX VARCHAR2(100));
COMMENT ON COLUMN GD_DY.QLSX IS '权利顺序';
--changeset wenyuanwu:580 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD (QLSX VARCHAR2(100));
COMMENT ON COLUMN GD_YY.QLSX IS '权利顺序';
--changeset wenyuanwu:581 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (QLSX VARCHAR2(100));
COMMENT ON COLUMN GD_YG.QLSX IS '权利顺序';
--changeset wenyuanwu:582 failOnError:false runOnChange:true runAlways:true

ALTER TABLE bdc_sfxx
  ADD (QLRSFHJ NUMBER(24, 2));
COMMENT ON COLUMN bdc_sfxx.QLRSFHJ IS '权利人收费合计';
--changeset wenyuanwu:583 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_sfxx
  ADD (YWRSFHJ NUMBER(24, 2));
COMMENT ON COLUMN bdc_sfxx.YWRSFHJ IS '义务人收费合计';
--changeset wenyuanwu:584 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (DYTDMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.DYTDMJ IS '独用土地面积';
--changeset wenyuanwu:585 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (FTTDMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.FTTDMJ IS '分摊土地面积';
--changeset wenyuanwu:586 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD ccgd NUMBER(15, 2);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ccgd IS '草层高度';
--changeset wenyuanwu:587 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD CDYSZ VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.CDYSZ IS '草地优势种';
--changeset wenyuanwu:588 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD CDJQ VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.CDJQ IS '草地建群';
--changeset wenyuanwu:589 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD CDFGD VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.CDFGD IS '草地覆盖度';
--changeset wenyuanwu:590 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_OPINION
  ADD (CONTENTDB VARCHAR2(1000));
COMMENT ON COLUMN BDC_XT_OPINION.CONTENTDB IS '默认意见SQL数据源';
--changeset wenyuanwu:591 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD (YHLXB VARCHAR2(10));
COMMENT ON COLUMN BDC_SPXX.YHLXB IS '用海类型B';
--changeset wenyuanwu:592 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD (YWR VARCHAR2(100));
COMMENT ON COLUMN GD_FW_QL.YWR IS '义务人';
--changeset wenyuanwu:593 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD (YWR VARCHAR2(100));
COMMENT ON COLUMN GD_TD_QL.YWR IS '义务人';
--changeset wenyuanwu:594 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (SFGZ VARCHAR2(2));
COMMENT ON COLUMN BDC_XT_YH.SFGZ IS '是否挂账';
--changeset wenyuanwu:595 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (HTJE NUMBER(16, 4));
COMMENT ON COLUMN BDC_FDCQ.HTJE IS '合同金额';
--changeset wenyuanwu:596 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (HTQDSJ DATE);
COMMENT ON COLUMN BDC_FDCQ.HTQDSJ IS '合同签订时间';
--changeset wenyuanwu:600 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (FDCJYHTH VARCHAR2(100));
COMMENT ON COLUMN BDC_FDCQ_DZ.FDCJYHTH IS '房地产交易合同号';
--changeset wenyuanwu:601 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (HTJE NUMBER(16, 4));
COMMENT ON COLUMN BDC_FDCQ_DZ.HTJE IS '合同金额';
--changeset wenyuanwu:602 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (HTQDSJ DATE);
COMMENT ON COLUMN BDC_FDCQ_DZ.HTQDSJ IS '合同签订时间';
--changeset wenyuanwu:603 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (FWTC NUMBER(10));
COMMENT ON COLUMN BDC_QLR.FWTC IS '房屋套次';
--changeset wenyuanwu:604 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (FWTCMX CLOB);
COMMENT ON COLUMN BDC_QLR.FWTCMX IS '房屋套次明细';
--changeset wenyuanwu:605 failOnError:false runOnChange:true runAlways:true


CREATE TABLE BDC_TSZT
(
  tsid  VARCHAR2(32) NOT NULL,
  proid VARCHAR2(32),
  qlid  VARCHAR2(32),
  tsdx  VARCHAR2(100),
  tsxs  VARCHAR2(1),
  tscs  NUMBER(10),
  tszt  VARCHAR2(10),
  tssj  DATE,
  tsr   VARCHAR2(100),
  tsqk  VARCHAR2(2000),
  bz    VARCHAR2(2000),
  xmly  VARCHAR2(1),
  qllx  VARCHAR2(100),
  qszt  VARCHAR2(2)
);
COMMENT ON TABLE BDC_TSZT
IS '不动产登记推送状态';
COMMENT ON COLUMN BDC_TSZT.tsid
IS '主键';
COMMENT ON COLUMN BDC_TSZT.proid
IS '项目id';
COMMENT ON COLUMN BDC_TSZT.qlid
IS '权利ID';
COMMENT ON COLUMN BDC_TSZT.tsdx
IS '推送对象';
COMMENT ON COLUMN BDC_TSZT.tsxs
IS '推送形式';
COMMENT ON COLUMN BDC_TSZT.tscs
IS '推送次数';
COMMENT ON COLUMN BDC_TSZT.tszt
IS '推送状态';
COMMENT ON COLUMN BDC_TSZT.tssj
IS '推送时间';
COMMENT ON COLUMN BDC_TSZT.tsr
IS '推送人';
COMMENT ON COLUMN BDC_TSZT.tsqk
IS '推送情况';
COMMENT ON COLUMN BDC_TSZT.bz
IS '备注';
COMMENT ON COLUMN BDC_TSZT.xmly
IS '项目来源';
COMMENT ON COLUMN BDC_TSZT.qllx
IS '权利类型';
COMMENT ON COLUMN BDC_TSZT.qszt
IS '权属状态';
--changeset wenyuanwu:606 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_QTDJ_YW_REL
(
  wdid   VARCHAR2(50)  NOT NULL,
  ywbm   VARCHAR2(32)  NOT NULL,
  ywmc   VARCHAR2(200) NOT NULL,
  qlbm   VARCHAR2(32)  NOT NULL,
  qlmc   VARCHAR2(200) NOT NULL,
  fdbjsx NUMBER(4)     NOT NULL
);
COMMENT ON TABLE BDC_QTDJ_YW_REL
IS '不动产与其他登记业务关系表';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.wdid
IS '流程定义id';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.ywbm
IS '业务编码';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.ywmc
IS '业务编码名称';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.qlbm
IS '权利编码';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.qlmc
IS '权利编码名称';
COMMENT ON COLUMN BDC_QTDJ_YW_REL.fdbjsx
IS '法定办结时限';
--changeset wenyuanwu:607 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (YWH VARCHAR2(20));
COMMENT ON COLUMN GD_XM.YWH IS '业务号';
--changeset wenyuanwu:608 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_log
  ADD (WIID VARCHAR2(32));
COMMENT ON COLUMN BDC_XT_log.WIID IS '工作流id';
--changeset wenyuanwu:609 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (XMLY VARCHAR2(100));
COMMENT ON COLUMN GD_XM.XMLY IS '项目来源（数据录入、数据整合）';
--changeset wenyuanwu:670 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_XM
  ADD (DJYY VARCHAR2(100));
COMMENT ON COLUMN GD_XM.DJYY IS '登记原因';
--changeset wenyuanwu:671 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (QTSM VARCHAR2(1000));
COMMENT ON COLUMN BDC_XT_SJCL.QTSM IS '其他说明';
--changeset wenyuanwu:672 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FWZL
  ADD (ZLBF VARCHAR2(100));
COMMENT ON COLUMN BDC_FWZL.ZLBF IS '租赁部位';
--changeset wenyuanwu:673 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (ZLFS VARCHAR2(2));
COMMENT ON COLUMN BDC_FWZL.ZLFS IS '租赁方式';
--changeset wenyuanwu:674 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (ZLLX VARCHAR2(2));
COMMENT ON COLUMN BDC_FWZL.ZLLX IS '租赁类型';
--changeset wenyuanwu:675 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (YZJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_FWZL.YZJ IS '月租金';
--changeset wenyuanwu:676 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (FWZLBAZMH VARCHAR2(100));
COMMENT ON COLUMN BDC_FWZL.FWZLBAZMH IS '房屋租赁备案证明号';
--changeset wenyuanwu:677 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (NF VARCHAR2(4));
COMMENT ON COLUMN BDC_FWZL.NF IS '年份';
--changeset wenyuanwu:678 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWZL
  ADD (LSH NUMBER(4));
COMMENT ON COLUMN BDC_FWZL.LSH IS '流水号';

--changeset wenyuanwu:679 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (SFSBCLKD VARCHAR2(2));
COMMENT ON COLUMN BDC_XM.SFSBCLKD IS '是否申报材料快递';
--changeset wenyuanwu:770 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_WLXX
(
  wlxxid   VARCHAR2(32) NOT NULL,
  ckh      VARCHAR2(100),
  bh       VARCHAR2(100),
  fjr      VARCHAR2(100),
  fjrsheng VARCHAR2(100),
  fjrshi   VARCHAR2(100),
  fjrqx    VARCHAR2(100),
  fjdz     VARCHAR2(500),
  fjrsj    VARCHAR2(100),
  fjrlxdh  VARCHAR2(100),
  xflsh    VARCHAR2(100),
  kddh     VARCHAR2(100),
  yjlx     VARCHAR2(10),
  jjnrlx   VARCHAR2(10),
  sflx     VARCHAR2(10),
  sjr      VARCHAR2(100),
  sjrsheng VARCHAR2(100),
  sjrshi   VARCHAR2(100),
  sjrqx    VARCHAR2(100),
  sjdz     VARCHAR2(500),
  sjrsj    VARCHAR2(100),
  sjrlxdh  VARCHAR2(100),
  sjryb    VARCHAR2(100),
  yjclsm   VARCHAR2(200),
  qjyzm    VARCHAR2(6),
  zwfwzxbm VARCHAR2(100),
  blbm     VARCHAR2(100),
  blbmbm   VARCHAR2(100),
  jssj     DATE,
  sfyjjs   VARCHAR2(100),
  wllx     VARCHAR2(2)  NOT NULL,
  proid    VARCHAR2(32) NOT NULL
);
COMMENT ON TABLE BDC_WLXX
IS '不动产物流信息表';
COMMENT ON COLUMN BDC_WLXX.wlxxid
IS '物流信息ID';
COMMENT ON COLUMN BDC_WLXX.ckh
IS '窗口号';
COMMENT ON COLUMN BDC_WLXX.bh
IS '办件编号';
COMMENT ON COLUMN BDC_WLXX.fjr
IS '发件人';
COMMENT ON COLUMN BDC_WLXX.fjrsheng
IS '发件人省';
COMMENT ON COLUMN BDC_WLXX.fjrshi
IS '发件人市';
COMMENT ON COLUMN BDC_WLXX.fjrqx
IS '发件人区县';
COMMENT ON COLUMN BDC_WLXX.fjdz
IS '发件地址';
COMMENT ON COLUMN BDC_WLXX.fjrsj
IS '发件人手机';
COMMENT ON COLUMN BDC_WLXX.fjrlxdh
IS '发件人联系电话';
COMMENT ON COLUMN BDC_WLXX.xflsh
IS '信封流水号';
COMMENT ON COLUMN BDC_WLXX.kddh
IS '快递单号';
COMMENT ON COLUMN BDC_WLXX.yjlx
IS '邮寄类型';
COMMENT ON COLUMN BDC_WLXX.jjnrlx
IS '寄件内容类型';
COMMENT ON COLUMN BDC_WLXX.sflx
IS '收费类型';
COMMENT ON COLUMN BDC_WLXX.sjr
IS '收件人';
COMMENT ON COLUMN BDC_WLXX.sjrsheng
IS '收件人省';
COMMENT ON COLUMN BDC_WLXX.sjrshi
IS '收件人市';
COMMENT ON COLUMN BDC_WLXX.sjrqx
IS '收件人区县';
COMMENT ON COLUMN BDC_WLXX.sjdz
IS '收件地址';
COMMENT ON COLUMN BDC_WLXX.sjrsj
IS '收件人手机';
COMMENT ON COLUMN BDC_WLXX.sjrlxdh
IS '收件人联系电话';
COMMENT ON COLUMN BDC_WLXX.sjryb
IS '收件人邮编';
COMMENT ON COLUMN BDC_WLXX.yjclsm
IS '邮寄材料说明';
COMMENT ON COLUMN BDC_WLXX.qjyzm
IS '取件验证码';
COMMENT ON COLUMN BDC_WLXX.zwfwzxbm
IS '政务服务中心编码';
COMMENT ON COLUMN BDC_WLXX.blbm
IS '办理部门';
COMMENT ON COLUMN BDC_WLXX.blbmbm
IS '办理部门编码';
COMMENT ON COLUMN BDC_WLXX.jssj
IS '寄送时间';
COMMENT ON COLUMN BDC_WLXX.sfyjjs
IS '是否已经寄送';
COMMENT ON COLUMN BDC_WLXX.wllx
IS '物流类型';
COMMENT ON COLUMN BDC_WLXX.proid
IS '项目ID';
--changeset wenyuanwu:771 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_DJJG
(
  id     VARCHAR2(32) NOT NULL,
  djjgmc VARCHAR2(100),
  djjgdm VARCHAR2(100),
  dwdm   VARCHAR2(100)
);
COMMENT ON TABLE BDC_ZD_DJJG
IS '登记机构字典表';
COMMENT ON COLUMN BDC_ZD_DJJG.id
IS '主键';
COMMENT ON COLUMN BDC_ZD_DJJG.djjgmc
IS '登记机构名称';
COMMENT ON COLUMN BDC_ZD_DJJG.djjgdm
IS '登记机构代码';
COMMENT ON COLUMN BDC_ZD_DJJG.dwdm
IS '单位代码';
--changeset wenyuanwu:772 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_WLLX
(
  dm VARCHAR2(100),
  mc VARCHAR2(100)
);
COMMENT ON TABLE BDC_ZD_WLLX
IS '物流类型字典表';
COMMENT ON COLUMN BDC_ZD_WLLX.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_WLLX.mc
IS '名称';

--changeset wenyuanwu:773 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (SFRZ VARCHAR2(10));
COMMENT ON COLUMN BDC_DYAQ.SFRZ IS '是否融资';
--changeset wenyuanwu:774 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CX_QXPZ
(
  id     VARCHAR2(32)  NOT NULL,
  dwdm   VARCHAR2(10)  NOT NULL,
  roleid VARCHAR2(100) NOT NULL,
  cxzydm VARCHAR2(100) NOT NULL,
  cxzymc VARCHAR2(100) NOT NULL,
  pzmb   VARCHAR2(4000)
);
COMMENT ON TABLE BDC_CX_QXPZ
IS '不动产查询权限配置';
COMMENT ON COLUMN BDC_CX_QXPZ.id
IS '主键';
COMMENT ON COLUMN BDC_CX_QXPZ.dwdm
IS '单位代码';
COMMENT ON COLUMN BDC_CX_QXPZ.roleid
IS '角色id';
COMMENT ON COLUMN BDC_CX_QXPZ.cxzydm
IS '查询资源代码';
COMMENT ON COLUMN BDC_CX_QXPZ.cxzymc
IS '查询资源名称';
COMMENT ON COLUMN BDC_CX_QXPZ.pzmb
IS '配置模板';

--changeset wenyuanwu:775 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xt_opinion
  ADD (DWDM VARCHAR2(100));
COMMENT ON COLUMN bdc_xt_opinion.DWDM IS '单位代码';
--changeset wenyuanwu:776 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_ZDQMPZ
(
  id    VARCHAR2(32) NOT NULL,
  gzlid VARCHAR2(200),
  gzlmc VARCHAR2(1000),
  jdmc  VARCHAR2(100),
  jdid  VARCHAR2(100),
  yhid  VARCHAR2(100),
  yhmc  VARCHAR2(100),
  qmbs  VARCHAR2(100),
  qmfs  VARCHAR2(100),
  dwdm  VARCHAR2(100)
);
COMMENT ON TABLE BDC_XT_ZDQMPZ
IS '不动产自动签名配置表';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.id
IS '主键';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.gzlid
IS '工作流ID';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.gzlmc
IS '工作流名称';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.jdmc
IS '节点名称';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.jdid
IS '节点ID';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.yhid
IS '用户ID';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.yhmc
IS '用户名称';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.qmbs
IS '签名标示';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.qmfs
IS '签名方式';
COMMENT ON COLUMN BDC_XT_ZDQMPZ.dwdm
IS '单位代码';
--changeset wenyuanwu:777 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (YZWYWH VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.YZWYWH IS '一张网业务号';
--changeset wenyuanwu:778 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_sfxm
  ADD (FFFS VARCHAR2(10));
COMMENT ON COLUMN bdc_sfxm.FFFS IS '付费方式';
--changeset wenyuanwu:779 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_sfxm
  ADD (FFZD VARCHAR2(10));
COMMENT ON COLUMN bdc_sfxm.FFZD IS '付费终端';
--changeset wenyuanwu:780 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_FFFS
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_FFFS
IS '付费方式字典表';
--changeset wenyuanwu:781 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_FFZD
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_FFZD
IS '付费终端字典表';

--changeset wenyuanwu:782 failOnError:false runOnChange:true runAlways:true
CREATE TABLE QUERY_XT_LOG
(
  logid        VARCHAR2(32) NOT NULL,
  username     VARCHAR2(50),
  userid       VARCHAR2(50),
  czrq         DATE,
  controller   VARCHAR2(500),
  ip           VARCHAR2(50),
  reason       VARCHAR2(200),
  computername VARCHAR2(100),
  mac          VARCHAR2(100),
  parmjson_bak VARCHAR2(4000),
  parmjson     CLOB,
  wiid         VARCHAR2(100)
);
COMMENT ON TABLE QUERY_XT_LOG
IS '用户操作系统日志';
COMMENT ON COLUMN QUERY_XT_LOG.logid
IS '主键';
COMMENT ON COLUMN QUERY_XT_LOG.username
IS '用户名称';
COMMENT ON COLUMN QUERY_XT_LOG.userid
IS '用户ID';
COMMENT ON COLUMN QUERY_XT_LOG.czrq
IS '操作日期';
COMMENT ON COLUMN QUERY_XT_LOG.controller
IS '操作调用方法（方法字典表）';
COMMENT ON COLUMN QUERY_XT_LOG.ip
IS 'IP地址';
COMMENT ON COLUMN QUERY_XT_LOG.computername
IS '计算机名称';
COMMENT ON COLUMN QUERY_XT_LOG.mac
IS 'mac地址';
--changeset wenyuanwu:783 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (QMFS VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.QMFS IS '签名方式';
--changeset wenyuanwu:784 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (YCSLYWH VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.YCSLYWH IS '一窗受理业务号';
--changeset wenyuanwu:785 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (SPXTBLZT VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.SPXTBLZT IS '审批系统办理状态';
--changeset wenyuanwu:786 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SJGL_XM
(
  proid  VARCHAR2(32) NOT NULL,
  bh     VARCHAR2(100),
  cjsj   DATE,
  cjr    VARCHAR2(20),
  sqlx   VARCHAR2(10),
  djlx   VARCHAR2(10),
  djyy   VARCHAR2(100),
  lsh    VARCHAR2(100),
  nf     VARCHAR2(4),
  zl     VARCHAR2(200),
  qlr    VARCHAR2(100),
  ywr    VARCHAR2(100),
  cqzh   VARCHAR2(100),
  bdcdyh VARCHAR2(28),
  bjsj   DATE,
  xmly   VARCHAR2(1),
  wiid   VARCHAR2(32),
  yproid VARCHAR2(32),
  yqlid  VARCHAR2(32),
  bz     VARCHAR2(2000)
);
COMMENT ON COLUMN BDC_SJGL_XM.proid
IS '项目ID';
COMMENT ON COLUMN BDC_SJGL_XM.bh
IS '编号';
COMMENT ON COLUMN BDC_SJGL_XM.cjsj
IS '项目创建时间';
COMMENT ON COLUMN BDC_SJGL_XM.cjr
IS '项目创建人';
COMMENT ON COLUMN BDC_SJGL_XM.sqlx
IS '申请类型';
COMMENT ON COLUMN BDC_SJGL_XM.djlx
IS '登记类型';
COMMENT ON COLUMN BDC_SJGL_XM.djyy
IS '登记原因';
COMMENT ON COLUMN BDC_SJGL_XM.lsh
IS '流水号';
COMMENT ON COLUMN BDC_SJGL_XM.nf
IS '年份';
COMMENT ON COLUMN BDC_SJGL_XM.zl
IS '坐落';
COMMENT ON COLUMN BDC_SJGL_XM.qlr
IS '权利人';
COMMENT ON COLUMN BDC_SJGL_XM.ywr
IS '义务人';
COMMENT ON COLUMN BDC_SJGL_XM.cqzh
IS '产权证号';
COMMENT ON COLUMN BDC_SJGL_XM.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_SJGL_XM.bjsj
IS '办结时间';
COMMENT ON COLUMN BDC_SJGL_XM.xmly
IS '项目来源';
COMMENT ON COLUMN BDC_SJGL_XM.wiid
IS '工作流项目ID';
COMMENT ON COLUMN BDC_SJGL_XM.yproid
IS '原项目ID';
COMMENT ON COLUMN BDC_SJGL_XM.yqlid
IS '原权利ID';
COMMENT ON COLUMN BDC_SJGL_XM.bz
IS '备注';
--changeset wenyuanwu:787 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJGL_XM
  ADD CONSTRAINT PK_BDC_SJGL_XM PRIMARY KEY (PROID);
--changeset wenyuanwu:788 failOnError:false runOnChange:true runAlways:true

ALTER TABLE bdc_xm
  ADD (WWSLBH VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.WWSLBH IS '外网受理编号';
--changeset wenyuanwu:789 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (WWYYH VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.WWYYH IS '外网预约号';

--changeset wenyuanwu:880 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_ZDQMPZ
  ADD (MRYJ VARCHAR2(1000));
COMMENT ON COLUMN BDC_XT_ZDQMPZ.MRYJ IS '默认意见';

--changeset wenyuanwu:881 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZXDYYWH VARCHAR2(100);
COMMENT ON COLUMN GD_DY.ZXDYYWH IS '注销抵押业务号';
--changeset wenyuanwu:882 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZXDYYY VARCHAR2(1000);
COMMENT ON COLUMN GD_DY.ZXDYYY IS '注销抵押原因';
--changeset wenyuanwu:883 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZXDBR VARCHAR2(100);
COMMENT ON COLUMN GD_DY.ZXDBR IS '注销抵押登簿人';
--changeset wenyuanwu:884 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZXDBSJ DATE;
COMMENT ON COLUMN GD_DY.ZXDBSJ IS '注销抵押登簿时间';
--changeset wenyuanwu:885 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZXYYYWH VARCHAR2(100);
COMMENT ON COLUMN GD_YY.ZXYYYWH IS '注销异议业务号';
--changeset wenyuanwu:886 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZXYYYY VARCHAR2(1000);
COMMENT ON COLUMN GD_YY.ZXYYYY IS '注销异议原因';
--changeset wenyuanwu:887 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZXYYDBR VARCHAR2(100);
COMMENT ON COLUMN GD_YY.ZXYYDBR IS '注销异议登簿人';
--changeset wenyuanwu:888 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZXYYDJSJ DATE;
COMMENT ON COLUMN GD_YY.ZXYYDJSJ IS '注销异议登簿时间';

--changeset wenyuanwu:889 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD DYCS NUMBER(10) DEFAULT 0;
COMMENT ON COLUMN BDC_ZS.DYCS IS '打印次数';

--changeset wenyuanwu:900 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD JFYY VARCHAR2(100) DEFAULT 0;
COMMENT ON COLUMN GD_CF.JFYY IS '解封原因';
--changeset wenyuanwu:901 failOnError:false runOnChange:true runAlways:true

ALTER TABLE bdc_spxx
  ADD zdzhmj2 NUMBER(20, 4);
COMMENT ON COLUMN bdc_spxx.zdzhmj2 IS '宗地宗海面积2';
--changeset wenyuanwu:902 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_spxx
  ADD zdzhmj3 NUMBER(20, 4);
COMMENT ON COLUMN bdc_spxx.zdzhmj3 IS '宗地宗海面积3';
--changeset wenyuanwu:903 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (CFSX NUMBER(2));
COMMENT ON COLUMN BDC_CF.CFSX IS '查封顺序';
--changeset wenyuanwu:904 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SFXM
  ADD (FWYT VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_SFXM.FWYT IS '房屋用途';
--changeset wenyuanwu:905 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (DWDM VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_SJCL.DWDM IS '单位代码';
--changeset wenyuanwu:906 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (SFZJF VARCHAR2(2));
COMMENT ON COLUMN BDC_FDCQ.SFZJF IS '是否自建房';
--changeset wenyuanwu:907 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (DYSX NUMBER(2));
COMMENT ON COLUMN GD_DY.DYSX IS '抵押顺序';

--changeset wenyuanwu:908 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_cf
  ADD (XFJSSJ DATE);
COMMENT ON COLUMN GD_cf.XFJSSJ IS '续封结束时间';
--changeset wenyuanwu:909 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_cf
  ADD (XFJSSJ DATE);
COMMENT ON COLUMN BDC_cf.XFJSSJ IS '续封结束时间';
--changeset wenyuanwu:910 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (ZZDMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_FDCQ.ZZDMJ IS '幢占地面积';
--changeset wenyuanwu:911 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFZXX
  ADD (ZZDMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_FWFZXX.ZZDMJ IS '幢占地面积';
--changeset wenyuanwu:912 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD (YJFS NUMBER(10));
COMMENT ON COLUMN BDC_SJCL.YJFS IS '原件份数';
--changeset wenyuanwu:913 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD (FYJFS NUMBER(10));
COMMENT ON COLUMN BDC_SJCL.FYJFS IS '复印件份数';
--changeset wenyuanwu:914 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD (GXFS NUMBER(10));
COMMENT ON COLUMN BDC_SJCL.GXFS IS '共享份数';
--changeset wenyuanwu:915 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJCL
  ADD (SFYS VARCHAR2(2));
COMMENT ON COLUMN BDC_SJCL.SFYS IS '是否验收';

--changeset wenyuanwu:916 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (YJFS NUMBER(10));
COMMENT ON COLUMN BDC_XT_SJCL.YJFS IS '原件份数';
--changeset wenyuanwu:917 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (FYJFS NUMBER(10));
COMMENT ON COLUMN BDC_XT_SJCL.FYJFS IS '复印件份数';
--changeset wenyuanwu:918 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (GXFS NUMBER(10));
COMMENT ON COLUMN BDC_XT_SJCL.GXFS IS '共享份数';
--changeset wenyuanwu:919 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_SJCL
  ADD (SFYS VARCHAR2(2));
COMMENT ON COLUMN BDC_XT_SJCL.SFYS IS '是否验收';
--changeset wenyuanwu:920 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (QCTBSLBH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.QCTBSLBH IS '全城通办受理编号';
--changeset wenyuanwu:921 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_ZD_DJJG
  ADD (DEPTNO_EMS VARCHAR2(100));
COMMENT ON COLUMN BDC_ZD_DJJG.DEPTNO_EMS IS '部门办理编码';
--changeset wenyuanwu:922 failOnError:false runOnChange:true runAlways:true
CREATE TABLE PF_WORKFLOWEVENT
(
  id                     NVARCHAR2(32) NOT NULL,
  workflow_definition_id NVARCHAR2(32),
  workflow_name          NVARCHAR2(256),
  activity_definition_id NVARCHAR2(32),
  workflow_event_name    NVARCHAR2(102),
  workflow_event_url     NVARCHAR2(102),
  workflow_event_asyn    NVARCHAR2(10)
);
COMMENT ON TABLE PF_WORKFLOWEVENT
IS '工作流事件配置表';
COMMENT ON COLUMN PF_WORKFLOWEVENT.workflow_definition_id
IS '流程ID';
COMMENT ON COLUMN PF_WORKFLOWEVENT.workflow_name
IS '流程名称';
COMMENT ON COLUMN PF_WORKFLOWEVENT.activity_definition_id
IS '流程节点ID';
COMMENT ON COLUMN PF_WORKFLOWEVENT.workflow_event_name
IS '事件名';
COMMENT ON COLUMN PF_WORKFLOWEVENT.workflow_event_url
IS '事件方法';
COMMENT ON COLUMN PF_WORKFLOWEVENT.workflow_event_asyn
IS '是否异步(0：同步，1：异步)';
--changeset wenyuanwu:923 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_YG.ZXYWH IS '注销业务号';
--changeset wenyuanwu:924 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN GD_YG.ZXYWH IS '注销业务号';
--changeset wenyuanwu:925 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (BASJ DATE);
COMMENT ON COLUMN BDC_FDCQ.BASJ IS '备案时间';
--changeset wenyuanwu:926 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (TKNX NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ.TKNX IS '调控年限';
--changeset wenyuanwu:927 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xxcxjl
  RENAME COLUMN cxrmc TO cxrmc_temp;
ALTER TABLE bdc_xxcxjl
  ADD cxrmc CLOB;
UPDATE bdc_xxcxjl
SET cxrmc = trim(cxrmc_temp);
ALTER TABLE bdc_xxcxjl
  DROP COLUMN cxrmc_temp;

--changeset wenyuanwu:928 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JYXX
(
  jyxxid VARCHAR2(32) NOT NULL,
  jybh   VARCHAR2(100),
  htbh   VARCHAR2(100),
  ywlx   VARCHAR2(100),
  kssj   DATE,
  jssj   DATE,
  xzqdm  VARCHAR2(20),
  ywzt   VARCHAR2(10),
  bz     VARCHAR2(100),
  drr    VARCHAR2(100),
  drsj   DATE,
  proid  VARCHAR2(32)
);
COMMENT ON TABLE BDC_JYXX
IS '不动产交易信息';
COMMENT ON COLUMN BDC_JYXX.jyxxid
IS '交易信息ID';
COMMENT ON COLUMN BDC_JYXX.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_JYXX.htbh
IS '合同编号';
COMMENT ON COLUMN BDC_JYXX.ywlx
IS '业务类型';
COMMENT ON COLUMN BDC_JYXX.kssj
IS '开始时间';
COMMENT ON COLUMN BDC_JYXX.jssj
IS '结束时间';
COMMENT ON COLUMN BDC_JYXX.xzqdm
IS '行政区代码';
COMMENT ON COLUMN BDC_JYXX.ywzt
IS '业务状态';
COMMENT ON COLUMN BDC_JYXX.bz
IS '备注';
COMMENT ON COLUMN BDC_JYXX.drr
IS '导入人';
COMMENT ON COLUMN BDC_JYXX.drsj
IS '导入时间';
COMMENT ON COLUMN BDC_JYXX.proid
IS '项目id';
--changeset wenyuanwu:929 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYXX
  ADD CONSTRAINT PK_JYXXID PRIMARY KEY (JYXXID);

--changeset wenyuanwu:930 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JYSQR
(
  jysqrid VARCHAR2(32) NOT NULL,
  jybh    VARCHAR2(32),
  qlrmc   VARCHAR2(100),
  zjzl    VARCHAR2(100),
  zjh     VARCHAR2(100),
  qlrlb   VARCHAR2(10),
  drr     VARCHAR2(100),
  drsj    DATE
);
COMMENT ON TABLE BDC_JYSQR
IS '不动产交易申请人信息';
COMMENT ON COLUMN BDC_JYSQR.jysqrid
IS '交易申请人ID';
COMMENT ON COLUMN BDC_JYSQR.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_JYSQR.qlrmc
IS '权利人名称';
COMMENT ON COLUMN BDC_JYSQR.zjzl
IS '证件种类';
COMMENT ON COLUMN BDC_JYSQR.zjh
IS '证件号';
COMMENT ON COLUMN BDC_JYSQR.qlrlb
IS '权利人类别   1：买方2：卖方
放代码
';
COMMENT ON COLUMN BDC_JYSQR.drr
IS '导入人  ';
COMMENT ON COLUMN BDC_JYSQR.drsj
IS '导入时间';
--changeset wenyuanwu:931 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYSQR
  ADD CONSTRAINT PK_JYSQRID PRIMARY KEY (JYSQRID);

--changeset wenyuanwu:932 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JYHT
(
  jyhtid VARCHAR2(32) NOT NULL,
  jybh   VARCHAR2(100),
  htbh   VARCHAR2(100),
  htfwm  VARCHAR2(100),
  basj   DATE,
  htzt   VARCHAR2(100),
  htje   NUMBER(10),
  zl     VARCHAR2(100),
  jzmj   NUMBER(10),
  htlx   VARCHAR2(10),
  zjjg   VARCHAR2(100),
  zjjgdm VARCHAR2(100),
  bz     VARCHAR2(100),
  drr    VARCHAR2(100),
  drsj   DATE
);
COMMENT ON TABLE BDC_JYHT
IS '不动产交易合同信息';
COMMENT ON COLUMN BDC_JYHT.jyhtid
IS '交易合同id';
COMMENT ON COLUMN BDC_JYHT.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_JYHT.htbh
IS '合同编号';
COMMENT ON COLUMN BDC_JYHT.htfwm
IS '合同防伪码';
COMMENT ON COLUMN BDC_JYHT.basj
IS '备案时间';
COMMENT ON COLUMN BDC_JYHT.htzt
IS '合同状态';
COMMENT ON COLUMN BDC_JYHT.htje
IS '合同金额  单位：元';
COMMENT ON COLUMN BDC_JYHT.zl
IS '坐落';
COMMENT ON COLUMN BDC_JYHT.jzmj
IS '建筑面积  单位：平方米';
COMMENT ON COLUMN BDC_JYHT.htlx
IS '合同类型   1表示商品房（预售）买卖合同2表示商品房（现售）买卖合同3存量房合同';
COMMENT ON COLUMN BDC_JYHT.zjjg
IS '中介机构';
COMMENT ON COLUMN BDC_JYHT.zjjgdm
IS '中介机构社会征信代码';
COMMENT ON COLUMN BDC_JYHT.bz
IS '备注';
COMMENT ON COLUMN BDC_JYHT.drr
IS '导入人';
COMMENT ON COLUMN BDC_JYHT.drsj
IS '导入时间';
--changeset wenyuanwu:933 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYHT
  ADD CONSTRAINT PK_JYHTID PRIMARY KEY (JYHTID);

--changeset wenyuanwu:934 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_JYXX
(
  lsjyxxid VARCHAR2(32) NOT NULL,
  jyxxid   VARCHAR2(32),
  jybh     VARCHAR2(100),
  htbh     VARCHAR2(100),
  ywlx     VARCHAR2(100),
  kssj     DATE,
  jssj     DATE,
  xzqdm    VARCHAR2(20),
  ywzt     VARCHAR2(10),
  bz       VARCHAR2(100),
  drr      VARCHAR2(100),
  drsj     DATE,
  proid    VARCHAR2(32)
);
COMMENT ON TABLE BDC_LS_JYXX
IS '不动产交易历史信息';
COMMENT ON COLUMN BDC_LS_JYXX.lsjyxxid
IS '历史交易信息ID';
COMMENT ON COLUMN BDC_LS_JYXX.jyxxid
IS '交易信息ID';
COMMENT ON COLUMN BDC_LS_JYXX.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_LS_JYXX.htbh
IS '合同编号';
COMMENT ON COLUMN BDC_LS_JYXX.ywlx
IS '业务类型';
COMMENT ON COLUMN BDC_LS_JYXX.kssj
IS '开始时间';
COMMENT ON COLUMN BDC_LS_JYXX.jssj
IS '结束时间';
COMMENT ON COLUMN BDC_LS_JYXX.xzqdm
IS '行政区代码';
COMMENT ON COLUMN BDC_LS_JYXX.ywzt
IS '业务状态';
COMMENT ON COLUMN BDC_LS_JYXX.bz
IS '备注';
COMMENT ON COLUMN BDC_LS_JYXX.drr
IS '导入人';
COMMENT ON COLUMN BDC_LS_JYXX.drsj
IS '导入时间';
COMMENT ON COLUMN BDC_LS_JYXX.proid
IS '项目id';
--changeset wenyuanwu:936 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_JYXX
  ADD CONSTRAINT PK_C_LSJYXXID PRIMARY KEY (LSJYXXID);
--changeset wenyuanwu:935 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_LS_JYSQR
(
  lsjysqrid VARCHAR2(32) NOT NULL,
  jyxxid    VARCHAR2(32),
  jybh      VARCHAR2(100),
  qlrmc     VARCHAR2(100),
  zjzl      VARCHAR2(100),
  zjh       VARCHAR2(100),
  qlrlb     VARCHAR2(10),
  drr       VARCHAR2(100),
  drsj      DATE
);
COMMENT ON TABLE BDC_LS_JYSQR
IS '不动产交易申请人历史信息';
COMMENT ON COLUMN BDC_LS_JYSQR.lsjysqrid
IS '历史交易申请人ID';
COMMENT ON COLUMN BDC_LS_JYSQR.jyxxid
IS '交易申请人ID';
COMMENT ON COLUMN BDC_LS_JYSQR.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_LS_JYSQR.qlrmc
IS '权利人名称';
COMMENT ON COLUMN BDC_LS_JYSQR.zjzl
IS '证件种类';
COMMENT ON COLUMN BDC_LS_JYSQR.zjh
IS '证件号';
COMMENT ON COLUMN BDC_LS_JYSQR.qlrlb
IS '权利人类别 1：买方2：卖方';
COMMENT ON COLUMN BDC_LS_JYSQR.drr
IS '导入人';
COMMENT ON COLUMN BDC_LS_JYSQR.drsj
IS '导入时间';
--changeset wenyuanwu:937 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_JYSQR
  ADD CONSTRAINT PK_C_LSJYSQRID PRIMARY KEY (LSJYSQRID);

--changeset wenyuanwu:938 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_LS_JYHT
(
  lsjyhtid VARCHAR2(32) NOT NULL,
  jyhtid   VARCHAR2(32),
  jybh     VARCHAR2(100),
  htbh     VARCHAR2(100),
  htfwm    VARCHAR2(100),
  basj     DATE,
  htzt     VARCHAR2(100),
  htje     NUMBER(10),
  zl       VARCHAR2(100),
  jzmj     NUMBER(10),
  htlx     VARCHAR2(10),
  zjjg     VARCHAR2(100),
  zjjgdm   VARCHAR2(100),
  bz       VARCHAR2(100),
  drr      VARCHAR2(100),
  drsj     DATE
);
COMMENT ON TABLE BDC_LS_JYHT
IS '不动产交易合同历史信息';
COMMENT ON COLUMN BDC_LS_JYHT.lsjyhtid
IS '历史交易合同id';
COMMENT ON COLUMN BDC_LS_JYHT.jyhtid
IS '交易合同id';
COMMENT ON COLUMN BDC_LS_JYHT.jybh
IS '交易编号';
COMMENT ON COLUMN BDC_LS_JYHT.htbh
IS '合同编号';
COMMENT ON COLUMN BDC_LS_JYHT.htfwm
IS '合同防伪码';
COMMENT ON COLUMN BDC_LS_JYHT.basj
IS '备案时间';
COMMENT ON COLUMN BDC_LS_JYHT.htzt
IS '合同状态';
COMMENT ON COLUMN BDC_LS_JYHT.htje
IS '合同金额';
COMMENT ON COLUMN BDC_LS_JYHT.zl
IS '坐落';
COMMENT ON COLUMN BDC_LS_JYHT.jzmj
IS '建筑面积';
COMMENT ON COLUMN BDC_LS_JYHT.htlx
IS '合同类型';
COMMENT ON COLUMN BDC_LS_JYHT.zjjg
IS '中介机构';
COMMENT ON COLUMN BDC_LS_JYHT.zjjgdm
IS '中介机构社会征信代码';
COMMENT ON COLUMN BDC_LS_JYHT.bz
IS '备注';
COMMENT ON COLUMN BDC_LS_JYHT.drr
IS '导入人';
COMMENT ON COLUMN BDC_LS_JYHT.drsj
IS '导入时间';
--changeset wenyuanwu:939 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LS_JYHT
  ADD CONSTRAINT PK_C_LSJYHTID PRIMARY KEY (LSJYHTID);
--changeset wenyuanwu:940 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XXCXJL
  ADD ycxjlid VARCHAR2(32);
COMMENT ON COLUMN BDC_XXCXJL.ycxjlid
IS '原查询记录id（记录打印操作对应的查询记录）';
--changeset wenyuanwu:941 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD SDNX NUMBER(10);
COMMENT ON COLUMN BDC_BDCZSSD.SDNX
IS '锁定年限';
--changeset wenyuanwu:942 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD SCMJ NUMBER(20, 4);
COMMENT ON COLUMN GD_FW.SCMJ
IS '实测面积';
--changeset wenyuanwu:943 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD SCMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_FDCQ.SCMJ
IS '实测面积';
--changeset wenyuanwu:944 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD SCMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_SPXX.SCMJ
IS '实测面积';
--changeset wenyuanwu:945 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD FWSX VARCHAR2(50);
COMMENT ON COLUMN GD_FWSYQ.FWSX
IS '房屋属性';
--changeset wenyuanwu:946 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD FWSX VARCHAR2(2);
COMMENT ON COLUMN BDC_FDCQ.FWSX
IS '房屋属性';

--changeset wenyuanwu:947 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDSYQ_LHXX
  ADD LHZT VARCHAR2(2);
COMMENT ON COLUMN BDC_JSYDSYQ_LHXX.LHZT IS '量化状态';
--changeset wenyuanwu:948 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD ZDPZMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_SPXX.ZDPZMJ IS '宗地批准面积';
--changeset wenyuanwu:949 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD FWPZJZMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_SPXX.FWPZJZMJ IS '房屋批准建筑面积';
--changeset wenyuanwu:950 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD SFSCYBZS VARCHAR2(2);
COMMENT ON COLUMN BDC_XM.SFSCYBZS IS '是否生成一本证书';
--changeset wenyuanwu:951 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD JJDBH VARCHAR2(32);
COMMENT ON COLUMN BDC_XM.JJDBH IS '交接单编号';
--changeset wenyuanwu:952 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_CF
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_CF.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:953 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_DY.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:954 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_FWSYQ.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:955 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_TDSYQ.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:956 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_YY.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:957 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_YG.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:958 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_CQ.ZXDAYWH IS '注销档案业务号';
--changeset wenyuanwu:959 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD ZXDAYWH VARCHAR2(32);
COMMENT ON COLUMN GD_LQ.ZXDAYWH IS '注销档案业务号';

--changeset wenyuanwu:960 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_XM.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:961 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_XM.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:962 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_ZS.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:963 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_ZS.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:964 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_ZS.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:965 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_ZS.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:966 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_FDCQ.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:967 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1205 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.YWR
IS '义务人';
--changeset wenyuanwu:968 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_FDCQ.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:969 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:970 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_FDCQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:971 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:972 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_FDCQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:973 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ.ZL
IS '坐落';
--changeset wenyuanwu:974 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FDCQ_DZ
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_FDCQ_DZ.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:975 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:976 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.YWR
IS '义务人';
--changeset wenyuanwu:977 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_FDCQ_DZ.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:978 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:979 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_FDCQ_DZ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:980 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:981 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN BDC_FDCQ_DZ.ZL
IS '坐落';

--changeset wenyuanwu:982 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFZXX
  ADD BDCDYBH VARCHAR2(4000);
COMMENT ON COLUMN BDC_FWFZXX.BDCDYBH
IS '不动产单元编号';

--changeset wenyuanwu:983 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYR VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYAQ.DYR
IS '抵押人';
--changeset wenyuanwu:984 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_DYAQ.DYRZJZL
IS '抵押人证件种类';
--changeset wenyuanwu:985 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYAQ.DYRZJH
IS '抵押人证件号';
--changeset wenyuanwu:986 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYQR VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYAQ.DYQR
IS '抵押权人';
--changeset wenyuanwu:987 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYQRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_DYAQ.DYQRZJZL
IS '抵押权人证件种类';
--changeset wenyuanwu:988 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD DYQRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYAQ.DYQRZJH
IS '抵押权人证件号';
--changeset wenyuanwu:989 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYAQ.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:990 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD BDCQZMH VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYAQ.BDCQZMH
IS '不动产权证明号';
--changeset wenyuanwu:991 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_DYAQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:992 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD BDCDYBH VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYAQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:993 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD ZL VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYAQ.ZL
IS '坐落';
--changeset wenyuanwu:994 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD GYDBDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_DYQ.GYDBDCDYH
IS '供役地不动产单元号';
--changeset wenyuanwu:995 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD GYDBDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_DYQ.GYDBDCDYBH
IS '供役地不动产单元编号';
--changeset wenyuanwu:996 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD GYDQLR VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.GYDQLR
IS '供役地权利人';
--changeset wenyuanwu:997 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD GYDQLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_DYQ.GYDQLRZJZL
IS '供役地权利人证件种类';
--changeset wenyuanwu:998 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD GYDQLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.GYDQLRZJH
IS '供役地权利人证件号';
--changeset wenyuanwu:999 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD XYDQLR VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.XYDQLR
IS '需役地权利人';
--changeset wenyuanwu:1000 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD XYDQLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_DYQ.XYDQLRZJZL
IS '需役地权利人证件种类';
--changeset wenyuanwu:1001 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD XYDQLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.XYDQLRZJH
IS '需役地权利人证件号';
--changeset wenyuanwu:1002 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD XYDBDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_DYQ.XYDBDCDYBH
IS '需役地不动产单元编号';
--changeset wenyuanwu:1003 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_DYQ.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:1004 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD BDCQZMH VARCHAR2(100);
COMMENT ON COLUMN BDC_DYQ.BDCQZMH
IS '不动产权证明号';
--changeset wenyuanwu:1005 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD QLR VARCHAR2(4000);
COMMENT ON COLUMN BDC_YG.QLR
IS '权利人';
--changeset wenyuanwu:1006 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_YG.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1007 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_YG.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1008 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN BDC_YG.YWR
IS '义务人';
--changeset wenyuanwu:1009 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_YG.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:1010 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_YG.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1011 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_YG.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1012 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_YG.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:1013 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD BDCQZMH VARCHAR2(100);
COMMENT ON COLUMN BDC_YG.BDCQZMH
IS '不动产权证明号';

--changeset wenyuanwu:1014 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_YG.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1015 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_YG.ZL
IS '坐落';
--changeset wenyuanwu:1016 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN BDC_YY.YWR
IS '异议人';
--changeset wenyuanwu:1017 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_YY.YWRZJZL
IS '异议人证件种类';
--changeset wenyuanwu:1018 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_YY.YWRZJH
IS '异议人证件号';
--changeset wenyuanwu:1019 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_YY.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1020 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_YY.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:1021 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD BDCQZMH VARCHAR2(100);
COMMENT ON COLUMN BDC_YY.BDCQZMH
IS '不动产权证明号';
--changeset wenyuanwu:1022 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_YY.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1023 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_YY.ZL
IS '坐落';
--changeset wenyuanwu:1024 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_CF.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1025 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_CF.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1026 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN BDC_CF.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:1027 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN BDC_CF.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1028 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_CF.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1029 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD BDCQZH VARCHAR2(4000);
COMMENT ON COLUMN BDC_CF.BDCQZH
IS '不动产权证号';
--changeset wenyuanwu:1030 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_CF.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1031 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN BDC_CF.ZL
IS '坐落';
--changeset wenyuanwu:1032 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1033 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1034 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1035 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_TDSYQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1036 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_TDSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1037 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_TDSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1038 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_TDSYQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1039 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_TDSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1040 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_TDSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1041 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_HYSYQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1042 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_HYSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1043 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_HYSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1044 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1045 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1046 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1047 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_QTXGQL.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1049 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_QTXGQL.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1048 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_QTXGQL.ZL
IS '坐落';
--changeset wenyuanwu:1050 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD BDCDYH VARCHAR2(28);
COMMENT ON COLUMN BDC_LQ.BDCDYH
IS '不动产单元号';
--changeset wenyuanwu:1051 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN BDC_LQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1052 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD ZL VARCHAR2(100);
COMMENT ON COLUMN BDC_LQ.ZL
IS '坐落';
--changeset wenyuanwu:1053 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QZYSXLH VARCHAR2(100);
COMMENT ON COLUMN BDC_QLR.QZYSXLH
IS '权证印刷序列号';
--changeset wenyuanwu:1054 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD BDCQZH VARCHAR2(100);
COMMENT ON COLUMN BDC_QLR.BDCQZH
IS '不动产权证号';

--changeset wenyuanwu:1055 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD QLR VARCHAR2(4000);
COMMENT ON COLUMN GD_FWSYQ.QLR
IS '权利人';
--changeset wenyuanwu:1056 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_FWSYQ.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1057 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_FWSYQ.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1058 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1059 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_FWSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1060 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_TDSYQ
  ADD QLR VARCHAR2(4000);
COMMENT ON COLUMN GD_TDSYQ.QLR
IS '权利人';
--changeset wenyuanwu:1061 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_TDSYQ.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1062 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_TDSYQ.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1063 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_TDSYQ.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1064 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_TDSYQ.ZL
IS '坐落';
--changeset wenyuanwu:1065 failOnError:false runOnChange:true runAlways:true

ALTER TABLE GD_FW_QL
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_FW_QL.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1066 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_FW_QL.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1067 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_TD_QL.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1068 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_TD_QL.BDCDYBH
IS '不动产单元编号';

--changeset wenyuanwu:1069 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD QLR VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.QLR
IS '权利人';
--changeset wenyuanwu:1070 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_YG.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1071 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1072 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.YWR
IS '义务人';
--changeset wenyuanwu:1073 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_YG.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:1074 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1075 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD YCQZH VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.YCQZH
IS '产权证号';
--changeset wenyuanwu:1076 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_YG.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1077 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YG
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_YG.ZL
IS '坐落';
--changeset wenyuanwu:1078 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD YWR VARCHAR2(4000);
COMMENT ON COLUMN GD_YY.YWR
IS '异议人';
--changeset wenyuanwu:1079 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_YY.YWRZJZL
IS '异议人证件种类';
--changeset wenyuanwu:1080 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_YY.YWRZJH
IS '异议人证件号';
--changeset wenyuanwu:1081 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_YY.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1082 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD YCQZH VARCHAR2(4000);
COMMENT ON COLUMN GD_YY.YCQZH
IS '产权证号';
--changeset wenyuanwu:1083 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_YY
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_YY.ZL
IS '坐落';
--changeset wenyuanwu:1084 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYR VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.DYR
IS '抵押人';
--changeset wenyuanwu:1085 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_DY.DYRZJZL
IS '抵押人证件种类';
--changeset wenyuanwu:1086 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.DYRZJH
IS '抵押人证件号';
--changeset wenyuanwu:1087 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYQR VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.DYQR
IS '抵押权人';
--changeset wenyuanwu:1088 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYQRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_DY.DYQRZJZL
IS '抵押权人证件种类';
--changeset wenyuanwu:1089 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYQRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.DYQRZJH
IS '抵押权人证件号';
--changeset wenyuanwu:1090 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD YCQZH VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.YCQZH
IS '产权证号';
--changeset wenyuanwu:1091 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_DY.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1092 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_DY.ZL
IS '坐落';
--changeset wenyuanwu:1093 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD QLRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_CF.QLRZJZL
IS '权利人证件种类';
--changeset wenyuanwu:1094 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD QLRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_CF.QLRZJH
IS '权利人证件号';
--changeset wenyuanwu:1095 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD YWRZJZL VARCHAR2(20);
COMMENT ON COLUMN GD_CF.YWRZJZL
IS '义务人证件种类';
--changeset wenyuanwu:1096 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD YWRZJH VARCHAR2(4000);
COMMENT ON COLUMN GD_CF.YWRZJH
IS '义务人证件号';
--changeset wenyuanwu:1097 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD YCQZH VARCHAR2(4000);
COMMENT ON COLUMN GD_CF.YCQZH
IS '产权证号';
--changeset wenyuanwu:1098 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD BDCDYBH VARCHAR2(100);
COMMENT ON COLUMN GD_CF.BDCDYBH
IS '不动产单元编号';
--changeset wenyuanwu:1099 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CF
  ADD ZL VARCHAR2(4000);
COMMENT ON COLUMN GD_CF.ZL
IS '坐落';
--changeset wenyuanwu:1100 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD CQZH VARCHAR2(100);
COMMENT ON COLUMN GD_QLR.CQZH
IS '产权证号';
--changeset wenyuanwu:1101 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD QZYSXLH VARCHAR2(100);
COMMENT ON COLUMN GD_QLR.QZYSXLH
IS '权证印刷序列号';

--changeset wenyuanwu:1102 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD SFHCDZZZ VARCHAR2(2);
COMMENT ON COLUMN BDC_XM.SFHCDZZZ
IS '是否合成电子证照';

--changeset wenyuanwu:1103 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (TDSYKSQX2 DATE);
COMMENT ON COLUMN BDC_FDCQ_DZ.TDSYKSQX2 IS '土地使用开始期限2';
--changeset wenyuanwu:1104 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (TDSYJSQX2 DATE);
COMMENT ON COLUMN BDC_FDCQ_DZ.TDSYJSQX2 IS '土地使用结束期限2';
--changeset wenyuanwu:1105 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (TDSYKSQX3 DATE);
COMMENT ON COLUMN BDC_FDCQ_DZ.TDSYKSQX3 IS '土地使用开始期限3';
--changeset wenyuanwu:1106 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (TDSYJSQX3 DATE);
COMMENT ON COLUMN BDC_FDCQ_DZ.TDSYJSQX3 IS '土地使用结束期限3';
--changeset wenyuanwu:1107 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SFXX_JG
(
  SFXXID  VARCHAR2(32) NOT NULL,
  FKRQC   VARCHAR2(100),
  FKRZH   VARCHAR2(100),
  FKRKHYH VARCHAR2(100),
  SKRQC   VARCHAR2(100),
  SKRZH   VARCHAR2(100),
  SKRKHYH VARCHAR2(100),
  FPBH    VARCHAR2(100),
  TZRQ    DATE,
  FPH     VARCHAR2(100),
  CPR     VARCHAR2(100),
  ZJE     NUMBER(24, 2),
  FKFS    VARCHAR2(50),
  ZSDWMC  VARCHAR2(100),
  ZSDWDM  VARCHAR2(100),
  FPYH    VARCHAR2(100),
  SBSJ    DATE,
  ZFSJ    DATE,
  ZFYY    VARCHAR2(100),
  FPZT    VARCHAR2(20)
);
COMMENT ON COLUMN BDC_SFXX_JG.SFXXID
IS '收费信息ID';
COMMENT ON COLUMN BDC_SFXX_JG.FKRQC
IS '付款人全称';
COMMENT ON COLUMN BDC_SFXX_JG.FKRZH
IS '付款人账号';
COMMENT ON COLUMN BDC_SFXX_JG.FKRKHYH
IS '付款人开户银行';
COMMENT ON COLUMN BDC_SFXX_JG.SKRQC
IS '收款人全称';
COMMENT ON COLUMN BDC_SFXX_JG.SKRZH
IS '收款人账号';
COMMENT ON COLUMN BDC_SFXX_JG.SKRKHYH
IS '收款人开户银行';
COMMENT ON COLUMN BDC_SFXX_JG.FPBH
IS '发票编号（年份加证书流水号）';
COMMENT ON COLUMN BDC_SFXX_JG.TZRQ
IS '填制日期';
COMMENT ON COLUMN BDC_SFXX_JG.FPH
IS '发票号';
COMMENT ON COLUMN BDC_SFXX_JG.CPR
IS '出票人';
COMMENT ON COLUMN BDC_SFXX_JG.ZJE
IS '总金额';
COMMENT ON COLUMN BDC_SFXX_JG.FKFS
IS '付款方式';
COMMENT ON COLUMN BDC_SFXX_JG.ZSDWMC
IS '执收单位名称';
COMMENT ON COLUMN BDC_SFXX_JG.ZSDWDM
IS '执收单位代码';
COMMENT ON COLUMN BDC_SFXX_JG.FPYH
IS '发票印号';
COMMENT ON COLUMN BDC_SFXX_JG.SBSJ
IS '上报时间';
COMMENT ON COLUMN BDC_SFXX_JG.ZFSJ
IS '作废时间';
COMMENT ON COLUMN BDC_SFXX_JG.ZFYY
IS '作废原因';
COMMENT ON COLUMN BDC_SFXX_JG.FPZT
IS '发票状态';
--changeset wenyuanwu:1108 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX_JG
  ADD CONSTRAINT SFXMMJGPRI PRIMARY KEY (SFXXID)
  USING INDEX;
--changeset wenyuanwu:1109 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SFXM_JG
(
  SFXMID VARCHAR2(32) NOT NULL,
  SFXXID VARCHAR2(32) NOT NULL,
  SFXMBM VARCHAR2(100),
  SFXMMC VARCHAR2(100),
  DW     VARCHAR2(100),
  SL     NUMBER,
  SFBZ   VARCHAR2(50),
  JE     NUMBER(24, 2),
  JSBZ   NUMBER(24, 2),
  DXJE   VARCHAR2(50)
);
COMMENT ON COLUMN BDC_SFXM_JG.SFXMID
IS '收费项目ID';
COMMENT ON COLUMN BDC_SFXM_JG.SFXXID
IS '收费信息ID';
COMMENT ON COLUMN BDC_SFXM_JG.SFXMBM
IS '收费项目编码';
COMMENT ON COLUMN BDC_SFXM_JG.SFXMMC
IS '收费项目名称';
COMMENT ON COLUMN BDC_SFXM_JG.DW
IS '单位';
COMMENT ON COLUMN BDC_SFXM_JG.SL
IS '数量';
COMMENT ON COLUMN BDC_SFXM_JG.SFBZ
IS '收费标准';
COMMENT ON COLUMN BDC_SFXM_JG.JE
IS '金额';
COMMENT ON COLUMN BDC_SFXM_JG.JSBZ
IS '计算标准';
COMMENT ON COLUMN BDC_SFXM_JG.DXJE
IS '大写金额';
--changeset wenyuanwu:1110 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM_JG
  ADD CONSTRAINT SFXMIDPRI PRIMARY KEY (SFXMID)
  USING INDEX;
--changeset wenyuanwu:1111 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XMSF_REL
(
  RELID  VARCHAR2(32) NOT NULL,
  PROID  VARCHAR2(32),
  SFXXID VARCHAR2(32)
);
COMMENT ON COLUMN BDC_XMSF_REL.RELID
IS '项目收费项目关系ID';
COMMENT ON COLUMN BDC_XMSF_REL.PROID
IS '项目ID';
COMMENT ON COLUMN BDC_XMSF_REL.SFXXID
IS '收费项目ID';
--changeset wenyuanwu:1112 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XMSF_REL
  ADD CONSTRAINT XMSFRELPRI PRIMARY KEY (RELID)
  USING INDEX;
--changeset wenyuanwu:1113 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_SPXX
  ADD XYSHSJ DATE;
COMMENT ON COLUMN BDC_SPXX.XYSHSJ
IS '信用审核时间';
--changeset wenyuanwu:1114 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD XYSHR VARCHAR2(100);
COMMENT ON COLUMN BDC_SPXX.XYSHR
IS '信用审核人';
--changeset wenyuanwu:1115 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD XYSHZT VARCHAR2(2);
COMMENT ON COLUMN BDC_SPXX.XYSHZT
IS '信用审核状态1:通过，0:未通过';
--changeset wenyuanwu:1116 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD XYSHYJ VARCHAR2(200);
COMMENT ON COLUMN BDC_SPXX.XYSHYJ
IS '信用审核意见';
--changeset wenyuanwu:1117 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYGL
  ADD SJLY VARCHAR2(100);
COMMENT ON COLUMN BDC_XYGL.SJLY
IS '数据来源';

--changeset wenyuanwu:1118 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD FCZHFWBH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.FCZHFWBH
IS '房产证号房屋编号';
--changeset wenyuanwu:1119 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD DYDJZMHFWBH VARCHAR2(100);
COMMENT ON COLUMN GD_DY.DYDJZMHFWBH
IS '抵押登记证明号房屋编号';
--changeset wenyuanwu:1120 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD ZFFWBH VARCHAR2(100);
COMMENT ON COLUMN GD_FW.ZFFWBH
IS '主房房屋编号';

--changeset wenyuanwu:1121 failOnError:false runOnChange:true runAlways:true

CREATE TABLE BDC_SJLR_SQXX
(
  sqxxid    VARCHAR2(32) NOT NULL,
  proid     VARCHAR2(32) NOT NULL,
  tznr      VARCHAR2(500),
  tzjg      VARCHAR2(500),
  tzyy      VARCHAR2(500),
  qlr       VARCHAR2(50),
  qlrsfzjzl VARCHAR2(2),
  qlrzjh    VARCHAR2(50),
  zl        VARCHAR2(500),
  bdcqzh    VARCHAR2(50),
  bdcdyh    VARCHAR2(28),
  jzmj      NUMBER(20, 4),
  zdmj      NUMBER(20, 4),
  ghyt      VARCHAR2(4),
  zdyt      VARCHAR2(4),
  sqr       VARCHAR2(100),
  sqsj      DATE
);
COMMENT ON TABLE BDC_SJLR_SQXX
IS '数据录入申请信息';
COMMENT ON COLUMN BDC_SJLR_SQXX.sqxxid
IS '数据录入id';
COMMENT ON COLUMN BDC_SJLR_SQXX.proid
IS '项目id';
COMMENT ON COLUMN BDC_SJLR_SQXX.tznr
IS '调整内容';
COMMENT ON COLUMN BDC_SJLR_SQXX.tzjg
IS '调整结果';
COMMENT ON COLUMN BDC_SJLR_SQXX.tzyy
IS '调整原因';
COMMENT ON COLUMN BDC_SJLR_SQXX.qlr
IS '权利人';
COMMENT ON COLUMN BDC_SJLR_SQXX.qlrsfzjzl
IS '权利人身份证件种类';
COMMENT ON COLUMN BDC_SJLR_SQXX.qlrzjh
IS '权利人证件号';
COMMENT ON COLUMN BDC_SJLR_SQXX.zl
IS '坐落';
COMMENT ON COLUMN BDC_SJLR_SQXX.bdcqzh
IS '不动产权证号';
COMMENT ON COLUMN BDC_SJLR_SQXX.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_SJLR_SQXX.jzmj
IS '建筑面积';
COMMENT ON COLUMN BDC_SJLR_SQXX.zdmj
IS '宗地面积';
COMMENT ON COLUMN BDC_SJLR_SQXX.ghyt
IS '规划用途';
COMMENT ON COLUMN BDC_SJLR_SQXX.zdyt
IS '宗地用途';
COMMENT ON COLUMN BDC_SJLR_SQXX.sqr
IS '申请人';
COMMENT ON COLUMN BDC_SJLR_SQXX.sqsj
IS '申请时间';
--changeset wenyuanwu:1122 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_TDSYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1123 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_JSYDZJDSYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1124 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_FDCQ_DZ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1125 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_FDCQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1126 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWGY
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_JZWGY.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1127 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_JZWSYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1128 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_HYSYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_HYSYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1129 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_TDCBNYDSYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1130 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTXGQL
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_QTXGQL.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1131 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_LQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1132 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1133 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_DYAQ.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1134 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_YG.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1135 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD QLQTZK VARCHAR2(1000);
COMMENT ON COLUMN BDC_YY.QLQTZK
IS '权利其他状况';
--changeset wenyuanwu:1136 failOnError:false runOnChange:true runAlways:true
CREATE TABLE A_DATA_XG
(
  wtms  VARCHAR2(1000),
  sqr   VARCHAR2(100),
  sqsj  VARCHAR2(32),
  type  VARCHAR2(32),
  sqid  VARCHAR2(32) NOT NULL,
  proid VARCHAR2(32)
);
COMMENT ON COLUMN A_DATA_XG.wtms
IS '问题描述';
COMMENT ON COLUMN A_DATA_XG.sqr
IS '申请人';
COMMENT ON COLUMN A_DATA_XG.sqsj
IS '申请时间';
COMMENT ON COLUMN A_DATA_XG.type
IS '问题类型';
COMMENT ON COLUMN A_DATA_XG.sqid
IS '申请id';
COMMENT ON COLUMN A_DATA_XG.proid
IS '项目id';
--changeset wenyuanwu:1137 failOnError:false runOnChange:true runAlways:true
ALTER TABLE A_DATA_XG
  ADD CONSTRAINT PK_A_DATA_XG PRIMARY KEY (SQID);

--changeset wenyuanwu:1138 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SPXX
  ADD FZMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_SPXX.FZMJ
IS '发证面积';
--changeset wenyuanwu:1139 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD FZMJ NUMBER(20, 4);
COMMENT ON COLUMN BDC_FDCQ.FZMJ
IS '发证面积';
--changeset wenyuanwu:1140 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DSXX
(
  dsxxid VARCHAR2(32) NOT NULL,
  proid  VARCHAR2(32) NOT NULL,
  sfzjhm VARCHAR2(32) NOT NULL,
  nsrmc  VARCHAR2(32),
  zspmmc VARCHAR2(50),
  sz     VARCHAR2(10),
  cqfwzl VARCHAR2(50),
  ycqrmc VARCHAR2(50),
  jsje   NUMBER(10, 2),
  mj     NUMBER(10, 2),
  jmje   NUMBER(10, 2),
  nsje   NUMBER(10, 2),
  jmlx   VARCHAR2(10),
  bzyy   VARCHAR2(100)
);
COMMENT ON TABLE BDC_DSXX
IS '地税信息表';
COMMENT ON COLUMN BDC_DSXX.dsxxid
IS '主键';
COMMENT ON COLUMN BDC_DSXX.proid
IS '项目id';
COMMENT ON COLUMN BDC_DSXX.sfzjhm
IS '身份证件号码';
COMMENT ON COLUMN BDC_DSXX.nsrmc
IS '纳税人名称';
COMMENT ON COLUMN BDC_DSXX.zspmmc
IS '证书品目名称';
COMMENT ON COLUMN BDC_DSXX.sz
IS '税种';
COMMENT ON COLUMN BDC_DSXX.cqfwzl
IS '产权房屋坐落';
COMMENT ON COLUMN BDC_DSXX.ycqrmc
IS '原产权人名称';
COMMENT ON COLUMN BDC_DSXX.jsje
IS '计税金额';
COMMENT ON COLUMN BDC_DSXX.mj
IS '面积';
COMMENT ON COLUMN BDC_DSXX.jmje
IS '减免金额';
COMMENT ON COLUMN BDC_DSXX.nsje
IS '纳税金额';
COMMENT ON COLUMN BDC_DSXX.jmlx
IS '减免类型';
COMMENT ON COLUMN BDC_DSXX.bzyy
IS '不征原因';
--changeset wenyuanwu:1141 failOnError:false runOnChange:true runAlways:true
CREATE TABLE CH_XM
(
  lsh   VARCHAR2(100),
  nf    VARCHAR2(4),
  xmzt  VARCHAR2(2),
  xmyj  VARCHAR2(1000),
  pzwh  VARCHAR2(100),
  dkbh  VARCHAR2(100),
  pzmj  NUMBER(10, 2),
  pzyt  VARCHAR2(10),
  bmmc  VARCHAR2(100),
  kclx1 VARCHAR2(10),
  kclx2 VARCHAR2(10),
  chdw  VARCHAR2(100),
  kcbh  VARCHAR2(100),
  pgsj  DATE,
  fzr   VARCHAR2(100),
  chyq  VARCHAR2(100),
  chxt  VARCHAR2(100),
  yqgcy VARCHAR2(100),
  kzy   VARCHAR2(100),
  cthzy VARCHAR2(100),
  chrq  DATE,
  jzds  VARCHAR2(100),
  xmmj  NUMBER(10, 2),
  sjyt  VARCHAR2(10),
  tdzh  VARCHAR2(100),
  chfy  NUMBER(10, 2),
  wiid  VARCHAR2(100),
  xmid  VARCHAR2(32) NOT NULL,
  xmbh  VARCHAR2(100),
  sjbh  VARCHAR2(100),
  ywlx  VARCHAR2(50),
  ywmx  VARCHAR2(50),
  xmmc  VARCHAR2(100),
  qxh   VARCHAR2(6),
  jdh   VARCHAR2(20),
  dclx  VARCHAR2(10),
  yddw  VARCHAR2(100),
  zl    VARCHAR2(1000),
  lxr   VARCHAR2(100),
  lxdh  VARCHAR2(100),
  xmcjr VARCHAR2(100),
  bjsj  DATE,
  cjsj  DATE,
  wszt  VARCHAR2(2),

  fczh  VARCHAR2(100),
  qzh   VARCHAR2(100),
  bz    VARCHAR2(500),
  jfsj  DATE
);
COMMENT ON COLUMN CH_XM.lsh
IS '流水号';
COMMENT ON COLUMN CH_XM.nf
IS '年份';
COMMENT ON COLUMN CH_XM.xmzt
IS '项目状态 0：办理中
1：办结
';
COMMENT ON COLUMN CH_XM.xmyj
IS '项目依据';
COMMENT ON COLUMN CH_XM.pzwh
IS '批准文号';
COMMENT ON COLUMN CH_XM.dkbh
IS '地块编号';
COMMENT ON COLUMN CH_XM.pzmj
IS '批准面积';
COMMENT ON COLUMN CH_XM.pzyt
IS '批准用途（二调用途字典表）';
COMMENT ON COLUMN CH_XM.bmmc
IS '部门名称';
COMMENT ON COLUMN CH_XM.kclx1
IS '勘测类型1勘测类型1字典表';
COMMENT ON COLUMN CH_XM.kclx2
IS '勘测类型2 勘测类型2字典表';
COMMENT ON COLUMN CH_XM.chdw
IS '勘测单位';
COMMENT ON COLUMN CH_XM.kcbh
IS '勘测编号';
COMMENT ON COLUMN CH_XM.pgsj
IS '派工时间';
COMMENT ON COLUMN CH_XM.fzr
IS '负责人';
COMMENT ON COLUMN CH_XM.chyq
IS '测绘仪器';
COMMENT ON COLUMN CH_XM.chxt
IS '测绘系统';
COMMENT ON COLUMN CH_XM.yqgcy
IS '仪器观测员';
COMMENT ON COLUMN CH_XM.kzy
IS '勘丈员';
COMMENT ON COLUMN CH_XM.cthzy
IS '草图绘制员';
COMMENT ON COLUMN CH_XM.chrq
IS '测绘日期';
COMMENT ON COLUMN CH_XM.jzds
IS '界址点数';
COMMENT ON COLUMN CH_XM.xmmj
IS '项目面积';
COMMENT ON COLUMN CH_XM.sjyt
IS '实际用途 二调用途字典表';
COMMENT ON COLUMN CH_XM.tdzh
IS '土地证号';
COMMENT ON COLUMN CH_XM.chfy
IS '测绘费用';
COMMENT ON COLUMN CH_XM.wiid
IS '工作流ID';
COMMENT ON COLUMN CH_XM.xmid
IS '主键';
COMMENT ON COLUMN CH_XM.xmbh
IS '项目编号';
COMMENT ON COLUMN CH_XM.sjbh
IS '收件编号';
COMMENT ON COLUMN CH_XM.ywlx
IS '业务类型';
COMMENT ON COLUMN CH_XM.ywmx
IS '业务明细';
COMMENT ON COLUMN CH_XM.xmmc
IS '项目名称';
COMMENT ON COLUMN CH_XM.qxh
IS '区县号';
COMMENT ON COLUMN CH_XM.jdh
IS '街道号';
COMMENT ON COLUMN CH_XM.dclx
IS '调查类型';
COMMENT ON COLUMN CH_XM.yddw
IS '用地单位';
COMMENT ON COLUMN CH_XM.zl
IS '土地坐落';
COMMENT ON COLUMN CH_XM.lxr
IS '联系人';
COMMENT ON COLUMN CH_XM.lxdh
IS '联系电话';
COMMENT ON COLUMN CH_XM.xmcjr
IS '项目创建人';
COMMENT ON COLUMN CH_XM.bjsj
IS '办结时间';
COMMENT ON COLUMN CH_XM.cjsj
IS '创建时间';
COMMENT ON COLUMN CH_XM.proid
IS '不动产项目id';
COMMENT ON COLUMN CH_XM.fczh
IS '房产证号';
COMMENT ON COLUMN CH_XM.qzh
IS '丘幢号';
COMMENT ON COLUMN CH_XM.bz
IS '备注';

--changeset wenyuanwu:1142 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GL_DYH_REL
(
  relid     VARCHAR2(32) NOT NULL,
  proid     VARCHAR2(32) NOT NULL,
  bdcdyh    VARCHAR2(28) NOT NULL,
  glbdcdyh  VARCHAR2(28),
  glbdcdybh VARCHAR2(100)
);
COMMENT ON TABLE BDC_GL_DYH_REL
IS '不动产登记关联单元号关联表';
COMMENT ON COLUMN BDC_GL_DYH_REL.relid
IS '关系ID';
COMMENT ON COLUMN BDC_GL_DYH_REL.proid
IS '登记项目ID';
COMMENT ON COLUMN BDC_GL_DYH_REL.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_GL_DYH_REL.glbdcdyh
IS '关联的不动产单元号';
COMMENT ON COLUMN BDC_GL_DYH_REL.glbdcdybh
IS '关联的不动产单元编号';
--changeset wenyuanwu:1143 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJXX
  ADD DYZT VARCHAR2(1);
COMMENT ON COLUMN BDC_SJXX.DYZT
IS '打印状态';
--changeset wenyuanwu:1144 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FWFZXX
  ADD JZND NUMBER(10);
COMMENT ON COLUMN BDC_FWFZXX.JZND IS '年代字段';
--changeset wenyuanwu:1145 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_HYCK
(
  DM VARCHAR2(10),
  MC VARCHAR2(50)
);
COMMENT ON COLUMN BDC_ZD_HYCK.DM
IS '核验窗口代码';
COMMENT ON COLUMN BDC_ZD_HYCK.MC
IS '核验窗口名称';
--changeset wenyuanwu:1146 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_HYXX
(
  HYXXID VARCHAR2(32) NOT NULL,
  XMID   VARCHAR2(32),
  DJJGDM VARCHAR2(100),
  DJJGMC VARCHAR2(100),
  HYCKDM VARCHAR2(100),
  HYCKMC VARCHAR2(100),
  HYQSSJ DATE,
  HYZZSJ DATE,
  HYBMID VARCHAR2(50),
  HYBMMC VARCHAR2(100)
);
COMMENT ON TABLE BDC_HYXX
IS '核验信息表';
COMMENT ON COLUMN BDC_HYXX.HYXXID
IS '核验信息id';
COMMENT ON COLUMN BDC_HYXX.XMID
IS '项目id';
COMMENT ON COLUMN BDC_HYXX.DJJGDM
IS '登记机构代码';
COMMENT ON COLUMN BDC_HYXX.DJJGMC
IS '登记机构';
COMMENT ON COLUMN BDC_HYXX.HYCKDM
IS '核验窗口代码';
COMMENT ON COLUMN BDC_HYXX.HYCKMC
IS '核验窗口名称';
COMMENT ON COLUMN BDC_HYXX.HYQSSJ
IS '核验起始时间';
COMMENT ON COLUMN BDC_HYXX.HYZZSJ
IS '核验终止时间';
COMMENT ON COLUMN BDC_HYXX.HYBMID
IS '核验部门id';
COMMENT ON COLUMN BDC_HYXX.HYBMMC
IS '核验部门名称';
--changeset wenyuanwu:1147 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_DJJG_HYCK_REL
(
  RELID  VARCHAR2(32) NOT NULL,
  DJJGDM VARCHAR2(50),
  DJJGMC VARCHAR2(100),
  HYCKDM VARCHAR2(50),
  HYCKMC VARCHAR2(100),
  SXH    NUMBER
);
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.RELID
IS '关系id';
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.DJJGDM
IS '登记机构代码';
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.DJJGMC
IS '登记机构名称';
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.HYCKDM
IS '核验窗口代码';
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.HYCKMC
IS '核验窗口名称';
COMMENT ON COLUMN BDC_DJJG_HYCK_REL.SXH
IS '顺序号';
--changeset wenyuanwu:1148 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD GYBDCQZH VARCHAR2(100);
COMMENT ON COLUMN BDC_ZS.GYBDCQZH IS '共用不动产权证号';
--changeset wenyuanwu:1149 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QLRZJYXKSRQ DATE;
COMMENT ON COLUMN BDC_QLR.QLRZJYXKSRQ IS '权利人证件有效开始日期';
--changeset wenyuanwu:1150 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD QLRZJYXJSRQ DATE;
COMMENT ON COLUMN BDC_QLR.QLRZJYXJSRQ IS '权利人证件有效结束日期';
--changeset wenyuanwu:1151 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_FWFSSS
  ADD (JRFZMJ NUMBER(10, 2));
COMMENT ON COLUMN BDC_FWFSSS.JRFZMJ IS '计入发证面积';
--changeset wenyuanwu:1152 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GDXX
  ADD (AJJS NUMBER(10));
COMMENT ON COLUMN BDC_GDXX.AJJS IS '案卷件数';
--changeset wenyuanwu:1153 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GDXX
  ADD (AJYS NUMBER(10));
COMMENT ON COLUMN BDC_GDXX.AJYS IS '案卷页数';
--changeset wenyuanwu:1154 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_ZS
  ADD QSZT VARCHAR2(2);
COMMENT ON COLUMN BDC_ZS.QSZT IS '权属状态';
--changeset wenyuanwu:1155 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD BZJE NUMBER(10, 2);
COMMENT ON COLUMN BDC_SFXM.BZJE IS '收费项目标准金额';

--changeset wenyuanwu:1156 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xt_limitfield
  ADD DJZXDM VARCHAR2(10);
COMMENT ON COLUMN bdc_xt_limitfield.DJZXDM IS '登记子项代码';
--changeset wenyuanwu:1157 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD BDCQZHJC VARCHAR2(100);
COMMENT ON COLUMN BDC_ZS.BDCQZHJC IS '';
--changeset wenyuanwu:1158 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD CZTXMBH VARCHAR2(100);
COMMENT ON COLUMN BDC_SFXX.CZTXMBH IS '财政条形码编号';
--changeset wenyuanwu:1159 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SSXX
(
  ssxxid VARCHAR2(32),
  xmid   VARCHAR2(32),
  jedw   NUMBER(2),
  ssr    VARCHAR2(100),
  sssj   DATE,
  ssje   NUMBER(10, 2)
);
COMMENT ON TABLE BDC_SSXX
IS '不动产收税信息';
COMMENT ON COLUMN BDC_SSXX.ssxxid
IS '收税信息ID';
COMMENT ON COLUMN BDC_SSXX.xmid
IS '项目id';
COMMENT ON COLUMN BDC_SSXX.jedw
IS '金额单位';
COMMENT ON COLUMN BDC_SSXX.ssr
IS '收税人';
COMMENT ON COLUMN BDC_SSXX.sssj
IS '收税时间';
COMMENT ON COLUMN BDC_SSXX.ssje
IS '收税金额';
--changeset wenyuanwu:1160 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_JEDW
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_JEDW
IS '金额单位字典项';
COMMENT ON COLUMN BDC_ZD_JEDW.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_JEDW.mc
IS '名称';

--changeset wenyuanwu:1161 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYHT
  ADD (PROID VARCHAR2(100));
COMMENT ON COLUMN BDC_JYHT.PROID IS '项目id';
--changeset wenyuanwu:1162 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYHT
  ADD (jyyfczh VARCHAR2(100));
COMMENT ON COLUMN BDC_JYHT.jyyfczh IS '交易原房产证号';
--changeset wenyuanwu:1163 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XMTD
(
  XMTDID VARCHAR2(32),
  XMID   VARCHAR2(32),
  XMTDDM VARCHAR2(2),
  XMTDLY VARCHAR2(100)
);
COMMENT ON TABLE BDC_XMTD
IS '不动产项目特点表';
COMMENT ON COLUMN BDC_XMTD.XMTDID
IS '项目特点ID';
COMMENT ON COLUMN BDC_XMTD.XMID
IS '项目id';
COMMENT ON COLUMN BDC_XMTD.XMTDDM
IS '项目特点代码';
COMMENT ON COLUMN BDC_XMTD.XMTDLY
IS '项目特点理由';
--changeset wenyuanwu:1164 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYGL
  ADD (QLRXZ VARCHAR2(5));
COMMENT ON COLUMN BDC_XYGL.QLRXZ IS '权利人性质';
--changeset wenyuanwu:1165 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYGL
  ADD (QLRLXDH VARCHAR2(100));
COMMENT ON COLUMN BDC_XYGL.QLRLXDH IS '权利人联系电话';
--changeset wenyuanwu:1166 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYGL
  ADD (QLRYB VARCHAR2(100));
COMMENT ON COLUMN BDC_XYGL.QLRYB IS '权利人邮编';
--changeset wenyuanwu:1167 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XYGL
  ADD (QLRFDDBR VARCHAR2(100));
COMMENT ON COLUMN BDC_XYGL.QLRFDDBR IS '权利人法定代表人';

--changeset wenyuanwu:1168 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_XMTD
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_XMTD
IS '项目特点字典项';
COMMENT ON COLUMN BDC_ZD_XMTD.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_XMTD.mc
IS '名称';
--changeset wenyuanwu:1169 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_SFJSFF
(
  dm   VARCHAR2(10),
  mc   VARCHAR2(50),
  sfbl NUMBER(10, 2)
);
COMMENT ON TABLE BDC_ZD_SFJSFF
IS '收费计算方法字典表';
COMMENT ON COLUMN BDC_ZD_SFJSFF.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_SFJSFF.mc
IS '名称';
COMMENT ON COLUMN BDC_ZD_SFJSFF.sfbl
IS '收费比例';
--changeset wenyuanwu:1170 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (CZMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_FDCQ_DZ.CZMJ IS '超占面积';
--changeset wenyuanwu:1171 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (TDYCSYNX NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ_DZ.TDYCSYNX IS '土地有偿使用年限';
--changeset wenyuanwu:1172 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SDMXX
(
  SDMXXID VARCHAR2(32),
  XMID    VARCHAR2(32),
  SKHH    VARCHAR2(100),
  DKHH    VARCHAR2(100),
  RQKHH   VARCHAR2(100)
);
COMMENT ON TABLE BDC_SDMXX
IS '不动产水电煤信息';
COMMENT ON COLUMN BDC_SDMXX.SDMXXID
IS '水电煤信息ID';
COMMENT ON COLUMN BDC_SDMXX.XMID
IS '项目id';
COMMENT ON COLUMN BDC_SDMXX.SKHH
IS '水卡户号';
COMMENT ON COLUMN BDC_SDMXX.DKHH
IS '电卡户号';
COMMENT ON COLUMN BDC_SDMXX.RQKHH
IS '燃气卡户号';
--changeset wenyuanwu:1173 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_XM
  ADD (ZJTGXYBH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.ZJTGXYBH IS '资金托管协议编号';

--changeset wenyuanwu:1174 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CRJJKLXD
(
  lxdid  VARCHAR2(32) NOT NULL,
  proid  VARCHAR2(32),
  wiid   VARCHAR2(32),
  tdjb   VARCHAR2(50),
  tdyt   VARCHAR2(1),
  crjdj  NUMBER(10, 2),
  crjzj  NUMBER(10, 2),
  jkkssj DATE,
  jkjssj DATE,
  crjdw  VARCHAR2(2),
  skdw   VARCHAR2(100),
  khh    VARCHAR2(100),
  zh     VARCHAR2(100),
  jkdd   VARCHAR2(100)
);
COMMENT ON TABLE BDC_CRJJKLXDD
IS '不动产出让金缴款联系单';
COMMENT ON COLUMN BDC_CRJJKLXDD.lxdid
IS '联系单Id';
COMMENT ON COLUMN BDC_CRJJKLXDD.proid
IS '项目Id';
COMMENT ON COLUMN BDC_CRJJKLXDD.wiid
IS '工作流项目Id';
COMMENT ON COLUMN BDC_CRJJKLXDD.tdjb
IS '土地级别';
COMMENT ON COLUMN BDC_CRJJKLXDD.tdyt
IS '土地用途';
COMMENT ON COLUMN BDC_CRJJKLXDD.crjdj
IS '出让金单价';
COMMENT ON COLUMN BDC_CRJJKLXDD.crjzj
IS '出让金总价';
COMMENT ON COLUMN BDC_CRJJKLXDD.jkkssj
IS '缴款开始时间';
COMMENT ON COLUMN BDC_CRJJKLXDD.jkjssj
IS '缴款结束时间';
COMMENT ON COLUMN BDC_CRJJKLXDD.crjdw
IS '出让金单位';
COMMENT ON COLUMN BDC_CRJJKLXDD.skdw
IS '收款单位';
COMMENT ON COLUMN BDC_CRJJKLXDD.khh
IS '开户行';
COMMENT ON COLUMN BDC_CRJJKLXDD.zh
IS '账号';
COMMENT ON COLUMN BDC_CRJJKLXDD.jkdd
IS '缴款地点';
--changeset wenyuanwu:1175 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_CRJJKLXDMX
(
  lxdmxid VARCHAR2(32) NOT NULL,
  lxdid   VARCHAR2(32),
  xmmc    VARCHAR2(100),
  yfje    NUMBER(10, 2),
  skje    NUMBER(10, 2),
  skrq    DATE,
  fkkssj  DATE,
  fkjssj  DATE,
  jbr     VARCHAR2(50),
  fkdw    VARCHAR2(2)
);

COMMENT ON TABLE BDC_CRJJKLXDMX
IS '不动产出让金缴款联系单明细表';
COMMENT ON COLUMN BDC_CRJJKLXDMX.lxdmxid
IS '联系单明细Id';
COMMENT ON COLUMN BDC_CRJJKLXDMX.lxdid
IS '联系单id';
COMMENT ON COLUMN BDC_CRJJKLXDMX.xmmc
IS '项目名称';
COMMENT ON COLUMN BDC_CRJJKLXDMX.yfje
IS '应付金额';
COMMENT ON COLUMN BDC_CRJJKLXDMX.skje
IS '收款金额';
COMMENT ON COLUMN BDC_CRJJKLXDMX.skrq
IS '收款日期';
COMMENT ON COLUMN BDC_CRJJKLXDMX.fkkssj
IS '付款开始时间';
COMMENT ON COLUMN BDC_CRJJKLXDMX.fkjssj
IS '付款结束时间';
COMMENT ON COLUMN BDC_CRJJKLXDMX.jbr
IS '经办人';
COMMENT ON COLUMN BDC_CRJJKLXDMX.fkdw
IS '付款单位';

--changeset wenyuanwu:1176 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (SQLXMC VARCHAR2(100));
COMMENT ON COLUMN BDC_ZS.SQLXMC IS '申请类型名称';
--changeset wenyuanwu:1177 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (SQLXDM VARCHAR2(10));
COMMENT ON COLUMN BDC_ZS.SQLXDM IS '申请类型代码';
--changeset wenyuanwu:1178 failOnError:false runOnChange:true runAlways:true

ALTER TABLE bdc_xm
  ADD (LZRZJH VARCHAR2(100));
COMMENT ON COLUMN bdc_xm.LZRZJH IS '领证人证件号';
--changeset wenyuanwu:1179 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_xm
  ADD (LZRZJZL VARCHAR2(2));
COMMENT ON COLUMN bdc_xm.LZRZJZL IS '领证人证件种类';
--changeset wenyuanwu:1180 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_SDMXX
  ADD (DSKH VARCHAR2(100));
COMMENT ON COLUMN BDC_SDMXX.DSKH IS '电视卡号';
--changeset wenyuanwu:1181 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD (ISZX VARCHAR2(2));
COMMENT ON COLUMN GD_TD_QL.ISZX IS '是否注销';
--changeset wenyuanwu:1182 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD (ISZX VARCHAR2(2));
COMMENT ON COLUMN GD_FW_QL.ISZX IS '是否注销';
--changeset wenyuanwu:1183 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CJLB
  ADD (ZSBH VARCHAR2(100));
COMMENT ON COLUMN BDC_CJLB.ZSBH IS '证书编号';
--changeset wenyuanwu:1184 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (CZMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_FDCQ.CZMJ IS '超占面积';
--changeset wenyuanwu:1185 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (TDYCSYNX NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ.TDYCSYNX IS '土地有偿使用年限';
--changeset wenyuanwu:1186 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (DJCKH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.DJCKH IS '登记窗口号';
--changeset wenyuanwu:1188 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_XMJG
(
  xmjgid    VARCHAR2(32) NOT NULL,
  xmtd      VARCHAR2(5),
  sqlxdm    VARCHAR2(10),
  ckjxmqx   NUMBER(10),
  zdxmqlrmc VARCHAR2(100),
  zdxmywrmc VARCHAR2(100),
  zdxmzdmj  NUMBER(10, 4)
);
--changeset wenyuanwu:1187 failOnError:false runOnChange:true runAlways:true
ALTER TABLE NATIONAL_ACCESSLOG
  ADD (ACCESS_TIMES NUMBER(10));
COMMENT ON COLUMN NATIONAL_ACCESSLOG.ACCESS_TIMES IS '上报次数';
--changeset wenyuanwu:1189 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (CZMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.CZMJ IS '超占面积';
--changeset wenyuanwu:11990 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (TDYCSYNX NUMBER(10));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.TDYCSYNX IS '土地有偿使用年限';

--changeset wenyuanwu:11991 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (JKFS VARCHAR2(5));
COMMENT ON COLUMN BDC_SFXX.JKFS IS '缴款方式';
--changeset wenyuanwu:1192 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (ZSFS VARCHAR2(5));
COMMENT ON COLUMN BDC_SFXX.ZSFS IS '征收方式';
--changeset wenyuanwu:1193 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (ZPHM VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX.ZPHM IS '支票号码';
--changeset wenyuanwu:1194 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_BDCSD
  ADD (JSLCGZLID VARCHAR2(32));
COMMENT ON COLUMN GD_BDCSD.JSLCGZLID IS '解锁流程工作流ID';
--changeset wenyuanwu:1195 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDYSD
  ADD (JSLCGZLID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCDYSD.JSLCGZLID IS '解锁流程工作流ID';
--changeset wenyuanwu:1196 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD (SDLCGZLID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCZSSD.SDLCGZLID IS '锁定流程工作流ID';
--changeset wenyuanwu:1197 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCZSSD
  ADD (JSLCGZLID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCZSSD.JSLCGZLID IS '解锁流程工作流ID';
--changeset wenyuanwu:1198 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QTDJ_YW_REL
  ADD (XZDM VARCHAR2(10));
COMMENT ON COLUMN BDC_QTDJ_YW_REL.XZDM IS '区县代码';

--changeset wenyuanwu:1199 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_SFQY
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_SFQY
IS '收费企业字典表';

--changeset wenyuanwu:1200 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_zsbh
  ADD (jzdw VARCHAR2(100));
COMMENT ON COLUMN bdc_zsbh.jzdw IS '监制单位';
--changeset wenyuanwu:1201 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (sfcz VARCHAR2(2));
COMMENT ON COLUMN BDC_FDCQ_DZ.sfcz IS '是否超占';
--changeset wenyuanwu:9897 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (sfcz VARCHAR2(2));
COMMENT ON COLUMN BDC_FDCQ.sfcz IS '是否超占';
--changeset wenyuanwu:9898 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD JFYY VARCHAR2(100);
COMMENT ON COLUMN BDC_CF.JFYY IS '解封原因';
--changeset wenyuanwu:9899 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_DYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9908 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_FDCQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9909 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_FDCQ_DZ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9910 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_HYSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_HYSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9911 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9912 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JZWSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_JZWSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9913 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_LQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_LQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9914 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDCBNYDSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_TDCBNYDSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9915 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TDSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_TDSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9916 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YY
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN BDC_YY.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9917 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_CQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN GD_CQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9918 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9919 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_LQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN GD_LQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9920 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (ZXYWH VARCHAR2(100));
COMMENT ON COLUMN GD_TDSYQ.ZXYWH IS '注销业务号';
--changeset wenyuanwu:9921 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (DYBDCLX VARCHAR2(50));
COMMENT ON COLUMN BDC_DYAQ.DYBDCLX IS '抵押不动产类型';
--changeset wenyuanwu:9922 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (QLRLX VARCHAR2(10));
COMMENT ON COLUMN BDC_SFXX.QLRLX IS '权利人类型';
--changeset wenyuanwu:9923 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (DKFS VARCHAR2(50));
COMMENT ON COLUMN BDC_YG.DKFS IS '贷款方式';
--changeset wenyuanwu:9924 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJXX
  ADD (SXH VARCHAR2(10));
COMMENT ON COLUMN BDC_SJXX.SXH IS '顺序号,收件单流水号，每年重置，从000001开始';
--changeset wenyuanwu:9925 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_TSZT
  ADD (TSJDMC VARCHAR2(100));
COMMENT ON COLUMN BDC_TSZT.TSJDMC IS '推送节点名称';
--changeset wenyuanwu:9926 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (QLRLX VARCHAR2(10));
COMMENT ON COLUMN BDC_SFXX.QLRLX IS '权利人类型';
--changeset wenyuanwu:9927 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JYHT
  ADD (YTMC VARCHAR2(100));
COMMENT ON COLUMN BDC_JYHT.YTMC IS '用途名称';
--changeset wenyuanwu:9928 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX_JG
  ADD (SFZT VARCHAR2(1));
COMMENT ON COLUMN BDC_SFXX_JG.SFZT IS '收费状态';
--changeset wenyuanwu:9929 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX_JG
  ADD (BZ VARCHAR2(1));
COMMENT ON COLUMN BDC_SFXX_JG.BZ IS '备注';
--changeset wenyuanwu:9930 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX_JG
  ADD (SFZTCZR VARCHAR2(100));
COMMENT ON COLUMN BDC_SFXX_JG.SFZTCZR IS '收费状态操作人';
--changeset wenyuanwu:9931 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX_JG
  ADD (SFZTCZRQ DATE);
COMMENT ON COLUMN BDC_SFXX_JG.SFZTCZRQ IS '收费状态操作日期';
--changeset wenyuanwu:9932 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (SFXYGG VARCHAR2(2));
COMMENT ON COLUMN BDC_XM.SFXYGG IS '是否需要公告';
--changeset wenyuanwu:9933 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_DYH_REL
(
  bdcdyh VARCHAR2(50) NOT NULL,
  tdid   VARCHAR2(50),
  relid  VARCHAR2(50) NOT NULL,

  gdid   VARCHAR2(50)

);
COMMENT ON TABLE GD_LS_DYH_REL
IS '过渡历史单元号关系';
COMMENT ON COLUMN GD_LS_DYH_REL.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN GD_LS_DYH_REL.tdid
IS '宗地主键';
COMMENT ON COLUMN GD_LS_DYH_REL.relid
IS '主键';

COMMENT ON COLUMN GD_LS_DYH_REL.gdid
IS '过渡ID';
--changeset wenyuanwu:9934 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_DYH_REL_BDCDYH
  ON GD_LS_DYH_REL (BDCDYH);
--changeset wenyuanwu:9935 failOnError:false runOnChange:true runAlways:true
CREATE INDEX IDX_GD_LS_DYH_REL_TDID
  ON GD_LS_DYH_REL (TDID);
ALTER TABLE GD_LS_DYH_REL
  ADD CONSTRAINT GD_LS_DYH_REL_RELID PRIMARY KEY (RELID);
--changeset wenyuanwu:9936 failOnError:false runOnChange:true runAlways:true
CREATE TABLE GD_LS_QL_DYH_REL
(
  relid  VARCHAR2(32),
  bdcdyh VARCHAR2(28) NOT NULL,
  qlid   VARCHAR2(100),
  bdclx  VARCHAR2(5),
  tdqlid VARCHAR2(100)
);
COMMENT ON TABLE GD_LS_QL_DYH_REL
IS '过渡历史权利与不动产单元关系';
COMMENT ON COLUMN GD_LS_QL_DYH_REL.relid
IS '主键';
COMMENT ON COLUMN GD_LS_QL_DYH_REL.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN GD_LS_QL_DYH_REL.qlid
IS '权利id';
COMMENT ON COLUMN GD_LS_QL_DYH_REL.bdclx
IS '不动产类型';
COMMENT ON COLUMN GD_LS_QL_DYH_REL.tdqlid
IS '土地权利id';

--changeset wenyuanwu:9937 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (DWMC VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.DWMC IS '单位名称';
--changeset wenyuanwu:9938 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW
  ADD (DWMC VARCHAR2(100));
COMMENT ON COLUMN GD_FW.DWMC IS '单位名称';
--changeset wenyuanwu:9939 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_SDMXX
  ADD (SFGHSWK VARCHAR2(2));
COMMENT ON COLUMN BDC_SDMXX.SFGHSWK IS '是否过户水务卡';
--changeset wenyuanwu:9940 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SDMXX
  ADD (SFGHRQK VARCHAR2(2));
COMMENT ON COLUMN BDC_SDMXX.SFGHRQK IS '是否过户燃气卡';
--changeset wenyuanwu:9941 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SDMXX
  ADD (SFGHDSK VARCHAR2(2));
COMMENT ON COLUMN BDC_SDMXX.SFGHDSK IS '是否过户电视卡';
--changeset wenyuanwu:9942 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SDMXX
  ADD (SFGHDFK VARCHAR2(2));
COMMENT ON COLUMN BDC_SDMXX.SFGHDFK IS '是否过户电费卡';
--changeset wenyuanwu:9943 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SDMXX
  ADD (DSKH VARCHAR2(100));
COMMENT ON COLUMN BDC_SDMXX.DSKH IS '电视卡号';
--changeset wenyuanwu:9944 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_BDCDY_ZHFZJL
(
  zhfzjlid VARCHAR2(32) NOT NULL,
  wiid     VARCHAR2(32),
  sqlxdm   VARCHAR2(10),
  bdcdyh   VARCHAR2(28),
  sfsczs   VARCHAR2(2),
  sfsczm   VARCHAR2(2),
  sfscybzm VARCHAR2(2)
);
COMMENT ON TABLE BDC_BDCDY_ZHFZJL
IS '不动产不动产单元组合发证记录表';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.zhfzjlid
IS '主键';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.wiid
IS '工作流id';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.sqlxdm
IS '申请类型代码';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.bdcdyh
IS '不动产单元号';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.sfsczs
IS '是否生成证书';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.sfsczm
IS '是否生成证明';
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.sfscybzm
IS '是否生成一本证明';

--changeset wenyuanwu:9945 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_BDCDY_ZHFZJL
  ADD (ZHID VARCHAR2(32));
COMMENT ON COLUMN BDC_BDCDY_ZHFZJL.ZHID IS '组合id';
--changeset wenyuanwu:9946 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_YH_CJR_REL
(
  gxid  VARCHAR2(32) NOT NULL,
  yhbh  VARCHAR2(100),
  cjrid VARCHAR2(32),
  cjrmc VARCHAR2(100),
  djckh VARCHAR2(10)
);
COMMENT ON TABLE BDC_YH_CJR_REL
IS '银行和创建人关系表';
COMMENT ON COLUMN BDC_YH_CJR_REL.gxid
IS '关系id';
COMMENT ON COLUMN BDC_YH_CJR_REL.yhbh
IS '银行编号';
COMMENT ON COLUMN BDC_YH_CJR_REL.cjrid
IS '创建人id';
COMMENT ON COLUMN BDC_YH_CJR_REL.cjrmc
IS '创建人名称';
COMMENT ON COLUMN BDC_YH_CJR_REL.djckh
IS '登记窗口号';
--changeset wenyuanwu:9949 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_TDSYQXZ
(
  dm VARCHAR2(10) NOT NULL,
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_TDSYQXZ
IS '土地使用权性质字典表';
COMMENT ON COLUMN BDC_ZD_TDSYQXZ.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_TDSYQXZ.mc
IS '名称';
--changeset wenyuanwu:9948 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZD_TDSYQXZ
  ADD CONSTRAINT PK_BDC_ZD_TDSYQXZ PRIMARY KEY (DM)
  USING INDEX;
--changeset wenyuanwu:9947 failOnError:false runOnChange:true runAlways:true
INSERT INTO BDC_ZD_TDSYQXZ (dm, mc) VALUES ('1', '国家所有');
INSERT INTO BDC_ZD_TDSYQXZ (dm, mc) VALUES ('2', '集体所有');

--changeset wenyuanwu:9950 failOnError:false runOnChange:true runAlways:true

ALTER TABLE BDC_ZS
  ADD (SFSYYZ VARCHAR2(2));
COMMENT ON COLUMN BDC_ZS.SFSYYZ IS '是否使用印章';
--changeset wenyuanwu:9951 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_ZDQMPZ
  ADD (XYZJDMC VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_ZDQMPZ.XYZJDMC IS '需验证节点名称';
--changeset wenyuanwu:9952 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (LZRLXDH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.LZRLXDH IS '联系人联系电话';

--changeset wenyuanwu:9953 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_QLQTZK_CONFIG
  ADD (djzxdm VARCHAR2(10));
COMMENT ON COLUMN BDC_XT_QLQTZK_CONFIG.djzxdm IS '登记子项代码';

--changeset wenyuanwu:9954 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_ZFRZPTJG
(
  dm VARCHAR2(2) NOT NULL,
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_ZFRZPTJG
IS '政府融资平台机构字典表';
COMMENT ON COLUMN BDC_ZD_ZFRZPTJG.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_ZFRZPTJG.mc
IS '名称';
ALTER TABLE BDC_ZD_ZFRZPTJG
  ADD CONSTRAINT PK_BDC_ZD_ZFRZPTJG PRIMARY KEY (DM)
  USING INDEX;

--changeset wenyuanwu:9956 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_TDCBJG
(
  dm VARCHAR2(2) NOT NULL,
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_TDCBJG
IS '土地储备机构字典表';
COMMENT ON COLUMN BDC_ZD_TDCBJG.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_TDCBJG.mc
IS '名称';
ALTER TABLE BDC_ZD_TDCBJG
  ADD CONSTRAINT PK_BDC_ZD_TDCBJG PRIMARY KEY (DM)
  USING INDEX;
--changeset wenyuanwu:9957 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SFXXCXJL
(
  jlid   VARCHAR2(32) NOT NULL,
  cxbh   VARCHAR2(100),
  qlrmc  VARCHAR2(100),
  jdmc   VARCHAR2(100),
  lcmc   VARCHAR2(100),
  cjkssj DATE,
  cjjssj DATE,
  czrmc  VARCHAR2(100),
  czsj   DATE,
  czip   VARCHAR2(20)
);
COMMENT ON TABLE BDC_SFXXCXJL
IS '不动产收费信息查询记录表';
COMMENT ON COLUMN BDC_SFXXCXJL.jlid
IS '记录id';
COMMENT ON COLUMN BDC_SFXXCXJL.cxbh
IS '查询编号';
COMMENT ON COLUMN BDC_SFXXCXJL.qlrmc
IS '权利人名称';
COMMENT ON COLUMN BDC_SFXXCXJL.jdmc
IS '节点名称';
COMMENT ON COLUMN BDC_SFXXCXJL.lcmc
IS '流程名称';
COMMENT ON COLUMN BDC_SFXXCXJL.cjkssj
IS '创建开始时间';
COMMENT ON COLUMN BDC_SFXXCXJL.cjjssj
IS '创建结束时间';
COMMENT ON COLUMN BDC_SFXXCXJL.czrmc
IS '操作人名称';
COMMENT ON COLUMN BDC_SFXXCXJL.czsj
IS '操作时间';
COMMENT ON COLUMN BDC_SFXXCXJL.czip
IS '操作IP地址';
--changeset wenyuanwu:9958 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_SFXXCXJG
(
  jgid VARCHAR2(32) NOT NULL,
  slbh VARCHAR2(100),
  lcmc VARCHAR2(100),
  jdmc VARCHAR2(100),
  zl   VARCHAR2(100),
  qlr  VARCHAR2(100),
  ywr  VARCHAR2(100),
  ssje NUMBER(10, 2),
  dyzt VARCHAR2(1),
  dysj DATE,
  jbr  VARCHAR2(100),
  jlid VARCHAR2(32) NOT NULL
);
COMMENT ON TABLE BDC_SFXXCXJG
IS '不动产收费信息查询结果表';
COMMENT ON COLUMN BDC_SFXXCXJG.jgid
IS '结果id';
COMMENT ON COLUMN BDC_SFXXCXJG.slbh
IS '受理编号';
COMMENT ON COLUMN BDC_SFXXCXJG.lcmc
IS '流程名称';
COMMENT ON COLUMN BDC_SFXXCXJG.jdmc
IS '节点名称';
COMMENT ON COLUMN BDC_SFXXCXJG.zl
IS '坐落';
COMMENT ON COLUMN BDC_SFXXCXJG.qlr
IS '权利人';
COMMENT ON COLUMN BDC_SFXXCXJG.ywr
IS '义务人';
COMMENT ON COLUMN BDC_SFXXCXJG.ssje
IS '实收金额';
COMMENT ON COLUMN BDC_SFXXCXJG.dyzt
IS '打印状态';
COMMENT ON COLUMN BDC_SFXXCXJG.dysj
IS '打印时间';
COMMENT ON COLUMN BDC_SFXXCXJG.jbr
IS '打印人';
COMMENT ON COLUMN BDC_SFXXCXJG.jlid
IS '查询记录ID';
--changeset wenyuanwu:9959 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GDYWXX
(
  gdywxxid VARCHAR2(32) NOT NULL,
  gdxxid   VARCHAR2(32),
  gdywid   VARCHAR2(32),
  sjclid   VARCHAR2(32)
);
COMMENT ON TABLE BDC_GDYWXX
IS '不动产登记归档原文信息';
COMMENT ON COLUMN BDC_GDYWXX.gdywxxid
IS '主键';
COMMENT ON COLUMN BDC_GDYWXX.gdxxid
IS '归档信息ID';
COMMENT ON COLUMN BDC_GDYWXX.gdywid
IS '归档原文ID';
COMMENT ON COLUMN BDC_GDYWXX.sjclid
IS '收件材料ID';
--changeset wenyuanwu:9960 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_WD
(
  dm VARCHAR2(10) NOT NULL,
  mc VARCHAR2(100)
);
COMMENT ON TABLE BDC_ZD_WD
IS '网点字典表';
COMMENT ON COLUMN BDC_ZD_WD.dm
IS '代码';
COMMENT ON COLUMN BDC_ZD_WD.mc
IS '名称';
--changeset wenyuanwu:9961 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_XT_RYWD
(
  rywdid VARCHAR2(32) NOT NULL,
  yhmc   VARCHAR2(100),
  yhid   VARCHAR2(32),
  wddm   VARCHAR2(10),
  kssj   DATE,
  jssj   DATE,
  sfyx   VARCHAR2(2)
);
COMMENT ON TABLE BDC_XT_RYWD
IS '人员网点配置表';
COMMENT ON COLUMN BDC_XT_RYWD.rywdid
IS '主键';
COMMENT ON COLUMN BDC_XT_RYWD.yhmc
IS '用户名称';
COMMENT ON COLUMN BDC_XT_RYWD.yhid
IS '用户id';
COMMENT ON COLUMN BDC_XT_RYWD.wddm
IS '网点代码';
COMMENT ON COLUMN BDC_XT_RYWD.kssj
IS '开始时间';
COMMENT ON COLUMN BDC_XT_RYWD.jssj
IS '结束时间';
COMMENT ON COLUMN BDC_XT_RYWD.sfyx
IS '是否有效';

--changeset wenyuanwu:1214 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (FZWDDM VARCHAR2(10));
COMMENT ON COLUMN BDC_XM.FZWDDM IS '发证网点代码';
--changeset wenyuanwu:9962 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SJXX
  ADD (SJWDDM VARCHAR2(10));
COMMENT ON COLUMN BDC_SJXX.SJWDDM IS '收件网点代码';
--changeset wenyuanwu:9963 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (DAH VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.DAH IS '档案号';
--changeset wenyuanwu:9964 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (DAH VARCHAR2(100));
COMMENT ON COLUMN GD_TDSYQ.DAH IS '档案号';

--changeset wenyuanwu:9965 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (SFCC VARCHAR2(2));
COMMENT ON COLUMN GD_FWSYQ.SFCC IS '是否拆除';
--changeset wenyuanwu:9966 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (SFCC VARCHAR2(2));
COMMENT ON COLUMN BDC_FDCQ.SFCC IS '是否拆除';

--changeset wenyuanwu:9968 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (GYFS NUMBER(2));
COMMENT ON COLUMN BDC_XM.GYFS IS '共有方式';
--changeset wenyuanwu:9969 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (DJSJ DATE);
COMMENT ON COLUMN BDC_XM.DJSJ IS '登记时间';
--changeset wenyuanwu:9967 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (DBR VARCHAR2(200));
COMMENT ON COLUMN BDC_XM.DBR IS '登簿人';
--changeset wenyuanwu:9970 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (QSZT NUMBER(2));
COMMENT ON COLUMN BDC_XM.QSZT IS '权属状态';

--changeset wenyuanwu:9971 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (BDCQZH VARCHAR2(2000));
COMMENT ON COLUMN BDC_XM.BDCQZH IS '不动产权证号';
--changeset wenyuanwu:9972 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (QLR VARCHAR2(2000));
COMMENT ON COLUMN BDC_XM.QLR IS '权利人';
--changeset wenyuanwu:9973 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (QLRZJH VARCHAR2(2000));
COMMENT ON COLUMN BDC_XM.QLRZJH IS '权利人证件号';
--changeset wenyuanwu:9974 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_QLR
  ADD (SFZXXLY VARCHAR2(2));
COMMENT ON COLUMN BDC_QLR.SFZXXLY IS '身份证信息来源';
--changeset wenyuanwu:9975 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ
  ADD (FCQDH VARCHAR2(100));
COMMENT ON COLUMN BDC_FDCQ.FCQDH IS '房产丘地号';
--changeset wenyuanwu:9976 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_FDCQ_DZ
  ADD (FCQDH VARCHAR2(100));
COMMENT ON COLUMN BDC_FDCQ_DZ.FCQDH IS '房产丘地号';

--changeset wenyuanwu:9977 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GDXX
  ADD (HH VARCHAR2(100));
COMMENT ON COLUMN BDC_GDXX.HH IS '盒号';
--changeset wenyuanwu:9978 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GDXX
  ADD (DAH VARCHAR2(100));
COMMENT ON COLUMN BDC_GDXX.DAH IS '档案号';

--changeset wenyuanwu:9979 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (CQZHJC VARCHAR2(100));
COMMENT ON COLUMN GD_FWSYQ.CQZHJC IS '产权证号简称';
--changeset wenyuanwu:9980 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TDSYQ
  ADD (CQZHJC VARCHAR2(100));
COMMENT ON COLUMN GD_TDSYQ.CQZHJC IS '产权证号简称';
--changeset wenyuanwu:9981 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_QLR
  ADD (CQZHJC VARCHAR2(100));
COMMENT ON COLUMN GD_QLR.CQZHJC IS '产权证号简称';

--changeset wenyuanwu:9982 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FW_QL
  ADD (CQZHJC VARCHAR2(100));
COMMENT ON COLUMN GD_FW_QL.CQZHJC IS '产权证号简称';
--changeset wenyuanwu:9983 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD (CQZHJC VARCHAR2(100));
COMMENT ON COLUMN GD_TD_QL.CQZHJC IS '产权证号简称';
--changeset wenyuanwu:9984 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GDXX
  ADD (GDLX VARCHAR2(2));
COMMENT ON COLUMN BDC_GDXX.GDLX IS '归档类型';
--changeset wenyuanwu:3052 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_SFZXXLY
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_SFZXXLY
IS '身份证信息来源字典表';
--changeset wenyuanwu:3051 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_GDLX
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_GDLX
IS '归档类型字典表';

--changeset wenyuanwu:9985 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (SFTYSF VARCHAR2(2));
COMMENT ON COLUMN BDC_XT_YH.SFTYSF IS '是否统一收费';

--changeset wenyuanwu:9986 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GG
  ADD (XMLY VARCHAR2(2));
COMMENT ON COLUMN BDC_GG.XMLY IS '项目来源';

CREATE TABLE BDC_GGMX
(
  ggmxid VARCHAR2(32) NOT NULL,
  ggid   VARCHAR2(32) NOT NULL,
  qlrmc  VARCHAR2(100),
  cqzh   VARCHAR2(100),
  zl     VARCHAR2(500),
  smr    VARCHAR2(100)
);
COMMENT ON TABLE BDC_GGMX
IS '不动产公告明细表';
COMMENT ON COLUMN BDC_GGMX.ggmxid
IS '公告明细ID';
COMMENT ON COLUMN BDC_GGMX.ggid
IS '公告ID';
COMMENT ON COLUMN BDC_GGMX.qlrmc
IS '权利人名称';
COMMENT ON COLUMN BDC_GGMX.cqzh
IS '产权证号';
COMMENT ON COLUMN BDC_GGMX.zl
IS '坐落';
COMMENT ON COLUMN BDC_GGMX.smr
IS '声明人';
--changeset wenyuanwu:3050 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_WWYY
(
  yyid    VARCHAR2(32) NOT NULL,
  yyh     VARCHAR2(50) NOT NULL,
  yysj    DATE,
  sqrxm   VARCHAR2(50),
  sqrzjhm VARCHAR2(50),
  sqrlxdh VARCHAR2(50),
  cqzh    VARCHAR2(50),
  wqhth   VARCHAR2(100),
  ywrxm   VARCHAR2(50),
  ywrzjhm VARCHAR2(50),
  qlrxm   VARCHAR2(50),
  qlrzjhm VARCHAR2(50),
  yylxdm  VARCHAR2(10),
  yylxmc  VARCHAR2(50),
  bjrxm   VARCHAR2(50),
  bjsj    DATE
);
COMMENT ON TABLE BDC_WWYY
IS '不动产外网预约';
COMMENT ON COLUMN BDC_WWYY.yyid
IS '预约id';
COMMENT ON COLUMN BDC_WWYY.yyh
IS '预约号';
COMMENT ON COLUMN BDC_WWYY.yysj
IS '预约时间';
COMMENT ON COLUMN BDC_WWYY.sqrxm
IS '申请人姓名';
COMMENT ON COLUMN BDC_WWYY.sqrzjhm
IS '申请人证件号码';
COMMENT ON COLUMN BDC_WWYY.sqrlxdh
IS '申请人联系电话';
COMMENT ON COLUMN BDC_WWYY.cqzh
IS '产权证号';
COMMENT ON COLUMN BDC_WWYY.wqhth
IS '网签合同号';
COMMENT ON COLUMN BDC_WWYY.ywrxm
IS '卖方姓名';
COMMENT ON COLUMN BDC_WWYY.ywrzjhm
IS '卖方证件号码';
COMMENT ON COLUMN BDC_WWYY.qlrxm
IS '买方姓名';
COMMENT ON COLUMN BDC_WWYY.qlrzjhm
IS '买方证件号码';
COMMENT ON COLUMN BDC_WWYY.yylxdm
IS '预约类型代码';
COMMENT ON COLUMN BDC_WWYY.yylxmc
IS '预约类型名称';
COMMENT ON COLUMN BDC_WWYY.bjrxm
IS '办件人姓名';
COMMENT ON COLUMN BDC_WWYY.bjsj
IS '办件时间';
--changeset wenyuanwu:9987 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_WWYY
  ADD CONSTRAINT PK_BDC_WWYY PRIMARY KEY (YYID)
  USING INDEX;

--changeset wenyuanwu:3049 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_JFMX
(
  JFMXID   VARCHAR2(32) NOT NULL,
  JFZT     VARCHAR2(2),
  JFMS     VARCHAR2(40),
  JFLX     VARCHAR2(2),
  SHMC     VARCHAR2(40),
  SHBH     VARCHAR2(15),
  ZDBH     VARCHAR2(8),
  JFKH     VARCHAR2(19),
  JFPCH    VARCHAR2(6),
  YJFPCH   VARCHAR2(6),
  JFPZH    VARCHAR2(6),
  YJFPZH   VARCHAR2(6),
  YHJZRQ   DATE,
  JFRQ     DATE,
  JFSJ     DATE,
  JFJE     NUMBER(12, 2),
  KLX      VARCHAR2(1),
  FKZZMC   VARCHAR2(40),
  DDH      VARCHAR2(20),
  JFCKH    VARCHAR2(12),
  SJJFLX   VARCHAR2(20),
  SFXXJGID VARCHAR2(32),
  YWSLBH   VARCHAR2(32),
  QQFJFLX  VARCHAR2(2),
  QQFSHMC  VARCHAR2(40),
  QQFJFJE  NUMBER(12, 2),
  YJFCKH   VARCHAR2(12),
  YJFRQ    DATE
);
COMMENT ON COLUMN BDC_JFMX.JFMXID
IS '缴费明细id';
COMMENT ON COLUMN BDC_JFMX.JFZT
IS '缴费状态:字典项：0为未收费，1为已收费';
COMMENT ON COLUMN BDC_JFMX.JFMS
IS '缴费描述';
COMMENT ON COLUMN BDC_JFMX.JFLX
IS '缴费类型:03为收款,05为退款';
COMMENT ON COLUMN BDC_JFMX.SHMC
IS '商户名称';
COMMENT ON COLUMN BDC_JFMX.SHBH
IS '商户编号';
COMMENT ON COLUMN BDC_JFMX.ZDBH
IS '终端编号';
COMMENT ON COLUMN BDC_JFMX.JFKH
IS '缴费卡号';
COMMENT ON COLUMN BDC_JFMX.JFPCH
IS '缴费批次号';
COMMENT ON COLUMN BDC_JFMX.YJFPCH
IS '原缴费批次号';
COMMENT ON COLUMN BDC_JFMX.JFPZH
IS '缴费凭证号';
COMMENT ON COLUMN BDC_JFMX.YJFPZH
IS '原缴费凭证号:撤销、退货时存在';
COMMENT ON COLUMN BDC_JFMX.YHJZRQ
IS '银行记帐日期';
COMMENT ON COLUMN BDC_JFMX.JFRQ
IS '缴费日期';
COMMENT ON COLUMN BDC_JFMX.JFSJ
IS '缴费时间';
COMMENT ON COLUMN BDC_JFMX.JFJE
IS '缴费金额:撤销、退货时为原交易金额';
COMMENT ON COLUMN BDC_JFMX.KLX
IS '卡类型:0为银联,1为外卡,2为IC卡';
COMMENT ON COLUMN BDC_JFMX.FKZZMC
IS '发卡组织名称';
COMMENT ON COLUMN BDC_JFMX.DDH
IS '订单号';
COMMENT ON COLUMN BDC_JFMX.JFCKH
IS '缴费参考号';
COMMENT ON COLUMN BDC_JFMX.SJJFLX
IS '实际缴费类型:SALE银行卡消费,WEIXINPAY微信消费,ALIPAY支付宝消费,REFUND银行卡退货,WEIXINREFUND微信退货,ALIREFUND支付宝退货';
COMMENT ON COLUMN BDC_JFMX.SFXXJGID
IS '收费信息结果表主键';
COMMENT ON COLUMN BDC_JFMX.YWSLBH
IS '业务受理编号';
COMMENT ON COLUMN BDC_JFMX.QQFJFLX
IS '请求方缴费类型 字典项：03为收款，05为退款';
COMMENT ON COLUMN BDC_JFMX.QQFSHMC
IS '请求方商户名称';
COMMENT ON COLUMN BDC_JFMX.QQFJFJE
IS '请求方缴费金额';
COMMENT ON COLUMN BDC_JFMX.YJFCKH
IS '原缴费参考号';
COMMENT ON COLUMN BDC_JFMX.YJFRQ
IS '原缴费日期';
--changeset wenyuanwu:9989 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JFMX
  ADD CONSTRAINT JYJGPRIMARY PRIMARY KEY (JFMXID)
  USING INDEX;

--changeset wenyuanwu:9990 failOnError:false runOnChange:true runAlways:true
ALTER TABLE PF_WORKFLOWEVENT
  ADD (WORKFLOW_EVENT_ORDER NUMBER(10));
COMMENT ON COLUMN PF_WORKFLOWEVENT.WORKFLOW_EVENT_ORDER IS '执行事件顺序';

--changeset wenyuanwu:3048 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_YZ_LOG
(
  logid VARCHAR2(32) NOT NULL,
  proid VARCHAR2(32),
  bh    VARCHAR2(32),
  csxx  VARCHAR2(1000),
  ipdz  VARCHAR2(100),
  macdz VARCHAR2(100),
  yzx   VARCHAR2(1000),
  yzsj  DATE,
  yzjg  VARCHAR2(1000),
  sftg  NUMBER(1),
  sfyc  NUMBER(1),
  ycxx  VARCHAR2(1000)
);
COMMENT ON TABLE BDC_YZ_LOG
IS '验证日志对象';
COMMENT ON COLUMN BDC_YZ_LOG.logid
IS '主键';
COMMENT ON COLUMN BDC_YZ_LOG.proid
IS '项目ID';
COMMENT ON COLUMN BDC_YZ_LOG.bh
IS '编号';
COMMENT ON COLUMN BDC_YZ_LOG.csxx
IS '参数信息';
COMMENT ON COLUMN BDC_YZ_LOG.ipdz
IS 'ip地址';
COMMENT ON COLUMN BDC_YZ_LOG.macdz
IS 'mac地址';
COMMENT ON COLUMN BDC_YZ_LOG.yzx
IS '验证项';
COMMENT ON COLUMN BDC_YZ_LOG.yzsj
IS '验证时间';
COMMENT ON COLUMN BDC_YZ_LOG.yzjg
IS '验证结果';
COMMENT ON COLUMN BDC_YZ_LOG.sftg
IS '是否通过';
COMMENT ON COLUMN BDC_YZ_LOG.sfyc
IS '是否异常';
COMMENT ON COLUMN BDC_YZ_LOG.ycxx
IS '异常信息';
--changeset wenyuanwu:9991 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YZ_LOG
  ADD CONSTRAINT PK_BDC_YZ_LOG_ID PRIMARY KEY (LOGID)
  USING INDEX;

--changeset wenyuanwu:9992 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_DAMLH
  ADD (SQLXDM VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_DAMLH.SQLXDM IS '申请类型代码';
--changeset wenyuanwu:9993 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_DAMLH
  ADD (BGQX VARCHAR2(50));
COMMENT ON COLUMN BDC_XT_DAMLH.BGQX IS '保管期限';

--changeset wenyuanwu:9994 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_YG
  ADD (FCQDH VARCHAR2(100));
COMMENT ON COLUMN BDC_YG.FCQDH IS '房产丘地号';
--changeset wenyuanwu:9995 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_DYAQ
  ADD (FCQDH VARCHAR2(100));
COMMENT ON COLUMN BDC_DYAQ.FCQDH IS '房产丘地号';
--changeset wenyuanwu:9996 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XWBL
  ADD (SFFBCZ NUMBER(1));
COMMENT ON COLUMN BDC_XWBL.SFFBCZ IS '是否分别持证（是或否）';
--changeset wenyuanwu:9997 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (CWFPH VARCHAR2(50));
COMMENT ON COLUMN BDC_SFXX.CWFPH IS '财务发票号';
--changeset wenyuanwu:9998 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXX
  ADD (ZDZHMJ NUMBER(20, 4));
COMMENT ON COLUMN BDC_SFXX.ZDZHMJ IS '宗地宗海面积';
--changeset wenyuanwu:9999 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_SFXM
  ADD (SFJZJF VARCHAR2(2));
COMMENT ON COLUMN BDC_SFXM.SFJZJF IS '是否集中缴费0不是，1是集中缴费';
--changeset wenyuanwu:3000 failOnError:false runOnChange:true runAlways:true
-----2019-4-17 zx  GD_TDSYQ、BDC_JSYDZJDSYQ表增加是否拆除
ALTER TABLE GD_TDSYQ
  ADD (SFCC VARCHAR2(2));
COMMENT ON COLUMN GD_TDSYQ.SFCC IS '是否拆除';
--changeset wenyuanwu:3001 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_JSYDZJDSYQ
  ADD (SFCC VARCHAR2(2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.SFCC IS '是否拆除';

--changeset wenyuanwu:3002 failOnError:false runOnChange:true runAlways:true
-----2019-4-17 zx  GD_CF、BDC_CF表增加限制查封编号
ALTER TABLE GD_CF
  ADD (XZCFBH VARCHAR2(50));
COMMENT ON COLUMN GD_CF.XZCFBH IS '限制查封编号';
--changeset wenyuanwu:3003 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_CF
  ADD (XZCFBH VARCHAR2(50));
COMMENT ON COLUMN BDC_CF.XZCFBH IS '限制查封编号';
--changeset wenyuanwu:3004 failOnError:false runOnChange:true runAlways:true
-----2019-4-17 zx  GD_FW_QL、BDC_TD_QL表增加限制查封编号
ALTER TABLE GD_FW_QL
  ADD (XZCFBH VARCHAR2(50));
COMMENT ON COLUMN GD_FW_QL.XZCFBH IS '限制查封编号';
--changeset wenyuanwu:3005 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_TD_QL
  ADD (XZCFBH VARCHAR2(50));
COMMENT ON COLUMN GD_TD_QL.XZCFBH IS '限制查封编号';
--changeset wenyuanwu:3006 failOnError:false runOnChange:true runAlways:true
-----2019-4-17 zx  BDC_ZSBH表增加领取人id1、领取时间1、领取人1
ALTER TABLE BDC_ZSBH
  ADD (LQR1 VARCHAR2(50));
COMMENT ON COLUMN BDC_ZSBH.LQR1 IS '领取人1';
--changeset wenyuanwu:3007 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (LQSJ1 DATE);
COMMENT ON COLUMN BDC_ZSBH.LQSJ1 IS '领取时间1';
--changeset wenyuanwu:3008 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZSBH
  ADD (LQRID1 VARCHAR2(50));
COMMENT ON COLUMN BDC_ZSBH.LQRID1 IS '领取人id1';

--changeset wenyuanwu:3009 failOnError:false runOnChange:true runAlways:true
--2019-4-24 zx BDC_XYMX新增字段
ALTER TABLE BDC_XYMX
  ADD CFWH VARCHAR2(50);
--changeset wenyuanwu:3010 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.CFWH IS '查封文号';
ALTER TABLE BDC_XYMX
  ADD CFJG VARCHAR2(50);
--changeset wenyuanwu:3011 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.CFJG IS '查封机关';
ALTER TABLE BDC_XYMX
  ADD FBR VARCHAR2(50);
--changeset wenyuanwu:3012 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.FBR IS '发布人';
ALTER TABLE BDC_XYMX
  ADD FBSJ DATE;
--changeset wenyuanwu:3013 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.FBSJ IS '发布时间';
ALTER TABLE BDC_XYMX
  ADD FBZT VARCHAR2(1);
--changeset wenyuanwu:3014 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.FBZT IS '发布状态 0：未发布 1：已发布';
ALTER TABLE BDC_XYMX
  ADD SXDQSJ DATE;
--changeset wenyuanwu:3015 failOnError:false runOnChange:true runAlways:true
COMMENT ON COLUMN BDC_XYMX.SXDQSJ IS '失效到期时间';

--changeset wenyuanwu:3047 failOnError:false runOnChange:true runAlways:true
--2019-4-24 sly 新增记录上报全生命周期记录日志表
CREATE TABLE EXCHANGE_ACCESS_LOG
(
  PROID         VARCHAR2(50) NOT NULL
    PRIMARY KEY,
  YWH           VARCHAR2(50) NOT NULL,
  CJSJ          DATE,
  SFSB          VARCHAR2(6)    DEFAULT NULL,
  BWXML         CLOB,
  SUCCESSFLAG   VARCHAR2(2),
  RESPONSECODE  VARCHAR2(50),
  RESPONSEINFO  VARCHAR2(300),
  ACCESSSDATE   DATE,
  SBSERVICE     VARCHAR2(100),
  PSUCCESSFLAG  VARCHAR2(2),
  PRESPONSECODE VARCHAR2(50),
  PRESPONSEINFO VARCHAR2(1500) DEFAULT NULL
);
COMMENT ON TABLE EXCHANGE_ACCESS_LOG IS '上报全生命周期日志';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.PROID IS '登记业务id';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.YWH IS '业务号';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.CJSJ IS '创建时间';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.SFSB IS '是否上报';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.BWXML IS '报文xml，默认加到文件中心';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.SUCCESSFLAG IS '上报成功标志';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.RESPONSECODE IS '响应报文';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.RESPONSEINFO IS '报文响应信息';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.ACCESSSDATE IS '上报时间';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.SBSERVICE IS '上报对应service';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.PSUCCESSFLAG IS '省级上报成功标志';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.PRESPONSECODE IS '省级上报返回报文代码';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG.PRESPONSEINFO IS '省级上报响应信息';
CREATE TABLE EXCHANGE_ACCESS_LOG_NODE
(
  NODEID       VARCHAR2(50) NOT NULL
    PRIMARY KEY,
  NODENAME     VARCHAR2(50) NOT NULL,
  PROID        VARCHAR2(50) NOT NULL,
  KSSJ         DATE,
  JSSJ         DATE,
  SUCCESSFLAG  VARCHAR2(2),
  RESPONSEINFO VARCHAR2(2500) DEFAULT NULL
);
COMMENT ON TABLE EXCHANGE_ACCESS_LOG_NODE IS '全生命周期日志子节点信息';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.NODEID IS '节点主键';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.NODENAME IS '节点名称';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.PROID IS '业务主键';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.KSSJ IS '节点触发时间';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.JSSJ IS '节点结束时间';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.SUCCESSFLAG IS '成功标志';
COMMENT ON COLUMN EXCHANGE_ACCESS_LOG_NODE.RESPONSEINFO IS '返回信息';

--2019-4-24 ccx 日志表增加字段
--changeset wenyuanwu:3016 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GZJCLOG
  ADD XZWHID VARCHAR2(100);
--changeset wenyuanwu:3017 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GZJCLOG
  ADD GQSJ DATE;
--changeset wenyuanwu:3018 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_GZJCLOG
  ADD GQYY VARCHAR2(255);
-- Add comments to the columns
COMMENT ON COLUMN BDC_GZJCLOG.GQSJ
IS '挂起时间';
COMMENT ON COLUMN BDC_GZJCLOG.GQYY
IS '挂起原因';

--2019-4-24 ccx 规则等级字段表
-- Create table
CREATE TABLE BDC_ZD_GZDJ
(
  DM VARCHAR2(10) NOT NULL,
  MC VARCHAR2(50),
  SM VARCHAR2(100)
);
-- Add comments to the columns
COMMENT ON COLUMN BDC_ZD_GZDJ.DM IS '代码';
COMMENT ON COLUMN BDC_ZD_GZDJ.MC IS '名称';
COMMENT ON COLUMN BDC_ZD_GZDJ.SM IS '等级说明';
-- Create/Recreate primary, unique and foreign key constraints
ALTER TABLE BDC_ZD_GZDJ
  ADD CONSTRAINT PK_BDC_ZD_GZDJ PRIMARY KEY (DM);

--changeset wenyuanwu:3019 failOnError:false runOnChange:true runAlways:true
--2019-4-24 ccx 增加挂起原因字段
ALTER TABLE BDC_GZJCLOG
  ADD GQYY VARCHAR2(500);
COMMENT ON COLUMN BDC_GZJCLOG.GQYY IS '挂起原因';

--2019-4-24 ccx 原因及解决方案表
--changeset wenyuanwu:3045 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_GZ_YYJJFA
(
  ID   VARCHAR2(32) NOT NULL,
  GZID VARCHAR2(32),
  KNYY VARCHAR2(4000),
  JJFA VARCHAR2(4000)
);
COMMENT ON COLUMN BDC_GZ_YYJJFA.ID IS '主键';
COMMENT ON COLUMN BDC_GZ_YYJJFA.GZID IS '规则主键';
COMMENT ON COLUMN BDC_GZ_YYJJFA.KNYY IS '可能原因';
COMMENT ON COLUMN BDC_GZ_YYJJFA.JJFA IS '解决方案';
-- Create/Recreate primary, unique and foreign key constraints
ALTER TABLE BDC_GZ_YYJJFA
  ADD CONSTRAINT PK_BDC_GZ_YYJJFA_ID PRIMARY KEY (ID);

--changeset wenyuanwu:3046 failOnError:false runOnChange:true runAlways:true
-----2019-04-25 zx 领证方式字典表
CREATE TABLE BDC_ZD_LZFS
(
  dm VARCHAR2(10),
  mc VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_LZFS
IS '领证方式字典表';

--changeset wenyuanwu:3020 failOnError:false runOnChange:true runAlways:true
-----2019-04-25 zx BDC_XM领证方式
ALTER TABLE BDC_XM
  ADD (LZFS VARCHAR2(2));
COMMENT ON COLUMN BDC_XM.LZFS IS '领证方式';

--changeset wenyuanwu:3021 failOnError:false runOnChange:true runAlways:true
-----2019-04-28 sc GD_FWSYQ房产证号房屋编号、拆分前权利ID
ALTER TABLE GD_FWSYQ
  ADD (FCZHFWBH VARCHAR2(100));
--changeset wenyuanwu:3022 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (CFQQLID VARCHAR2(32));
--changeset wenyuanwu:3023 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_FWSYQ
  ADD (SFXMNDZ NUMBER(1));
COMMENT ON COLUMN GD_FWSYQ.FCZHFWBH IS '房产证号房屋编号';
COMMENT ON COLUMN GD_FWSYQ.CFQQLID IS '拆分前权利ID';
COMMENT ON COLUMN GD_FWSYQ.SFXMNDZ IS '项目内多幢';
--changeset wenyuanwu:3024 failOnError:false runOnChange:true runAlways:true
-----2019-04-28 sc GD_DY抵押登记证明号房屋编号、拆分前权利ID
ALTER TABLE GD_DY
  ADD (DYDJZMHFWBH VARCHAR2(100));
--changeset wenyuanwu:3025 failOnError:false runOnChange:true runAlways:true
ALTER TABLE GD_DY
  ADD (CFQQLID VARCHAR2(32));
COMMENT ON COLUMN GD_DY.DYDJZMHFWBH IS '抵押登记证明号房屋编号';
COMMENT ON COLUMN GD_DY.CFQQLID IS '拆分前权利ID';
--changeset wenyuanwu:3026 failOnError:false runOnChange:true runAlways:true
-----2019-04-28 sc GD_FW主房房屋编号
ALTER TABLE GD_FW
  ADD (ZFFWBH VARCHAR2(100));
COMMENT ON COLUMN GD_FW.ZFFWBH IS '主房房屋编号';

--changeset wenyuanwu:3027 failOnError:false runOnChange:true runAlways:true
-----2019-05-1 sc BDC_ZS设备编号
ALTER TABLE BDC_ZS
  ADD (SBBH VARCHAR2(100));
COMMENT ON COLUMN BDC_ZS.SBBH IS '设备编号';
--changeset wenyuanwu:3028 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_yg
  ADD (fwpgjg NUMBER(20, 4));
COMMENT ON COLUMN bdc_yg.fwpgjg IS '房屋评估价格';
--changeset wenyuanwu:3029 failOnError:false runOnChange:true runAlways:true
ALTER TABLE bdc_yg
  ADD (tdpgjg NUMBER(20, 4));
COMMENT ON COLUMN bdc_yg.tdpgjg IS '土地评估价格';

--changeset wenyuanwu:3030 failOnError:false runOnChange:true runAlways:true
-----2019-05-20 liujie BDC_SFXX_JG表增加票据唯一标识码
ALTER TABLE BDC_SFXX_JG
  ADD (PJWYBSM VARCHAR2(20));
COMMENT ON COLUMN BDC_SFXX_JG.PJWYBSM IS '票据唯一标识码';
---修改bdc_zs表字段长度
--changeset wenyuanwu:3031 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY syqx VARCHAR2(200);
--changeset wenyuanwu:3032 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY zl VARCHAR2(2000);
--changeset wenyuanwu:3033 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY qlr VARCHAR2(2000);
--changeset wenyuanwu:3034 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY ywr VARCHAR2(2000);
--changeset wenyuanwu:3035 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY yt VARCHAR2(200);
--changeset wenyuanwu:3036 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY mj VARCHAR2(200);
--changeset wenyuanwu:3037 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY qlrzjh VARCHAR2(2000);
--changeset wenyuanwu:3038 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY ywrzjh VARCHAR2(2000);
--changeset wenyuanwu:3039 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY fj VARCHAR2(4000);
--changeset wenyuanwu:3040 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY bdcdyh VARCHAR2(2000);
--changeset wenyuanwu:3041 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  MODIFY qlqtzk VARCHAR2(4000);

--changeset wenyuanwu:3042 failOnError:false runOnChange:true runAlways:true
-- 2019-5-27 sly登记系统exchang默认值配置表：
CREATE TABLE BDC_EXCHANGE_DEFAULT_VALUE
(
  TABLE_NAME   VARCHAR2(50)  NOT NULL,
  WDID         VARCHAR2(100),
  FIELDNAME    VARCHAR2(100) NOT NULL,
  DEFAULTVALUE VARCHAR2(100) NOT NULL
);
COMMENT ON TABLE BDC_EXCHANGE_DEFAULT_VALUE IS '上报默认值字段配置';
COMMENT ON COLUMN BDC_EXCHANGE_DEFAULT_VALUE.TABLE_NAME IS '表名';
COMMENT ON COLUMN BDC_EXCHANGE_DEFAULT_VALUE.WDID IS '流程id(可为空)';
COMMENT ON COLUMN BDC_EXCHANGE_DEFAULT_VALUE.FIELDNAME IS '字段名称';
COMMENT ON COLUMN BDC_EXCHANGE_DEFAULT_VALUE.DEFAULTVALUE IS '默认值';
CREATE INDEX BDCABLENAME
  ON BDC_EXCHANGE_DEFAULT_VALUE (TABLE_NAME);
--changeset wenyuanwu:3043 failOnError:false runOnChange:true runAlways:true
-- 2019-5-30 zx 登记系统exchang默认值配置表：
CREATE TABLE BDC_FPH
(
  FPHID VARCHAR2(32) NOT NULL,
  FPH   VARCHAR2(40) NOT NULL,
  DWDM  VARCHAR2(40),
  SYQK  VARCHAR2(2),
  CJR   VARCHAR2(50),
  CJRID VARCHAR2(32),
  CJSJ  DATE,
  LQR   VARCHAR2(50),
  LQRID VARCHAR2(32),
  LQSJ  DATE,
  BZ    VARCHAR2(100)
);
COMMENT ON COLUMN BDC_FPH.FPHID
IS '发票号id';
COMMENT ON COLUMN BDC_FPH.FPH
IS '发票号';
COMMENT ON COLUMN BDC_FPH.DWDM
IS '单位代码';
COMMENT ON COLUMN BDC_FPH.SYQK
IS '0：未领用3：已使用2：作废';
COMMENT ON COLUMN BDC_FPH.CJR
IS '创建人';
COMMENT ON COLUMN BDC_FPH.CJRID
IS '创建人ID';
COMMENT ON COLUMN BDC_FPH.CJSJ
IS '创建时间';
COMMENT ON COLUMN BDC_FPH.LQR
IS '领取人';
COMMENT ON COLUMN BDC_FPH.LQRID
IS '领取人ID';
COMMENT ON COLUMN BDC_FPH.LQSJ
IS '领取时间';
COMMENT ON COLUMN BDC_FPH.BZ
IS '备注';
ALTER TABLE BDC_FPH
  ADD CONSTRAINT FPHID_PRI PRIMARY KEY (FPHID);
ALTER TABLE BDC_FPH
  ADD CONSTRAINT FPH_UNI UNIQUE (FPH);
--changeset wenyuanwu:3044 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_FPHSYMX
(
  FPHSYMXID VARCHAR2(32) NOT NULL,
  FPH       VARCHAR2(40),
  SYR       VARCHAR2(50),
  SYRID     VARCHAR2(32),
  SYSJ      DATE,
  SYYY      VARCHAR2(100)
);
COMMENT ON COLUMN BDC_FPHSYMX.FPHSYMXID
IS '发票号使用明细id';
COMMENT ON COLUMN BDC_FPHSYMX.FPH
IS '发票号';
COMMENT ON COLUMN BDC_FPHSYMX.SYR
IS '使用人';
COMMENT ON COLUMN BDC_FPHSYMX.SYRID
IS '使用人id';
COMMENT ON COLUMN BDC_FPHSYMX.SYSJ
IS '使用时间';
COMMENT ON COLUMN BDC_FPHSYMX.SYYY
IS '使用原因';
ALTER TABLE BDC_FPHSYMX
  ADD CONSTRAINT SYMX_PRI PRIMARY KEY (FPHSYMXID);

--2019-6-27 sly登记库更新：
--changeset wenyuanwu:10001 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_EXCHANGE_DEFAULT_VALUE
  ADD djzx VARCHAR2(100);
COMMENT ON COLUMN BDC_EXCHANGE_DEFAULT_VALUE.djzx IS '登记子项(可为空，不为空时流程id必须不为空)';
--2019-7-1 不动产出让合同：
--changeset wenyuanwu:10002 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_Crht
(
  proid   VARCHAR2(50),
  sfhbzcr VARCHAR2(10),
  nf      VARCHAR2(10),
  lsh     VARCHAR2(10),
  dldj    VARCHAR2(10),
  tdyt    VARCHAR2(10),
  mpmjg   NUMBER(10, 4),
  jfbl    NUMBER(10, 2),
  mpmsfje NUMBER(10, 4),
  zsfje   NUMBER(10, 4)
);
COMMENT ON TABLE BDC_Crht IS '不动产出让合同';
COMMENT ON COLUMN BDC_Crht.proid IS '项目id';
COMMENT ON COLUMN BDC_Crht.sfhbzcr IS '是否划拨转出让（是、否）';
COMMENT ON COLUMN BDC_Crht.nf IS '年份';
COMMENT ON COLUMN BDC_Crht.lsh IS '流水号';
COMMENT ON COLUMN BDC_Crht.dldj IS '地类等级';
COMMENT ON COLUMN BDC_Crht.tdyt IS '土地用途';
COMMENT ON COLUMN BDC_Crht.mpmjg IS '每平方米价格';
COMMENT ON COLUMN BDC_Crht.jfbl IS '缴费比例';
COMMENT ON COLUMN BDC_Crht.mpmsfje IS '每平方米收费金额';
COMMENT ON COLUMN BDC_Crht.zsfje IS '总收费金额';
ALTER TABLE BDC_Crht
  ADD CONSTRAINT PK_BDC_Crht PRIMARY KEY (PROID);

--changeset wenyuanwu:10003 failOnError:false runOnChange:true runAlways:true
CREATE TABLE BDC_ZD_TdCRSF
(
  id      VARCHAR2(50),
  dldj    VARCHAR2(10),
  tdyt    VARCHAR2(10),
  mpmjg   NUMBER(10, 4),
  jfbl    NUMBER(10, 2),
  mpmsfje NUMBER(10, 4)
);
COMMENT ON TABLE BDC_ZD_TdCRSF IS '不动产土地出让收费字典表';
COMMENT ON COLUMN BDC_ZD_TdCRSF.id IS 'id';
COMMENT ON COLUMN BDC_ZD_TdCRSF.dldj IS '地类等级';
COMMENT ON COLUMN BDC_ZD_TdCRSF.tdyt IS '土地用途';
COMMENT ON COLUMN BDC_ZD_TdCRSF.mpmjg IS '每平方米价格';
COMMENT ON COLUMN BDC_ZD_TdCRSF.jfbl IS '缴费比例';
COMMENT ON COLUMN BDC_ZD_TdCRSF.mpmsfje IS '每平方米收费金额';

-----2019-07-03 sc BDC_XT_YH银行信息
--changeset wenyuanwu:10004 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (YHFRZJZL VARCHAR2(10));
COMMENT ON COLUMN BDC_XT_YH.YHFRZJZL IS '银行法人证件种类';
--changeset wenyuanwu:10005 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (YHFRZJH VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.YHFRZJH IS '银行法人证件号';
--changeset wenyuanwu:10006 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XT_YH
  ADD (YHFRDH VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.YHFRDH IS '银行法人电话';
-----2019-07-04 liujie BDC_XM表增加YBDCQZMH字段
--changeset wenyuanwu:10007 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_XM
  ADD (YBDCQZMH VARCHAR2(1000));
COMMENT ON COLUMN BDC_XM.YBDCQZMH IS '原不动产权证明号';
-----2019-07-04 sc BDC_ZS表增加ZZBS字段
--changeset wenyuanwu:10008 failOnError:false runOnChange:true runAlways:true
ALTER TABLE BDC_ZS
  ADD (ZZBS VARCHAR2(100));
COMMENT ON COLUMN BDC_ZS.ZZBS IS '证照标示';

--处理过渡库gd_td表qsrq、zzrq字段类型不是公司标准的问题
--alter table gd_td modify qsrq4 varchar2(100);
--alter table gd_td modify zzrq4 varchar2(100);
--update gd_td set qsrq4= to_char(qsrq,'yyyy-MM-dd'), zzrq4=to_char(zzrq,'yyyy-MM-dd');
--commit;
--update gd_td set qsrq=null,zzrq=null;
--commit;
--ALTER TABLE gd_td modify(qsrq VARCHAR2(100));
--ALTER TABLE gd_td modify(zzrq VARCHAR2(100));
--update gd_td set qsrq= qsrq4, zzrq=zzrq4;
--commit;
--alter table gd_td drop column qsrq4;
--alter table gd_td drop column zzrq4;


--富平电子证照表
CREATE TABLE BDC_DZZZ
(
  ZZID     VARCHAR2(32) NOT NULL,
  ZSID     VARCHAR2(32) NOT NULL,
  ZSTYPE   VARCHAR2(50),
  FZRQ     DATE,
  BDCQZH   VARCHAR2(100),
  YEAR     VARCHAR2(10),
  MONTH    VARCHAR2(10),
  DAY      VARCHAR2(10),
  ZZBH     VARCHAR2(50),
  ZSBH     VARCHAR2(50),
  NF       VARCHAR2(10),
  SQSJC    VARCHAR2(50),
  SZSXQC   VARCHAR2(50),
  ZHLSH    VARCHAR2(50),
  QLR      VARCHAR2(500),
  GYQK     VARCHAR2(50),
  ZL       VARCHAR2(100),
  BDCDYH   VARCHAR2(50),
  QLLX     VARCHAR2(50),
  QLXZ     VARCHAR2(50),
  YT       VARCHAR2(200),
  MJ       VARCHAR2(200),
  SYQX     VARCHAR2(200),
  QLQTZK   VARCHAR2(4000),
  FJ       VARCHAR2(4000),
  ZZQZLJ   VARCHAR2(100),
  YWR      VARCHAR2(500),
  ZMQLSXMC VARCHAR2(50),
  EWMNR    VARCHAR2(200),
  PROID    VARCHAR2(32),
  BH       VARCHAR2(32)
);
COMMENT ON COLUMN BDC_DZZZ.ZZID
IS '主键';
COMMENT ON COLUMN BDC_DZZZ.ZSID
IS '证书id';
COMMENT ON COLUMN BDC_DZZZ.ZSTYPE
IS '区分记录是证明还是证书';
COMMENT ON COLUMN BDC_DZZZ.FZRQ
IS '发证日期';
COMMENT ON COLUMN BDC_DZZZ.BDCQZH
IS '不动产权证号';
COMMENT ON COLUMN BDC_DZZZ.YEAR
IS '发证日期年';
COMMENT ON COLUMN BDC_DZZZ.MONTH
IS '发证日期月';
COMMENT ON COLUMN BDC_DZZZ.DAY
IS '发证日期日';
COMMENT ON COLUMN BDC_DZZZ.ZZBH
IS '证照编号';
COMMENT ON COLUMN BDC_DZZZ.ZSBH
IS '证书编号';
COMMENT ON COLUMN BDC_DZZZ.NF
IS '年份';
COMMENT ON COLUMN BDC_DZZZ.SQSJC
IS '省区市简称';
COMMENT ON COLUMN BDC_DZZZ.SZSXQC
IS '所在市县全称';
COMMENT ON COLUMN BDC_DZZZ.ZHLSH
IS '证号流水号';
COMMENT ON COLUMN BDC_DZZZ.QLR
IS '权利人';
COMMENT ON COLUMN BDC_DZZZ.GYQK
IS '共有情况';
COMMENT ON COLUMN BDC_DZZZ.ZL
IS '坐落';
COMMENT ON COLUMN BDC_DZZZ.BDCDYH
IS '不动产单元号';
COMMENT ON COLUMN BDC_DZZZ.QLLX
IS '权利类型';
COMMENT ON COLUMN BDC_DZZZ.QLXZ
IS '权利性质';
COMMENT ON COLUMN BDC_DZZZ.YT
IS '用途';
COMMENT ON COLUMN BDC_DZZZ.MJ
IS '面积';
COMMENT ON COLUMN BDC_DZZZ.SYQX
IS '使用期限';
COMMENT ON COLUMN BDC_DZZZ.QLQTZK
IS '权利其他状况';
COMMENT ON COLUMN BDC_DZZZ.FJ
IS '附记';
COMMENT ON COLUMN BDC_DZZZ.ZZQZLJ
IS '证照路径';
COMMENT ON COLUMN BDC_DZZZ.YWR
IS '义务人';
COMMENT ON COLUMN BDC_DZZZ.ZMQLSXMC
IS '证明权利或事项';
COMMENT ON COLUMN BDC_DZZZ.EWMNR
IS '二维码内容';
COMMENT ON COLUMN BDC_DZZZ.BH
IS '编号';
ALTER TABLE BDC_DZZZ
  ADD CONSTRAINT BDC_DZZZ_PK PRIMARY KEY (ZZID);

-----2019-07-18 sc BDC_FDCQ、BDC_FDCQ_DZ表增加SFJCKH字段
ALTER TABLE BDC_FDCQ
  ADD (SFJCKH VARCHAR2(10));
COMMENT ON COLUMN BDC_FDCQ.SFJCKH IS '是否继承空户 0不继承，1继承';
ALTER TABLE BDC_FDCQ_DZ
  ADD (SFJCKH VARCHAR2(10));
COMMENT ON COLUMN BDC_FDCQ_DZ.SFJCKH IS '是否继承空户 0不继承，1继承';

-----2019-07-24 liujie BDC_FWZL表增加ZLMJ字段
ALTER TABLE BDC_FWZL
  ADD (ZLMJ NUMBER(15, 2));
COMMENT ON COLUMN BDC_FWZL.ZLMJ IS '租赁面积';
ALTER TABLE BDC_FWZL
  ADD (QLQTZK VARCHAR2(1000));
COMMENT ON COLUMN BDC_FWZL.QLQTZK IS '权利其他状况';

-----2019-07-29 jiangganzhi BDC_XM表增加SBJYWH字段
ALTER TABLE BDC_XM
  ADD (SBJYWH VARCHAR2(50));
COMMENT ON COLUMN BDC_XM.SBJYWH IS '自助申报机业务号';

-----2019-07-18 sc 新增不动产法院配置表
CREATE TABLE BDC_XT_FY
(
  fyid VARCHAR2(32) NOT NULL,
  fymc VARCHAR2(200),
  zjlx VARCHAR2(10),
  zjbh VARCHAR2(100),
  bz   VARCHAR2(1000)
);
COMMENT ON TABLE BDC_XT_FY
IS '不动产法院';
-- Add comments to the columns
COMMENT ON COLUMN BDC_XT_FY.fyid
IS '法院id';
COMMENT ON COLUMN BDC_XT_FY.fymc
IS '法院名称';
COMMENT ON COLUMN BDC_XT_FY.zjlx
IS '证件类型';
COMMENT ON COLUMN BDC_XT_FY.zjbh
IS '证件编号';
COMMENT ON COLUMN BDC_XT_FY.bz
IS '备注';
ALTER TABLE BDC_XT_FY
  ADD CONSTRAINT BDC_XT_FY_PR PRIMARY KEY (FYID);

--2019-7-31 sunchao
ALTER TABLE BDC_GDXX
  ADD (GXZT VARCHAR2(2));
COMMENT ON COLUMN BDC_GDXX.GXZT IS '更新状态';

------------2019-8-16,不动产权利人、义务人  视图增加联系电话修改-张宇
CREATE OR REPLACE VIEW mergeproid_bdc_qlr AS
  SELECT
    b.proid,
    strcat(to_char(b.qlrmc))              AS qlr,
    strcat(to_char(CASE WHEN j.mc IS NOT NULL
      THEN j.mc
                   ELSE b.qlrsfzjzl END)) AS qlrsfzjzl,
    strcat(to_char(b.qlrzjh))             AS qlrzjh,
    strcat(to_char(q.mc))                 AS QLRXZ,
    strcat(to_char(b.qlrlxdh))            AS qlrlxdh
  FROM (SELECT *
        FROM bdc_qlr
        ORDER BY sxh) b
    LEFT JOIN BDC_ZD_ZJLX j ON j.dm = b.qlrsfzjzl
    LEFT JOIN bdc_zd_qlrxz q ON q.dm = b.qlrxz
  WHERE b.qlrlx = 'qlr'
  GROUP BY b.proid;
CREATE OR REPLACE VIEW mergeproid_bdc_ywr AS
  SELECT
    b.proid,
    strcat(DISTINCT to_char(b.qlrmc))     AS qlr,
    strcat(to_char(CASE WHEN j.mc IS NOT NULL
      THEN j.mc
                   ELSE b.qlrsfzjzl END)) AS qlrsfzjzl,
    strcat(DISTINCT to_char(b.qlrzjh))    AS qlrzjh,
    strcat(to_char(b.QLRXZ))              AS QLRXZ,
    strcat(to_char(b.qlrlxdh))            AS qlrlxdh
  FROM (SELECT *
        FROM bdc_qlr
        ORDER BY proid, sxh) b
    LEFT JOIN BDC_ZD_ZJLX j ON j.dm = b.qlrsfzjzl
  WHERE b.qlrlx = 'ywr'
  GROUP BY b.proid;

-----2019-08-20 jiangganzhi BDC_FDCQ、BDC_FDCQ_DZ新增限制转让期限字段、限制转让登簿时间
ALTER TABLE bdc_fdcq
  ADD (XZZRDBSJ DATE);
COMMENT ON COLUMN bdc_fdcq.XZZRDBSJ IS '限制转让登簿时间';
ALTER TABLE bdc_fdcq
  ADD (XZZRNX NUMBER);
COMMENT ON COLUMN BDC_FDCQ.XZZRNX IS '限制转让年限';

ALTER TABLE bdc_fdcq_dz
  ADD (XZZRDBSJ DATE);
COMMENT ON COLUMN bdc_fdcq_dz.XZZRDBSJ IS '限制转让登簿时间';
ALTER TABLE bdc_fdcq_dz
  ADD (XZZRNX NUMBER);
COMMENT ON COLUMN bdc_fdcq_dz.XZZRNX IS '限制转让年限';

--2019-8-21  zhangyu  新增打证终端
ALTER TABLE bdc_zs
  ADD (dzzd VARCHAR2(2));
COMMENT ON COLUMN bdc_zs.dzzd IS '打证终端（0或空为局方人员，1为自助打证机）';

--2019-8-22  zhengqi  新增撤销状态
ALTER TABLE bdc_fdcq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN BDC_FDCQ.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_fdcq_dz
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_fdcq_dz.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_jsydzjdsyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_jsydzjdsyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_tdsyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_tdsyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_tdcbnydsyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_tdcbnydsyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE BDC_QTXGQL
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN BDC_QTXGQL.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_jzwsyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_jzwsyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_hysyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_hysyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_dyq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_dyq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_cf
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_cf.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_dyaq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_dyaq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_yg
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_yg.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_yy
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_yy.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';
ALTER TABLE bdc_lq
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN bdc_lq.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';

--增加移民搬迁户
CREATE TABLE BDC_QLRBQH
(
  qlrid  VARCHAR2(32) NOT NULL,
  zm     VARCHAR2(10),
  cm     VARCHAR2(10),
  qlrmc  VARCHAR2(50),
  xszcrs NUMBER,
  yhzgx  VARCHAR2(10),
  sfzjh  VARCHAR2(20),
  bqnd   VARCHAR2(10),
  azfs   VARCHAR2(15),
  qrd    VARCHAR2(50),
  sfsc   VARCHAR2(10),
  bqlx   VARCHAR2(30),
  zlgjz  VARCHAR2(20),
  zlgjz2 VARCHAR2(20),
  zlgjz3 VARCHAR2(20),
  bz     VARCHAR2(100)
);
COMMENT ON COLUMN BDC_QLRBQH.qlrid
IS '主键';
COMMENT ON COLUMN BDC_QLRBQH.zm
IS '镇名';
COMMENT ON COLUMN BDC_QLRBQH.cm
IS '村名';
COMMENT ON COLUMN BDC_QLRBQH.qlrmc
IS '姓名';
COMMENT ON COLUMN BDC_QLRBQH.xszcrs
IS '实际享受政策人口';
COMMENT ON COLUMN BDC_QLRBQH.yhzgx
IS '与户主关系';
COMMENT ON COLUMN BDC_QLRBQH.sfzjh
IS '身份证件号';
COMMENT ON COLUMN BDC_QLRBQH.bqnd
IS '搬迁年度';
COMMENT ON COLUMN BDC_QLRBQH.azfs
IS '安置方式';
COMMENT ON COLUMN BDC_QLRBQH.qrd
IS '迁入地';
COMMENT ON COLUMN BDC_QLRBQH.sfsc
IS '是否为‘双超’整改户';
COMMENT ON COLUMN BDC_QLRBQH.bqlx
IS '搬迁类型';
COMMENT ON COLUMN BDC_QLRBQH.zlgjz
IS '迁入地坐落关键字';
COMMENT ON COLUMN BDC_QLRBQH.zlgjz2
IS '迁入地坐落关键字2';
COMMENT ON COLUMN BDC_QLRBQH.zlgjz3
IS '迁入地坐落关键字3';
COMMENT ON COLUMN BDC_QLRBQH.bz
IS '备注';
ALTER TABLE BDC_QLRBQH
  ADD CONSTRAINT PK_QLRID PRIMARY KEY (QLRID);

--2019-8-30 沈飞
ALTER TABLE BDC_ZDPJJL
  ADD (xnpjsl NUMBER(10));
COMMENT ON COLUMN BDC_ZDPJJL.xnpjsl IS '虚拟派件数量';
ALTER TABLE BDC_ZDPJJL
  RENAME COLUMN pjsl TO sjpjsl;
COMMENT ON COLUMN BDC_ZDPJJL.sjpjsl IS '实际派件数量';
ALTER TABLE BDC_ZDPJJL
  MODIFY xnpjsl DEFAULT 0;

ALTER TABLE pf_workflowevent
  ADD (TARGET_ACTIVITY_DEFINITION_ID NVARCHAR2(32));
COMMENT ON COLUMN pf_workflowevent.TARGET_ACTIVITY_DEFINITION_ID IS '目标流程节点ID';
ALTER TABLE pf_workflowevent
  ADD (TARGET_ACTIVITY_DEFINITIONNAME NVARCHAR2(32));
COMMENT ON COLUMN pf_workflowevent.TARGET_ACTIVITY_DEFINITIONNAME IS '目标流程节点名称';

-- Create table
CREATE TABLE BDC_ZDPJJL_ALL
(
  pjjlid VARCHAR2(32) NOT NULL,
  yhid   VARCHAR2(32),
  yhmc   VARCHAR2(100),
  pjsl   NUMBER(10)  DEFAULT 0,
  pjsx   NUMBER(10)  DEFAULT 1,
  kqzt   VARCHAR2(2) DEFAULT 1

);
-- Add comments to the table
COMMENT ON TABLE BDC_ZDPJJL_ALL
IS '自动派件记录(不区分流程、节点)';
-- Add comments to the columns
COMMENT ON COLUMN BDC_ZDPJJL_ALL.pjjlid
IS '派件记录id';
COMMENT ON COLUMN BDC_ZDPJJL_ALL.yhid
IS '用户id';
COMMENT ON COLUMN BDC_ZDPJJL_ALL.yhmc
IS '用户名称';
COMMENT ON COLUMN BDC_ZDPJJL_ALL.pjsl
IS '派件数量';
COMMENT ON COLUMN BDC_ZDPJJL_ALL.pjsx
IS '派件顺序';
COMMENT ON COLUMN BDC_ZDPJJL_ALL.kqzt
IS '考勤状态';

-- Create/Recreate primary, unique and foreign key constraints
ALTER TABLE BDC_ZDPJJL_ALL
  ADD CONSTRAINT PK_BDC_ZDPJJL_ALL_KEY PRIMARY KEY (PJJLID);

ALTER TABLE BDC_ZDPJJL_ALL
  ADD (xnpjsl NUMBER(10));
COMMENT ON COLUMN BDC_ZDPJJL_ALL.xnpjsl IS '虚拟派件数量';
ALTER TABLE bdc_zdpjjl_all
  RENAME COLUMN pjsl TO sjpjsl;
COMMENT ON COLUMN BDC_ZDPJJL_ALL.sjpjsl IS '实际派件数量';
ALTER TABLE BDC_ZDPJJL_ALL
  MODIFY xnpjsl DEFAULT 0;

--2019-09-03  BDC_XM增加材料移交状态字段--姜淦之
ALTER TABLE BDC_XM
  ADD (CLYJZT VARCHAR2(2));
COMMENT ON COLUMN BDC_XM.CLYJZT IS '材料移交状态（1：已移交 0：未移交）';

-----2019-05-29 zx 任务办理默认意见配置
CREATE TABLE BDC_XT_RWBLMRYJ
(
  yjid VARCHAR2(32),
  yjnr VARCHAR2(100),
  yjlx VARCHAR2(50)
);
COMMENT ON TABLE BDC_XT_RWBLMRYJ
IS '任务办理默认意见配置';
COMMENT ON COLUMN BDC_XT_RWBLMRYJ.yjid
IS '主键';
COMMENT ON COLUMN BDC_XT_RWBLMRYJ.yjnr
IS '意见内容';
COMMENT ON COLUMN BDC_XT_RWBLMRYJ.yjlx
IS '意见类型';

--2019-09-06  DC_BDCZSSD 、 GD_BDCSD 、BDC_BDCDYSD三张表新增字段：锁定机构，锁定文号，解锁机构，解锁文号--孙超
ALTER TABLE bdc_bdczssd
  ADD (sdjg VARCHAR2(100));
COMMENT ON COLUMN bdc_bdczssd.sdjg IS '锁定结构';
ALTER TABLE bdc_bdczssd
  ADD (sdwh VARCHAR2(100));
COMMENT ON COLUMN bdc_bdczssd.sdwh IS '锁定文号';
ALTER TABLE bdc_bdczssd
  ADD (jsjg VARCHAR2(100));
COMMENT ON COLUMN bdc_bdczssd.jsjg IS '解锁机构';
ALTER TABLE bdc_bdczssd
  ADD (jswh VARCHAR2(100));
COMMENT ON COLUMN bdc_bdczssd.jswh IS '解锁文号';

ALTER TABLE gd_bdcsd
  ADD (sdjg VARCHAR2(100));
COMMENT ON COLUMN gd_bdcsd.sdjg IS '锁定结构';
ALTER TABLE gd_bdcsd
  ADD (sdwh VARCHAR2(100));
COMMENT ON COLUMN gd_bdcsd.sdwh IS '锁定文号';
ALTER TABLE gd_bdcsd
  ADD (jsjg VARCHAR2(100));
COMMENT ON COLUMN gd_bdcsd.jsjg IS '解锁机构';
ALTER TABLE gd_bdcsd
  ADD (jswh VARCHAR2(100));
COMMENT ON COLUMN gd_bdcsd.jswh IS '解锁文号';

ALTER TABLE bdc_bdcdysd
  ADD (sdjg VARCHAR2(100));
COMMENT ON COLUMN bdc_bdcdysd.sdjg IS '锁定结构';
ALTER TABLE bdc_bdcdysd
  ADD (sdwh VARCHAR2(100));
COMMENT ON COLUMN bdc_bdcdysd.sdwh IS '锁定文号';
ALTER TABLE bdc_bdcdysd
  ADD (jsjg VARCHAR2(100));
COMMENT ON COLUMN bdc_bdcdysd.jsjg IS '解锁机构';
ALTER TABLE bdc_bdcdysd
  ADD (jswh VARCHAR2(100));
COMMENT ON COLUMN bdc_bdcdysd.jswh IS '解锁文号';

--2019/09/06 chenjia gd_bdc_ql_rel增加坐落
ALTER TABLE GD_BDC_QL_REL
  ADD (ZL VARCHAR2(1000));
COMMENT ON COLUMN GD_BDC_QL_REL.zl IS '坐落';

--2019/09/09 liujie bdc_yg表增加房屋结构
ALTER TABLE BDC_YG
  ADD (FWJG VARCHAR2(1000));
COMMENT ON COLUMN BDC_YG.FWJG IS '房屋结构';

--2019-9-11  zhengqi  新增撤销状态
ALTER TABLE GD_FWSYQ
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN GD_FWSYQ.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';

ALTER TABLE GD_TDSYQ
  ADD (cxzt NUMBER(2) DEFAULT 0);
COMMENT ON COLUMN GD_TDSYQ.cxzt IS '撤销状态(1：已撤销，0或空：未撤销)';

--2019/09/09 sunchao cf表增加是否轮候查封转查封
ALTER TABLE BDC_CF
  ADD (SFLHCFZCF NUMBER(1));
COMMENT ON COLUMN BDC_CF.SFLHCFZCF IS '是否轮候查封转查封';
ALTER TABLE GD_CF
  ADD (SFLHCFZCF NUMBER(1));
COMMENT ON COLUMN GD_CF.SFLHCFZCF IS '是否轮候查封转查封';

--2019/09/18 sunchao 过渡权利人新增共有方式
ALTER TABLE GD_QLR
  ADD (GYFS VARCHAR2(10));
COMMENT ON COLUMN GD_QLR.GYFS IS '共有方式';

-- 2019/09/19 dingweiwei 新增不动产领证人字典表
CREATE TABLE BDC_ZD_LZR
(
  LZRMC  VARCHAR2(50),
  LZRZJH VARCHAR2(50)
);
COMMENT ON TABLE BDC_ZD_LZR
IS '不动产领证人字典表';
COMMENT ON COLUMN BDC_ZD_LZR.LZRMC
IS '领证人名称';
COMMENT ON COLUMN BDC_ZD_LZR.LZRZJH
IS '领证人证件号';

--2019/09/18 chenjia 新增审核状态
ALTER TABLE GX_WW_SQXM
  ADD (SHZT VARCHAR2(10));
COMMENT ON COLUMN GX_WW_SQXM.SHZT IS '审核状态（0或者空为未审核，1为审核通过，2未审核不通过）';

--2019/09/28 沈飞
ALTER TABLE pf_workflowevent
  ADD (workflow_event_method NVARCHAR2(10));
COMMENT ON COLUMN pf_workflowevent.workflow_event_method IS '请求方式';

--2019-10-8 zhangyu 电子证照调用权籍房屋宗地图  增加字段
CREATE OR REPLACE VIEW djsj_fwhst AS
  SELECT
    a.fw_hst_index,
    a.hst,
    a.hstmc,
    a.fwzdtmc,
    a.fwzdt
  FROM bdc611002.fw_hst a;
--2019-10-8 zhangyu  增加电子证照印制编号流水号记录表
CREATE TABLE BDC_DZZZ_YZBH_LSH
(
  lshid    VARCHAR2(32) NOT NULL,
  lsh      VARCHAR2(20),
  cjsj     DATE,
  zzbfjgdm VARCHAR2(30),
  zzlxdm   VARCHAR2(30)
);
COMMENT ON TABLE BDC_DZZZ_YZBH_LSH
IS '电子证照印制编号流水号表';
COMMENT ON COLUMN BDC_DZZZ_YZBH_LSH.lshid
IS '流水号ID';
COMMENT ON COLUMN BDC_DZZZ_YZBH_LSH.lsh
IS '流水号';
COMMENT ON COLUMN BDC_DZZZ_YZBH_LSH.cjsj
IS '创建时间';
COMMENT ON COLUMN BDC_DZZZ_YZBH_LSH.zzbfjgdm
IS '颁发机构代码';
COMMENT ON COLUMN BDC_DZZZ_YZBH_LSH.zzlxdm
IS '证照类型代码';
ALTER TABLE BDC_DZZZ_YZBH_LSH
  ADD CONSTRAINT YZBH_LSH_PRIMARY_LSHID PRIMARY KEY (lshid);

--解决过度数据是否注销字段为空的问题  如果为空，可能导致互联网查询时查询不到
UPDATE gd_fwsyq
SET iszx = 0
WHERE iszx IS NULL;
UPDATE gd_tdsyq
SET iszx = 0
WHERE iszx IS NULL;
UPDATE gd_cf
SET isjf = 0
WHERE isjf IS NULL;
UPDATE gd_dy
SET isjy = 0
WHERE isjy IS NULL;
UPDATE gd_yg
SET iszx = 0
WHERE iszx IS NULL;
COMMIT;

-- 2019-10-21 sly新增共享库报错日志
CREATE TABLE djf_dj_errorlog
(
  ywh     VARCHAR2(50) NOT NULL,
  service VARCHAR2(50),
  msg     VARCHAR2(50)
);
COMMENT ON COLUMN djf_dj_errorlog.ywh
IS '业务号';
COMMENT ON COLUMN djf_dj_errorlog.service
IS '报错位置';
COMMENT ON COLUMN djf_dj_errorlog.msg
IS '报错信息';

--2019/10/24 陈佳
ALTER TABLE BDC_XM
  ADD (CKQHBH VARCHAR2(10));
COMMENT ON COLUMN BDC_XM.CKQHBH IS '窗口取号编号';

----2019 10 24  zhangyu DJSJ_BDCDY 修改逻辑如果预测转实测 则不显示预测那条数据
CREATE OR REPLACE VIEW DJSJ_BDCDY AS
  SELECT
    a.ZD_DJDCB_INDEX AS id,
    a.djh,
    a.bdcdyh,
    to_char(a.tdzl)     tdzl,
    ''                  qlr,
    'TD'             AS bdclx,
    ''               AS bdcdyfwlx,
    to_char(a.syqlx)    qlxz
  FROM bdc611002.Zd_djdcb a
  WHERE a.bdcdyh IS NOT NULL AND a.gxrq IS NULL
  UNION ALL
  SELECT
    t.id,
    substr(t.bdcdyh, 0, 19) djh,
    t.bdcdyh,
    to_char(t.tdzl),
    '' AS                   qlr,
    'TDFW'                  bdclx,
    t.bdcdyfwlx,
    ''                      qlxz
  FROM (
         SELECT
           t.fw_xmxx_index         id,
           substr(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t1.tdzl,
           'TDFW'                  bdclx,
           '1'                     bdcdyfwlx
         FROM bdc611002.fw_xmxx t
           LEFT JOIN bdc611002.zd_djdcb t1 ON (t.lszd = t1.djh AND t1.gxrq IS NULL)
         WHERE t.bdcdyh IS NOT NULL
         UNION ALL
         SELECT
           t.fw_dcb_index          id,
           substr(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zldz                  tdzl,
           'TDFW'                  bdclx,
           '2'                     bdcdyfwlx
         FROM bdc611002.fw_ljz t
         WHERE t.bdcdyh IS NOT NULL AND t.bdcdyfwlx = '2'
         UNION ALL
         SELECT
           t.fw_hs_index           id,
           substr(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl                    tdzl,
           'TDFW'                  bdclx,
           '4'                     bdcdyfwlx
         FROM bdc611002.fw_hs t
           LEFT JOIN bdc611002.fw_ljz t1 ON t.fw_dcb_index = t1.fw_dcb_index
         UNION ALL
         SELECT
           t.fw_hs_index           id,
           substr(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl                    tdzl,
           'TDFW'                  bdclx,
           '4'                     bdcdyfwlx
         FROM bdc611002.fw_ychs t
           LEFT JOIN bdc611002.fw_ljz t1 ON t.fw_dcb_index = t1.fw_dcb_index
           LEFT JOIN bdc611002.fw_hs t2 ON t.bdcdyh = t2.bdcdyh
         WHERE t.bdcdyh IS NOT NULL AND t1.bdcdyfwlx = '4' AND t2.ycfwbm IS NULL
       ) t
  UNION ALL
  SELECT
    A.NYD_DJDCB_INDEX       AS ID,
    SUBSTR(A.BDCDYH, 0, 19) AS DJH,
    A.BDCDYH,
    TO_CHAR(A.TDZL)            TDZL,
    ''                         QLR,
    'TD'                    AS BDCLX,
    ''                      AS BDCDYFWLX,
    ''                         QLXZ
  FROM bdc611002.NYD_DJDCB A
  UNION ALL
  SELECT DISTINCT
    a.LQ_DCB_INDEX          AS id,
    substr(a.bdcdyh, 0, 19) AS djh,
    a.bdcdyh,
    to_char(a.zl)              tdzl,
    ''                      AS qlr,
    'TDSL'                  AS bdclx,
    ''                      AS bdcdyfwlx,
    ''                         qlxz
  FROM djsj_lq_dcb a
  UNION ALL
  SELECT
    a.djh AS        id,
    a.djh,
    a.bdcdyh,
    to_char(a.tdzl) tdzl,
    ''              qlr,
    'TD'  AS        bdclx,
    ''    AS        bdcdyfwlx,
    ''              qlxz
  FROM bdc611002.qszd_djdcb a
  WHERE a.bdcdyh IS NOT NULL AND a.gxrq IS NULL;

----2019 10 24  zhangyu  DJSJ_BDCDY_TDFW_YC  修改逻辑如果预测转实测 则不显示预测那条数据
CREATE OR REPLACE VIEW DJSJ_BDCDY_TDFW_YC AS
  SELECT
    t.id,
    SUBSTR(t.bdcdyh, 0, 19) djh,
    t.bdcdyh,
    to_char(t.tdzl)         tdzl,
    t1.qlr                  qlr,
    'TDFW'                  bdclx,
    t.bdcdyfwlx,
    ''                      qlxz,
    qsdwdm,
    ismzfztj,
    t.cqqid,
    t.isfsss
  FROM (
         SELECT
           t.fw_xmxx_index         ID,
           SUBSTR(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl AS                 tdzl,
           'TDFW'                  bdclx,
           '1'                     bdcdyfwlx,
           ''                      qsdwdm,
           ''                      ismzfztj,
           ''   AS                 cqqid,
           NULL AS                 isfsss
         FROM bdc611002.fw_xmxx t
           LEFT JOIN bdc611002.zd_djdcb t1 ON (t.lszd = t1.djh AND t1.gxrq IS NULL)

         WHERE t.bdcdyh IS NOT NULL
         UNION ALL
         SELECT
           t.fw_dcb_index          ID,
           SUBSTR(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zldz                  tdzl,
           'TDFW'                  bdclx,
           '2'                     bdcdyfwlx,
           to_char(qsdwdm)         qsdwdm,
           to_char(ismzfztj)       ismzfztj,
           ''   AS                 cqqid,
           NULL AS                 isfsss
         FROM bdc611002.fw_ljz t

         WHERE t.bdcdyh IS NOT NULL AND t.bdcdyfwlx = '2'
         UNION ALL
         SELECT
           t.fw_hs_index           ID,
           SUBSTR(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl                    tdzl,
           'TDFW'                  bdclx,
           '3'                     bdcdyfwlx,
           to_char(t.qsdwdm)       qsdwdm,
           to_char(t.ismzfztj)     ismzfztj,
           ''   AS                 cqqid,
           NULL AS                 isfsss
         FROM bdc611002.fw_hs t
           LEFT JOIN bdc611002.fw_ljz t1 ON t.fw_dcb_index = t1.fw_dcb_index

         WHERE t.bdcdyh IS NOT NULL AND t1.bdcdyfwlx = '3'
         UNION ALL
         SELECT
           t.fw_hs_index           ID,
           SUBSTR(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl                    tdzl,
           'TDFW'                  bdclx,
           '4'                     bdcdyfwlx,
           to_char(t.qsdwdm)       qsdwdm,
           to_char(t.ismzfztj)     ismzfztj,
           ''   AS                 cqqid,
           NULL AS                 isfsss
         FROM bdc611002.fw_hs t
           LEFT JOIN bdc611002.fw_ljz t1 ON t.fw_dcb_index = t1.fw_dcb_index
         WHERE t.bdcdyh IS NOT NULL AND t1.bdcdyfwlx = '4'
         UNION ALL
         SELECT
           t.fw_hs_index           ID,
           SUBSTR(t.bdcdyh, 0, 19) djh,
           t.bdcdyh,
           t.zl                    tdzl,
           'TDFW'                  bdclx,
           '4'                     bdcdyfwlx,
           ''                      qsdwdm,
           ''                      ismzfztj,
           '' AS                   cqqid,
           t.isfsss
         FROM
           bdc611002.fw_ychs t
           LEFT JOIN bdc611002.fw_ljz t1 ON t.fw_dcb_index = t1.fw_dcb_index
           LEFT JOIN bdc611002.fw_hs t2 ON t.bdcdyh = t2.bdcdyh
         WHERE t.bdcdyh IS NOT NULL AND t1.bdcdyfwlx = '4' AND t2.ycfwbm IS NULL
       ) t
    LEFT JOIN mergefwhs_djsj_fw_qlr t1 ON t.id = t1.id;

-- 侯马24116 增加收件台账
        CREATE TABLE BDC_SJJBXX
        (
          proid  VARCHAR2(30),
          sjbh   VARCHAR2(30),
          sjrq   DATE,
          sjr    VARCHAR2(50),
          sqlx   VARCHAR2(50),
          djzx   VARCHAR2(50),
          djyy   VARCHAR2(50),
          slr    VARCHAR2(50),
          slrq   DATE,
          sqzsbs VARCHAR2(10),
          sffbcz VARCHAR2(10)
        );
        COMMENT ON COLUMN BDC_SJJBXX.proid
        IS '主键';
        COMMENT ON COLUMN BDC_SJJBXX.sjbh
        IS '收件编号';
        COMMENT ON COLUMN BDC_SJJBXX.sjrq
        IS '收件日期';
        COMMENT ON COLUMN BDC_SJJBXX.sjr
        IS '收件人 存id';
        COMMENT ON COLUMN BDC_SJJBXX.sqlx
        IS '申请类型 存代码';
        COMMENT ON COLUMN BDC_SJJBXX.djzx
        IS '登记子项 存代码';
        COMMENT ON COLUMN BDC_SJJBXX.djyy
        IS '登记原因 存代码';
        COMMENT ON COLUMN BDC_SJJBXX.slr
        IS '受理人';
        COMMENT ON COLUMN BDC_SJJBXX.slrq
        IS '受理日期';
        COMMENT ON COLUMN BDC_SJJBXX.sqzsbs
        IS '申请证书板式';

        CREATE TABLE BDC_SJQLRXX
        (
          proid     VARCHAR2(60),
          qlrid     VARCHAR2(60),
          qlrmc     VARCHAR2(100),
          qlrzjh    VARCHAR2(50),
          qlrsfzjzl VARCHAR2(10),
          lxdh      VARCHAR2(50)
        );
        COMMENT ON COLUMN BDC_SJQLRXX.proid
        IS '收件基本信息主键';
        COMMENT ON COLUMN BDC_SJQLRXX.qlrid
        IS '主键';
        COMMENT ON COLUMN BDC_SJQLRXX.qlrmc
        IS '名称';
        COMMENT ON COLUMN BDC_SJQLRXX.qlrzjh
        IS '证件号';
        COMMENT ON COLUMN BDC_SJQLRXX.qlrsfzjzl
        IS '证件类型 bdc_zd_sqlx 存代码';
        COMMENT ON COLUMN BDC_SJQLRXX.lxdh
        IS '联系电话';

        CREATE TABLE BDC_SJCLXX
        (
          proid  VARCHAR2(60),
          clxxid VARCHAR2(60),
          clmc   VARCHAR2(200),
          fs     NUMBER(10),
          ys     NUMBER(10),
          xh     NUMBER(10),
          cllx   VARCHAR2(50),
          mrfs   NUMBER(10)
        );
        COMMENT ON COLUMN BDC_SJCLXX.proid
        IS '收件基本信息主键';
        COMMENT ON COLUMN BDC_SJCLXX.clxxid
        IS '主键';
        COMMENT ON COLUMN BDC_SJCLXX.clmc
        IS '材料名称';
        COMMENT ON COLUMN BDC_SJCLXX.fs
        IS '份数';
        COMMENT ON COLUMN BDC_SJCLXX.ys
        IS '页数';
        COMMENT ON COLUMN BDC_SJCLXX.xh
        IS '序号';
        COMMENT ON COLUMN BDC_SJCLXX.cllx
        IS '材料类型 bdc_zd_cllx 存代码';
        COMMENT ON COLUMN BDC_SJCLXX.mrfs
        IS '默认份数';

    alter table BDC_SJCLXX add wjzxid  number(10);
    alter table BDC_SJQLRXX add SXH  number(10);


 --2019/10/28 孙超 新增不动产数据校验表
create table BDC_SJJY
(
  jyid   VARCHAR2(32) not null,
  jylx   VARCHAR2(50),
  jyr    VARCHAR2(100),
  jysj   DATE,
  jysjid VARCHAR2(32),
  jyjg   VARCHAR2(20),
  bz     VARCHAR2(200)
);
comment on table BDC_SJJY
  is '不动产数据校验';
comment on column BDC_SJJY.jyid
  is '校验ID';
comment on column BDC_SJJY.jylx
  is '校验类型（中文）';
comment on column BDC_SJJY.jyr
  is '校验人';
comment on column BDC_SJJY.jysj
  is '校验时间';
comment on column BDC_SJJY.jysjid
  is '校验数据ID';
comment on column BDC_SJJY.jyjg
  is '校验结果';
comment on column BDC_SJJY.bz
  is '备注';
  alter table BDC_SJJY
  add constraint PK_BDC_SJJY_JYID primary key (JYID);

--2019/10/31 sunchao 不动产项目表新增创建人部门
alter table BDC_XM add(CJRBM VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.CJRBM IS '创建人部门';


--2019/11/5 sunchao 新增不动产单元号例外
create table BDC_DYH_LW
(
  lwid   VARCHAR2(32) not null,
  ip     VARCHAR2(100) not null,
  czryid VARCHAR2(100) not null,
  czsj   DATE not null,
  lwlx   VARCHAR2(1) default 1 not null,
  bdcdyh VARCHAR2(100) not null,
  xzwh   VARCHAR2(200) not null,
  lwyy   VARCHAR2(1000)
);

comment on table BDC_DYH_LW
  is '不动产验证单元号例外';
comment on column BDC_DYH_LW.lwid
  is '例外id';
comment on column BDC_DYH_LW.ip
  is '操作机器ip';
comment on column BDC_DYH_LW.czryid
  is '操作人员';
comment on column BDC_DYH_LW.czsj
  is '操作时间';
comment on column BDC_DYH_LW.lwlx
  is '特权类型(1:跳过查封)';
comment on column BDC_DYH_LW.bdcdyh
  is '不动产单元号';
comment on column BDC_DYH_LW.xzwh
  is '限制文号';
comment on column BDC_DYH_LW.lwyy
  is '例外原因';
alter table BDC_DYH_LW
  add constraint BDC_DYH_LW_LWID primary key (LWID);
  --2019/11/7 sunchao 不动产项目表新增合同编号、不动产单元新增房屋编码
alter table BDC_XM add(HTBH VARCHAR2(100));
COMMENT ON COLUMN BDC_XM.HTBH IS '合同编号';
alter table BDC_BDCDY add(FWBM VARCHAR2(100));
COMMENT ON COLUMN BDC_BDCDY.FWBM IS '房屋编码';

  -----2019-11-08 zhengqi BDC_ZS表增加ZZQZBS字段
alter table BDC_ZS add(ZZQZBS VARCHAR2(100));
COMMENT ON COLUMN BDC_ZS.ZZQZBS IS '证照签章标识';

-----2019-11-12 zhangyu BDC_SJJBXX表增加THYY字段
alter table BDC_SJJBXX add(THYY VARCHAR2(1000));
COMMENT ON COLUMN BDC_SJJBXX.THYY IS '退回原因';
-----2019-11-12 zhangyu BDC_SJJBXX表增加slrid字段
alter table BDC_SJJBXX add(slrid VARCHAR2(50));
COMMENT ON COLUMN BDC_SJJBXX.slrid IS '受理人ID';
  -----2019-11-14 sunchao BDC_ZSBH表增加SFDY字段
alter table BDC_ZSBH add(SFDY VARCHAR2(10));
COMMENT ON COLUMN BDC_ZSBH.SFDY IS '是否打印 1：已放到打证机 0或空未放到打证机';



  -----2019-11-15 dingweiwei BDC_JYHT表增加SFJS字段
alter table BDC_JYHT add(SFJS VARCHAR2(20));
COMMENT ON COLUMN BDC_JYHT.SFJS IS '是否交税';

 -----2019-11-15 guting 创建表BDC_DWGZXX
create table BDC_DWGZXX
(
  dwgzid VARCHAR2(32) not null,
  dwmc      VARCHAR2(100),
  qksm     VARCHAR2(100),
  wjid     VARCHAR2(100),
  basj      DATE
);
-- Add comments to the table
comment on table BDC_DWGZXX
  is '单位公章信息';
comment on column BDC_DWGZXX.dwgzid
  is '单位公章id';
comment on column BDC_DWGZXX.dwmc
  is '单位名称';
comment on column BDC_DWGZXX.qksm
  is '情况说明';
comment on column BDC_DWGZXX.wjid
  is '文件中心文件id';
comment on column BDC_DWGZXX.basj
  is '备案时间';
  -----2019-11-15  bdc_zdpjjl表增加SJPJSL字段
alter table bdc_zdpjjl add(SJPJSL NUMBER(10));
COMMENT ON COLUMN bdc_zdpjjl.SJPJSL IS '派件数量默认值为0';

-----2019-11-23 sunchao BDC_XT_DAMLH表增加qllx,sqlx字段
alter table BDC_XT_DAMLH add(qllx VARCHAR2(10));
COMMENT ON COLUMN BDC_XT_DAMLH.qllx IS '权利类型';
alter table BDC_XT_DAMLH add(sqlx VARCHAR2(10));
COMMENT ON COLUMN BDC_XT_DAMLH.sqlx IS '申请类型';


-----2019-11-26 sunchao 创建不动产测绘表
create table BDC_CH
(
  chid   VARCHAR2(32) not null,
  chjg   VARCHAR2(50),
  jgdmz  VARCHAR2(50),
  xmzrr  VARCHAR2(30),
  chzz   VARCHAR2(2),
  chzzbh VARCHAR2(30),
  proid  VARCHAR2(30),
  zl     VARCHAR2(200),
  stshjg VARCHAR2(200),
  jzmj   NUMBER(10,4),
  zzmj   NUMBER(10,4),
  glmj   NUMBER(10,4),
  ckmj   NUMBER(10,4),
  symj   NUMBER(10,4),
  qtmj   NUMBER(10,4)
);
comment on table BDC_CH
  is '不动产测绘表';
comment on column BDC_CH.chid
  is '测绘ID';
comment on column BDC_CH.chjg
  is '测绘机构';
comment on column BDC_CH.jgdmz
  is '机构代码证';
comment on column BDC_CH.xmzrr
  is '项目责任人';
comment on column BDC_CH.chzz
  is '测绘资质';
comment on column BDC_CH.chzzbh
  is '测绘资质编号';
comment on column BDC_CH.zl
  is '坐落';
comment on column BDC_CH.stshjg
  is '受托审核机构';
comment on column BDC_CH.jzmj
  is '建筑面积';
comment on column BDC_CH.zzmj
  is '住宅面积';
comment on column BDC_CH.glmj
  is '阁楼面积';
comment on column BDC_CH.ckmj
  is '车库面积';
comment on column BDC_CH.symj
  is '商业面积';
comment on column BDC_CH.qtmj
  is '其他面积';

  -----2019-11-27 sunchao bdc_jyht表增加sfhs字段
alter table bdc_jyht add(sfhs VARCHAR2(10));
COMMENT ON COLUMN bdc_jyht.sfhs IS '是否核税';
alter table bdc_jyht add(jssj DATE);
COMMENT ON COLUMN bdc_jyht.jssj IS '交税时间';

alter table bdc_jzwgy add(cxzt NUMBER(2) default 0);
comment on column bdc_jzwgy.cxzt is '撤销状态(1：已撤销，0或空：未撤销)';
alter table BDC_DYAQ add(bdbzzqsesum  NUMBER(15,4));
COMMENT ON COLUMN BDC_DYAQ.bdbzzqsesum IS '被担保主债权数额汇总（用于批量抵押）';

  -----2019-12-4 sunchao BDC_JSYDZJDSYQ表增加dj、jzrjl、jg、jzmd、jzxg字段
alter table BDC_JSYDZJDSYQ add(dj NVARCHAR2(2));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.dj IS '等级';
alter table BDC_JSYDZJDSYQ add(jzrjl NUMBER(38,8));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.jzrjl IS '建筑容积率';
alter table BDC_JSYDZJDSYQ add(jg NUMBER(38,8));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.jg IS '价格（万元）';
alter table BDC_JSYDZJDSYQ add(jzmd NUMBER(38,8));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.jzmd IS '建筑密度';
alter table BDC_JSYDZJDSYQ add(jzxg NUMBER(38,8));
COMMENT ON COLUMN BDC_JSYDZJDSYQ.jzxg IS '建筑限高';


  -----2019-12-4 zhangyu
alter table bdc_yg add(yfje NUMBER(15,4));
COMMENT ON COLUMN bdc_yg.yfje IS '预付金额';
alter table bdc_yg add(syje NUMBER(15,4));
COMMENT ON COLUMN bdc_yg.syje IS '剩余金额';
--2019 12 09 zhangyu  富平验证外网申请项目是否创建
create or replace view v_gx_ww_sqxx as
select a.bdcdyh,a.zl,a.xmid,a.sqxxid,b.sqsj,b.sqslbh,b.djzt,b.byslyy,b.sqlx from bdcdj_gx.gx_ww_sqxx a
left join bdcdj_gx.gx_ww_sqxm b on a.xmid= b.xmid  where b.djzt is null or b.djzt in ('0');


  -----2019-12-10 zhengqi
alter table bdc_zs add(sfzz VARCHAR2(10));
COMMENT ON COLUMN bdc_zs.sfzz IS '是否纸质（0或空为纸质，1为电子证照）';

--奎屯 一窗受理审核信息
create table KUITUN_HTBASHXX
(
  HTBAXXID VARCHAR2(32) not null,
  PROID    VARCHAR2(32) not null,
  YCSLYWH  VARCHAR2(32) not null,
  JGMC     VARCHAR2(200),
  SHYJ     VARCHAR2(100),
  SHZT     VARCHAR2(2),
  SHR      VARCHAR2(100),
  SHSJ     DATE
);
comment on table KUITUN_HTBASHXX
  is '奎屯一窗合同备案信息';
comment on column KUITUN_HTBASHXX.PROID
  is '项目id';
comment on column KUITUN_HTBASHXX.YCSLYWH
  is '一窗受理业务号';
comment on column KUITUN_HTBASHXX.JGMC
  is '机构名称';
comment on column KUITUN_HTBASHXX.SHYJ
  is '审核意见';
comment on column KUITUN_HTBASHXX.SHZT
  is '审核状态  0 审核未通过 1 审核通过';
comment on column KUITUN_HTBASHXX.SHR
  is '审核人';
comment on column KUITUN_HTBASHXX.SHSJ
  is '审核时间';
create unique index PK_KUITUN_HTBASHXX on KUITUN_HTBASHXX (HTBAXXID);
--奎屯一窗完税信息表
create table KUITUN_WSXX
(
  WSXXID                VARCHAR2(32) not null,
  PROID                 VARCHAR2(32) not null,
  BIZCODE               VARCHAR2(32) not null,
  REALESTATEUNITCODE    VARCHAR2(30),
  TAXPAYER              VARCHAR2(200),
  CERTIFICATETYPE       VARCHAR2(10),
  CERTIFICATECODE       VARCHAR2(30),
  LOCATION              VARCHAR2(200),
  TAXAMOUNT             NUMBER(15,2),
  TAXRATE               NUMBER(4,2),
  TAXTYPE               VARCHAR2(50),
  TAXSUBJECT            VARCHAR2(50),
  OBLIGEEHOUSENUM       NUMBER(2),
  EXEMPTIONS            NUMBER(15,2),
  TAXPAYABLE            NUMBER(15,2),
  REDUCTIONREASON       VARCHAR2(200),
  TAXPAYMENT            NUMBER(15,2),
  TAXPAYMENTCERTIFICATE VARCHAR2(50),
  TAXBILLYEAR           VARCHAR2(8),
  TAXBILLCODE           VARCHAR2(50),
  TAXBILLUUID           VARCHAR2(50),
  SYNCHRONIZATIONTIME   DATE,
  CONTRACTCODE          VARCHAR2(50),
  PAYEE                 VARCHAR2(50),
  PAIDTIME              DATE
);
comment on table KUITUN_WSXX
  is '奎屯一窗完税信息表';
comment on column KUITUN_WSXX.PROID
  is '项目id';
comment on column KUITUN_WSXX.BIZCODE
  is '一窗受理业务号';
comment on column KUITUN_WSXX.REALESTATEUNITCODE
  is '不动产单元号';
comment on column KUITUN_WSXX.TAXPAYER
  is '承受方名称';
comment on column KUITUN_WSXX.CERTIFICATETYPE
  is '证件类型';
comment on column KUITUN_WSXX.CERTIFICATECODE
  is '承受方证件号';
comment on column KUITUN_WSXX.LOCATION
  is '坐落';
comment on column KUITUN_WSXX.TAXAMOUNT
  is '计税金额';
comment on column KUITUN_WSXX.TAXRATE
  is '税率';
comment on column KUITUN_WSXX.TAXTYPE
  is '税费种类';
comment on column KUITUN_WSXX.TAXSUBJECT
  is '税费科目名称';
comment on column KUITUN_WSXX.OBLIGEEHOUSENUM
  is '住房套数';
comment on column KUITUN_WSXX.EXEMPTIONS
  is '减免税额(元)';
comment on column KUITUN_WSXX.TAXPAYABLE
  is '应纳税额(元)';
comment on column KUITUN_WSXX.REDUCTIONREASON
  is '减免原因';
comment on column KUITUN_WSXX.TAXPAYMENT
  is '实收金额(元)';
comment on column KUITUN_WSXX.TAXPAYMENTCERTIFICATE
  is '完税凭证号码';
comment on column KUITUN_WSXX.TAXBILLYEAR
  is '税票所属年度';
comment on column KUITUN_WSXX.TAXBILLCODE
  is '税票字轨';
comment on column KUITUN_WSXX.TAXBILLUUID
  is '税票UUID';
comment on column KUITUN_WSXX.SYNCHRONIZATIONTIME
  is '数据同步时间';
comment on column KUITUN_WSXX.CONTRACTCODE
  is '合同编号';
comment on column KUITUN_WSXX.PAYEE
  is '收费人员';
comment on column KUITUN_WSXX.PAIDTIME
  is '收费日期';
create unique index PK_KUITUN_WSXX on KUITUN_WSXX (WSXXID);


-------2019-12-12 zhangyiyang
alter table GD_CF ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_CF.SLBH IS '受理编号';
alter table GD_DY ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_DY.SLBH IS '受理编号';
alter table GD_YG ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_YG.SLBH IS '受理编号';
alter table GD_YY ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_YY.SLBH IS '受理编号';
alter table GD_FWSYQ ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_FWSYQ.SLBH IS '受理编号';
alter table GD_TDSYQ ADD SLBH VARCHAR2(100);
COMMENT ON COLUMN GD_TDSYQ.SLBH IS '受理编号';
ALTER TABLE GD_BDC_QL_REL ADD TABLENAME VARCHAR2(200);
COMMENT ON COLUMN GD_BDC_QL_REL.TABLENAME IS '权利表名称';


alter table bdc_jsydzjdsyq ADD qlslfs VARCHAR2(20);
COMMENT ON COLUMN bdc_jsydzjdsyq.qlslfs IS '权利设立方式';



-----2019-12-12 liujie
alter table  BDC_XT_YH add(SFJCPTTYSF VARCHAR2(2));
COMMENT ON COLUMN  BDC_XT_YH.SFJCPTTYSF IS '是否集成平台统一收费（1：是，0或者空：否）';

-----2019-12-13 shaoliyao exchange需求新增，推送自然资源厅日志表
create table POST_ACCESS_LOG
(
        REC_TYPE VARCHAR2(7),
        REG_TYPE VARCHAR2(8),
        CREATE_DATE DATE,
        REC_FLOW_ID VARCHAR2(50) not null
                constraint PK_POST_ACCESS
                        primary key,
        SUCCESS_FLAG NUMBER,
        RESPONSE_CODE VARCHAR2(4),
        RESPONSE_INFO VARCHAR2(500),
        ACCESS_DATE DATE,
        JSON CLOB
);

comment on table POST_ACCESS_LOG is '登记结果推送';
comment on column POST_ACCESS_LOG.REC_TYPE is '业务编码';
comment on column POST_ACCESS_LOG.REG_TYPE is '登记类型';
comment on column POST_ACCESS_LOG.CREATE_DATE is '创建时间';
comment on column POST_ACCESS_LOG.REC_FLOW_ID is '业务流水号';
comment on column POST_ACCESS_LOG.SUCCESS_FLAG is '成功标识';
comment on column POST_ACCESS_LOG.RESPONSE_CODE is '响应编码';
comment on column POST_ACCESS_LOG.RESPONSE_INFO is '报文响应信息';
comment on column POST_ACCESS_LOG.ACCESS_DATE is '汇交时间';
--shaoliyao 增加共享日志修改时间字段
alter table DJF_DJ_ERRORLOG add updatetime date;
comment on column DJF_DJ_ERRORLOG.updatetime   is '修改时间';

  -----2019-12-17 liujie
alter table  BDC_GDXX add(SJLY VARCHAR2(1));
COMMENT ON COLUMN  BDC_GDXX.SJLY IS '数据来源（0或者空：不动产；1：过渡土地；2：过渡房屋）';
-- 2019-12-17 wenyuanwu  增加与第三方对照关系表
create table BDC_DZ_REL(
  ID varchar2(36) primary key,
  DSFDM varchar2(50) not null,
  DSFMC varchar2(200) not null,
  DZBS varchar2(50) not null,
  BDCDM varchar2(50) not null,
  BDCMC varchar2(200) not null,
  DZJG varchar2(50) not null
);
comment on table BDC_DZ_REL is '不动产与第三方对照关系表';
comment on column BDC_DZ_REL.ID is '主键';
comment on column BDC_DZ_REL.DSFDM is '第三方代码';
comment on column BDC_DZ_REL.DSFMC is '第三方名称';
comment on column BDC_DZ_REL.DZBS is '对照标识';
comment on column BDC_DZ_REL.BDCDM is '不动产代码';
comment on column BDC_DZ_REL.BDCMC is '不动产名称';
comment on column BDC_DZ_REL.DZJG is '对照机构';

alter table bdc_sjcl add YPROID VARCHAR2(50);
comment on column bdc_sjcl.YPROID is '原项目id';

-- 2019-12-23 songhaowen  增加侯马一窗受理接口宗地信息视图
CREATE OR REPLACE VIEW djsj_td_jbxx AS
select z.bdcdyh yxtbsm,z.djh zddm,z.bdcdyh bdcdyh, '' ysdm,z.qslx zdtzm, z.tdzl zl, z.scmj zdmj, z.mjdw,
z.tdyt yt,z.dj,z.qdjg jg,'' qllx,z.syqlx qlxz,z.qlsdfs, z.jzrjl rjl,z.jzmd,z.jzxg,z.zdszd, z.zdszn, z.zdszx,
z.zdszb, '' zdt,  z.sztfh tfh, z.tdsyzmc tdsyqr, z.jzzmj jzmj, z.zdzmj jzwzdmj,'' qxdm, ''zdxz, '' lhl,''sjyt,''ysjyt,
z.qsrq syqqssj,z.zzrq syqjssj,z.gxrq gxsj,z.bz bz, '' txbz,'ZD_SHIYQ' yxtbm from bdcsjgl.zd_djdcb z

-- 2019-12-23 songhaowen  增加侯马一窗受理接口房屋信息视图
CREATE OR REPLACE VIEW djsj_fw_jbxx AS
select h.bdcdyh yxtbsm, ''zdshiyqbsm, h.fwbm, l.zrzh, l.ljzh, h.ch, h.zl, h.wlcs sjcs, h.fjh hh, l.fwjg , l.fwyt fwyt1,
l.fwyt2, l.fwyt3, f1.mc yxtfwytmc1, f2.mc yxtfwytmc2, f3.mc yxtfwytmc3, h.ghyt ,
g.mc yxtghytmc, h.ycjzmj,h.yctnjzmj,h.ycftjzmj,h.ycdxbfjzmj, h.ycqtjzmj,h.ycftxs,
h.scjzmj, h.sctnjzmj, h.scftjzmj, h.scdxbfjzmj, h.scqtjzmj, h.scftxs, h.gytdmj, h.fttdmj,
h.dytdmj, '' tdsyqmj,h.fwlx, x.mc yxtfwlxmc,h.fwxz, z.mc yxtfwxzmc, h.dycs szc,
l.fwcs zcs, l.jgrq jgsj, '' fwjs, l.lszd zddm, h.bdcdyh bdcdyh, l.zts,
l.xmmc,h.dyh, h.sxh fjsxh,2 fwlb, '' fwdh, '' fwldh,l.cb fwcb, to_char(l.jgrq,'yyyy') jcnf,
h.qsxz cqxz, h.bz, '' zfbsm, 'H' yxtbm, '' qxdm, h.dycs mycs, c.qsrq tdsyqssj,c.zzrq tdsyjssj,
c.tdyt, c.syqlx tdqlxz,c.scmj zdmj, '' fflb,'' gxsj,m.mc tdytmc, c.dj tddj, '' ybdcdyh
from (select bdcdyh,bdczt,bgbh,bz,cg,ch,cqly,dcsj,dcyj,dcz,dycs,dyh,
dytdmj,fcdah,fjh,fjsm,fttdmj,fw_dcb_index,fw_hs_index,
fw_hst_index,fwbm,fwhx,fwlx,fwxz,ghyt,ghyt2,ghyt3,
gyqk,gytdmj,hbfx,hbhs,hxjg,isfsss,jczxcd,jyjg,qlid,qlzt,qsrq,qsxz,
scdxbfjzmj,scftjzmj,scftxs,scjzmj,scqtjzmj,sctnjzmj,sfcsbh,sxh,
syfttdmjjs,tdsyqlx,tdyt,wlcs,ycdxbfjzmj,ycftjzmj,ycftxs,ycjzmj,ycqtjzmj,
yctnjzmj,ysdm,zl,zzrq  from bdcsjgl.fw_ychs
union all
select bdcdyh,bdczt,bgbh,bz,cg,ch,cqly,dcsj,dcyj,dcz,dycs,dyh,dytdmj,fcdah,fjh,
fjsm,fttdmj,fw_dcb_index,fw_hs_index,fw_hst_index,fwbm,fwhx,fwlx,fwxz,ghyt,ghyt2,
ghyt3,gyqk,gytdmj,hbfx,hbhs,hxjg,isfsss,jczxcd,jyjg,qlid,qlzt,qsrq,qsxz,scdxbfjzmj,scftjzmj,
scftxs,scjzmj,scqtjzmj,sctnjzmj,sfcsbh,sxh,syfttdmjjs,tdsyqlx,tdyt,wlcs,ycdxbfjzmj,
ycftjzmj,ycftxs,ycjzmj,ycqtjzmj,yctnjzmj,ysdm,zl,zzrq from bdcsjgl.fw_hs
) h
inner join bdcsjgl.fw_ljz l on h.fw_dcb_index =l.fw_dcb_index
left join bdcsjgl.s_zd_fwyt f1 on l.fwyt=f1.dm
left join bdcsjgl.s_zd_fwyt f2 on l.fwyt2=f2.dm left join bdcsjgl.s_zd_fwyt f3 on l.fwyt3=f3.dm
left join bdcsjgl.s_zd_fwyt g on h.ghyt=g.dm
left join bdcsjgl.s_zd_fwlx x on h.fwlx=x.dm
left join bdcsjgl.s_zd_fwxz z on h.fwxz=x.dm
left join bdcsjgl.zd_djdcb c on l.lszd=c.djh
left join bdcsjgl.s_zd_dldm m on c.tdyt=m.dm


  -----2019-12-18 chenjia
alter table BDC_DYAQ add(BDBZZQSESUM  NUMBER(15,4));
COMMENT ON COLUMN BDC_DYAQ.BDBZZQSESUM IS '被担保主债权数额（最高债权数额）总和）';

  -----2019-12-18 liujie
alter table  BDC_SJCL add(YPROID VARCHAR2(32));
COMMENT ON COLUMN  BDC_SJCL.YPROID IS '关联项目的原项目id';
--2019-12-26  qijiadong
alter table BDC_FDCQ add(ZXZH VARCHAR2(1000));
comment on column BDC_FDCQ.ZXZH is '准销证号';

--2019-12-30  chenjia
alter table BDC_XT_CHECKiNFO add(YZLY VARCHAR2(20));
comment on column BDC_XT_CHECKiNFO.YZLY is '验证来源';

--2019-12-30  chenjia 增加表审计顺序管控
create table BDC_SJSXGK
(
  sxgkid VARCHAR2(32) not null,
  slbh   VARCHAR2(50),
  czrid  VARCHAR2(50),
  czr    VARCHAR2(50),
  czyy   VARCHAR2(100),
  czsj   DATE
);
comment on column BDC_SJSXGK.sxgkid
  is '顺序管控id主键';
comment on column BDC_SJSXGK.slbh
  is '受理编号';
comment on column BDC_SJSXGK.czrid
  is '操作人id';
comment on column BDC_SJSXGK.czr
  is '操作人';
comment on column BDC_SJSXGK.czyy
  is '操作原因';
comment on column BDC_SJSXGK.czsj
  is '操作时间';
alter table BDC_SJSXGK
  add constraint PK_BDC_SJSXGK primary key (SXGKID);


--2020-01-06  qijiadong
alter table GD_FW add(FWBM VARCHAR2(100));
comment on column GD_FW.FWBM is '房屋编码';

--2020-01-08 guting
alter table BDC_FDCQ add(BUYERSCOUNT NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ.BUYERSCOUNT IS '买方查询数量';
alter table BDC_FDCQ add(SELLERSCOUNT NUMBER(10));
COMMENT ON COLUMN BDC_FDCQ.SELLERSCOUNT IS '卖方查询数量';
alter table BDC_FDCQ add(BHSCJJG NUMBER(20,4));
COMMENT ON COLUMN BDC_FDCQ.BHSCJJG IS '不含税成交价格';
alter table BDC_FDCQ add(DJQYJS NUMBER(2));
COMMENT ON COLUMN BDC_FDCQ.DJQYJS IS '登记前已缴税';

--2020-01-09 孙超bdc_qlr表新增sfwxqy
alter table BDC_QLR add(sfwxqy VARCHAR2(10));
COMMENT ON COLUMN BDC_QLR.sfwxqy IS '是否微小企业';


--2020-01-14 孙超BDC_SFXM表新增JMYJ
alter table BDC_SFXM add(JMYJ VARCHAR2(10));
COMMENT ON COLUMN BDC_SFXM.JMYJ IS '减免依据';

--2020-01-14 孙超BDC_YG表新增FWPGJG、FWDYMJ
alter table BDC_YG add(FWPGJG NUMBER(15,2));
COMMENT ON COLUMN BDC_YG.FWPGJG IS '房屋评估价格';
alter table BDC_YG add(FWDYMJ NUMBER(15,4));
COMMENT ON COLUMN BDC_YG.FWDYMJ IS '房屋抵押面积';

--------2020-01-15 谷挺 BDC_XT_YH表新增DLR、DLRZJLX、DLRZJH
alter table BDC_XT_YH add(DLR VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.DLR IS '代理人';

alter table BDC_XT_YH add(DLRZJLX VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.DLRZJLX IS '代理人证件类型';

alter table BDC_XT_YH add(DLRZJH VARCHAR2(100));
COMMENT ON COLUMN BDC_XT_YH.DLRZJH IS '代理人证件号';


--------2020-01-21 孙超 GD_FW_QL表新增SHZT、SHRY1、SHSJ1、SHRY2、SHSJ2
 alter table GD_FW_QL ADD SHZT VARCHAR2(2);
COMMENT ON COLUMN GD_FW_QL.SHZT IS '审核状态';
alter table GD_FW_QL ADD SHRY1 VARCHAR2(100);
COMMENT ON COLUMN GD_FW_QL.SHRY1 IS '审核人员1';
alter table GD_FW_QL ADD SHSJ1 DATE;
COMMENT ON COLUMN GD_FW_QL.SHSJ1 IS '审核时间1';
alter table GD_FW_QL ADD SHRY2 VARCHAR2(100);
COMMENT ON COLUMN GD_FW_QL.SHRY2 IS '审核人员2';
alter table GD_FW_QL ADD SHSJ2 DATE;
COMMENT ON COLUMN GD_FW_QL.SHSJ2 IS '审核时间2';


alter table BDC_zsbh add(syyhmc VARCHAR2(100));
COMMENT ON COLUMN BDC_zsbh.syyhmc IS '使用银行名称';


--富平一窗受理新建表
create table BDC_YCSL_YWXX_FP
(
  PROID     VARCHAR2(32) not null,
  FWSDSWJG  VARCHAR2(100),
  FWSZDXZQH VARCHAR2(32),
  FWSZCJX   VARCHAR2(200),
  CKMJ      NUMBER(15,4),
  GLMJ      NUMBER(15,4),
  CCSMJ     NUMBER(15,4),
  ZMJ       NUMBER(15,4),
  DLMC      VARCHAR2(200),
  XQMC      VARCHAR2(200),
  CX        VARCHAR2(32),
  DYH       VARCHAR2(32),
  FJH       VARCHAR2(32),
  JDMC      VARCHAR2(200),
  MPH       VARCHAR2(100),
  CGQK      VARCHAR2(100),
  TDSYQZH   VARCHAR2(200),
  YWDT      VARCHAR2(32),
  PGFW      VARCHAR2(200),
  XMLXBH    VARCHAR2(200),
  FWKZXXBZ  VARCHAR2(200),
  QSZYDX    VARCHAR2(100),
  QSZYFS    VARCHAR2(100),
  QSZYYT    VARCHAR2(50),
  HTBH      VARCHAR2(50),
  HTQDRQ    DATE,
  HTJE      NUMBER(15,4),
  JYJG      NUMBER(15,4),
  DY        NUMBER(15,4),
  FWTDZJG   NUMBER(15,4),
  CJJGSFHS  VARCHAR2(5),
  SFCEZS    VARCHAR2(5),
  SFFGYRDP  VARCHAR2(5),
  KCHLFY    NUMBER(15,4),
  SFSYZRFKP VARCHAR2(5),
  PGJG      NUMBER(15,4),
  FWJYXXBZ  VARCHAR2(500),
  FWCQZH    VARCHAR2(200),
  FWBM      VARCHAR2(100),
  TNJZMJ    NUMBER(15,4),
  FTJZMJ    NUMBER(15,4),
  JGSJ      DATE,
  FWXXBZ    VARCHAR2(200),
  ZCS       NUMBER,
  SZC       NUMBER,
  FWJG      VARCHAR2(50),
  ZRZH      VARCHAR2(50),
  TDSYKSQX  DATE,
  TDSYJSQX  DATE,
  FWLX      NUMBER,
  DYTDMJ    NUMBER(15,4),
  FTTDMJ    NUMBER(15,4),
  FWFJ      VARCHAR2(200),
  JCND      NUMBER,
  BDCXMMC   VARCHAR2(200),
  BDCXMBH   VARCHAR2(200),
  YSKJE     NUMBER(15,4),
  YSSKSSYF  VARCHAR2(30)
);
comment on column BDC_YCSL_YWXX_FP.PROID
  is '项目id';
comment on column BDC_YCSL_YWXX_FP.FWSDSWJG
  is '房屋属地税务机关';
comment on column BDC_YCSL_YWXX_FP.FWSZDXZQH
  is '房屋所在地行政区划';
comment on column BDC_YCSL_YWXX_FP.FWSZCJX
  is '房屋所在处、街乡';
comment on column BDC_YCSL_YWXX_FP.CKMJ
  is '车库面积';
comment on column BDC_YCSL_YWXX_FP.GLMJ
  is '阁楼面积';
comment on column BDC_YCSL_YWXX_FP.CCSMJ
  is '储藏室面积';
comment on column BDC_YCSL_YWXX_FP.ZMJ
  is '总面积';
comment on column BDC_YCSL_YWXX_FP.DLMC
  is '道路名称';
comment on column BDC_YCSL_YWXX_FP.XQMC
  is '小区名称';
comment on column BDC_YCSL_YWXX_FP.CX
  is '朝向';
comment on column BDC_YCSL_YWXX_FP.DYH
  is '单元号';
comment on column BDC_YCSL_YWXX_FP.FJH
  is '房间号';
comment on column BDC_YCSL_YWXX_FP.JDMC
  is '街道名称';
comment on column BDC_YCSL_YWXX_FP.MPH
  is '门牌号';
comment on column BDC_YCSL_YWXX_FP.CGQK
  is '采光情况';
comment on column BDC_YCSL_YWXX_FP.TDSYQZH
  is '土地使用权证号';
comment on column BDC_YCSL_YWXX_FP.YWDT
  is '有无电梯';
comment on column BDC_YCSL_YWXX_FP.PGFW
  is '评估范围';
comment on column BDC_YCSL_YWXX_FP.XMLXBH
  is '建设项目立项编号';
comment on column BDC_YCSL_YWXX_FP.FWKZXXBZ
  is '房屋扩展信息备注';
comment on column BDC_YCSL_YWXX_FP.QSZYDX
  is '权属转移对象';
comment on column BDC_YCSL_YWXX_FP.QSZYFS
  is '权属转移方式';
comment on column BDC_YCSL_YWXX_FP.QSZYYT
  is '权属转移用途';
comment on column BDC_YCSL_YWXX_FP.HTBH
  is '合同编号';
comment on column BDC_YCSL_YWXX_FP.HTQDRQ
  is '合同签订日期';
comment on column BDC_YCSL_YWXX_FP.HTJE
  is '合同金额(元)';
comment on column BDC_YCSL_YWXX_FP.JYJG
  is '交易价格(元)';
comment on column BDC_YCSL_YWXX_FP.DY
  is '单价(元)';
comment on column BDC_YCSL_YWXX_FP.FWTDZJG
  is '房屋/土地总价格';
comment on column BDC_YCSL_YWXX_FP.CJJGSFHS
  is '成交价格是否含税';
comment on column BDC_YCSL_YWXX_FP.SFCEZS
  is '是否差额征收';
comment on column BDC_YCSL_YWXX_FP.SFFGYRDP
  is '是否分共有人打票';
comment on column BDC_YCSL_YWXX_FP.KCHLFY
  is '个人所得税扣除合理费用';
comment on column BDC_YCSL_YWXX_FP.SFSYZRFKP
  is '本次申报交易是否属于转让方开票';
comment on column BDC_YCSL_YWXX_FP.PGJG
  is '评估价格';
comment on column BDC_YCSL_YWXX_FP.FWJYXXBZ
  is '房屋交易信息备注';
comment on column BDC_YCSL_YWXX_FP.FWCQZH
  is '房屋产权证号';
comment on column BDC_YCSL_YWXX_FP.FWBM
  is '房源编码';
comment on column BDC_YCSL_YWXX_FP.TNJZMJ
  is '套内建筑面积';
comment on column BDC_YCSL_YWXX_FP.FTJZMJ
  is '分摊建筑面积';
comment on column BDC_YCSL_YWXX_FP.JGSJ
  is '竣工时间';
comment on column BDC_YCSL_YWXX_FP.FWXXBZ
  is '房屋信息备注';
comment on column BDC_YCSL_YWXX_FP.ZCS
  is '总层数';
comment on column BDC_YCSL_YWXX_FP.SZC
  is '所在层';
comment on column BDC_YCSL_YWXX_FP.FWJG
  is '房屋结构';
comment on column BDC_YCSL_YWXX_FP.ZRZH
  is '房屋幢号';
comment on column BDC_YCSL_YWXX_FP.TDSYKSQX
  is '土地使用开始期限';
comment on column BDC_YCSL_YWXX_FP.TDSYJSQX
  is '土地使用结束期限';
comment on column BDC_YCSL_YWXX_FP.FWLX
  is '房屋类型';
comment on column BDC_YCSL_YWXX_FP.DYTDMJ
  is '独用土地面积';
comment on column BDC_YCSL_YWXX_FP.FTTDMJ
  is '分摊土地面积';
comment on column BDC_YCSL_YWXX_FP.FWFJ
  is '房屋附记';
comment on column BDC_YCSL_YWXX_FP.JCND
  is '建成年代';
comment on column BDC_YCSL_YWXX_FP.BDCXMMC
  is '不动产项目名称';
comment on column BDC_YCSL_YWXX_FP.BDCXMBH
  is '不动产项目编号';
comment on column BDC_YCSL_YWXX_FP.YSKJE
  is '当期应收款金额';
comment on column BDC_YCSL_YWXX_FP.YSSKSSYF
  is '当期应收税款所属月份';
alter table BDC_YCSL_YWXX_FP
  add constraint YCSL_YWXX_PROID_PK primary key (PROID);


create table BDC_YCSL_GXR_FP
(
  QLRID    VARCHAR2(32) not null,
  NSRSBH   VARCHAR2(50),
  SHTYXYDM VARCHAR2(50),
  XMLXBH   VARCHAR2(50),
  GJ       VARCHAR2(20),
  HYZK     VARCHAR2(20),
  SFZCQR   VARCHAR2(2),
  SCQDSJ   DATE,
  SCQDFS   VARCHAR2(50),
  SCQDCB   NUMBER(15,2),
  PROID    VARCHAR2(32)
);
comment on table BDC_YCSL_GXR_FP
  is '不动产一窗受理关系人表—富平';
comment on column BDC_YCSL_GXR_FP.QLRID
  is '权利人id';
comment on column BDC_YCSL_GXR_FP.NSRSBH
  is '纳税人识别号';
comment on column BDC_YCSL_GXR_FP.SHTYXYDM
  is '社会统一信用代码';
comment on column BDC_YCSL_GXR_FP.XMLXBH
  is '项目立项编号';
comment on column BDC_YCSL_GXR_FP.GJ
  is '国籍';
comment on column BDC_YCSL_GXR_FP.HYZK
  is '婚姻状况';
comment on column BDC_YCSL_GXR_FP.SFZCQR
  is '是否住产权人';
comment on column BDC_YCSL_GXR_FP.SCQDSJ
  is '上次取得时间';
comment on column BDC_YCSL_GXR_FP.SCQDFS
  is '上次取得方式';
comment on column BDC_YCSL_GXR_FP.SCQDCB
  is '上次取得成本';
comment on column BDC_YCSL_GXR_FP.PROID
  is '项目id';
alter table BDC_YCSL_GXR_FP
  add constraint QLRID_PK primary key (QLRID);


create table BDC_YCSL_XXHC_FP
(
  HCID   VARCHAR2(32) not null,
  JLID   VARCHAR2(32),
  JGID   VARCHAR2(32),
  CXLB   VARCHAR2(100),
  XXNR   CLOB,
  XXNRMW CLOB,
  CXSJ   DATE,
  PROID  VARCHAR2(32)
);
comment on table BDC_YCSL_XXHC_FP
  is '富平 不动产一窗受理接口信息核查表';
comment on column BDC_YCSL_XXHC_FP.HCID
  is '核查id';
comment on column BDC_YCSL_XXHC_FP.JLID
  is '记录id';
comment on column BDC_YCSL_XXHC_FP.JGID
  is '结果id';
comment on column BDC_YCSL_XXHC_FP.CXLB
  is '查询类别';
comment on column BDC_YCSL_XXHC_FP.XXNR
  is '信息内容';
comment on column BDC_YCSL_XXHC_FP.XXNRMW
  is '信息内容密文';
comment on column BDC_YCSL_XXHC_FP.CXSJ
  is '查询时间';
comment on column BDC_YCSL_XXHC_FP.PROID
  is '项目id';
alter table BDC_YCSL_XXHC_FP
  add constraint BDC_YCSL_XXHC_FP_PK primary key (HCID);


alter table bdc_zs add(sfdyzs VARCHAR2(10));
COMMENT ON COLUMN bdc_zs.sfdyzs IS '是否打印证书（空或是：打印该证书，否：不打印）';

--zhangyu  djsj_fw_ljz视图增加dqrq 到期日期字段
create or replace view djsj_fw_ljz as
select t.fw_xmxx_index, t.bdcdyfwlx, t.bdcdyh, t.fw_dcb_index, t.lszd, t.dh,
 t.fwmc, t.zldz, t.fwjg, t.fwcs,t.bz, t.fwyt, t.jgrq,  t.zrzh, t.ycjzmj, t.ycdxmj, t.ycqtmj,
 t.scjzmj, t.scdxmj, t.scqtmj,t.xmmc, t.zts,t.mph,t.ljzh,z.dm jzwzt ,t.zzdmj,t.zydmj,t.dscs,t.dxcs,t.bdczt,t.dcyj,t.dqrq
from  bdc611002.fw_ljz t
left join bdc611002.s_zd_jzwzt z on t.jzwzt=z.mc;
