/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.main;

import cn.gtmap.estateplat.core.support.xml.XmlUtils;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.print.DataToPrintXml;
import cn.gtmap.estateplat.server.core.model.MulDataToPrintXml;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZsPrintService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.utils.BarcodeUtil;
import cn.gtmap.estateplat.server.utils.GetQRcode;
import cn.gtmap.estateplat.server.web.main.BaseController;
import cn.gtmap.estateplat.utils.ArrayUtils;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bdcPrint"})
public class BdcPrintController
extends BaseController {
    @Autowired
    private BdcZsPrintService bdcZsPrintService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcZsService bdcZsService;
    private static final Map<String, String> fr3Address = ImmutableMap.of((Object)"zs", (Object)"C:/GTIS/zsPrint.fr3,", (Object)"zms", (Object)"C:/GTIS/zmsPrint.fr3,", (Object)"zmd", (Object)"C:/GTIS/zmdPrint.fr3,", (Object)"scdjxx", (Object)"C:/GTIS/scxx.fr3");
    private static final Map<String, String> zsTypeMap = ImmutableMap.of((Object)"zs", (Object)"\u4e0d\u52a8\u4ea7\u6743", (Object)"zm", (Object)"\u4e0d\u52a8\u4ea7\u8bc1\u660e", (Object)"scdjxx", (Object)"\u9996\u6b21\u767b\u8bb0\u8bc1");

    @ResponseBody
    @RequestMapping(value={"/printBdcqz"})
    public void printBdcqz(String proid, String zsid, String zslx, String hiddeMode, HttpServletResponse response) {
        StringBuilder modalUrls = new StringBuilder();
        StringBuilder xmlUrls = new StringBuilder();
        modalUrls.append((String)fr3Address.get(zslx));
        xmlUrls.append(this.bdcdjUrl).append("/bdcPrint/getBdcqzXml?proid=").append(proid).append("&amp;zsid=").append(zsid).append("&amp;zslx=").append(zslx).append(",");
        this.bdcZsPrintService.reponseModalUrl(hiddeMode, modalUrls, xmlUrls, response);
    }

    @ResponseBody
    @RequestMapping(value={"/printAllBdcqzs"})
    public void printAllBdcqzs(String wiid, String zslx, String hiddeMode, HttpServletResponse response) {
        StringBuilder zsids = new StringBuilder();
        List bdcZsList = this.bdcZsService.getPlZsByWiid(wiid);
        if (CollectionUtils.isNotEmpty((Collection)bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                boolean zsAvalible;
                boolean zmAvalible = StringUtils.equals((CharSequence)zslx, (CharSequence)"zms") && StringUtils.equals((CharSequence)bdcZs.getZstype(), (CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e");
                boolean bl = zsAvalible = StringUtils.equals((CharSequence)zslx, (CharSequence)"zs") && StringUtils.equals((CharSequence)bdcZs.getZstype(), (CharSequence)"\u4e0d\u52a8\u4ea7\u6743");
                if (!zmAvalible && !zsAvalible) continue;
                zsids.append(bdcZs.getZsid()).append(",");
            }
        }
        List<Object> zsidList = new ArrayList();
        if (StringUtils.indexOf((CharSequence)zsids, (CharSequence)",") > -1) {
            zsidList = Arrays.asList(StringUtils.split((String)zsids.toString(), (String)","));
        }
        StringBuilder modalUrls = new StringBuilder();
        StringBuilder xmlUrls = new StringBuilder();
        for (String string : zsidList) {
            List bdcXmList = this.bdcXmService.getBdcXmListByZsid(string);
            if (!CollectionUtils.isNotEmpty((Collection)bdcXmList)) continue;
            modalUrls.append((String)fr3Address.get(zslx));
            xmlUrls.append(this.bdcdjUrl).append("/bdcPrint/getBdcqzXml?proid=").append(((BdcXm)bdcXmList.get(0)).getProid()).append("&amp;zsid=").append(string).append("&amp;zslx=").append(zslx).append(",");
        }
        this.bdcZsPrintService.reponseModalUrl(hiddeMode, modalUrls, xmlUrls, response);
    }

    @ResponseBody
    @RequestMapping(value={"/spfMulPrint"})
    public void spfMulPrint(String wiid, String[] proids, String hiddeMode, String zslx, String startNum, String endNum, HttpServletResponse response) {
        HashMap hashMap = new HashMap();
        hiddeMode = StringUtils.isNotBlank((CharSequence)hiddeMode) ? hiddeMode : "false";
        this.bdcZsService.updateBdcZsListDyzt(wiid, proids, startNum, endNum, (String)zsTypeMap.get(zslx));
        StringBuilder modalUrls = new StringBuilder();
        StringBuilder xmlUrls = new StringBuilder();
        StringBuilder xmlUrlsSingle = new StringBuilder();
        Object[] zsArr = null;
        LinkedList<String> zsList = new LinkedList<String>();
        modalUrls.append((String)fr3Address.get(zslx));
        if (hashMap.size() > 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)CommonUtil.formatEmptyValue(entry.getKey()))) continue;
                zsList.add(CommonUtil.formatEmptyValue(entry.getKey()) + "@" + CommonUtil.formatEmptyValue(entry.getValue()));
                xmlUrlsSingle.append(this.bdcdjUrl);
                xmlUrlsSingle.append("/bdcPrint/getBdcqzXml?proid=");
                xmlUrlsSingle.append(CommonUtil.formatEmptyValue(entry.getKey()));
                xmlUrlsSingle.append("&amp;zsid=");
                xmlUrlsSingle.append(CommonUtil.formatEmptyValue(entry.getValue()));
                xmlUrlsSingle.append("&amp;zslx=");
                xmlUrlsSingle.append(zslx);
                xmlUrlsSingle.append(",");
            }
            if (zsList.size() == 1) {
                xmlUrls.append(xmlUrlsSingle.toString().substring(0, xmlUrlsSingle.length() - 1));
            } else {
                zsArr = zsList.toArray(new String[0]);
                xmlUrls.append(this.bdcdjUrl + "/bdcPrint/getBdcqzMulXml?zsArr=" + StringUtils.join((Object[])zsArr, (String)";") + "&amp;zslx=" + zslx);
            }
        }
        this.bdcZsPrintService.reponseModalUrl(hiddeMode, modalUrls, xmlUrls, response);
    }

    @RequestMapping(value={"/getBdcqzXml"})
    public void getBdcqzXml(String proid, String zsid, String zslx, HttpServletResponse response) throws IOException {
        String xml = "";
        DataToPrintXml dataToPrintXml = this.bdcZsPrintService.getZsPrintXml(proid, zslx, this.bdcdjUrl, zsid);
        if (dataToPrintXml != null) {
            XmlUtils resultBinder = new XmlUtils(new Class[]{DataToPrintXml.class});
            xml = resultBinder.entityToXml((Object)dataToPrintXml, "utf-8");
        }
        response.setContentType("text/xml;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.write(xml);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/getBdcqzMulXml"})
    public void getBdcqzMulXml(String zsArr, String zslx, HttpServletResponse response) throws IOException {
        MulDataToPrintXml muldataToPrintXml;
        String xml = "";
        Object[] zsArrs = zsArr.split(";");
        HashMap<String, String> proidAndzsidMap = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])zsArrs)) {
            for (Object proidAndzsid : zsArrs) {
                String[] param = ((String)proidAndzsid).split("@");
                String proid = param[0];
                String zsid = param[1];
                proidAndzsidMap.put(proid, zsid);
            }
        }
        if ((muldataToPrintXml = this.bdcZsPrintService.getMulZsPrintXml(zslx, this.bdcdjUrl, proidAndzsidMap)) != null) {
            XmlUtils resultBinder = new XmlUtils(new Class[]{MulDataToPrintXml.class});
            xml = resultBinder.entityToXml((Object)muldataToPrintXml, "utf-8");
        }
        response.setContentType("text/xml;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.write(xml);
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getEwm"})
    public void getEwmStream(@RequestParam(value="proid", required=false) String proid, @RequestParam(value="bz", required=false) String bz, HttpServletResponse response) throws IOException {
        try {
            BdcXm bdcXm;
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)bz)) {
                content = bz;
            }
            if (StringUtils.isBlank((CharSequence)content) && StringUtils.isNotBlank((CharSequence)proid) && (bdcXm = this.bdcXmService.getBdcXmByProid(proid)) != null) {
                content = bdcXm.getBh();
            }
            response.setContentType("image/jpg;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment; filename=test.jpg");
            GetQRcode.encoderQRCode((String)content, null, (HttpServletResponse)response);
        }
        finally {
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getTxm"})
    public void getTxmStream(@RequestParam(value="proid", required=false) String proid, HttpServletResponse response) throws IOException {
        try {
            BdcXm bdcXm;
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)proid) && (bdcXm = this.bdcXmService.getBdcXmByProid(proid)) != null) {
                content = bdcXm.getBh();
            }
            response.setContentType("image/jpg;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment; filename=test.jpg");
            BarcodeUtil.generateBarCode128((HttpServletResponse)response, (String)content, (String)"0.5", (String)"10", (String)"300");
        }
        finally {
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

