/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.validate;

import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.exception.ParameterNotFoundException;
import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import cn.gtmap.estateplat.utils.ExUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@ControllerAdvice
@EnableWebMvc
public class RestControllerExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(RestControllerExceptionHandler.class);
    @Autowired
    private OpenApiResponseService openApiResponseService;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object getError(HttpServletResponse response, Exception ex) throws IOException {
        ex.printStackTrace();
        if (ex instanceof BindException || ex instanceof MethodArgumentNotValidException || ex instanceof ParamsValidException || ex instanceof OpenApiException || ex instanceof ParameterNotFoundException) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            logger.info("\u4e00\u7a97\u53d7\u7406\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)ex.getMessage());
            return this.openApiResponseService.getExceptionResponse(ex.getMessage());
        }
        logger.info("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff1a{}", (Object)ex.getMessage());
        return ExUtils.toMap((Exception)ex);
    }
}

