/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidUtil {
    @Autowired
    private Validator validator;

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public <T> void validAndReturnFirstErrorTips(T t, Class<?> ... groups) {
        Set validate = this.validator.validate(t, (Class[])groups);
        if (validate.size() > 0) {
            ConstraintViolation next = (ConstraintViolation)validate.iterator().next();
            String message = next.getRootBeanClass().getName() + "-" + next.getPropertyPath() + "-" + next.getMessage();
            throw new ParamsValidException(message);
        }
    }

    public <T> void validAndReturnFirstErrorTips(Class targetClass, String fieldName, Object obj, Class<?> ... groups) {
        Set validate = this.validator.validateValue(targetClass, fieldName, obj, (Class[])groups);
        if (validate.size() > 0) {
            String message = targetClass.getName() + "-" + fieldName + "-" + ((ConstraintViolation)validate.iterator().next()).getMessage();
            throw new ParamsValidException(message);
        }
    }

    public <T> String validate(T target) {
        Set constraintViolations = this.validator.validate(target, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation error = (ConstraintViolation)iterator.next();
            throw new ParamsValidException(error.getMessage());
        }
        return null;
    }

    public <T> String validateWithParamter(T target) {
        Set constraintViolations = this.validator.validate(target, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation error = (ConstraintViolation)iterator.next();
            StringBuffer buffer = new StringBuffer().append("[").append(error.getPropertyPath().toString()).append("]").append(error.getMessage());
            throw new ParamsValidException(buffer.toString());
        }
        return null;
    }
}

