/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import cn.gtmap.estateplat.server.core.exception.AppException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RsaUtil {
    private static final Logger logger = LoggerFactory.getLogger(RsaUtil.class);
    protected static final String KEY_RSA = "RSA";
    protected static final String KEY_RSA_SIGNATURE = "MD5withRSA";
    protected static final String KEY_RSA_PUBLICKEY = "RSAPublicKey";
    protected static final String KEY_RSA_PRIVATEKEY = "RSAPrivateKey";
    protected static final int MAX_ENCRYPT_BLOCK = 117;
    protected static final int MAX_DECRYPT_BLOCK = 128;
    protected static final int MAX_DECRYPT_BLOCK_256 = 256;

    protected RsaUtil() {
    }

    public static Map<String, Object> generateKey() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair keyPair = generator.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            map.put("RSAPublicKey", publicKey);
            map.put("RSAPrivateKey", privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppException((Throwable)e);
        }
        return map;
    }

    public static String getPublicKey(Map<String, Object> map) {
        String str = "";
        try {
            Key key = (Key)map.get("RSAPublicKey");
            byte[] publicKey = key.getEncoded();
            str = RsaUtil.encryptBase64((byte[])publicKey);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
        return str;
    }

    public static String getPrivateKey(Map<String, Object> map) {
        String str = "";
        try {
            Key key = (Key)map.get("RSAPrivateKey");
            str = RsaUtil.encryptBase64((byte[])key.getEncoded());
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
        return str;
    }

    public static String sign(String privateKey, String dataStr) {
        try {
            byte[] data = dataStr.getBytes("UTF-8");
            return RsaUtil.sign((String)privateKey, (byte[])data);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public static String sign(String privateKey, byte[] data) {
        String str = "";
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] bytes = RsaUtil.decryptBase64((String)privateKey);
            PKCS8EncodedKeySpec pkc = new PKCS8EncodedKeySpec(bytes);
            PrivateKey key = factory.generatePrivate(pkc);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(key);
            signature.update(data);
            str = RsaUtil.encryptBase64((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
        return str;
    }

    public static boolean verify(String publicKey, String dataStr, String sign) {
        try {
            byte[] data = dataStr.getBytes("UTF-8");
            return RsaUtil.verify((String)publicKey, (byte[])data, (String)sign);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public static boolean verify(String publicKey, byte[] data, String sign) {
        boolean flag = false;
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] bytes = RsaUtil.decryptBase64((String)publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            PublicKey key = factory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(key);
            signature.update(data);
            flag = signature.verify(RsaUtil.decryptBase64((String)sign));
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
        return flag;
    }

    public static byte[] encryptByPublicKey(String publicKey, byte[] data) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bytes = RsaUtil.decryptBase64((String)publicKey);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            PublicKey pubKey = factory.generatePublic(keySpec);
            cipher.init(1, pubKey);
            int inputLen = data.length;
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public static String encryptByPublicKey(String publicKey, String dataStr) {
        try {
            byte[] result = RsaUtil.encryptByPublicKey((String)publicKey, (byte[])dataStr.getBytes("UTF-8"));
            return RsaUtil.encryptBase64((byte[])result);
        }
        catch (Exception ex) {
            throw new AppException((Throwable)ex);
        }
    }

    public static String decryptByPublicKey(String publicKey, String dataStr) {
        try {
            byte[] result = RsaUtil.decryptByPublicKey((String)publicKey, (byte[])RsaUtil.decryptBase64((String)dataStr));
            return new String(result, "UTF-8");
        }
        catch (Exception ex) {
            throw new AppException((Throwable)ex);
        }
    }

    public static byte[] decryptByPublicKey(String publicKey, byte[] data) {
        try {
            byte[] bytes = RsaUtil.decryptBase64((String)publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = factory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(2, pubKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(data, offSet, 128) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public static String decryptByPrivateKey(String privateKeyStr, String data) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyStr));
            RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return new String(RsaUtil.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.decodeBase64((String)data), (int)privateKey.getModulus().bitLength()), "UTF-8");
        }
        catch (Exception e) {
            throw new AppException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new AppException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    public static String encryptByPrivateKey(String privateKey, String dataStr) {
        try {
            byte[] result = RsaUtil.encryptByPrivateKey((String)privateKey, (byte[])dataStr.getBytes("UTF-8"));
            return RsaUtil.encryptBase64((byte[])result);
        }
        catch (Exception ex) {
            throw new AppException((Throwable)ex);
        }
    }

    public static byte[] encryptByPrivateKey(String privateKey, byte[] data) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            RSAPrivateKey priKey = (RSAPrivateKey)factory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(1, priKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public static byte[] decryptBase64(String key) {
        return DatatypeConverter.parseBase64Binary((String)key);
    }

    public static String encryptBase64(byte[] key) {
        return DatatypeConverter.printBase64Binary((byte[])key);
    }

    public static Map<String, String> getKeyMap() {
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        Map map = RsaUtil.generateKey();
        keyMap.put("publicKey", RsaUtil.getPublicKey((Map)map));
        keyMap.put("privateKey", RsaUtil.getPrivateKey((Map)map));
        return keyMap;
    }

    public static Map<String, Object> decryptStrByPrivateKey(String encryptParam, String privateKey) {
        Map depmap;
        ObjectMapper mapper = new ObjectMapper();
        String decryptParam = "";
        try {
            Map decryptMap = (Map)mapper.readValue(encryptParam, Map.class);
            decryptParam = (String)decryptMap.get("encryptParam");
        }
        catch (IOException e) {
            logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
        }
        try {
            decryptParam = RsaUtil.decryptByPrivateKey((String)privateKey, (String)decryptParam);
            decryptParam = URLDecoder.decode(decryptParam, "UTF-8");
        }
        catch (Exception er) {
            throw new AppException("\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\u83b7\u53d6\u6b63\u786e\u7684key\uff01");
        }
        try {
            depmap = (Map)mapper.readValue(decryptParam, Map.class);
        }
        catch (Exception er) {
            throw new AppException("\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\uff01" + er.getMessage());
        }
        Map mapValue = depmap;
        if (!mapValue.containsKey("timestamp")) {
            throw new AppException("\u53c2\u6570\u975e\u6cd5\uff0c\u672a\u5305\u542btimestamp\u4fe1\u606f\uff01");
        }
        String timestamp = (String)mapValue.get("timestamp");
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            throw new AppException("\u53c2\u6570\u975e\u6cd5\uff0ctimestamp\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        long lngRequestTime = Long.parseLong(timestamp);
        long currentTime = System.currentTimeMillis();
        Long s = (currentTime - lngRequestTime) / 60000L;
        if (s >= 30L) {
            throw new AppException("\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u65f6\u95f4\u6233\uff01");
        }
        return depmap;
    }
}

