/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.config.AppConfig;
import com.rabbitmq.tools.json.JSONReader;
import com.rabbitmq.tools.json.JSONWriter;
import com.vividsolutions.jts.geom.Geometry;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeometryOperationUtil {
    public static String msg;

    public static String queryGeometry(String layerName, String whereClause, String outFields) throws Exception {
        String message = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)layerName)) {
                HashMap resultMap;
                JSONReader jsonReader;
                Object json;
                String url = AppConfig.getProperty((String)"omp.url") + "/geometryService/rest/query";
                HttpClient client = new HttpClient();
                PostMethod method = new PostMethod(url);
                method.addParameter("layerName", layerName);
                if (StringUtils.isNotBlank((CharSequence)outFields) && !"*".equals(outFields = outFields.toUpperCase()) && outFields.indexOf("OBJECTID") < 0) {
                    outFields = outFields + ",OBJECTID";
                }
                method.addParameter("outFields", outFields);
                method.addParameter("where", whereClause);
                if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"sde.db.dsname"))) {
                    method.addParameter("dataSource", AppConfig.getProperty((String)"sde.db.dsname"));
                }
                int status = client.executeMethod((HttpMethod)method);
                String returnJson = method.getResponseBodyAsString();
                if (StringUtils.isNotBlank((CharSequence)returnJson) && (json = (jsonReader = new JSONReader()).read(returnJson)) != null && (resultMap = (HashMap)json) != null) {
                    if (!resultMap.containsKey("result")) {
                        System.out.println("\u5c1a\u672a\u6709\u56fe\u5f62\u6570\u636e\uff01");
                    } else {
                        List objList = GeometryOperationUtil.getKeyListByGeoJson(resultMap.get("result"), (String)"OBJECTID");
                        if (objList != null && objList.size() > 0) {
                            return resultMap.get("result").toString();
                        }
                        message = "\u5c1a\u672a\u6709\u56fe\u5f62\u6570\u636e\uff01";
                    }
                }
            } else {
                message = "ERROR:\u6ca1\u6709\u914d\u7f6e\u8be5\u3010" + layerName + "\u3011\u4e1a\u52a1\u7c7b\u578b\u7684\u56fe\u5f62\u53c2\u6570\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String insertGeometry(String proid, String busiType, String check, String geometry) throws Exception {
        String message = "";
        if (StringUtils.isBlank((CharSequence)busiType)) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)busiType) && StringUtils.isNotBlank((CharSequence)proid) && StringUtils.isNotBlank((CharSequence)geometry)) {
            String layerName = "";
            if (StringUtils.isNotBlank((CharSequence)layerName)) {
                HashMap resultMap;
                JSONReader jsonReader;
                Object json;
                String url = "";
                HttpClient client = new HttpClient();
                PostMethod method = new PostMethod(url);
                method.addParameter("layerName", layerName);
                method.addParameter("geometry", geometry);
                if (!StringUtils.isNotBlank((CharSequence)check) || !StringUtils.equals((CharSequence)check, (CharSequence)"false")) {
                    check = "true";
                }
                method.addParameter("check", check);
                client.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
                int status = client.executeMethod((HttpMethod)method);
                System.out.println("\u670d\u52a1\u5668\u8fd4\u56de\u72b6\u6001\uff1a" + method.getStatusLine());
                String returnJson = method.getResponseBodyAsString();
                System.out.println(returnJson);
                if (StringUtils.isNotBlank((CharSequence)returnJson) && (json = (jsonReader = new JSONReader()).read(returnJson)) != null && (resultMap = (HashMap)json) != null) {
                    if (!resultMap.containsKey("result")) {
                        System.out.println("\u5f53\u524d\u9879\u76ee\u521b\u5efa\u56fe\u5f62\u5931\u8d25\uff01");
                        message = returnJson;
                    } else {
                        message = "true";
                    }
                }
            } else {
                message = "gis.properties\u6587\u4ef6\u6ca1\u6709\u914d\u7f6e\u8be5\u3010" + busiType + "\u3011\u4e1a\u52a1\u7c7b\u578b\u7684\u56fe\u5f62\u53c2\u6570\uff01";
            }
        } else {
            message = "\u6784\u5efa\u5e73\u53f0\u6ca1\u6709\u914d\u7f6e\u5f53\u524d\u5de5\u4f5c\u6d41\u5bf9\u5e94\u7684busiType\uff01";
        }
        return message;
    }

    public static String updateGeometry(String proid, String busiType, HashMap<String, Object> param) throws Exception {
        String message = "";
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            String whereClause = "PROID='" + proid + "'";
            return GeometryOperationUtil.updateGeometry((String)proid, (String)busiType, param, (String)whereClause);
        }
        message = "\u9879\u76eeid\u4e3a\u7a7a\uff01";
        return message;
    }

    public static String updateGeometry(String proid, String busiType, HashMap<String, Object> param, String whereClause) throws Exception {
        String message = "";
        if (StringUtils.isBlank((CharSequence)busiType)) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)busiType)) {
            String layerName = "";
            String geoJson = GeometryOperationUtil.queryGeometry((String)busiType, (String)whereClause, (String)"*");
            if (StringUtils.isNotBlank((CharSequence)geoJson)) {
                FeatureJSON queryJson = new FeatureJSON();
                FeatureCollection queryCollection = queryJson.readFeatureCollection((Object)geoJson);
                if (queryCollection != null && queryCollection.size() > 0) {
                    FeatureIterator queryIterator = queryCollection.features();
                    while (queryIterator.hasNext()) {
                        JSONReader jsonReader;
                        Object json;
                        Feature feature = queryIterator.next();
                        if (param != null) {
                            for (Map.Entry<String, Object> entry : param.entrySet()) {
                                String key = entry.getKey();
                                Object value = entry.getValue();
                                if (feature.getProperty(key.toString()) == null) continue;
                                feature.getProperty(key.toString()).setValue(value);
                            }
                        }
                        String objectId = feature.getProperty("OBJECTID").getValue().toString();
                        String url = "";
                        HttpClient client = new HttpClient();
                        PostMethod method = new PostMethod(url);
                        method.addParameter("layerName", layerName);
                        method.addParameter("primaryKey", objectId);
                        String geometry = GeometryOperationUtil.toFeatureJSON((Object)feature);
                        if (StringUtils.isNotBlank((CharSequence)geometry)) {
                            method.addParameter("geometry", geometry);
                        }
                        int status = client.executeMethod((HttpMethod)method);
                        System.out.println("\u670d\u52a1\u5668\u8fd4\u56de\u7684\u72b6\u6001" + method.getStatusLine());
                        String returnJson = method.getResponseBodyAsString();
                        System.out.println(returnJson);
                        if (!StringUtils.isNotBlank((CharSequence)returnJson) || (json = (jsonReader = new JSONReader()).read(returnJson)) == null) continue;
                        HashMap resultMap = (HashMap)json;
                        if (!resultMap.containsKey("result")) {
                            message = message + returnJson + "\r\n";
                            System.out.println("\u66f4\u65b0\u56fe\u5f62\u5931\u8d25\uff01");
                            continue;
                        }
                        System.out.println("\u66f4\u65b0\u56fe\u5f62\u6210\u529f\uff01");
                    }
                } else {
                    message = "\u5f53\u524d\u9879\u76ee\u5c1a\u672a\u521b\u5efa\u56fe\u5f62\uff01";
                }
            }
        }
        return message;
    }

    public static List<HashMap<String, Object>> getGeometryProperty(String geoJson, String[] propertys) throws Exception {
        return GeometryOperationUtil.getGeometryProperty((String)geoJson, (String[])propertys, (Boolean)false);
    }

    public static List<HashMap<String, Object>> getGeometryProperty(String geoJson, String[] propertys, Boolean merge) throws Exception {
        ArrayList<HashMap<String, Object>> objList = new ArrayList<HashMap<String, Object>>();
        String message = "";
        try {
            int i;
            HashMap map;
            HashMap<String, HashMap> param = new HashMap<String, HashMap>();
            if (StringUtils.isNotBlank((CharSequence)geoJson)) {
                List tempList = GeometryOperationUtil.getKeyListByGeoJson((Object)geoJson, (String)"OBJECTID");
                if (tempList != null && tempList.size() > 0) {
                    FeatureJSON queryJson = new FeatureJSON();
                    FeatureCollection queryCollection = queryJson.readFeatureCollection((Object)geoJson);
                    if (queryCollection != null && queryCollection.size() > 0) {
                        String[] defaultProperties = new String[]{"OBJECTID", "SHAPE_AREA", "OG_SHAPE_AREA", "AREA"};
                        FeatureIterator queryIterator = queryCollection.features();
                        int index = 0;
                        while (queryIterator.hasNext()) {
                            Feature feature = queryIterator.next();
                            String objectId = feature.getProperty("OBJECTID").getValue().toString();
                            map = new HashMap();
                            for (i = 0; i < defaultProperties.length; ++i) {
                                if (feature.getProperty(defaultProperties[i]) == null) continue;
                                map.put(defaultProperties[i], feature.getProperty(defaultProperties[i]).getValue());
                            }
                            param.put(objectId + "_" + index, map);
                        }
                    }
                } else {
                    message = "\u56fe\u5c42\u6570\u636e\u4e0d\u5b58\u5728\uff01";
                }
            }
            if (param != null) {
                if (merge != null && merge.booleanValue()) {
                    HashMap<String, HashMap> objParam = new HashMap<String, HashMap>();
                    String[] areaProperties = new String[]{"SHAPE_AREA", "OG_SHAPE_AREA", "AREA"};
                    Set keySet = param.keySet();
                    for (Object obj : keySet) {
                        String key = obj.toString();
                        if (!StringUtils.isNotBlank((CharSequence)key) || key.indexOf("_") <= -1) continue;
                        String curObjectId = key.split("_")[0];
                        HashMap curMap = (HashMap)param.get(key);
                        if (objParam.containsKey(curObjectId)) {
                            map = (HashMap)objParam.get(curObjectId);
                            for (i = 0; i < areaProperties.length; ++i) {
                                if (!curMap.containsKey(areaProperties[i]) || !map.containsKey(areaProperties[i])) continue;
                                map.put(areaProperties[i], CommonUtil.addBigDecimal(curMap.get(areaProperties[i]), map.get(areaProperties[i])));
                            }
                            objParam.put(curObjectId, map);
                            continue;
                        }
                        objParam.put(curObjectId, curMap);
                    }
                    objList.addAll(objParam.values());
                } else {
                    objList.addAll(param.values());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objList;
    }

    public static String delGeometry(String proid, String busiType, String whereClause) throws Exception {
        String message = "";
        if (StringUtils.isBlank((CharSequence)busiType)) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)busiType)) {
            String layerName = "";
            String geoJson = GeometryOperationUtil.queryGeometry((String)busiType, (String)whereClause, (String)"*");
            if (StringUtils.isNotBlank((CharSequence)geoJson)) {
                FeatureJSON queryJson = new FeatureJSON();
                FeatureCollection queryCollection = queryJson.readFeatureCollection((Object)geoJson);
                if (queryCollection != null && queryCollection.size() > 0) {
                    FeatureIterator queryIterator = queryCollection.features();
                    String url = "";
                    while (queryIterator.hasNext()) {
                        JSONReader jsonReader;
                        Object json;
                        Feature feature = queryIterator.next();
                        String objectId = feature.getProperty("OBJECTID").getValue().toString();
                        HttpClient client = new HttpClient();
                        PostMethod method = new PostMethod(url);
                        method.addParameter("layerName", layerName);
                        method.addParameter("primaryKey", objectId);
                        int delStatus = client.executeMethod((HttpMethod)method);
                        System.out.println("\u670d\u52a1\u5668\u8fd4\u56de\u7684\u72b6\u6001" + method.getStatusLine());
                        String returnJson = method.getResponseBodyAsString();
                        System.out.println(returnJson);
                        if (!StringUtils.isNotBlank((CharSequence)returnJson) || (json = (jsonReader = new JSONReader()).read(returnJson)) == null) continue;
                        HashMap resultMap = (HashMap)json;
                        if (!resultMap.containsKey("result")) {
                            message = message + returnJson + "\r\n";
                            System.out.println("\u5220\u9664\u5931\u8d25\uff01");
                            continue;
                        }
                        System.out.println("\u5220\u9664\u6210\u529f\uff01");
                    }
                }
            } else {
                message = "\u5f53\u524d\u9879\u76ee\u5c1a\u672a\u521b\u5efa\u56fe\u5f62\uff01";
            }
        } else {
            message = "\u6784\u5efa\u5e73\u53f0\u6ca1\u6709\u914d\u7f6e\u5f53\u524d\u5de5\u4f5c\u6d41\u5bf9\u5e94\u7684busiType\uff01";
        }
        return message;
    }

    public static String delGeometry(String proid, String busiType) throws Exception {
        String message = "";
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            String whereClause = "PROID='" + proid + "'";
            return GeometryOperationUtil.delGeometry((String)proid, (String)busiType, (String)whereClause);
        }
        message = "\u9879\u76eeid\u4e3a\u7a7a\uff01";
        return message;
    }

    public static String analysisGeometry(String geoJson, String layerName) throws Exception {
        String message = "";
        System.out.println("\u5206\u6790\u5f00\u59cb......");
        if (StringUtils.isNotBlank((CharSequence)layerName)) {
            List objList;
            HashMap resultMap;
            JSONReader jsonReader;
            Object json;
            System.out.println("\u5206\u6790\u76ee\u6807\u56fe\u5c42\uff1a" + layerName);
            String url = AppConfig.getProperty((String)"omp.url") + "/geometryService/rest/intersect";
            HttpClient client = new HttpClient();
            PostMethod method = new PostMethod(url);
            method.addParameter("layerName", layerName);
            method.addParameter("geometry", geoJson);
            method.addParameter("dataSource", "sgbwm");
            int analyStatus = client.executeMethod((HttpMethod)method);
            String returnJson = method.getResponseBodyAsString();
            System.out.println(returnJson);
            if (StringUtils.isNotBlank((CharSequence)returnJson) && (json = (jsonReader = new JSONReader()).read(returnJson)) != null && (resultMap = (HashMap)json) != null && resultMap.containsKey("result") && (objList = GeometryOperationUtil.getKeyListByGeoJson(resultMap.get("result"), (String)"OBJECTID")) != null && objList.size() > 0) {
                return resultMap.get("result").toString();
            }
        } else {
            message = "gis.properties\u6587\u4ef6\u6ca1\u6709\u914d\u7f6e\u8be5\u3010" + layerName + "\u3011\u4e1a\u52a1\u7c7b\u578b\u7684\u56fe\u5f62\u53c2\u6570\uff01";
        }
        System.out.println("\u5206\u6790\u7ed3\u675f\uff01");
        return null;
    }

    public static String toFeatureJSON(Object feature) {
        String geoJson = "";
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature)feature).getBounds() != null);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature)feature).getFeatureType().getCoordinateReferenceSystem() != null);
                featureJSON.writeFeature((SimpleFeature)feature, (Object)out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection)feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getBounds() != null);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getFeatureType().getCoordinateReferenceSystem() != null);
                }
                featureJSON.writeFeatureCollection((FeatureCollection)feature, (Object)out);
            }
            geoJson = out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return geoJson;
    }

    public static String toGeoJSON(Geometry geometry) {
        String geoJson = "";
        try {
            GeometryJSON geometryJSON = new GeometryJSON(14);
            StringWriter out = new StringWriter();
            geometryJSON.write(geometry, (Object)out);
            geoJson = out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return geoJson;
    }

    public static List<String> getObjectIdListByReturnJson(String returnJson) throws Exception {
        List<String> objectidList = new ArrayList<String>();
        try {
            HashMap resultMap;
            JSONReader jsonReader = new JSONReader();
            Object json = jsonReader.read(returnJson);
            if (json != null && (resultMap = (HashMap)json) != null && resultMap.containsKey("result") && resultMap.get("result") != null) {
                objectidList = GeometryOperationUtil.getKeyListByGeoJson(resultMap.get("result"), (String)"OBJECTID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectidList;
    }

    public static List<String> getKeyListByGeoJson(Object geoJson, String key) throws Exception {
        ArrayList<String> objectidList;
        block7: {
            objectidList = new ArrayList<String>();
            try {
                List featureListMap;
                JSONWriter writer;
                String write;
                JSONReader jsonReader;
                Object json;
                HashMap geoMap;
                block8: {
                    if (geoJson == null || !StringUtils.isNotBlank((CharSequence)geoJson.toString())) break block7;
                    geoMap = new HashMap();
                    try {
                        JSONReader jsonReader2 = new JSONReader();
                        Object json2 = jsonReader2.read(geoJson.toString());
                        if (json2 != null) {
                            geoMap = (HashMap)json2;
                        }
                    }
                    catch (Exception e) {
                        JSONWriter writer2 = new JSONWriter();
                        String write2 = writer2.write(geoJson);
                        JSONReader jsonReader3 = new JSONReader();
                        Object json3 = jsonReader3.read(write2);
                        if (json3 == null) break block8;
                        geoMap = (HashMap)json3;
                    }
                }
                if (geoMap.containsKey("features") && geoMap.get("features") != null && (json = (jsonReader = new JSONReader()).read(write = (writer = new JSONWriter()).write(geoMap.get("features")))) != null && (featureListMap = (List)json) != null && featureListMap.size() > 0) {
                    for (int i = 0; i < featureListMap.size(); ++i) {
                        JSONWriter propertiesWriter;
                        String propertiesWrite;
                        JSONReader propertiesJsonReader;
                        Object propertiesJson;
                        HashMap propertyMap;
                        HashMap featureMap = (HashMap)featureListMap.get(i);
                        if (!featureMap.containsKey("properties") || featureMap.get("properties") == null || !(propertyMap = (HashMap)(propertiesJson = (propertiesJsonReader = new JSONReader()).read(propertiesWrite = (propertiesWriter = new JSONWriter()).write(featureMap.get("properties"))))).containsKey(key) || propertyMap.get(key) == null || !StringUtils.isNotBlank((CharSequence)propertyMap.get(key).toString())) continue;
                        objectidList.add(propertyMap.get(key).toString());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objectidList;
    }

    public static HashMap<String, String> getBusiMap(String busiType, String proid) throws Exception {
        HashMap busiMap = new HashMap<String, String>();
        try {
            String busiUrl;
            if (StringUtils.isNotBlank((CharSequence)busiType) && StringUtils.isNotBlank((CharSequence)proid) && StringUtils.isNotBlank((CharSequence)(busiUrl = ""))) {
                JSONReader reader;
                Object json;
                System.out.println("\u4e1a\u52a1\u6570\u636e\u83b7\u53d6URL\u5730\u5740\uff1a" + busiUrl);
                HttpClient client = new HttpClient();
                PostMethod method = new PostMethod(busiUrl);
                method.addParameter("proid", proid);
                int status = client.executeMethod((HttpMethod)method);
                System.out.println("\u670d\u52a1\u5668\u8fd4\u56de\u72b6\u6001\uff1a" + method.getStatusLine());
                String returnJson = method.getResponseBodyAsString();
                System.out.println(returnJson);
                if (StringUtils.isNotBlank((CharSequence)returnJson) && (json = (reader = new JSONReader()).read(returnJson = URLDecoder.decode(returnJson, "UTF-8"))) != null) {
                    busiMap = (HashMap)json;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (busiMap == null) {
            busiMap = new HashMap();
        }
        return busiMap;
    }
}

