/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.thread;

import com.gtis.config.AppConfig;
import com.gtis.spring.Container;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class BdcThreadEngine {
    private static final Logger logger = LoggerFactory.getLogger(BdcThreadEngine.class);
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    final Semaphore semaphore = new Semaphore(AppConfig.getIntProperty((String)"threadPool.max", (int)3));

    public <T> List<T> excuteThread(List<T> list) {
        boolean hasPool = this.semaphore.tryAcquire();
        if (CollectionUtils.isNotEmpty(list)) {
            this.taskExecutor = (ThreadPoolTaskExecutor)Container.getBean((String)"bdcThreadTaskExecutor");
            if (!hasPool) {
                this.taskExecutor.setCorePoolSize(1);
                this.taskExecutor.setMaxPoolSize(1);
            }
            double countSize = list.size();
            int i = 0;
            while ((double)i < countSize) {
                this.taskExecutor.execute((Runnable)list.get(i));
                ++i;
            }
            this.shutDownThread();
        }
        return list;
    }

    private void shutDownThread() {
        ThreadPoolExecutor threadPoolExecutor = this.taskExecutor.getThreadPoolExecutor();
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        while (true) {
            int count = this.taskExecutor.getActiveCount();
            int queueSize = queue.size();
            if (count == 0 && queueSize == 0) break;
            logger.info("\u7ebf\u7a0b\u6c60\u5c1a\u5728\u5de5\u4f5c\u4e2d\uff0c\u5f53\u524d\u89e6\u53d1{}\u4e2a\u7ebf\u7a0b\uff0c\u961f\u5217\u4e2d\u5b58\u5728{}\u4e2a\u4efb\u52a1\u6392\u961f", (Object)count, (Object)queueSize);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
        this.semaphore.release();
        this.taskExecutor.destroy();
    }
}

