/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.model.ycsl.bo.BdcMediaBO;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.OpenApiResponseMediaDTO;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.enums.ZdDzjgEnums;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryMediaService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestService;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiQueryMediaServiceImpl
implements OpenApiQueryMediaService {
    @Autowired
    private OpenApiRequestService openApiRequestService;
    @Autowired
    private PlatformUtil platformUtil;
    @Autowired
    private BdcXmService bdcXmService;

    public List<BdcMediaBO> queryFjxx(String parametes) {
        String url = AppConfig.getProperty((String)"hma.st.ycsl.cxyxzl.url");
        String fjxxs = this.openApiRequestService.request(url, parametes, ZdDzjgEnums.DZJG_SXYCSL.getDzjg());
        OpenApiResponseMediaDTO openApiResponseMediaDTO = (OpenApiResponseMediaDTO)JSONObject.parseObject((String)fjxxs, OpenApiResponseMediaDTO.class);
        if (openApiResponseMediaDTO != null) {
            return openApiResponseMediaDTO.getData();
        }
        return new ArrayList<BdcMediaBO>();
    }

    public List<BdcMediaBO> queryBdcFjxx(String dybm, List<String> qlidList) {
        if (CollectionUtils.isEmpty(qlidList)) {
            return Lists.newArrayList();
        }
        ArrayList qlids = Lists.newArrayList();
        for (String qlid : qlidList) {
            qlids.add(qlid.split("_")[1]);
        }
        HashMap queryParam = Maps.newHashMap();
        queryParam.put("qlids", qlids);
        List proidList = this.bdcXmService.queryProidsByQlid((Map)queryParam);
        if (CollectionUtils.isEmpty((Collection)proidList)) {
            throw new OpenApiException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f71\u50cf\u8d44\u6599\u4fe1\u606f\uff01");
        }
        ArrayList resultList = Lists.newArrayList();
        NodeService nodeService = PlatformUtil.getNodeService();
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        for (String proid : proidList) {
            Node tempNode = nodeService.getNode(space.getId(), proid, true);
            List nodes = nodeService.getChildNodes(tempNode.getId());
            if (!CollectionUtils.isNotEmpty((Collection)nodes)) continue;
            for (Node node : nodes) {
                Integer num = node.getChildCount();
                String name = node.getName();
                List childNodes = nodeService.getChildNodes(node.getId());
                if (!CollectionUtils.isNotEmpty((Collection)childNodes)) continue;
                for (Node child : childNodes) {
                    String type = null;
                    String childName = child.getName();
                    if (StringUtils.isNotBlank((CharSequence)childName)) {
                        type = childName.split("\\.")[1];
                    }
                    String image = this.platformUtil.queryFileBase64String(String.valueOf(child.getId()));
                    BdcMediaBO bdcMediaBO = new BdcMediaBO();
                    bdcMediaBO.setId(String.valueOf(child.getId()));
                    bdcMediaBO.setName(child.getName());
                    bdcMediaBO.setPageContent("data:image/jpeg;base64," + image);
                    bdcMediaBO.setDatumName(name);
                    bdcMediaBO.setType("." + type);
                    bdcMediaBO.setNumber(num);
                    resultList.add(bdcMediaBO);
                }
            }
        }
        return resultList;
    }
}

