/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.mapper.server.BdcXtConfigMapper;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.bo.BdcdyQlxxBO;
import cn.gtmap.estateplat.server.core.model.ycsl.qo.BdcdyQlxxQO;
import cn.gtmap.estateplat.server.core.service.BdcDjsjService;
import cn.gtmap.estateplat.server.core.service.BdcDyaqService;
import cn.gtmap.estateplat.server.core.service.BdcFdcqService;
import cn.gtmap.estateplat.server.core.service.BdcJsydzjdsyqService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcYgService;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.core.service.DjsjFwService;
import cn.gtmap.estateplat.server.enums.BdcDzbsEnum;
import cn.gtmap.estateplat.server.enums.ZdDzjgEnums;
import cn.gtmap.estateplat.server.enums.ZdQlbmEnum;
import cn.gtmap.estateplat.server.service.rest.OpenApiCommonService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryCqxxService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestParamCheckService;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import cn.gtmap.estateplat.server.utils.CommonUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
public class OpenApiQueryCqxxServiceImpl
implements OpenApiQueryCqxxService {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private OpenApiCommonService openApiCommonService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private OpenApiRequestParamCheckService openApiRequestParamCheckService;
    @Autowired
    private OpenApiResponseService openApiResponseService;
    @Autowired
    private BdcFdcqService bdcFdcqService;
    @Autowired
    private BdcJsydzjdsyqService bdcJsydzjdsyqService;
    @Autowired
    private BdcYgService bdcYgService;
    @Autowired
    private BdcDyaqService bdcDyaqService;
    @Autowired
    private DjsjFwService djsjFwService;
    @Autowired
    private BdcDjsjService bdcDjsjService;
    @Autowired
    public BdcXtConfigMapper bdcXtConfigMapper;

    public List<BdcdyQlxxBO> queryBdcdyQlxxList(@Validated BdcdyQlxxQO bdcdyQlxxQO) {
        List bdcdyQlxxBOList = this.bdcXmService.queryBdcdyQlxxList(bdcdyQlxxQO);
        HashMap xtConfig = Maps.newHashMap();
        xtConfig.put("nf", String.valueOf(CommonUtils.getCurrentYear()));
        BdcXtConfig bdcXtConfig = this.bdcXtConfigMapper.selectBdcXtConfig((Map)xtConfig);
        if (CollectionUtils.isNotEmpty((Collection)bdcdyQlxxBOList)) {
            for (BdcdyQlxxBO bdcdyQlxxBO : bdcdyQlxxBOList) {
                Object qlbm;
                Project project = new Project();
                project.setBdcdyh(bdcdyQlxxBO.getBdcdyh());
                project.setQllx(bdcdyQlxxBO.getQllxdm());
                String sqlx = this.bdcZdGlService.getBdcDzDm(bdcdyQlxxQO.getLcdm(), BdcDzbsEnum.DZBS_LCDM.getDzbs(), ZdDzjgEnums.DZJG_SXYCSL.getDzjg());
                if (sqlx != null) {
                    project.setSqlx(String.valueOf(sqlx));
                }
                bdcdyQlxxBO.setLcdm(bdcdyQlxxQO.getLcdm());
                String zszt = this.openApiCommonService.queryZszt(bdcdyQlxxBO.getBdcdyh(), bdcdyQlxxBO.getGdproid());
                boolean restrict = this.openApiCommonService.checkBdcXm(project);
                if (StringUtils.isBlank((String)zszt)) {
                    bdcdyQlxxBO.setZszt("\u6b63\u5e38");
                } else {
                    bdcdyQlxxBO.setZszt(zszt);
                    if (StringUtils.equals((String)"4", (String)bdcdyQlxxBO.getQllxdm())) {
                        restrict = true;
                    }
                }
                bdcdyQlxxBO.setRestrict(Boolean.valueOf(restrict));
                if (bdcXtConfig != null) {
                    bdcdyQlxxBO.setQxdm(Long.valueOf(bdcXtConfig.getDwdm()));
                }
                if ((qlbm = this.bdcZdGlService.getDsfDzDm((Object)bdcdyQlxxBO.getQllxdm(), BdcDzbsEnum.DJZX_QLBM.getDzbs().toLowerCase(), ZdDzjgEnums.DZJG_SXYCSL.getDzjg())) != null) {
                    bdcdyQlxxBO.setQlbm(String.valueOf(qlbm));
                    bdcdyQlxxBO.setQtdjbm(String.valueOf(qlbm));
                    bdcdyQlxxBO.setQlbsm(qlbm + "_" + bdcdyQlxxBO.getQlbsm());
                }
                if (bdcdyQlxxBO.getBdcdyh().contains("F")) {
                    bdcdyQlxxBO.setDybm("H");
                    continue;
                }
                bdcdyQlxxBO.setDybm("ZD_SHIYQ");
            }
        }
        return bdcdyQlxxBOList;
    }

    public String queryRights(ApiRequestParameter requestParameter) {
        try {
            this.openApiRequestParamCheckService.validateFiled(requestParameter);
            List bsmList = requestParameter.getQlbsms();
            String qlbm = requestParameter.getQlbm();
            Map qlbsmMap = this.openApiCommonService.parseBsms(bsmList);
            List qlbsmList = (List)qlbsmMap.get(qlbm);
            HashMap<String, List> param = new HashMap<String, List>(1);
            param.put("qlbsms", qlbsmList);
            String responseFields = "";
            List resultEntityList = null;
            if (StringUtils.equalsIgnoreCase((String)qlbm, (String)ZdQlbmEnum.QLBM_FDCQ.getQlbm())) {
                responseFields = "yxtbsm,ywh,qllx,djlx,yxtdjlxmc,djyy,fdcjyjg,qdfs,fkfs,gfhtbh,qyrq,jylx,qszt,qxdm,djjg,gxsj,bz,dsywlx,qszydx";
                resultEntityList = this.bdcFdcqService.queryFdcqxx(param);
            } else if (StringUtils.equalsIgnoreCase((String)qlbm, (String)ZdQlbmEnum.QLBM_JSYDSYQ.getQlbm())) {
                responseFields = "yxtbsm,ywh,qllx,djlx,djyy,syqmj,syqqssj,syqjssj,qdjg,djjg,mjdw,qxdm,dytdmj,fttdmj,gytdmj,jzmj,qlxz,qlrzdbh,qlrzl,sjyt,pzyt,sjytmc,pzytmc,gxsj,bz,qlxzmc";
                resultEntityList = this.bdcJsydzjdsyqService.queryJsydsyqxx(param);
            } else if (StringUtils.equalsIgnoreCase((String)qlbm, (String)ZdQlbmEnum.QLBM_YGDJ.getQlbm())) {
                responseFields = "yxtbsm,ywh,ygdjzl,djlx,djyy,tdsyqr,qdjg,fkfs,htbh,qlqssj,qljssj,bz,qszt,qxdm,djjg,dyfs,dysx,gxsj,hblx,qyrq";
                resultEntityList = this.bdcYgService.queryYgxx(param);
            } else if (StringUtils.equalsIgnoreCase((String)qlbm, (String)ZdQlbmEnum.QLBM_DYAQ.getQlbm())) {
                responseFields = "yxtbsm,ywh,dybdclx,dyfs,zjjzwzl,zjjzwdyfw,bdbzqse,zgzqse,qlqssj,qljssj,qlqx,zgzqqdsshse,djyy,djsj,qxdm,djjg,htbh,bz,dbfw,hblx";
                resultEntityList = this.bdcDyaqService.queryDyaqxx(param);
            }
            List resultList = this.openApiResponseService.parseResult(resultEntityList, responseFields, ZdDzjgEnums.DZJG_SXYCSL.getDzjg());
            return JSON.toJSONString((Object)this.openApiResponseService.response(resultList, requestParameter), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (OpenApiException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    public List<Map<String, Object>> queryHasZs(ApiRequestParameter apiRequestParameter) {
        this.openApiRequestParamCheckService.validateFiled(apiRequestParameter);
        String fzbm = apiRequestParameter.getFzbm();
        String regex = "[0-9]\\d*";
        if (Pattern.matches(regex, fzbm)) {
            apiRequestParameter.setZhlsh(fzbm);
        } else {
            apiRequestParameter.setBdcqzh(fzbm);
        }
        return this.bdcFdcqService.queryHasZs(apiRequestParameter);
    }

    public Object queryBdcdyJbxxList(@NotBlank String dybm, @NotBlank List<String> bdcdyhList) {
        if (StringUtils.equals((String)"H", (String)dybm)) {
            return this.djsjFwService.queryDjsjFwJbxx(bdcdyhList);
        }
        if (StringUtils.equals((String)"ZD_SHIYQ", (String)dybm)) {
            return this.bdcDjsjService.queryBdcTdJbxx(bdcdyhList);
        }
        throw new OpenApiException("\u5355\u5143\u7f16\u7801\u4e0d\u5c5e\u4e8e\u623f\u5c4b\u6237\u3001\u5b97\u5730");
    }

    public Object queryBdcTdjbxxAndQlxx(String zddm, String bdcqzh) {
        if (StringUtils.isBlank((String)zddm) && StringUtils.isBlank((String)bdcqzh)) {
            return Lists.newArrayList();
        }
        HashMap param = Maps.newHashMap();
        param.put("zddm", zddm);
        param.put("tdzh", bdcqzh);
        return this.bdcDjsjService.queryBdcTdxxAndQlxx((Map)param);
    }
}

