/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.service.BdcCfService;
import cn.gtmap.estateplat.server.core.service.BdcDyaqService;
import cn.gtmap.estateplat.server.core.service.BdcYgService;
import cn.gtmap.estateplat.server.core.service.BdcYyService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.GdXmService;
import cn.gtmap.estateplat.server.enums.MapKeyEnum;
import cn.gtmap.estateplat.server.enums.MapKeyLowerCaseEnum;
import cn.gtmap.estateplat.server.service.ProjectCheckInfoService;
import cn.gtmap.estateplat.server.service.rest.OpenApiCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiCommonServiceImpl
implements OpenApiCommonService {
    @Autowired
    ProjectCheckInfoService projectCheckInfoService;
    @Autowired
    BdcCfService bdcCfService;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    GdXmService gdXmService;
    @Autowired
    BdcDyaqService bdcDyaqService;
    @Autowired
    BdcYyService bdcYyService;
    @Autowired
    BdcYgService bdcYgService;

    public boolean checkBdcXm(Project project) {
        boolean result = false;
        List resultList = this.projectCheckInfoService.checkXmByProject(project);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            StringBuilder confirmMsg = new StringBuilder();
            StringBuilder alertMsg = new StringBuilder();
            for (Map map : resultList) {
                if (map.containsKey(MapKeyLowerCaseEnum.KEY_CHECKMODEL.getMapKey()) && map.get(MapKeyLowerCaseEnum.KEY_CHECKMODEL.getMapKey()) == "confirm") {
                    confirmMsg.append(map.get("checkMsg"));
                }
                if (!map.containsKey(MapKeyLowerCaseEnum.KEY_CHECKMODEL.getMapKey()) || map.get(MapKeyLowerCaseEnum.KEY_CHECKMODEL.getMapKey()) != "alert") continue;
                alertMsg.append(map.get("checkMsg"));
            }
            result = StringUtils.isNotBlank((CharSequence)confirmMsg) || StringUtils.isNotBlank((CharSequence)alertMsg);
        }
        return result;
    }

    public String queryZszt(String bdcdyh, String gdproid) {
        StringBuilder zsztBulider = new StringBuilder();
        boolean cfzt = this.bdcCfService.querySfcf(bdcdyh);
        boolean dyzt = this.bdcDyaqService.querySfdyaq(bdcdyh);
        boolean yyzt = this.bdcYyService.querySfyy(bdcdyh);
        boolean sdzt = this.querySdzt(bdcdyh, gdproid);
        boolean ygzt = this.bdcYgService.querySfyg(bdcdyh, "1,2");
        boolean ygdyzt = this.bdcYgService.querySfyg(bdcdyh, "3,4");
        if (cfzt) {
            zsztBulider.append("\u67e5\u5c01");
        }
        if (dyzt) {
            zsztBulider.append(StringUtils.isNotBlank((CharSequence)zsztBulider) ? "/\u62b5\u62bc" : "\u62b5\u62bc");
        }
        if (yyzt) {
            zsztBulider.append(StringUtils.isNotBlank((CharSequence)zsztBulider) ? "/\u5f02\u8bae" : "\u5f02\u8bae");
        }
        if (sdzt) {
            zsztBulider.append(StringUtils.isNotBlank((CharSequence)zsztBulider) ? "/\u9501\u5b9a" : "\u9501\u5b9a");
        }
        if (ygzt) {
            zsztBulider.append(StringUtils.isNotBlank((CharSequence)zsztBulider) ? "/\u9884\u544a" : "\u9884\u544a");
        }
        if (ygdyzt) {
            zsztBulider.append(StringUtils.isNotBlank((CharSequence)zsztBulider) ? "/\u9884\u544a\u62b5\u62bc" : "\u9884\u544a\u62b5\u62bc");
        }
        return zsztBulider.toString();
    }

    public boolean querySdzt(String bdcdyh, String gdproid) {
        if (StringUtils.isBlank((CharSequence)bdcdyh) || StringUtils.isBlank((CharSequence)gdproid)) {
            return false;
        }
        List bdcdySdList = this.bdcdyService.queryBdcdySdByBdcdyh(bdcdyh);
        List gdBdcSdList = this.gdXmService.getGdBdcSd(MapKeyEnum.PROID.getMapKey(), gdproid, 1);
        return CollectionUtils.isNotEmpty((Collection)bdcdySdList) || CollectionUtils.isNotEmpty((Collection)gdBdcSdList);
    }

    public Map<String, List<String>> parseBsms(List<String> bsmList) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (CollectionUtils.isEmpty(bsmList)) {
            return resultMap;
        }
        for (String bsms : bsmList) {
            String qlbm = StringUtils.substringBeforeLast((String)bsms, (String)"_");
            String qlbsm = StringUtils.substringAfter((String)bsms, (String)"_");
            if (resultMap.containsKey(qlbm)) {
                ((List)resultMap.get(qlbm)).add(qlbsm);
                continue;
            }
            ArrayList<String> tempQlbsm = new ArrayList<String>();
            tempQlbsm.add(qlbsm);
            resultMap.put(qlbm, tempQlbsm);
        }
        return resultMap;
    }
}

