/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.DynamicTableRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.springframework.stereotype.Service;

@Service
public class OfficeDocTablePolicy
extends DynamicTableRenderPolicy {
    private static final TableStyle rowStyle = new TableStyle();

    public void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            return;
        }
        List cellNameList = this.getTableCellName(table);
        if (CollectionUtils.isEmpty((Collection)cellNameList)) {
            return;
        }
        List labors = (List)data;
        if (CollectionUtils.isNotEmpty((Collection)labors)) {
            table.removeRow(1);
            for (int i = labors.size() - 1; i >= 0; --i) {
                XWPFTableRow insertNewTableRow = table.insertNewTableRow(1);
                int cellSize = CollectionUtils.isEmpty((Collection)cellNameList) ? ((Map)labors.get(i)).size() : cellNameList.size();
                for (int j = 0; j < cellSize; ++j) {
                    insertNewTableRow.createCell();
                }
                String[] cellDatas = new String[cellSize];
                Map cellData = (Map)labors.get(i);
                if (CollectionUtils.isEmpty((Collection)cellNameList)) {
                    int index = 0;
                    for (Map.Entry entry : cellData.entrySet()) {
                        cellDatas[index++] = String.valueOf(entry.getValue());
                    }
                } else {
                    for (int k = 0; k < cellSize; ++k) {
                        String dataStr;
                        Object itemData = cellData.get(cellNameList.get(k));
                        cellDatas[k] = dataStr = null == itemData ? "" : String.valueOf(itemData);
                    }
                }
                RowRenderData row = RowRenderData.build((String[])cellDatas);
                row.setRowStyle(rowStyle);
                MiniTableRenderPolicy.Helper.renderRow((XWPFTable)table, (int)1, (RowRenderData)row);
            }
        }
    }

    private List<String> getTableCellName(XWPFTable table) {
        String text = table.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\{\\{CELL_[A-Za-z0-9_]+\\}\\}");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> cellNameList = new ArrayList<String>(10);
        while (matcher.find()) {
            cellNameList.add(matcher.group().replace("{{CELL_", "").replace("}}", ""));
        }
        return cellNameList;
    }

    static {
        rowStyle.setAlign(STJc.CENTER);
    }
}

