/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import cn.gtmap.estateplat.server.core.model.OfficeExportDTO;
import cn.gtmap.estateplat.server.service.OfficeDocService;
import cn.gtmap.estateplat.server.service.impl.OfficeDocTablePolicy;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.policy.RenderPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OfficeDocServiceImpl
implements OfficeDocService {
    public NiceXWPFDocument getXwpfDocument(OfficeExportDTO officeExportDTO) throws Exception {
        if (null == officeExportDTO) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (CollectionUtils.isEmpty((Collection)officeExportDTO.getExportDataList())) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u5bfc\u51fapdf\u6570\u636e!");
        }
        List dataList = officeExportDTO.getExportDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u6253\u5370\u6570\u636e!");
        }
        NiceXWPFDocument firstXWPFDoc = this.getNiceXWPFDocument(officeExportDTO.getModelName(), (Map)dataList.get(0));
        if (dataList.size() > 1) {
            firstXWPFDoc.createParagraph().setPageBreak(true);
        }
        if (dataList.size() > 1) {
            for (int i = 1; i < dataList.size(); ++i) {
                NiceXWPFDocument document = this.getNiceXWPFDocument(officeExportDTO.getModelName(), (Map)dataList.get(i));
                if (i != dataList.size() - 1) {
                    document.createParagraph().setPageBreak(true);
                }
                firstXWPFDoc = firstXWPFDoc.merge(document);
            }
        }
        return firstXWPFDoc;
    }

    public List<NiceXWPFDocument> getXwpfDocumentList(OfficeExportDTO officeExportDTO) throws Exception {
        if (null == officeExportDTO) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        List dataList = officeExportDTO.getExportDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            throw new NullPointerException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5bfc\u51fa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<NiceXWPFDocument> documentList = new ArrayList<NiceXWPFDocument>(dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            NiceXWPFDocument document = this.getNiceXWPFDocument(officeExportDTO.getModelName(), (Map)dataList.get(i));
            documentList.add(document);
        }
        return documentList;
    }

    public NiceXWPFDocument getNiceXWPFDocument(String modelName, Map<String, Object> data) {
        Set<String> keySet = data.keySet();
        HashSet<String> subTableIDSet = new HashSet<String>(5);
        if (CollectionUtils.isNotEmpty(keySet)) {
            for (String key : keySet) {
                if (!StringUtils.isNotBlank((CharSequence)key) || !key.startsWith("TABLE_")) continue;
                subTableIDSet.add(key);
            }
        }
        if (CollectionUtils.isNotEmpty(subTableIDSet)) {
            Configure configs = Configure.createDefault();
            for (String subTableID : subTableIDSet) {
                configs.customPolicy(subTableID, (RenderPolicy)new OfficeDocTablePolicy());
            }
            XWPFTemplate template = XWPFTemplate.compile((String)modelName, (Configure)configs);
            template.render(data);
            return template.getXWPFDocument();
        }
        XWPFTemplate template = XWPFTemplate.compile((String)modelName);
        template.render(data);
        return template.getXWPFDocument();
    }
}

