/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcDelZszh;
import cn.gtmap.estateplat.model.server.core.BdcDyZs;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.server.BdcDelZszhMapper;
import cn.gtmap.estateplat.server.core.mapper.server.BdcZsMapper;
import cn.gtmap.estateplat.server.core.mapper.server.BdcZsbhMapper;
import cn.gtmap.estateplat.server.core.model.rest.BdcZsbhBO;
import cn.gtmap.estateplat.server.core.service.BdcXtConfigService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.service.BdczsBhService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class BdczsBhServiceImpl
implements BdczsBhService {
    @Autowired
    public BdcZsService bdcZsService;
    @Autowired
    public BdcXtConfigService bdcXtConfigService;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcDelZszhMapper bdcDelZszhMapper;
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    public BdcZsMapper bdcZsMapper;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private BdcZsbhMapper bdcZsbhMapper;

    public String getProvinceShortName(BdcXtConfig bdcXtConfig) {
        String provinceShortName = "";
        if (bdcXtConfig != null) {
            provinceShortName = bdcXtConfig.getSqsjc();
        }
        return provinceShortName;
    }

    public String getBhYear(BdcXtConfig bdcXtConfig) {
        String year = "";
        if (bdcXtConfig != null) {
            year = bdcXtConfig.getNf();
        }
        return year;
    }

    public String getXzqShortName(BdcXtConfig bdcXtConfig) {
        String xzq = "";
        if (bdcXtConfig != null) {
            xzq = bdcXtConfig.getSzsxqc();
        }
        return xzq;
    }

    @Transactional(readOnly=true)
    public String getLsh(BdcXtConfig bdcXtConfig, String zsFont, int zsIndex, String dwdm) {
        Integer maxLsh;
        String lsh = "";
        Integer len = 0;
        if (bdcXtConfig != null) {
            len = bdcXtConfig.getBdcqzhws();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zstype", zsFont);
        map.put("nf", CalendarUtil.getCurrYear());
        if (StringUtils.equals((CharSequence)AppConfig.getProperty((String)"sys.version"), (CharSequence)"ankang") || StringUtils.equals((CharSequence)AppConfig.getProperty((String)"sys.version"), (CharSequence)"lasa")) {
            map.put("dwdm", dwdm);
        }
        if ((maxLsh = this.bdcZsService.getMaxLsh(map)) == null) {
            maxLsh = 0;
        }
        maxLsh = maxLsh + 1;
        lsh = (maxLsh = Integer.valueOf(maxLsh + zsIndex)).toString();
        if (lsh.length() < len) {
            while ((lsh = "0" + lsh).length() < len) {
            }
        }
        return lsh;
    }

    public String getMaxLshBySl(BdcXtConfig bdcXtConfig, String zsFont, BdcXm bdcXm) {
        HashMap<String, String> map;
        Integer maxLsh = null;
        Integer len = 0;
        String lsh = "";
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)zsFont) && StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u6743")) {
            map = new HashMap<String, String>();
            String sqZscqzLsh = "sq_zscqz_lsh";
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getSsxz()) && bdcXm.getSsxz().length() != 6) {
                sqZscqzLsh = sqZscqzLsh + "_" + bdcXm.getSsxz();
            }
            map.put("BdcqzLsh", sqZscqzLsh);
            maxLsh = this.getMaxLshByXl(map);
        } else if (bdcXm != null && StringUtils.isNotBlank((CharSequence)zsFont) && StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e")) {
            map = new HashMap();
            String sqZsczmLsh = "sq_zsczm_lsh";
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getSsxz())) {
                sqZsczmLsh = sqZsczmLsh + "_" + bdcXm.getSsxz();
            }
            map.put("BdcqzLsh", sqZsczmLsh);
            maxLsh = this.getMaxLshByXl(map);
        }
        if (maxLsh != null) {
            lsh = maxLsh.toString();
        }
        if (bdcXtConfig != null && bdcXtConfig.getBdcqzhws() != null) {
            len = bdcXtConfig.getBdcqzhws();
        }
        if (lsh.length() < len) {
            while ((lsh = "0" + lsh).length() < len) {
            }
        }
        return lsh;
    }

    public List<BdcZsbh> queryBdcZsbh(Map params) {
        if (params == null || params.size() == 0) {
            return new ArrayList<BdcZsbh>();
        }
        return this.bdcZsbhMapper.getBdcZsBhListByBhfw(params);
    }

    public void updateSyqk(List<BdcZsbhBO> zsbhList) {
        if (CollectionUtils.isEmpty(zsbhList)) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(4);
        for (BdcZsbhBO bdcZsbhBO : zsbhList) {
            List bdcZsList;
            param.put("yhmc", bdcZsbhBO.getYhmc());
            param.put("zsbh", bdcZsbhBO.getZsbh());
            param.put("zslx", bdcZsbhBO.getZslx());
            List bdcZsbhs = this.bdcZsbhMapper.getBdcZsBhListByBhfw(param);
            if (!CollectionUtils.isNotEmpty((Collection)bdcZsbhs)) continue;
            String zsid = "";
            if (!StringUtils.equals((CharSequence)bdcZsbhBO.getSyqk(), (CharSequence)"2") && CollectionUtils.isNotEmpty((Collection)(bdcZsList = this.bdcZsService.queryBdcZsByProid(bdcZsbhBO.getYwbsm())))) {
                BdcZs bdcZs = (BdcZs)bdcZsList.get(0);
                zsid = bdcZs.getZsid();
            }
            BdcZsbh bdcZsbh = (BdcZsbh)bdcZsbhs.get(0);
            bdcZsbh.setSyqk(bdcZsbhBO.getSyqk());
            if (StringUtils.isNotBlank((CharSequence)zsid) && StringUtils.isBlank((CharSequence)bdcZsbh.getZsid())) {
                bdcZsbh.setZsid(zsid);
            }
            bdcZsbh.setLqr(bdcZsbhBO.getLqr());
            bdcZsbh.setLqrid(bdcZsbhBO.getLqrbs());
            this.entryMapper.saveOrUpdate((Object)bdcZsbh, (Object)bdcZsbh.getZsbhid());
        }
    }

    public Integer getMaxLshByXl(Map map) {
        return this.bdcZsMapper.getMaxLshByXl(map);
    }

    @Transactional
    public BdcDyZs creatBdcqzBh(BdcXm bdcXm, BdcDyZs bdcZs, int zsIndex) {
        String bdcqzh = "";
        if (bdcZs == null) {
            bdcZs = new BdcDyZs();
        }
        if (StringUtils.isBlank((CharSequence)bdcZs.getBdcqzh())) {
            BdcXtConfig bdcXtConfig = this.bdcXtConfigService.queryBdczsBhConfig(bdcXm);
            String nf = this.getBhYear(bdcXtConfig);
            String sqsjc = this.getProvinceShortName(bdcXtConfig);
            String szsxqc = this.getXzqShortName(bdcXtConfig);
            QllxVo qllxVo = this.qllxService.makeSureQllx(bdcXm);
            String zsFont = this.qllxService.makeSureBdcqzlx(qllxVo);
            String zsFont1 = AppConfig.getProperty((String)"spfscdj.zstype");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zsFont1}) && StringUtils.equals((CharSequence)zsFont1, (CharSequence)"\u9996\u6b21\u767b\u8bb0\u8bc1") && StringUtils.equals((CharSequence)bdcXm.getSqlx(), (CharSequence)"130")) {
                zsFont = zsFont1;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zsFont})) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("isuse", "0");
                map.put("zstype", zsFont);
                map.put("nf", nf);
                String bdcqzhFilterZhXzdm = AppConfig.getProperty((String)"bdcqzh.filterZh.xzdm");
                if (StringUtils.equals((CharSequence)bdcqzhFilterZhXzdm, (CharSequence)"true")) {
                    map.put("dwdm", bdcXm.getSsxz());
                } else {
                    map.put("dwdm", bdcXm.getDwdm());
                }
                List bdcDelZszhList = this.bdcDelZszhMapper.getBdcDelZszhList(map);
                if (bdcDelZszhList != null && CollectionUtils.isNotEmpty((Collection)bdcDelZszhList)) {
                    BdcDelZszh bdcDelZszh = (BdcDelZszh)bdcDelZszhList.get(0);
                    bdcZs.setZstype(zsFont);
                    bdcZs.setZhlsh(bdcDelZszh.getZhlsh());
                    bdcZs.setNf(bdcDelZszh.getNf());
                    bdcZs.setSqsjc(bdcDelZszh.getSqsjc());
                    bdcZs.setSzsxqc(bdcDelZszh.getSzsxqc());
                    bdcZs.setBdcqzh(bdcDelZszh.getBdcqzh());
                    bdcDelZszh.setIsuse("1");
                    this.entryMapper.saveOrUpdate((Object)bdcDelZszh, (Object)bdcDelZszh.getZszhid());
                } else {
                    String lsh = "";
                    String useSequence = AppConfig.getProperty((String)"use.sequence");
                    lsh = StringUtils.equals((CharSequence)useSequence, (CharSequence)"true") ? this.getMaxLshBySl(bdcXtConfig, zsFont, bdcXm) : this.getLsh(bdcXtConfig, zsFont, zsIndex, bdcXm.getDwdm());
                    String bdcqzhInsertZhXzdm = AppConfig.getProperty((String)"bdcqzh.insertZh.xzdm");
                    if (StringUtils.equals((CharSequence)bdcqzhInsertZhXzdm, (CharSequence)"true")) {
                        lsh = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcXm.getSsxz()}) && bdcXm.getSsxz().length() == 9 ? bdcXm.getSsxz().substring(7) + lsh : "00" + lsh;
                    }
                    bdcqzh = sqsjc + "(" + nf + ")" + szsxqc + zsFont + "\u7b2c" + lsh + "\u53f7";
                    bdcZs.setZstype(zsFont);
                    bdcZs.setZhlsh(lsh);
                    bdcZs.setNf(nf);
                    bdcZs.setSqsjc(sqsjc);
                    bdcZs.setSzsxqc(szsxqc);
                    bdcZs.setBdcqzh(bdcqzh);
                }
            }
        }
        return bdcZs;
    }
}

