/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.factory;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.enums.MapKeyLowerCaseEnum;
import cn.gtmap.estateplat.server.enums.ServiceOperateTypeEnum;
import cn.gtmap.estateplat.server.factory.DocumentReader;
import cn.gtmap.estateplat.server.service.CreatProjectService;
import cn.gtmap.estateplat.server.service.DelProjectService;
import cn.gtmap.estateplat.server.service.EndProjectService;
import cn.gtmap.estateplat.server.service.ProjectService;
import cn.gtmap.estateplat.server.service.TurnProjectService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class ProjectServiceFactory {
    private Logger logger = LoggerFactory.getLogger(ProjectServiceFactory.class);
    private Resource sqlxLocations;
    private Resource djlxLocations;
    private Map<String, String> createProjectServices = new HashMap();
    private Map<String, String> turnProjectServices = new HashMap();
    private Map<String, String> delProjectServices = new HashMap();
    private Map<String, String> endProjectServices = new HashMap();
    private Map<String, String> defaultCreateProjectServices = new HashMap();
    private Map<String, String> defaultTurnProjectServices = new HashMap();
    private Map<String, String> defaultDelProjectServices = new HashMap();
    private Map<String, String> defaultEndProjectServices = new HashMap();
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private ProjectService projectService;

    public ProjectServiceFactory(Resource sqlxLocations, Resource djlxLocations) {
        this.sqlxLocations = sqlxLocations;
        this.djlxLocations = djlxLocations;
    }

    public ProjectServiceFactory() {
    }

    @PostConstruct
    public void init() {
        this.registerServices();
    }

    private void registerServices() {
        if (this.sqlxLocations != null) {
            this.register(this.sqlxLocations);
        }
        if (this.djlxLocations != null) {
            this.register(this.djlxLocations);
        }
    }

    private void register(Resource resource) {
        DocumentReader reader = new DocumentReader();
        Document document = reader.read(resource);
        if (document != null) {
            this.parseServicesXml(document.getRootElement());
        }
    }

    private void parseServicesXml(Element rootElement) {
        List services = rootElement.elements();
        for (Element service : services) {
            this.parseService(service);
        }
    }

    private void parseService(Element service) {
        String serviceType = service.attributeValue("type");
        String operate = service.attributeValue("operate");
        List servList = service.elements("serv");
        Map servicesMap = this.parseServList(servList, serviceType);
        if (servicesMap == null || servicesMap.size() == 0) {
            return;
        }
        if (StringUtils.equals((CharSequence)"sqlx", (CharSequence)serviceType)) {
            if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_CREATE.getType())) {
                this.createProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_TURN.getType())) {
                this.turnProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_DELETE.getType())) {
                this.delProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_END.getType())) {
                this.endProjectServices.putAll(servicesMap);
            }
        } else if (StringUtils.equals((CharSequence)"djlx", (CharSequence)serviceType)) {
            if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_CREATE.getType())) {
                this.defaultCreateProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_TURN.getType())) {
                this.defaultTurnProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_DELETE.getType())) {
                this.defaultDelProjectServices.putAll(servicesMap);
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)ServiceOperateTypeEnum.OPERATE_TYPE_END.getType())) {
                this.defaultEndProjectServices.putAll(servicesMap);
            }
        }
    }

    private Map<String, String> parseServList(List<Element> servList, String type) {
        if (CollectionUtils.isEmpty(servList)) {
            return null;
        }
        HashMap<String, String> servicesMap = new HashMap<String, String>(servList.size());
        for (Element serv : servList) {
            String beanId = serv.attributeValue("beanId");
            if (StringUtils.equals((CharSequence)type, (CharSequence)"djlx")) {
                String djlx = serv.attributeValue("djlx");
                if (!this.beanFactory.containsBean(beanId) || !StringUtils.isNotBlank((CharSequence)djlx)) continue;
                servicesMap.put(djlx, beanId);
                continue;
            }
            if (!StringUtils.equals((CharSequence)type, (CharSequence)"sqlx")) continue;
            String sqlx = serv.attributeValue("sqlx");
            if (!this.beanFactory.containsBean(beanId) || !StringUtils.isNotBlank((CharSequence)sqlx)) continue;
            servicesMap.put(sqlx, beanId);
        }
        return servicesMap;
    }

    public <T> T getService(BdcXm bdcXm, Class t) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        if (t == null) {
            this.logger.error("\u83b7\u53d6\u5bf9\u5e94\u64cd\u4f5c\u5b9e\u73b0\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u4f20\u5165\u8981\u83b7\u53d6\u7684\u5b9e\u73b0\u7684\u7c7b\u578b");
            throw new NullPointerException("\u8fd4\u56deClass\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bdcXm == null) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5b9e\u73b0\u7684\u65f6\u5019\u4f20\u5165\u7684\u9879\u76ee\u53c2\u6570\u4e3a\u7a7a");
            throw new NullPointerException("\u9879\u76ee\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bdcXm.getDjlx()) || StringUtils.isBlank((CharSequence)bdcXm.getSqlx())) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5b9e\u73b0\u7684\u65f6\u5019 \u767b\u8bb0\u7c7b\u578b\u548c\u7533\u8bf7\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NullPointerException("\u9879\u76ee\u4e2d\u83b7\u53d6\u4e1a\u52a1\u5b9e\u73b0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pfSqlxdm = "";
        if (StringUtils.isNotBlank((CharSequence)bdcXm.getWiid()) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(bdcXm.getWiid())) != null && StringUtils.isNotBlank((CharSequence)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
            pfSqlxdm = this.bdcZdGlService.getBdcSqlxdmByWdid(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
        }
        if (t.equals(CreatProjectService.class)) {
            return (T)this.getCreatProjectService(bdcXm, pfSqlxdm);
        }
        if (t.equals(TurnProjectService.class)) {
            return (T)this.getTurnProjectService(bdcXm, pfSqlxdm);
        }
        if (t.equals(DelProjectService.class)) {
            return (T)this.getDelProjectService(bdcXm, pfSqlxdm);
        }
        if (t.equals(EndProjectService.class)) {
            return (T)this.getEndProjectService(bdcXm, pfSqlxdm);
        }
        return null;
    }

    private EndProjectService getEndProjectService(BdcXm bdcXm, String pfSqlxdm) {
        if (StringUtils.isNotBlank((CharSequence)pfSqlxdm) && this.endProjectServices.containsKey(pfSqlxdm)) {
            return (EndProjectService)this.beanFactory.getBean((String)this.endProjectServices.get(pfSqlxdm));
        }
        if (this.endProjectServices.containsKey(bdcXm.getSqlx())) {
            return (EndProjectService)this.beanFactory.getBean((String)this.endProjectServices.get(bdcXm.getSqlx()));
        }
        EndProjectService endProjectService = this.projectService.getEndService(bdcXm, pfSqlxdm);
        if (endProjectService != null) {
            return endProjectService;
        }
        if (this.defaultEndProjectServices.containsKey(bdcXm.getDjlx())) {
            return (EndProjectService)this.beanFactory.getBean((String)this.defaultEndProjectServices.get(bdcXm.getDjlx()));
        }
        return (EndProjectService)this.beanFactory.getBean((String)this.defaultEndProjectServices.get(MapKeyLowerCaseEnum.KEY_DEFAULT.getMapKey()));
    }

    private CreatProjectService getCreatProjectService(BdcXm bdcXm, String pfSqlxdm) {
        if (StringUtils.isNotBlank((CharSequence)pfSqlxdm) && this.createProjectServices.containsKey(pfSqlxdm)) {
            return (CreatProjectService)this.beanFactory.getBean((String)this.createProjectServices.get(pfSqlxdm));
        }
        if (this.createProjectServices.containsKey(bdcXm.getSqlx())) {
            return (CreatProjectService)this.beanFactory.getBean((String)this.createProjectServices.get(bdcXm.getSqlx()));
        }
        CreatProjectService creatProjectService = this.projectService.getCreateService(bdcXm, pfSqlxdm);
        if (creatProjectService != null) {
            return creatProjectService;
        }
        if (this.defaultCreateProjectServices.containsKey(bdcXm.getDjlx())) {
            return (CreatProjectService)this.beanFactory.getBean((String)this.defaultCreateProjectServices.get(bdcXm.getDjlx()));
        }
        return (CreatProjectService)this.beanFactory.getBean((String)this.defaultCreateProjectServices.get(MapKeyLowerCaseEnum.KEY_DEFAULT.getMapKey()));
    }

    private TurnProjectService getTurnProjectService(BdcXm bdcXm, String pfSqlxdm) {
        if (StringUtils.isNotBlank((CharSequence)pfSqlxdm) && this.turnProjectServices.containsKey(pfSqlxdm)) {
            return (TurnProjectService)this.beanFactory.getBean((String)this.turnProjectServices.get(pfSqlxdm));
        }
        if (this.turnProjectServices.containsKey(bdcXm.getSqlx())) {
            return (TurnProjectService)this.beanFactory.getBean((String)this.turnProjectServices.get(bdcXm.getSqlx()));
        }
        TurnProjectService turnProjectService = this.projectService.getTurnService(bdcXm, pfSqlxdm);
        if (turnProjectService != null) {
            return turnProjectService;
        }
        if (this.defaultTurnProjectServices.containsKey(bdcXm.getDjlx())) {
            return (TurnProjectService)this.beanFactory.getBean((String)this.defaultTurnProjectServices.get(bdcXm.getDjlx()));
        }
        return (TurnProjectService)this.beanFactory.getBean((String)this.defaultTurnProjectServices.get(MapKeyLowerCaseEnum.KEY_DEFAULT.getMapKey()));
    }

    private DelProjectService getDelProjectService(BdcXm bdcXm, String pfSqlxdm) {
        if (StringUtils.isNotBlank((CharSequence)pfSqlxdm) && this.delProjectServices.containsKey(pfSqlxdm)) {
            return (DelProjectService)this.beanFactory.getBean((String)this.delProjectServices.get(pfSqlxdm));
        }
        if (this.delProjectServices.containsKey(bdcXm.getSqlx())) {
            return (DelProjectService)this.beanFactory.getBean((String)this.delProjectServices.get(bdcXm.getSqlx()));
        }
        DelProjectService delProjectService = this.projectService.getDelService(bdcXm, pfSqlxdm);
        if (delProjectService != null) {
            return delProjectService;
        }
        if (this.defaultDelProjectServices.containsKey(bdcXm.getDjlx())) {
            return (DelProjectService)this.beanFactory.getBean((String)this.defaultDelProjectServices.get(bdcXm.getDjlx()));
        }
        return (DelProjectService)this.beanFactory.getBean((String)this.defaultDelProjectServices.get(MapKeyLowerCaseEnum.KEY_DEFAULT.getMapKey()));
    }

    public Resource getSqlxLocations() {
        return this.sqlxLocations;
    }

    public void setSqlxLocations(Resource sqlxLocations) {
        this.sqlxLocations = sqlxLocations;
    }

    public Resource getDjlxLocations() {
        return this.djlxLocations;
    }

    public void setDjlxLocations(Resource djlxLocations) {
        this.djlxLocations = djlxLocations;
    }
}

