/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.lasa.impl;

import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.mapper.lasa.LaSaQzSjkMapper;
import cn.gtmap.estateplat.server.core.model.lasa.TBmCaseApplyBaseInfo;
import cn.gtmap.estateplat.server.core.model.lasa.TBmQlCase;
import cn.gtmap.estateplat.server.core.model.lasa.TBmQlCaseBusiness;
import cn.gtmap.estateplat.server.core.model.lasa.TBmQlCaseExtend;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.lasa.BdcSendBdcdjLsService;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcSendBdcdjLsServiceImpl
implements BdcSendBdcdjLsService {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private LaSaQzSjkMapper laSaQzSjkMapper;

    @Transactional
    public void insert(TBmQlCase tBmQlCase, TBmQlCaseExtend tBmQlCaseExtend, TBmQlCaseBusiness tBmQlCaseBusiness, TBmCaseApplyBaseInfo tBmCaseApplyBaseInfo) {
        System.out.print("\u62c9\u8428\u524d\u7f6e\u6570\u636e\u5e93\u5f00\u59cb\u63a8\u9001:tBmQlCase:" + JSON.toJSONString((Object)tBmQlCase));
        this.laSaQzSjkMapper.insertTBmQlCase(tBmQlCase);
        System.out.print("\u62c9\u8428\u524d\u7f6e\u6570\u636e\u5e93\u5f00\u59cb\u63a8\u9001:tBmQlCaseExtend:" + JSON.toJSONString((Object)tBmQlCaseExtend));
        this.laSaQzSjkMapper.insertTBmQlCaseExtend(tBmQlCaseExtend);
        System.out.print("\u62c9\u8428\u524d\u7f6e\u6570\u636e\u5e93\u5f00\u59cb\u63a8\u9001:tBmQlCaseBusiness:" + JSON.toJSONString((Object)tBmQlCaseBusiness));
        this.laSaQzSjkMapper.insertTBmQlCaseBusiness(tBmQlCaseBusiness);
        System.out.print("\u62c9\u8428\u524d\u7f6e\u6570\u636e\u5e93\u5f00\u59cb\u63a8\u9001:tBmCaseApplyBaseInfo:" + JSON.toJSONString((Object)tBmCaseApplyBaseInfo));
        this.laSaQzSjkMapper.insertTBmCaseApplyBaseInfo(tBmCaseApplyBaseInfo);
    }

    public void senddata(String proid) {
        Date now = new Date();
        TBmQlCase tBmQlCase = new TBmQlCase();
        TBmQlCaseExtend tBmQlCaseExtend = new TBmQlCaseExtend();
        TBmQlCaseBusiness tBmQlCaseBusiness = new TBmQlCaseBusiness();
        TBmCaseApplyBaseInfo tBmCaseApplyBaseInfo = new TBmCaseApplyBaseInfo();
        String lasaOrganOid = AppConfig.getProperty((String)"lasaqzsjk.organoid");
        String lasaBussVenueDistrictOid = AppConfig.getProperty((String)"lasaqzsjk.bussvenuedistrictoid");
        String lasaSpecificLocation = AppConfig.getProperty((String)"lasaqzsjk.specificlocation");
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        String bjbh = this.getBjbh(bdcXm, now);
        this.initTBmQlCase(bdcXm, tBmQlCase);
        this.inittBmQlCaseExtend(tBmQlCaseExtend);
        this.inittBmCaseApplyBaseInfo(tBmCaseApplyBaseInfo);
        this.inittBmQlCaseBusiness(tBmQlCaseBusiness);
        List bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(proid);
        Map result = this.initBdcQlr(bdcQlrList);
        Map bjInfo = this.initCaseNumber(bdcXm.getSqlx());
        tBmQlCase.setServiceCode((String)bjInfo.get("caseNumber"));
        tBmQlCase.setCaseNumber(bjbh);
        tBmQlCase.setApplyUserName((String)result.get("applyUserName"));
        tBmQlCase.setApplyUserType((String)result.get("applyUserType"));
        tBmQlCase.setCredentialType((String)result.get("credentialType"));
        tBmQlCase.setCredentialNumber((String)result.get("credentialNumber"));
        tBmQlCase.setApplyUserTel((String)result.get("applyUserTel"));
        tBmQlCase.setModifyDate(now);
        tBmQlCase.setBussVenueDistrictOid(lasaBussVenueDistrictOid);
        tBmQlCase.setSpecificLocation(lasaSpecificLocation);
        tBmQlCase.setApplyProjectName((String)bjInfo.get("caseName"));
        tBmQlCaseExtend.setProjid(bjbh);
        tBmQlCaseExtend.setOperatorUserName((String)result.get("applyUserName"));
        tBmQlCaseExtend.setOperatorNumberType((String)result.get("credentialType"));
        tBmQlCaseExtend.setOperatorNumber((String)result.get("credentialNumber"));
        tBmQlCaseExtend.setOperatorUserTel((String)result.get("applyUserTel"));
        tBmQlCaseExtend.setModifyDate(now);
        tBmQlCase.setOrganOid(lasaOrganOid);
        tBmCaseApplyBaseInfo.setProjectName((String)bjInfo.get("caseName"));
        tBmCaseApplyBaseInfo.setProjectCode((String)bjInfo.get("caseNumber"));
        tBmCaseApplyBaseInfo.setApplicantName((String)result.get("applyUserName"));
        tBmCaseApplyBaseInfo.setApplicantCardOid((String)result.get("credentialType"));
        tBmCaseApplyBaseInfo.setApplicantCardNumber((String)result.get("credentialNumber"));
        tBmCaseApplyBaseInfo.setAgentName((String)result.get("applyUserName"));
        tBmCaseApplyBaseInfo.setAgentCardOid((String)result.get("credentialType"));
        tBmCaseApplyBaseInfo.setAgentCardNumber((String)result.get("credentialNumber"));
        tBmCaseApplyBaseInfo.setModifyDate(now);
        tBmQlCaseBusiness.setProjid((String)bjInfo.get("caseNumber"));
        tBmQlCaseBusiness.setBusinessInfo(JSON.toJSONString((Object)bdcXm));
        tBmQlCaseBusiness.setModifyDate(now);
        this.insert(tBmQlCase, tBmQlCaseExtend, tBmQlCaseBusiness, tBmCaseApplyBaseInfo);
    }

    private String getBjbh(BdcXm bdcXm, Date date) {
        String bh = bdcXm.getBh();
        String lsh = bh.substring(bh.length() - 3, bh.length());
        String dateBh = DateUtils.formatTime((Date)date, (FastDateFormat)Constants.DATE_FORMAT);
        return "402881fa56e8b41c0156e8ba5e33000a" + dateBh + "0" + lsh;
    }

    public TBmQlCase initTBmQlCase(BdcXm bdcXm, TBmQlCase tBmQlCase) {
        tBmQlCase.setCaseOid(UUIDGenerator.generate());
        tBmQlCase.setCaseStatus("4");
        tBmQlCase.setCaseType("1");
        tBmQlCase.setApplyNumber(Integer.valueOf(1));
        tBmQlCase.setDelFlag("N");
        tBmQlCase.setAcceptanceDate(bdcXm.getCjsj());
        tBmQlCase.setCreateDate(bdcXm.getCjsj());
        tBmQlCase.setConcludeDate(bdcXm.getBjsj());
        tBmQlCase.setResultDeliveryWay("6");
        tBmQlCase.setNeedLincese("1");
        tBmQlCase.setChangeStatus("0");
        return tBmQlCase;
    }

    void inittBmQlCaseExtend(TBmQlCaseExtend tBmQlCaseExtend) {
        tBmQlCaseExtend.setCaseExtendOid(UUIDGenerator.generate());
        tBmQlCaseExtend.setCaseSource("0");
    }

    void inittBmCaseApplyBaseInfo(TBmCaseApplyBaseInfo tBmCaseApplyBaseInfo) {
        tBmCaseApplyBaseInfo.setOid(UUIDGenerator.generate());
        tBmCaseApplyBaseInfo.setProjectName("");
        tBmCaseApplyBaseInfo.setProjectCode(null);
    }

    void inittBmQlCaseBusiness(TBmQlCaseBusiness tBmQlCaseBusiness) {
        tBmQlCaseBusiness.setOid(UUIDGenerator.generate());
        tBmQlCaseBusiness.setChangeStatus("0");
    }

    Map<String, String> initBdcQlr(List<BdcQlr> bdcQlrList) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        StringBuilder applyUserName = new StringBuilder();
        StringBuilder applyUserType = new StringBuilder();
        StringBuilder credentialType = new StringBuilder();
        StringBuilder credentialNumber = new StringBuilder();
        StringBuilder applyUserTel = new StringBuilder();
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (int i = 0; i < bdcQlrList.size(); ++i) {
                BdcQlr bdcQlr = bdcQlrList.get(i);
                if (i == 0) {
                    applyUserName.append(bdcQlr.getQlrmc());
                    applyUserType.append(this.initApplyUserType(bdcQlr));
                    credentialType.append(this.initCredentialType(bdcQlr));
                    credentialNumber.append(bdcQlr.getQlrzjh());
                    applyUserTel.append(bdcQlr.getQlrlxdh());
                    continue;
                }
                applyUserName.append(" ").append(bdcQlr.getQlrmc());
                applyUserType.append(" ").append(this.initApplyUserType(bdcQlr));
                credentialType.append(" ").append(this.initCredentialType(bdcQlr));
                credentialNumber.append(" ").append(bdcQlr.getQlrzjh());
                applyUserTel.append(" ").append(bdcQlr.getQlrlxdh());
            }
        }
        result.put("applyUserName", applyUserName.toString());
        result.put("applyUserType", applyUserType.toString());
        result.put("credentialType", credentialType.toString());
        result.put("credentialNumber", credentialNumber.toString());
        result.put("applyUserTel", applyUserTel.toString());
        return result;
    }

    Map<String, String> initCaseNumber(String sqlx) {
        String caseNumber;
        String caseName;
        HashMap<String, String> result = new HashMap<String, String>(4);
        if (StringUtils.equals((String)"1001", (String)sqlx)) {
            caseName = "\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y02";
        } else if (ArrayUtils.contains((Object[])Constants.SQLX_DY_ZXDJ, (Object)sqlx)) {
            caseName = "\u62b5\u62bc\u6743\u6ce8\u9500\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y03";
        } else if (StringUtils.equals((String)"700", (String)sqlx)) {
            caseName = "\u9884\u8d2d\u5546\u54c1\u623f\u9884\u544a\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y06";
        } else if (StringUtils.equals((String)"702", (String)sqlx)) {
            caseName = "\u9884\u8d2d\u5546\u54c1\u623f\u62b5\u62bc\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y07";
        } else if (StringUtils.equals((String)"320", (String)sqlx)) {
            caseName = "\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743\u53d8\u66f4\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y10";
        } else if (StringUtils.equals((String)"1019", (String)sqlx)) {
            caseName = "\u623f\u5c4b\u6784\u7b51\u7269\u62b5\u62bc\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y15";
        } else if (StringUtils.equals((String)"137", (String)sqlx)) {
            caseName = "\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y01";
        } else if (StringUtils.equals((String)"111", (String)sqlx)) {
            caseName = "\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743\u53ca\u623f\u5c4b\u6240\u6709\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y04";
        } else if (ArrayUtils.contains((Object[])new String[]{"9999909", "9999913"}, (Object)sqlx)) {
            caseName = "\u5728\u5efa\u5de5\u7a0b\u62b5\u62bc\u62b5\u62bc\u6743\u9996\u6b21\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y14";
        } else {
            caseName = "\u5176\u4ed6\u8f6c\u79fb\u767b\u8bb0";
            caseNumber = "11540100735542708J300071500100Y08";
        }
        result.put("caseName", caseName);
        result.put("caseNumber", caseNumber);
        return result;
    }

    String initApplyUserType(BdcQlr bdcQlr) {
        String ApplyUserType = null;
        ApplyUserType = StringUtils.equals((String)"6", (String)bdcQlr.getQlrsfzjzl()) ? "4" : (StringUtils.equals((String)"7", (String)bdcQlr.getQlrsfzjzl()) ? "2" : (StringUtils.equals((String)"99", (String)bdcQlr.getQlrsfzjzl()) ? "9" : "1"));
        return ApplyUserType;
    }

    String initCredentialType(BdcQlr bdcQlr) {
        String credentialType = null;
        credentialType = ArrayUtils.contains((Object[])new String[]{"1", "2"}, (Object)bdcQlr.getQlrsfzjzl()) ? "402881945c147ae2015c156f5272000d" : (StringUtils.equals((String)"3", (String)bdcQlr.getQlrsfzjzl()) ? "402881945c147ae2015c157407f80010" : (StringUtils.equals((String)"5", (String)bdcQlr.getQlrsfzjzl()) ? "402881945c147ae2015c15716a86000e" : (ArrayUtils.contains((Object[])new String[]{"6", "7"}, (Object)bdcQlr.getQlrsfzjzl()) ? "402881945c147ae2015c1575b1980012" : "402881945c147ae2015c1575fc670013")));
        return credentialType;
    }
}

