/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.server.core.service.SignService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SignServiceImpl
implements SignService {
    private SysSignService sysSignService;
    private SysTaskService sysTaskService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private SysUserService sysUserServiceImpl;
    private Map<String, String> signKeyMap;

    public SysSignService getSysSignService() {
        return this.sysSignService;
    }

    public void setSysSignService(SysSignService sysSignService) {
        this.sysSignService = sysSignService;
    }

    public SysTaskService getSysTaskService() {
        return this.sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return this.sysWorkFlowInstanceService;
    }

    public SysUserService getSysUserServiceImpl() {
        return this.sysUserServiceImpl;
    }

    public void setSysUserServiceImpl(SysUserService sysUserServiceImpl) {
        this.sysUserServiceImpl = sysUserServiceImpl;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public Map<String, String> getSignKeyMap() {
        return this.signKeyMap;
    }

    public void setSignKeyMap(Map<String, String> signKeyMap) {
        this.signKeyMap = signKeyMap;
    }

    public void handleRetreatSign(String proid, String userid, String activityid, String targetActivityDefids) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        PfActivityVo backActivitys = null;
        if (pfWorkFlowInstanceVo != null) {
            backActivitys = this.sysTaskService.getActivityBywIdandadId(pfWorkFlowInstanceVo.getWorkflowIntanceId(), targetActivityDefids);
        }
        if (backActivitys != null && StringUtils.isNotBlank((CharSequence)backActivitys.getActivityName()) && this.signKeyMap.containsKey(backActivitys.getActivityName())) {
            String signKey = (String)this.signKeyMap.get(backActivitys.getActivityName());
            this.deleleSign(proid, signKey);
        }
    }

    public String handleTurnAutoSignBySignkeys(String proid, String userid) {
        String str = "";
        String autoSignUserId = AppConfig.getProperty((String)"sign.auto.user");
        String autoSignKey = AppConfig.getProperty((String)"sign.auto.key");
        if (StringUtils.isNotBlank((CharSequence)autoSignUserId) && StringUtils.isNotBlank((CharSequence)autoSignKey)) {
            String[] autoSignKeyArr;
            String[] autoSignUserIdArr = autoSignUserId.split(",");
            if (autoSignUserId.endsWith(",")) {
                autoSignUserIdArr = Arrays.copyOf(autoSignUserIdArr, autoSignUserIdArr.length + 1);
                autoSignUserIdArr[autoSignUserIdArr.length - 1] = "";
            }
            if (autoSignUserIdArr.length != (autoSignKeyArr = autoSignKey.split(",")).length) {
                str = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff0csign.auto.user\u3001sign.auto.key\u4e24\u4e2a\u503c\u65e0\u6cd5\u5339\u914d\uff01";
            } else {
                for (int i = 0; i < autoSignKeyArr.length; ++i) {
                    String tempUserId = autoSignUserIdArr[i];
                    String tempSignKey = autoSignKeyArr[i];
                    List pfSignVoList = this.sysSignService.getSignList(tempSignKey, proid);
                    if (!CollectionUtils.isEmpty((Collection)pfSignVoList)) continue;
                    if (StringUtils.isBlank((CharSequence)tempUserId)) {
                        tempUserId = userid;
                    }
                    PfSignVo pfSignVo = this.initPfSignVo(proid, tempSignKey, tempUserId);
                    this.sysSignService.insertAutoSign(pfSignVo);
                }
            }
        }
        return str;
    }

    private void deleleSign(String proid, String signKey) {
        String[] signKeysArr;
        for (String tmpSignKey : signKeysArr = signKey.split(",")) {
            List pfSignVoList = this.sysSignService.getSignList(tmpSignKey, proid);
            if (!CollectionUtils.isNotEmpty((Collection)pfSignVoList)) continue;
            for (PfSignVo pfSignVo : pfSignVoList) {
                this.sysSignService.deleteSign(pfSignVo.getSignId());
            }
        }
    }

    private PfSignVo initPfSignVo(String proid, String signkey, String singUserid) {
        PfSignVo pfSignVo = new PfSignVo();
        pfSignVo.setProId(proid);
        pfSignVo.setSignKey(signkey);
        pfSignVo.setSignId(UUIDGenerator.generate());
        pfSignVo.setSignOpinion("");
        pfSignVo.setSignType("1");
        pfSignVo.setUserId(singUserid);
        pfSignVo.setSignName(this.sysUserServiceImpl.getUserVo(singUserid).getUserName());
        pfSignVo.setSignDate(Calendar.getInstance().getTime());
        return pfSignVo;
    }
}

