/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.server.core.mapper.server.BdcDzzzMapper;
import cn.gtmap.estateplat.server.core.mapper.server.ExportMapper;
import cn.gtmap.estateplat.server.core.model.BdcDzzz;
import cn.gtmap.estateplat.server.core.service.BdcHstService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.ExportService;
import cn.gtmap.estateplat.server.core.service.FuPingSealEncryptionSecivce;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExportServiceImpl
implements ExportService {
    private static final String IMAGPATH = "conf/server/img/simkai.ttf";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportServiceImpl.class);
    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private ExportMapper exportMapper;
    @Autowired
    private BdcHstService bdcHstService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcDzzzMapper bdcDzzzMapper;
    @Autowired
    private FuPingSealEncryptionSecivce fuPingSealEncryptionSecivce;

    private static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && null != (children = dir.list())) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = ExportServiceImpl.deleteDir((File)new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public String exportZmsSlCheckRole(String proid, String userid) {
        List pfRoleVoList;
        String createElectronicRoleNames = AppConfig.getProperty((String)"createElectronicRoleNames");
        String[] createElectronicRoleNamesArr = null;
        if (StringUtils.isNotBlank((CharSequence)createElectronicRoleNames)) {
            createElectronicRoleNamesArr = createElectronicRoleNames.split(",");
        }
        if (CollectionUtils.isNotEmpty((Collection)(pfRoleVoList = this.sysUserService.getRoleListByUser(userid)))) {
            for (PfRoleVo pfRoleVo : pfRoleVoList) {
                if (!CommonUtil.indexOfStrs((String[])createElectronicRoleNamesArr, (String)pfRoleVo.getRoleName())) continue;
                return this.exportZmsSl(proid);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportZmsSl(String proid) {
        String zstype = "";
        String fzrq = "";
        String bh = "";
        String nf = "";
        String sqsjc = "";
        String szsxqc = "";
        String zhlsh = "";
        String bdcqzh = "";
        String zmqlsxmc = "";
        String qlr = "";
        String ywr = "";
        String zl = "";
        String bdcdyh = "";
        String qlqtzk = "";
        String fj = "";
        String year = "";
        String month = "";
        String day = "";
        String zsbh = "";
        List list = this.bdcZsService.getPlZsByProid(proid);
        BdcZs bdcZs = null;
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("proid", proid);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            bdcZs = (BdcZs)list.get(0);
        }
        if (null != bdcZs) {
            parmMap.put("zsid", bdcZs.getZsid());
            zstype = bdcZs.getZstype();
        }
        if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e", (CharSequence)zstype)) {
            Map map;
            List mapList = this.exportMapper.getPdfBdcqzm(parmMap);
            if (CollectionUtils.isNotEmpty((Collection)mapList) && null != (map = (Map)mapList.get(0))) {
                qlqtzk = (String)map.get("QLQTZK");
                qlr = (String)map.get("QLR");
                ywr = (String)map.get("YWR");
                zl = (String)map.get("ZL");
                fj = (String)map.get("FJ");
                zmqlsxmc = (String)map.get("QLLX");
                bdcdyh = (String)map.get("BDCDYH");
                bdcqzh = (String)map.get("BDCQZH");
                nf = (String)map.get("NF");
                sqsjc = (String)map.get("SQSJC");
                szsxqc = (String)map.get("SZSXQC");
                zhlsh = (String)map.get("ZHLSH");
                zsbh = (String)map.get("ZSBH");
                fzrq = CalendarUtil.sdf_China.format((Date)map.get("FZRQ"));
                if (StringUtils.isNotBlank((CharSequence)fzrq)) {
                    year = fzrq.substring(0, 4);
                    month = fzrq.substring(5, 7);
                    day = fzrq.substring(8, 10);
                }
                bh = zsbh;
            }
            String fileName = bdcqzh + ".pdf";
            String temp = "C:/TEMP/";
            String path = temp + fileName;
            File tempfile = new File(temp);
            if (!tempfile.exists()) {
                tempfile.mkdir();
            }
            Rectangle pageSize = new Rectangle(843.0f, 633.0f);
            Document document = new Document(pageSize);
            PdfWriter writer = null;
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
                document.open();
                if (null != writer) {
                    PdfContentByte cb = writer.getDirectContent();
                    BaseFont bf = BaseFont.createFont((String)(AppConfig.getEgovHome() + "conf/server/img/simkai.ttf"), (String)"Identity-H", (boolean)false);
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb = this.setPdfYearAndMonthAndDay(cb, year, month, day, 253.33333333333334, 303.3333333333333, 336.6666666666667, 215.0);
                    cb = this.setPdfBh(bh, cb, 240.0, 126.66666666666667);
                    cb = this.setPdfSqsjcaAndNfAndSzsxqcAndZhlshY(cb, sqsjc, nf, szsxqc, zhlsh, 453.3333333333333, 481.6666666666667, 540.0, 680.0, 525.0);
                    cb = this.setPdfZmqlsxmcXqlrXywrXzlXbdcdyhX(cb, zmqlsxmc, qlr, ywr, zl, bdcdyh, 556.6666666666666, 486.6666666666667, 451.6666666666667, 418.3333333333333, 386.6666666666667, 353.3333333333333);
                    String qlqtzkLineLeng = AppConfig.getProperty((String)"fupingDzzm.Qlqtzk.mhxszs");
                    int qlatzkTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlqtzkLineLeng}) ? Integer.valueOf(qlqtzkLineLeng) : 31;
                    cb = this.textSubstring(qlqtzk, cb, 556.6666666666666, 970.0, qlatzkTextLeng);
                    String fjLineLeng = AppConfig.getProperty((String)"fupingDzzm.Fj.mhxszs");
                    int fjTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fjLineLeng}) ? Integer.valueOf(fjLineLeng) : 23;
                    cb = this.textSubstring(fj, cb, 556.6666666666666, 620.0, fjTextLeng);
                    cb.endText();
                }
                Image image = Image.getInstance((String)(AppConfig.getEgovHome() + "conf/server/img/\u8bc1\u660e.png"));
                document.add((Element)image);
            }
            catch (DocumentException e) {
                LOGGER.error("PdfWriter.getInstance() DocumentException occurred", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("PdfWriter.getInstance() FileNotFoundException occurred", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("image Image.getInstance() IOException occurred", (Throwable)e);
            }
            finally {
                document.close();
                if (null != writer) {
                    writer.close();
                }
            }
            this.sendFileCenter(path, proid, fileName, "\u4e0d\u52a8\u4ea7\u7535\u5b50\u8bc1\u7167");
            ExportServiceImpl.deleteDir((File)new File(temp));
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportZmsQiS(String proid) {
        String result = "success";
        String zstype = "";
        String fzrq = "";
        String bh = "";
        String zsbh = "";
        String nf = "";
        String sqsjc = "";
        String szsxqc = "";
        String zhlsh = "";
        String bdcqzh = "";
        String zmqlsxmc = "";
        String qlr = "";
        String ywr = "";
        String zl = "";
        String bdcdyh = "";
        String qlqtzk = "";
        String fj = "";
        String year = "";
        String month = "";
        String day = "";
        List list = this.bdcZsService.getPlZsByProid(proid);
        BdcZs bdcZs = null;
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("proid", proid);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            bdcZs = (BdcZs)list.get(0);
        }
        if (null != bdcZs) {
            parmMap.put("zsid", bdcZs.getZsid());
            zstype = bdcZs.getZstype();
        }
        if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e", (CharSequence)zstype)) {
            Map map;
            List mapList = this.exportMapper.getPdfBdcqzm(parmMap);
            if (CollectionUtils.isNotEmpty((Collection)mapList) && null != (map = (Map)mapList.get(0))) {
                qlqtzk = (String)map.get("QLQTZK");
                qlr = (String)map.get("QLR");
                ywr = (String)map.get("YWR");
                zl = (String)map.get("ZL");
                fj = (String)map.get("FJ");
                zmqlsxmc = (String)map.get("QLLX");
                bdcdyh = (String)map.get("BDCDYH");
                bdcqzh = (String)map.get("BDCQZH");
                nf = (String)map.get("NF");
                sqsjc = (String)map.get("SQSJC");
                szsxqc = (String)map.get("SZSXQC");
                zhlsh = (String)map.get("ZHLSH");
                fzrq = CalendarUtil.sdf_China.format((Date)map.get("FZRQ"));
                if (StringUtils.isNotBlank((CharSequence)fzrq)) {
                    year = fzrq.substring(0, 4);
                    month = fzrq.substring(5, 7);
                    day = fzrq.substring(8, 10);
                }
                zsbh = (String)map.get("ZSBH");
                bh = (String)map.get("BH");
            }
            String fileName = bdcqzh + ".pdf";
            String temp = "C:/TEMP/";
            String path = temp + fileName;
            File tempfile = new File(temp);
            if (!tempfile.exists()) {
                tempfile.mkdir();
            }
            Rectangle pageSize = new Rectangle(843.0f, 633.0f);
            Document document = new Document(pageSize);
            PdfWriter writer = null;
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
                document.open();
                if (null != writer) {
                    PdfContentByte cb = writer.getDirectContent();
                    BaseFont bf = BaseFont.createFont((String)(AppConfig.getEgovHome() + "conf/server/img/simkai.ttf"), (String)"Identity-H", (boolean)false);
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb = this.setPdfYearAndMonthAndDay(cb, year, month, day, 253.33333333333334, 303.3333333333333, 336.6666666666667, 195.0);
                    cb = this.setPdfBh(zsbh, cb, 240.0, 106.66666666666667);
                    cb = this.setPdfSqsjcaAndNfAndSzsxqcAndZhlshY(cb, sqsjc, nf, szsxqc, zhlsh, 453.3333333333333, 481.6666666666667, 540.0, 680.0, 511.6666666666667);
                    cb = this.setPdfZmqlsxmcXqlrXywrXzlXbdcdyhX(cb, zmqlsxmc, qlr, ywr, zl, bdcdyh, 556.6666666666666, 473.3333333333333, 438.3333333333333, 405.0, 370.0, 336.6666666666667);
                    String qlqtzkLineLeng = AppConfig.getProperty((String)"fupingDzzm.Qlqtzk.mhxszs");
                    int qlatzkTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlqtzkLineLeng}) ? Integer.valueOf(qlqtzkLineLeng) : 31;
                    cb = this.textSubstring(qlqtzk, cb, 556.6666666666666, 920.0, qlatzkTextLeng);
                    String fjLineLeng = AppConfig.getProperty((String)"fupingDzzm.Fj.mhxszs");
                    int fjTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fjLineLeng}) ? Integer.valueOf(fjLineLeng) : 23;
                    cb = this.textSubstring(fj, cb, 556.6666666666666, 570.0, fjTextLeng);
                    cb.endText();
                    Image image = Image.getInstance((String)(AppConfig.getEgovHome() + "conf/server/img/\u7535\u5b50\u8bc1\u660e\u6a21\u677f_\u5c90\u5c71.jpg"));
                    image.scaleAbsolute(776.6667f, 566.6667f);
                    BarcodeQRCode barcodeQRCode = new BarcodeQRCode(bh, 100, 100, null);
                    Image codeQrImage = barcodeQRCode.getImage();
                    codeQrImage.setAbsolutePosition(100.0f, 193.33333f);
                    document.add((Element)image);
                    document.add((Element)codeQrImage);
                }
            }
            catch (DocumentException e) {
                result = "false";
                LOGGER.error("PdfWriter.getInstance() DocumentException occurred", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                result = "false";
                LOGGER.error("PdfWriter.getInstance() FileNotFoundException occurred", (Throwable)e);
            }
            catch (IOException e) {
                result = "false";
                LOGGER.error("image Image.getInstance() IOException occurred", (Throwable)e);
            }
            finally {
                document.close();
                if (null != writer) {
                    writer.close();
                }
            }
            this.sendFileCenter(path, proid, fileName, "\u94f6\u884c\u7535\u5b50\u8bc1\u7167");
            ExportServiceImpl.deleteDir((File)new File(temp));
        }
        return result;
    }

    public String exportPdfZmsFuPing(String proid) {
        BdcDzzz bdcDzzz = new BdcDzzz();
        bdcDzzz.setZzid(UUIDGenerator.generate());
        bdcDzzz.setProid(proid);
        List list = this.bdcZsService.getPlZsByProid(proid);
        BdcZs bdcZs = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            bdcZs = (BdcZs)list.get(0);
        }
        if (null != bdcZs) {
            bdcDzzz.setZsid(bdcZs.getZsid());
            bdcDzzz.setZstype(bdcZs.getZstype());
            this.getBdcDzzzByProidAndZsid(bdcDzzz);
        }
        return this.createDzzzZmsPdf(bdcDzzz);
    }

    public String exportPdfZsFuPing(String proid) {
        BdcDzzz bdcDzzz = new BdcDzzz();
        bdcDzzz.setProid(proid);
        List list = this.bdcZsService.getPlZsByProid(proid);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BdcZs bdcZs : list) {
                bdcDzzz.setZzid(UUIDGenerator.generate());
                bdcDzzz.setZsid(bdcZs.getZsid());
                bdcDzzz.setZstype(bdcZs.getZstype());
                this.getBdcDzzzByProidAndZsid(bdcDzzz);
            }
        }
        return this.createDzzzZsPdf(bdcDzzz);
    }

    private BdcDzzz getBdcDzzzByProidAndZsid(BdcDzzz bdcDzzz) {
        Map map;
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("proid", bdcDzzz.getProid());
        parmMap.put("zsid", bdcDzzz.getZsid());
        List mapList = this.exportMapper.getPdfBdcqzm(parmMap);
        if (CollectionUtils.isNotEmpty((Collection)mapList) && null != (map = (Map)mapList.get(0))) {
            bdcDzzz.setYwr((String)map.get("YWR"));
            bdcDzzz.setZmqlsxmc((String)map.get("QLLX"));
            bdcDzzz.setFzrq((Date)map.get("FZRQ"));
            String fzrq = CalendarUtil.sdf_China.format(bdcDzzz.getFzrq());
            if (StringUtils.isNotBlank((CharSequence)fzrq)) {
                bdcDzzz.setYear(fzrq.substring(0, 4));
                bdcDzzz.setMonth(fzrq.substring(5, 7));
                bdcDzzz.setDay(fzrq.substring(8, 10));
            }
            bdcDzzz.setBh((String)map.get("BH"));
            bdcDzzz.setQlqtzk((String)map.get("QLQTZK"));
            bdcDzzz.setQlr((String)map.get("QLR"));
            bdcDzzz.setZl((String)map.get("ZL"));
            bdcDzzz.setFj((String)map.get("FJ"));
            bdcDzzz.setBdcdyh((String)map.get("BDCDYH"));
            bdcDzzz.setBdcqzh((String)map.get("BDCQZH"));
            bdcDzzz.setNf((String)map.get("NF"));
            bdcDzzz.setSqsjc((String)map.get("SQSJC"));
            bdcDzzz.setSzsxqc((String)map.get("SZSXQC"));
            bdcDzzz.setZhlsh((String)map.get("ZHLSH"));
            bdcDzzz.setGyqk((String)map.get("GYQK"));
            bdcDzzz.setZsbh((String)map.get("ZSBH"));
            bdcDzzz.setZzbh((String)map.get("ZSBH"));
            bdcDzzz.setQllx((String)map.get("QLLX"));
            bdcDzzz.setQlxz((String)map.get("QLXZ"));
            bdcDzzz.setYt((String)map.get("YT"));
            bdcDzzz.setMj((String)map.get("MJ"));
            bdcDzzz.setSyqx((String)map.get("SYQX"));
        }
        return bdcDzzz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDzzzZmsPdf(BdcDzzz bdcDzzz) {
        String result = "success";
        String fileName = bdcDzzz.getBdcqzh() + ".pdf";
        String temp = "C:/TEMP/";
        String path = temp + fileName;
        File tempfile = new File(temp);
        if (!tempfile.exists()) {
            tempfile.mkdir();
        }
        Rectangle pageSize = new Rectangle(843.0f, 633.0f);
        Document document = new Document(pageSize);
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
            document.open();
            if (null != writer) {
                PdfContentByte cb = writer.getDirectContent();
                BaseFont bf = BaseFont.createFont((String)(AppConfig.getEgovHome() + "conf/server/img/simkai.ttf"), (String)"Identity-H", (boolean)false);
                cb.beginText();
                cb.setFontAndSize(bf, 9.0f);
                cb = this.setPdfYearAndMonthAndDay(cb, bdcDzzz.getYear(), bdcDzzz.getMonth(), bdcDzzz.getDay(), 253.33333333333334, 303.3333333333333, 336.6666666666667, 195.0);
                cb = this.setPdfBh(bdcDzzz.getZsbh(), cb, 206.66666666666666, 103.33333333333333);
                cb = this.setPdfSqsjcaAndNfAndSzsxqcAndZhlshY(cb, bdcDzzz.getSqsjc(), bdcDzzz.getNf(), bdcDzzz.getSzsxqc(), bdcDzzz.getZhlsh(), 453.3333333333333, 481.6666666666667, 540.0, 680.0, 516.6666666666666);
                cb = this.setPdfZmqlsxmcXqlrXywrXzlXbdcdyhX(cb, bdcDzzz.getZmqlsxmc(), bdcDzzz.getQlr(), bdcDzzz.getYwr(), bdcDzzz.getZl(), bdcDzzz.getBdcdyh(), 556.6666666666666, 474.0, 445.0, 408.3333333333333, 371.6666666666667, 336.6666666666667);
                cb.setFontAndSize(bf, 8.0f);
                String qlqtzkLineLeng = AppConfig.getProperty((String)"fupingDzzm.Qlqtzk.mhxszs");
                int qlatzkTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlqtzkLineLeng}) ? Integer.valueOf(qlqtzkLineLeng) : 31;
                cb = this.textSubstring(bdcDzzz.getQlqtzk(), cb, 556.6666666666666, 920.0, qlatzkTextLeng);
                String fjLineLeng = AppConfig.getProperty((String)"fupingDzzm.Fj.mhxszs");
                int fjTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fjLineLeng}) ? Integer.valueOf(fjLineLeng) : 23;
                cb = this.textSubstring(bdcDzzz.getFj(), cb, 556.6666666666666, 560.0, fjTextLeng);
                cb.endText();
                Image image = Image.getInstance((String)(AppConfig.getEgovHome() + "conf/server/img/\u7535\u5b50\u8bc1\u660e\u6a21\u677f_\u5bcc\u5e73.jpg"));
                image.scaleAbsolute(776.6667f, 566.6667f);
                byte[] codeQrImageByte = this.getQrcodeImageByte(100, 100, bdcDzzz.getBh(), 4);
                Image codeQrImage = Image.getInstance((byte[])codeQrImageByte);
                codeQrImage.setAbsolutePosition(100.0f, 193.33333f);
                document.add((Element)image);
                document.add((Element)codeQrImage);
            }
        }
        catch (DocumentException e) {
            result = "false";
            LOGGER.error("PdfWriter.getInstance() DocumentException occurred", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            result = "false";
            LOGGER.error("PdfWriter.getInstance() FileNotFoundException occurred", (Throwable)e);
        }
        catch (IOException e) {
            result = "false";
            LOGGER.error("image Image.getInstance() IOException occurred", (Throwable)e);
        }
        finally {
            document.close();
            if (null != writer) {
                writer.close();
            }
            path = this.fuPingSealEncryptionSecivce.sealEncryption(path, fileName, 270, 160, 370, 260, 1);
        }
        String nodeId = this.sendFileCenterNode(path, bdcDzzz.getProid(), fileName, "\u4e0d\u52a8\u4ea7\u7535\u5b50\u8bc1\u7167");
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            bdcDzzz.setZzqzlj(nodeId);
        }
        this.insertDzzz(bdcDzzz);
        System.gc();
        ExportServiceImpl.deleteDir((File)new File(temp));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDzzzZsPdf(BdcDzzz bdcDzzz) {
        String result = "success";
        String zdtPath = "";
        String hszdtPath = "";
        String hstPath = "";
        if (StringUtils.isNotEmpty((CharSequence)bdcDzzz.getBdcdyh())) {
            List hstMap = this.bdcHstService.getBdcHstMc(StringUtils.deleteWhitespace((String)bdcDzzz.getBdcdyh()));
            List zdtMap = this.bdcHstService.getZdZdtMc(StringUtils.deleteWhitespace((String)bdcDzzz.getBdcdyh()));
            if (CollectionUtils.isNotEmpty((Collection)hstMap)) {
                if (StringUtils.isNotBlank((CharSequence)((String)((Map)hstMap.get(0)).get("FWZDTMC")))) {
                    hszdtPath = AppConfig.getProperty((String)"hszdt.path") + File.separator + ((Map)hstMap.get(0)).get("FWZDTMC");
                }
                if (StringUtils.isNotBlank((CharSequence)((String)((Map)hstMap.get(0)).get("HSTMC")))) {
                    hstPath = AppConfig.getProperty((String)"hst.path") + File.separator + ((Map)hstMap.get(0)).get("HSTMC");
                }
            } else if (CollectionUtils.isNotEmpty((Collection)zdtMap)) {
                zdtPath = AppConfig.getProperty((String)"zdt.path") + File.separator + ((Map)zdtMap.get(0)).get("UPLOADPATH");
            }
        }
        String fileName = bdcDzzz.getBdcqzh() + ".pdf";
        String temp = "C:/TEMP/";
        String path = temp + fileName;
        File tempfile = new File(temp);
        if (!tempfile.exists()) {
            tempfile.mkdir();
        }
        Rectangle pageSize = new Rectangle(842.0f, 595.0f);
        Document document = new Document(pageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
            document.open();
            if (null != writer) {
                Image ztd;
                PdfContentByte cb = writer.getDirectContent();
                BaseFont bf = BaseFont.createFont((String)(AppConfig.getEgovHome() + "conf/server/img/simkai.ttf"), (String)"Identity-H", (boolean)false);
                cb.beginText();
                cb.setFontAndSize(bf, 11.0f);
                cb.setColorFill(BaseColor.BLACK);
                cb.showTextAligned(0, bdcDzzz.getYear(), 230.0f, 188.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getMonth(), 273.0f, 188.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getDay(), 311.0f, 188.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getZsbh(), 190.0f, 78.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getSqsjc(), 467.0f, 547.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getNf(), 510.0f, 547.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getSzsxqc(), 581.0f, 547.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getZhlsh(), 722.0f, 547.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getQlr(), 521.0f, 513.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getGyqk(), 521.0f, 480.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getZl(), 521.0f, 446.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getBdcdyh(), 521.0f, 411.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getQllx(), 521.0f, 376.5f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getQlxz(), 521.0f, 342.0f, 0.0f);
                cb.showTextAligned(0, bdcDzzz.getYt(), 521.0f, 308.0f, 0.0f);
                String mjLineLeng = AppConfig.getProperty((String)"fupingDzzs.Mj.mhxszs");
                int mjTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mjLineLeng}) ? Integer.valueOf(mjLineLeng) : 29;
                cb = this.textSubstring(bdcDzzz.getMj(), cb, 521.0, 273.5, mjTextLeng, 13);
                String syqxLineLeng = AppConfig.getProperty((String)"fupingDzzs.Syqx.mhxszs");
                int syqxTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{syqxLineLeng}) ? Integer.valueOf(syqxLineLeng) : 29;
                cb = this.textSubstring(bdcDzzz.getSyqx(), cb, 521.0, 240.0, syqxTextLeng, 13);
                String qlqtzkLineLeng = AppConfig.getProperty((String)"fupingDzzs.Qlqtzk.mhxszs");
                int qlqtzkTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlqtzkLineLeng}) ? Integer.valueOf(qlqtzkLineLeng) : 29;
                cb = this.textSubstring(bdcDzzz.getQlqtzk(), cb, 521.0, 646.0, qlqtzkTextLeng);
                cb.endText();
                Image image = Image.getInstance((String)(AppConfig.getEgovHome() + "conf/server/img/\u7535\u5b50\u8bc1\u4e66\u6a21\u677f_\u5bcc\u5e731.jpg"));
                image.scaleAbsolute(842.0f, 595.0f);
                byte[] codeQrImageByte = this.getQrcodeImageByte(80, 80, bdcDzzz.getBh(), 4);
                Image codeQrImage = Image.getInstance((byte[])codeQrImageByte);
                codeQrImage.setAbsolutePosition(80.0f, 200.0f);
                document.add((Element)image);
                document.add((Element)codeQrImage);
                document.newPage();
                cb.beginText();
                cb.setFontAndSize(bf, 12.0f);
                cb.setColorFill(BaseColor.BLACK);
                String fjLineLeng = AppConfig.getProperty((String)"fupingDzzs.Fj.mhxszs");
                int fjTextLeng = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fjLineLeng}) ? Integer.valueOf(fjLineLeng) : 29;
                cb = this.textSubstring(bdcDzzz.getFj(), cb, 47.0, 1550.0, fjTextLeng);
                cb.endText();
                Image image2 = Image.getInstance((String)(AppConfig.getEgovHome() + "conf/server/img/\u7535\u5b50\u8bc1\u4e66\u6a21\u677f_\u5bcc\u5e732.jpg"));
                image2.scaleAbsolute(842.0f, 595.0f);
                document.add((Element)image2);
                if (StringUtils.isNotEmpty((CharSequence)hszdtPath)) {
                    ztd = Image.getInstance((String)hszdtPath);
                    ztd.setAbsolutePosition(472.0f, 290.0f);
                    ztd.setRotationDegrees(90.0f);
                    ztd.scaleToFit(320.0f, 300.0f);
                    document.add((Element)ztd);
                } else if (StringUtils.isNotEmpty((CharSequence)zdtPath)) {
                    ztd = Image.getInstance((String)zdtPath);
                    ztd.setAbsolutePosition(472.0f, 290.0f);
                    ztd.setRotationDegrees(90.0f);
                    ztd.scaleToFit(320.0f, 300.0f);
                    document.add((Element)ztd);
                }
                if (StringUtils.isNotEmpty((CharSequence)hstPath)) {
                    Image hst = Image.getInstance((String)hstPath);
                    hst.scaleToFit(320.0f, 300.0f);
                    hst.setAbsolutePosition(472.0f, 44.0f);
                    document.add((Element)hst);
                }
            }
        }
        catch (DocumentException e) {
            result = "false";
            LOGGER.error("PdfWriter.getInstance() DocumentException occurred", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            result = "false";
            LOGGER.error("PdfWriter.getInstance() FileNotFoundException occurred", (Throwable)e);
        }
        catch (IOException e) {
            result = "false";
            LOGGER.error("image Image.getInstance() IOException occurred", (Throwable)e);
        }
        finally {
            document.close();
            if (null != writer) {
                writer.close();
            }
            path = this.fuPingSealEncryptionSecivce.sealEncryption(path, fileName, 250, 160, 350, 260, 1);
        }
        String nodeId = this.sendFileCenterNode(path, bdcDzzz.getProid(), fileName, "\u4e0d\u52a8\u4ea7\u7535\u5b50\u8bc1\u7167");
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            bdcDzzz.setZzqzlj(nodeId);
        }
        this.insertDzzz(bdcDzzz);
        System.gc();
        ExportServiceImpl.deleteDir((File)new File(temp));
        return result;
    }

    public String createDzzzByZsid(String zsid) {
        String msg = "\u521b\u5efa\u5931\u8d25!";
        BdcDzzz bdcDzzz = this.bdcDzzzMapper.queryBdcDzzzByZsid(zsid);
        if (null != bdcDzzz) {
            msg = this.createDzzz(bdcDzzz);
            if ("success".equals(msg)) {
                msg = "\u521b\u5efa\u6210\u529f!";
            } else if (msg.equals("false")) {
                msg = "\u521b\u5efa\u5931\u8d25!";
            }
        }
        return msg;
    }

    public String createDzzz(BdcDzzz bdcDzzz) {
        if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u6743", (CharSequence)bdcDzzz.getZstype())) {
            return this.createDzzzZsPdf(bdcDzzz);
        }
        if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e", (CharSequence)bdcDzzz.getZstype())) {
            return this.createDzzzZmsPdf(bdcDzzz);
        }
        return "\u672a\u77e5\u8bc1\u4e66\u7c7b\u578b";
    }

    public void insertDzzz(BdcDzzz bdcDzzz) {
        this.entityMapper.saveOrUpdate((Object)bdcDzzz, (Object)bdcDzzz.getZzid());
    }

    public void autoCreateDzzz(Map paramMap) {
        List list = this.bdcDzzzMapper.queryBdcDzzzNotCreate(paramMap);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map map : list) {
                BdcDzzz bdcDzzz = this.bdcDzzzMapper.queryBdcDzzzByZsid((String)map.get("ZSID"));
                if (null != bdcDzzz && !StringUtils.isBlank((CharSequence)bdcDzzz.getZzqzlj())) continue;
                BdcDzzz dzzz = new BdcDzzz();
                dzzz.setZzid(UUIDGenerator.generate());
                dzzz.setProid((String)map.get("PROID"));
                dzzz.setZsid((String)map.get("ZSID"));
                dzzz.setZstype((String)map.get("ZSTYPE"));
                this.getBdcDzzzByProidAndZsid(dzzz);
                this.createDzzz(dzzz);
            }
        }
    }

    private PdfContentByte setPdfBh(String bh, PdfContentByte cb, double bhX, double bhY) {
        if (StringUtils.isNotBlank((CharSequence)bh)) {
            cb.showTextAligned(0, bh, (float)bhX, (float)bhY, 0.0f);
        }
        return cb;
    }

    private PdfContentByte setPdfZmqlsxmcXqlrXywrXzlXbdcdyhX(PdfContentByte cb, String zmqlsxmc, String qlr, String ywr, String zl, String bdcdyh, double zmqlsxmcXqlrXywrXzlXbdcdyhX, double zmqlsxmcY, double qlrY, double ywrY, double zlY, double bdcdyhY) {
        if (StringUtils.isNotBlank((CharSequence)zmqlsxmc)) {
            cb.showTextAligned(0, zmqlsxmc, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)zmqlsxmcY, 0.0f);
        }
        if (StringUtils.isNotBlank((CharSequence)qlr)) {
            cb.showTextAligned(0, qlr, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)qlrY, 0.0f);
        }
        if (StringUtils.isNotBlank((CharSequence)ywr)) {
            cb.showTextAligned(0, ywr, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)ywrY, 0.0f);
        }
        if (StringUtils.isNotBlank((CharSequence)zl)) {
            while (zl.length() > 20) {
                String zlNew = zl.substring(0, 20);
                cb.showTextAligned(0, zlNew, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)(zlY += 8.0), 0.0f);
                zl = zl.substring(20);
                zlY -= 13.0;
            }
            cb.showTextAligned(0, zl, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)zlY, 0.0f);
        }
        if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            cb.showTextAligned(0, bdcdyh, (float)zmqlsxmcXqlrXywrXzlXbdcdyhX, (float)bdcdyhY, 0.0f);
        }
        return cb;
    }

    private PdfContentByte setPdfSqsjcaAndNfAndSzsxqcAndZhlshY(PdfContentByte cb, String sqsjc, String nf, String szsxqc, String zhlsh, double sqsjcX, double nfX, double szsxqcX, double zhlshX, double sqsjcaAndNfAndSzsxqcAndZhlshY) {
        if (StringUtils.isNotBlank((CharSequence)sqsjc) && StringUtils.isNotBlank((CharSequence)nf) && StringUtils.isNotBlank((CharSequence)szsxqc) && StringUtils.isNotBlank((CharSequence)zhlsh)) {
            cb.showTextAligned(0, sqsjc, (float)sqsjcX, (float)sqsjcaAndNfAndSzsxqcAndZhlshY, 0.0f);
            cb.showTextAligned(0, nf, (float)nfX, (float)sqsjcaAndNfAndSzsxqcAndZhlshY, 0.0f);
            cb.showTextAligned(0, szsxqc, (float)szsxqcX, (float)sqsjcaAndNfAndSzsxqcAndZhlshY, 0.0f);
            cb.showTextAligned(0, zhlsh, (float)zhlshX, (float)sqsjcaAndNfAndSzsxqcAndZhlshY, 0.0f);
        }
        return cb;
    }

    private PdfContentByte setPdfYearAndMonthAndDay(PdfContentByte cb, String year, String month, String day, double yearX, double monthX, double dayX, double yearAndMonthAndDayY) {
        if (StringUtils.isNotBlank((CharSequence)year) && StringUtils.isNotBlank((CharSequence)month) && StringUtils.isNotBlank((CharSequence)day)) {
            cb.showTextAligned(0, year, (float)yearX, (float)yearAndMonthAndDayY, 0.0f);
            cb.showTextAligned(0, month, (float)monthX, (float)yearAndMonthAndDayY, 0.0f);
            cb.showTextAligned(0, day, (float)dayX, (float)yearAndMonthAndDayY, 0.0f);
        }
        return cb;
    }

    private boolean sendFileCenter(String path, String proid, String nodeName, String directoryName) {
        boolean bol = false;
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)proid)) {
            Integer projectFileId = this.platformUtil.getProjectFileId(proid);
            Integer nodeId = this.platformUtil.getNodeId(projectFileId, directoryName);
            bol = this.platformUtil.uploadFileFromPath(path, nodeId, nodeName);
        }
        return bol;
    }

    private String sendFileCenterNode(String path, String proid, String nodeName, String directoryName) {
        String nodeIdN = null;
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)proid)) {
            Integer projectFileId = this.platformUtil.getProjectFileId(proid);
            Integer nodeId = this.platformUtil.getNodeId(projectFileId, directoryName);
            nodeIdN = this.platformUtil.uploadFileFromPathNodeId(path, nodeId, nodeName);
        }
        return nodeIdN;
    }

    public PdfContentByte textSubstring(String str, PdfContentByte cb, double x, double y, int wordNum, int lineSpacing) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            while (str.length() > wordNum) {
                String zlNew = str.substring(0, wordNum);
                cb.showTextAligned(0, zlNew, (float)x, (float)(y += 8.0), 0.0f);
                str = str.substring(wordNum);
                y -= (double)lineSpacing;
            }
            cb.showTextAligned(0, str, (float)x, (float)y, 0.0f);
        }
        return cb;
    }

    private PdfContentByte textSubstring(String str, PdfContentByte cb, double x, double y, int textLen) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            String[] strs = str.split("\\n");
            int j = 0;
            for (int i = 0; i < strs.length; ++i) {
                double strY = (y - (double)(j * 50)) / 3.0;
                while (strs[i].length() > textLen) {
                    String qtText = strs[i].substring(0, textLen);
                    strs[i] = strs[i].substring(textLen, strs[i].length());
                    cb.showTextAligned(0, qtText, (float)x, (float)strY, 0.0f);
                    strY = (y - (double)(++j * 50)) / 3.0;
                }
                cb.showTextAligned(0, strs[i], (float)x, (float)strY, 0.0f);
                ++j;
            }
        }
        return cb;
    }

    public void getQrcodeImage(int width, int height, String content, String imageFile, int qrcodeVersion) {
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect('L');
        qrcode.setQrcodeEncodeMode('N');
        qrcode.setQrcodeVersion(qrcodeVersion);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D gs = bufferedImage.createGraphics();
            gs.setBackground(Color.white);
            gs.clearRect(0, 0, width, height);
            gs.setColor(Color.black);
            byte[] contentBytes = content.getBytes("utf-8");
            int pixoff = 2;
            if (contentBytes.length > 0 && contentBytes.length < 130) {
                boolean[][] codeOut = qrcode.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        if (!codeOut[j][i]) continue;
                        gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                    }
                }
            }
            gs.dispose();
            bufferedImage.flush();
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(imageFile));
        }
        catch (IOException e) {
            LOGGER.error("getQrcodeImage() IOException occurred", (Throwable)e);
        }
    }

    public byte[] getQrcodeImageByte(int width, int height, String content, int qrcodeVersion) {
        byte[] result = null;
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect('L');
        qrcode.setQrcodeEncodeMode('N');
        qrcode.setQrcodeVersion(qrcodeVersion);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D gs = bufferedImage.createGraphics();
            gs.setBackground(Color.white);
            gs.clearRect(0, 0, width, height);
            gs.setColor(Color.black);
            byte[] contentBytes = content.getBytes("utf-8");
            int pixoff = 2;
            if (contentBytes.length > 0 && contentBytes.length < 130) {
                boolean[][] codeOut = qrcode.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        if (!codeOut[j][i]) continue;
                        gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                    }
                }
            }
            gs.dispose();
            result = this.getQrcodeImageByte(bufferedImage, "png");
        }
        catch (IOException e) {
            LOGGER.error("getQrcodeImageByte:IOException", (Throwable)e);
        }
        return result;
    }

    public byte[] getQrcodeImageByte(BufferedImage bufferedImage, String format) {
        byte[] qrcodeByte = null;
        if (null != bufferedImage) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                bufferedImage.flush();
                if (ImageIO.write((RenderedImage)bufferedImage, format, out)) {
                    qrcodeByte = out.toByteArray();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return qrcodeByte;
    }
}

