/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.model.examine.BdcExamineParam;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.mapper.server.ExamineCheckInfoMapper;
import cn.gtmap.estateplat.server.core.service.ExamineCheckInfoService;
import cn.gtmap.estateplat.server.enums.MapKeyEnum;
import cn.gtmap.estateplat.service.examine.BdcExamineService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamineCheckInfoServiceImpl
implements ExamineCheckInfoService {
    @Autowired
    private ExamineCheckInfoMapper examineCheckInfoMapper;
    @Autowired
    private BdcExamineService bdcExamineService;

    public List<BdcExamineParam> getBdcExamineParam(String wiid, Project project) {
        ArrayList<BdcExamineParam> bdcExamineParamList = new ArrayList<BdcExamineParam>();
        this.getBdcExamineParamFromProject(project, bdcExamineParamList);
        this.getBdcExamineParamByWiid(wiid, bdcExamineParamList);
        return bdcExamineParamList;
    }

    private List<BdcExamineParam> getBdcExamineParamFromProject(Project project, List<BdcExamineParam> bdcExamineParamList) {
        if (project != null && StringUtils.isNotBlank((CharSequence)project.getProid())) {
            List bdcdyhList = this.getBdcdyhFromProject(project);
            if (CollectionUtils.isNotEmpty((Collection)bdcdyhList)) {
                for (String bdcdyh : bdcdyhList) {
                    BdcExamineParam bdcExamineParam = new BdcExamineParam();
                    bdcExamineParam.setBdcdyh(bdcdyh);
                    bdcExamineParamList.add(bdcExamineParam);
                }
            }
        } else if (project != null && StringUtils.isNotBlank((CharSequence)project.getGdproid())) {
            ArrayList<String> paramList = new ArrayList<String>();
            for (String gdProid : StringUtils.split((String)project.getGdproid(), (String)"$")) {
                if (!StringUtils.isNotBlank((CharSequence)gdProid) || paramList.contains(gdProid)) continue;
                paramList.add(gdProid);
            }
            if (CollectionUtils.isNotEmpty(paramList)) {
                HashMap args = Maps.newHashMap();
                args.put("gdproids", paramList);
                List gdQlidList = this.examineCheckInfoMapper.queryGdproidByProject((Map)args);
                if (CollectionUtils.isNotEmpty((Collection)gdQlidList)) {
                    BdcExamineParam bdcExamineParam = new BdcExamineParam();
                    ArrayList yQlidList = new ArrayList();
                    for (Map gdQlid : gdQlidList) {
                        if (gdQlid.get("QLID") == null) continue;
                        yQlidList.add(gdQlid.get("QLID"));
                    }
                    bdcExamineParam.setyQlidList(yQlidList);
                    bdcExamineParamList.add(bdcExamineParam);
                }
            }
        }
        return bdcExamineParamList;
    }

    private List<BdcExamineParam> getBdcExamineParamByWiid(String wiid, List<BdcExamineParam> bdcExamineParamList) {
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            HashMap args = Maps.newHashMap();
            args.put("wiid", wiid);
            List proidMapList = this.examineCheckInfoMapper.queryYproidByWiid((Map)args);
            if (CollectionUtils.isNotEmpty((Collection)proidMapList)) {
                bdcExamineParamList.clear();
                for (Map proidMap : proidMapList) {
                    BdcExamineParam bdcExamineParam = new BdcExamineParam();
                    String proid = "";
                    String bdcdyh = "";
                    ArrayList yQlidList = new ArrayList();
                    if (proidMap.get("PROID") != null) {
                        List yQlidMapList;
                        Map bdcdyhMap;
                        proid = (String)proidMap.get("PROID");
                        bdcExamineParam.setProid(proid);
                        args.clear();
                        args.put("proid", proid);
                        List bdcdyhMapList = this.examineCheckInfoMapper.queryBdcdyhByWiid((Map)args);
                        if (CollectionUtils.isNotEmpty((Collection)bdcdyhMapList) && (bdcdyhMap = (Map)bdcdyhMapList.get(0)).get("BDCDYH") != null) {
                            bdcdyh = (String)bdcdyhMap.get("BDCDYH");
                            bdcExamineParam.setBdcdyh(bdcdyh);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(yQlidMapList = this.examineCheckInfoMapper.queryYproidByWiid((Map)args)))) {
                            for (Map yQlidMap : yQlidMapList) {
                                if (yQlidMap.get("YQLID") == null) continue;
                                yQlidList.add(yQlidMap.get("YQLID"));
                            }
                        }
                    }
                    bdcExamineParamList.add(bdcExamineParam);
                }
            }
        }
        return bdcExamineParamList;
    }

    private List<String> getBdcdyhFromProject(Project project) {
        int i$;
        int len$;
        String[] arr$;
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<String> bdcdyhList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)project.getDjIds())) {
            for (String djId : project.getDjIds()) {
                arr$ = StringUtils.split((String)djId, (String)"$");
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String tempDjId = arr$[i$];
                    if (!StringUtils.isNotBlank((CharSequence)tempDjId)) continue;
                    paramList.add(tempDjId);
                }
            }
            bdcdyhList.addAll(this.queryBdcdyhListByParam("djids", paramList));
        }
        paramList.clear();
        if (CollectionUtils.isNotEmpty((Collection)project.getDcbIndexs())) {
            for (String dcbIndex : project.getDcbIndexs()) {
                arr$ = StringUtils.split((String)dcbIndex, (String)"$");
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String tempDcbIndex = arr$[i$];
                    if (!StringUtils.isNotBlank((CharSequence)tempDcbIndex)) continue;
                    paramList.add(tempDcbIndex);
                }
            }
            bdcdyhList.addAll(this.queryBdcdyhListByParam("fwdcbindexs", paramList));
        }
        paramList.clear();
        if (StringUtils.isNotBlank((CharSequence)project.getDjId())) {
            for (String djId : StringUtils.split((String)project.getDjId(), (String)"$")) {
                if (!StringUtils.isNotBlank((CharSequence)djId)) continue;
                paramList.add(djId);
            }
            bdcdyhList.addAll(this.queryBdcdyhListByParam("djids", paramList));
        }
        paramList.clear();
        if (StringUtils.isNotBlank((CharSequence)project.getDcbIndex())) {
            for (String dcbIndex : StringUtils.split((String)project.getDcbIndex(), (String)"$")) {
                if (!StringUtils.isNotBlank((CharSequence)dcbIndex)) continue;
                paramList.add(dcbIndex);
            }
            bdcdyhList.addAll(this.queryBdcdyhListByParam("fwdcbindexs", paramList));
        }
        paramList.clear();
        if (CollectionUtils.isNotEmpty((Collection)project.getBdcdyhs())) {
            for (String bdcdyh : project.getBdcdyhs()) {
                for (String tempBdcdyh : StringUtils.split((String)bdcdyh, (String)"$")) {
                    if (!StringUtils.isNotBlank((CharSequence)tempBdcdyh) || bdcdyhList.contains(tempBdcdyh)) continue;
                    bdcdyhList.add(tempBdcdyh);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh())) {
            for (String tempBdcdyh : StringUtils.split((String)project.getBdcdyh(), (String)"$")) {
                if (!StringUtils.isNotBlank((CharSequence)tempBdcdyh) || bdcdyhList.contains(tempBdcdyh)) continue;
                bdcdyhList.add(tempBdcdyh);
            }
        }
        return bdcdyhList;
    }

    private List<String> queryBdcdyhListByParam(String param, List<String> paramList) {
        ArrayList<String> bdcdyhList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap<String, Object[]> paramMap = new HashMap<String, Object[]>();
            paramMap.put(param, paramList.toArray());
            List tempBdcdyhList = this.examineCheckInfoMapper.queryFwHsInfoByBdcdyh(paramMap);
            if (CollectionUtils.isNotEmpty((Collection)tempBdcdyhList)) {
                for (Map resultMap : tempBdcdyhList) {
                    if (resultMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get("BDCDYH"))) || bdcdyhList.contains(resultMap.get("BDCDYH"))) continue;
                    bdcdyhList.add((String)resultMap.get("BDCDYH"));
                }
            }
        }
        return bdcdyhList;
    }

    public String getXzwhByWiid(String wiid) {
        Map checkMap;
        List bdcExamineParamList;
        String examineInfo = "";
        String lwsqUrl = "";
        if (StringUtils.isNotBlank((CharSequence)wiid) && CollectionUtils.isNotEmpty((Collection)(bdcExamineParamList = this.getBdcExamineParam(wiid, null))) && (checkMap = this.bdcExamineService.performExamine(bdcExamineParamList, wiid)) != null && checkMap.get(MapKeyEnum.EXAMINEINFO.getMapKey()) != null) {
            examineInfo = checkMap.get(MapKeyEnum.EXAMINEINFO.getMapKey()).toString();
        }
        if (StringUtils.isNotBlank((CharSequence)examineInfo)) {
            lwsqUrl = "/bdcXzyzLw/addXzyzLw?wiid=" + wiid + "&examineInfo=" + examineInfo;
        }
        return lwsqUrl;
    }
}

