/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcFdcq;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.server.BdcXmRelMapper;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcXmRelService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.GdXmService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.enums.MapKeyEnum;
import cn.gtmap.estateplat.server.utils.XmRelModel;
import cn.gtmap.estateplat.utils.ArrayUtils;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcXmRelServiceImpl
implements BdcXmRelService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcXmRelMapper bdcXmRelMapper;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private GdXmService gdXmService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcQlrService bdcQlrService;

    public BdcXmRel creatBdcXmRelFromProject(Project project) {
        BdcXmRel bdcXmRel = new BdcXmRel();
        bdcXmRel.setProid(project.getProid());
        bdcXmRel.setQjid(project.getDjId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getYxmid()})) {
            bdcXmRel.setYproid(project.getYxmid());
        } else {
            bdcXmRel.setYproid(project.getGdproid());
        }
        bdcXmRel.setYdjxmly(project.getXmly());
        bdcXmRel.setYqlid(project.getYqlid());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getProid()})) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)project.getProid());
            if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                this.entityMapper.deleteByExample(example);
            }
        }
        bdcXmRel.setRelid(UUIDGenerator.generate18());
        return bdcXmRel;
    }

    public List<BdcXmRel> creatMulBdcXmRelFromProject(Project project) {
        ArrayList<BdcXmRel> bdcXmRelList = null;
        if (project != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getProid()})) {
                Example example = new Example(BdcXmRel.class);
                example.createCriteria().andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)project.getProid());
                if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                    this.entityMapper.deleteByExample(example);
                }
            }
            if (StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"321")) {
                if (CollectionUtils.isNotEmpty((Collection)project.getBdcXmRelList())) {
                    bdcXmRelList = new ArrayList<BdcXmRel>();
                    for (BdcXmRel xmRel : project.getBdcXmRelList()) {
                        BdcXmRel tempBdcXmRel = new BdcXmRel();
                        tempBdcXmRel.setProid(project.getProid());
                        tempBdcXmRel.setYdjxmly(project.getXmly());
                        tempBdcXmRel.setYproid(xmRel.getYproid());
                        tempBdcXmRel.setRelid(UUIDGenerator.generate18());
                        bdcXmRelList.add(tempBdcXmRel);
                    }
                }
            } else if (project.getDjIds() != null && CollectionUtils.isNotEmpty((Collection)project.getDjIds())) {
                bdcXmRelList = new ArrayList();
                if (StringUtils.indexOf((CharSequence)((CharSequence)project.getDjIds().get(0)), (CharSequence)"$") > -1) {
                    String[] djIdsTemp;
                    List<String> djIds = new ArrayList();
                    if (StringUtils.equals((CharSequence)project.getBdclx(), (CharSequence)"TDFW")) {
                        djIds = this.gdXmService.getDjidByProid(project.getGdproid());
                    } else if (StringUtils.equals((CharSequence)project.getBdclx(), (CharSequence)"TD") && (djIdsTemp = StringUtils.split((String)((String)project.getDjIds().get(0)), (String)"$")) != null && djIdsTemp.length > 0) {
                        for (String djId : djIdsTemp) {
                            djIds.add(djId);
                        }
                    }
                    for (String djId : djIds) {
                        BdcXmRel bdcXmRel = new BdcXmRel();
                        bdcXmRel.setProid(project.getProid());
                        bdcXmRel.setQjid(djId);
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getYxmid()})) {
                            bdcXmRel.setYproid(project.getYxmid());
                        } else {
                            bdcXmRel.setYproid(project.getGdproid());
                        }
                        bdcXmRel.setYdjxmly(project.getXmly());
                        bdcXmRel.setRelid(UUIDGenerator.generate18());
                        bdcXmRelList.add(bdcXmRel);
                    }
                } else {
                    for (String djId : project.getDjIds()) {
                        BdcXmRel bdcXmRel = new BdcXmRel();
                        bdcXmRel.setProid(project.getProid());
                        bdcXmRel.setQjid(djId);
                        bdcXmRel.setYdjxmly(project.getXmly());
                        bdcXmRel.setYproid(project.getYxmid());
                        bdcXmRel.setRelid(UUIDGenerator.generate18());
                        bdcXmRelList.add(bdcXmRel);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)project.getDjId())) {
                bdcXmRelList = new ArrayList();
                BdcXmRel bdcXmRel = new BdcXmRel();
                bdcXmRel.setProid(project.getProid());
                bdcXmRel.setQjid(project.getDjId());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getYxmid()})) {
                    bdcXmRel.setYproid(project.getYxmid());
                } else {
                    bdcXmRel.setYproid(project.getGdproid());
                }
                bdcXmRel.setRelid(UUIDGenerator.generate18());
                bdcXmRelList.add(bdcXmRel);
            }
        }
        return bdcXmRelList;
    }

    public List<BdcXmRel> queryBdcXmRelByProid(String proid) {
        List bdcXmRelList = null;
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            BdcXmRel bdcXmRel = new BdcXmRel();
            bdcXmRel.setProid(proid);
            bdcXmRelList = this.bdcXmRelMapper.queryBdcXmRelMapper(bdcXmRel);
        }
        return bdcXmRelList;
    }

    @Transactional
    public void delBdcXmRelByProid(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)proid);
            if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                this.entityMapper.deleteByExample(BdcXmRel.class, (Object)example);
            }
        }
    }

    public String getYproid(String proid) {
        return this.bdcXmRelMapper.getYproid(proid);
    }

    public List<BdcXmRel> getHisBdcXmRelByProid(String proid) {
        return this.bdcXmRelMapper.getHisXmRelList(proid);
    }

    public String getHisXmRelXml(String proid, String bdcdyh, String portalUrl) {
        List bdcXmRelList;
        String xml = "";
        ArrayList<String> proidList = new ArrayList<String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid}) && (bdcXmRelList = this.getHisBdcXmRelByProid(proid)) != null && CollectionUtils.isNotEmpty((Collection)bdcXmRelList)) {
            HashMap<String, Object> map;
            ArrayList<BdcXmRel> queryBdcXmRelList = new ArrayList<BdcXmRel>();
            ArrayList<QllxVo> qllxVoList = new ArrayList<QllxVo>();
            String djid = "";
            if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
                map = new HashMap<String, Object>(1);
                map.put("bdcdyh", bdcdyh);
                List bdcdyhMapList = this.bdcdyService.getDjBdcdyListByPage(map);
                if (bdcdyhMapList != null && CollectionUtils.isNotEmpty((Collection)bdcdyhMapList) && StringUtils.isNotBlank((CharSequence)CommonUtil.formatEmptyValue(((Map)bdcdyhMapList.get(0)).get("ID")))) {
                    djid = CommonUtil.formatEmptyValue(((Map)bdcdyhMapList.get(0)).get("ID"));
                }
            }
            for (BdcXmRel bdcXmRel : bdcXmRelList) {
                BdcXm bdcXm;
                QllxVo qllxVo;
                if (!proidList.contains(bdcXmRel.getProid())) {
                    proidList.add(bdcXmRel.getProid());
                }
                if ((qllxVo = this.qllxService.queryQllxVo(bdcXm = this.bdcXmService.getBdcXmByProid(bdcXmRel.getProid()))) != null) {
                    qllxVoList.add(qllxVo);
                }
                if (StringUtils.isNotBlank((CharSequence)djid)) {
                    if (!StringUtils.equals((CharSequence)bdcXmRel.getQjid(), (CharSequence)djid) && !StringUtils.isBlank((CharSequence)bdcXmRel.getQjid())) continue;
                    queryBdcXmRelList.add(bdcXmRel);
                    continue;
                }
                queryBdcXmRelList.add(bdcXmRel);
            }
            map = new HashMap(2);
            map.put("proids", proidList);
            map.put("bdcdyh", bdcdyh);
            List bdcZsXmRelList = this.bdcZsService.getBdcqzByPage(map);
            List bdcXmList = this.bdcXmService.getBdcXmListForXmRel(map);
            bdcXmList = this.changeBdcXmSqlx(bdcXmList);
            List bdcZdQlztList = this.bdcZdGlService.getBdcZdQlztList();
            List hashMapList = this.bdcQlrService.getQlrByXmList(bdcXmList);
            Document document = XmRelModel.getXmRel(queryBdcXmRelList, (List)bdcZsXmRelList, (List)bdcXmList, qllxVoList, (List)bdcZdQlztList, (String)bdcdyh, (List)hashMapList, (String)portalUrl);
            if (document != null) {
                xml = document.asXML();
            }
        }
        return xml;
    }

    public List<BdcXmRel> getBdcXmRelByYproidAndBdcdyh(Map map) {
        return this.bdcXmRelMapper.getBdcXmRelByYproidAndBdcdyh(map);
    }

    public List<BdcXmRel> getAllHisRelList(Map map) {
        return this.bdcXmRelMapper.getAllHisRelList(map);
    }

    public String getAllXmRelXml(String proid, String bdcdyh, String portalUrl) {
        String xml = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid})) {
            List bdcXmRelList = this.getHisBdcXmRelByProid(proid);
            if (bdcXmRelList != null && CollectionUtils.isNotEmpty((Collection)bdcXmRelList)) {
                String firstProid = ((BdcXmRel)bdcXmRelList.get(0)).getProid();
                HashMap<String, String> map1 = new HashMap<String, String>(1);
                map1.put(MapKeyEnum.PROID.getMapKey(), firstProid);
                bdcXmRelList = this.getAllHisRelList(map1);
            }
            String bdcdyid = this.bdcdyService.getBdcdyidByBdcdyh(bdcdyh);
            if (bdcXmRelList != null && CollectionUtils.isNotEmpty((Collection)bdcXmRelList)) {
                Object[] proids = new String[bdcXmRelList.size()];
                ArrayList<BdcXmRel> queryBdcXmRelList = new ArrayList<BdcXmRel>();
                ArrayList<QllxVo> qllxVoList = new ArrayList<QllxVo>();
                String djid = "";
                if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put("bdcdyh", bdcdyh);
                    List bdcdyhMapList = this.bdcdyService.getDjBdcdyListByPage(map);
                    if (bdcdyhMapList != null && CollectionUtils.isNotEmpty((Collection)bdcdyhMapList) && StringUtils.isNotBlank((CharSequence)CommonUtil.formatEmptyValue(((Map)bdcdyhMapList.get(0)).get("ID")))) {
                        djid = CommonUtil.formatEmptyValue(((Map)bdcdyhMapList.get(0)).get("ID"));
                    }
                }
                int i = 0;
                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                    if (!ArrayUtils.contains((Object[])proids, (Object)bdcXmRel.getProid())) {
                        proids[i] = bdcXmRel.getProid();
                    }
                    if (StringUtils.isNotBlank((CharSequence)djid)) {
                        if (StringUtils.equals((CharSequence)bdcXmRel.getQjid(), (CharSequence)djid) || StringUtils.isBlank((CharSequence)bdcXmRel.getQjid()) && bdcdyid != null) {
                            queryBdcXmRelList.add(bdcXmRel);
                        }
                    } else {
                        queryBdcXmRelList.add(bdcXmRel);
                    }
                    ++i;
                }
                if (CollectionUtils.isNotEmpty(queryBdcXmRelList)) {
                    for (BdcXmRel bdcXmRel : queryBdcXmRelList) {
                        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(bdcXmRel.getProid());
                        QllxVo qllxVoTemp = this.qllxService.queryQllxVo(bdcXm);
                        if (qllxVoTemp == null) continue;
                        if (qllxVoTemp instanceof BdcFdcq) {
                            if (!StringUtils.isNotBlank((CharSequence)bdcdyid) || !bdcdyid.equals(((BdcFdcq)qllxVoTemp).getBdcdyid())) continue;
                            qllxVoList.add(qllxVoTemp);
                            continue;
                        }
                        qllxVoList.add(qllxVoTemp);
                    }
                }
                HashMap<String, Object[]> map = new HashMap<String, Object[]>();
                map.put("proids", proids);
                List bdcZsXmRelList = this.bdcZsService.getBdcqzByPage(map);
                List bdcXmList = this.bdcXmService.getBdcXmListForXmRel(map);
                bdcXmList = this.changeBdcXmSqlx(bdcXmList);
                List bdcZdQlztList = this.bdcZdGlService.getBdcZdQlztList();
                List hashMapList = this.bdcQlrService.getQlrByXmList(bdcXmList);
                Document document = XmRelModel.getXmRel(queryBdcXmRelList, (List)bdcZsXmRelList, (List)bdcXmList, qllxVoList, (List)bdcZdQlztList, (String)bdcdyh, (List)hashMapList, (String)portalUrl);
                if (document != null) {
                    xml = document.asXML();
                }
            }
        }
        return xml;
    }

    public String getDyAllXmRelXml(String bdcdyh, String portalUrl) {
        String xml = "";
        if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            BdcBdcdy bdcdy = this.bdcdyService.queryBdcdyByBdcdyh(bdcdyh);
            String proid = "";
            HashMap<String, String> querymap = new HashMap<String, String>(1);
            querymap.put("bdcdyid", bdcdy.getBdcdyid());
            List bdcXmList = this.bdcXmService.andEqualQueryBdcXm(querymap);
            if (bdcXmList != null && CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
                proid = ((BdcXm)bdcXmList.get(0)).getProid();
            }
            if (StringUtils.isNotBlank((CharSequence)proid)) {
                xml = this.getAllXmRelXml(proid, bdcdyh, portalUrl);
            }
        }
        return xml;
    }

    public BdcXmRel creatBdcXmRelFromProjectMul(Project project) {
        List bdcXmRelList;
        BdcXmRel bdcXmRel = new BdcXmRel();
        bdcXmRel.setProid(project.getProid());
        bdcXmRel.setQjid(project.getDjId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getYxmid()})) {
            bdcXmRel.setYproid(project.getYxmid());
        } else {
            bdcXmRel.setYproid(project.getGdproid());
        }
        bdcXmRel.setYdjxmly(project.getXmly());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getProid()})) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)project.getProid()).andEqualTo("ybdcdyid", (Object)project.getYbdcdyid());
            if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                this.entityMapper.deleteByExample(example);
            }
        }
        if ((bdcXmRelList = this.bdcXmRelMapper.queryBdcXmRelMapper(bdcXmRel)) == null || bdcXmRelList.isEmpty()) {
            bdcXmRel.setRelid(UUIDGenerator.generate18());
        } else {
            bdcXmRel = (BdcXmRel)bdcXmRelList.get(0);
        }
        return bdcXmRel;
    }

    public List<BdcXm> changeBdcXmSqlx(List<BdcXm> bdcXmList) {
        ArrayList<BdcXm> bdcXmLists = new ArrayList<BdcXm>();
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                if (bdcXm == null) continue;
                if (StringUtils.isNotBlank((CharSequence)bdcXm.getSqlx())) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("dm", bdcXm.getSqlx());
                    List bdcZdSqlxList = this.bdcZdGlService.getBdcSqlxByMap(hashMap);
                    if (CollectionUtils.isNotEmpty((Collection)bdcZdSqlxList)) {
                        bdcXm.setSqlx(((BdcZdSqlx)bdcZdSqlxList.get(0)).getMc());
                    }
                    bdcXmLists.add(bdcXm);
                    continue;
                }
                bdcXmLists.add(bdcXm);
            }
        }
        return bdcXmLists;
    }

    public List<BdcXmRel> getBdcXmRelByName(String name, String value) {
        List bdcXmRelList = null;
        Example example = new Example(BdcXmRel.class);
        example.createCriteria().andEqualTo(name, (Object)value);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            bdcXmRelList = this.entityMapper.selectByExample(example);
        }
        return bdcXmRelList;
    }

    public List<BdcXmRel> creatBdcXmRelListFromProject(Project project) {
        String[] yqlids;
        String[] yproids;
        ArrayList<Object> bdcXmRelList = null;
        if (project != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getProid()})) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)project.getProid());
            if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                this.entityMapper.deleteByExample(example);
            }
        }
        if (project != null && StringUtils.isNotBlank((CharSequence)project.getYxmid()) && StringUtils.isNotBlank((CharSequence)project.getYqlid()) && StringUtils.indexOf((CharSequence)project.getYqlid(), (CharSequence)",") > -1) {
            if (StringUtils.split((String)project.getYxmid(), (String)",").length == StringUtils.split((String)project.getYqlid(), (String)",").length) {
                bdcXmRelList = new ArrayList();
                yproids = project.getYxmid().split(",");
                String[] yqlids2 = project.getYqlid().split(",");
                int i = 0;
                for (String proid : yproids) {
                    BdcXmRel bdcXmRel = new BdcXmRel();
                    bdcXmRel.setProid(project.getProid());
                    bdcXmRel.setQjid(project.getDjId());
                    bdcXmRel.setYproid(proid);
                    bdcXmRel.setYqlid(yqlids2[i]);
                    bdcXmRel.setYdjxmly(project.getXmly());
                    bdcXmRel.setRelid(UUIDGenerator.generate18());
                    bdcXmRelList.add(bdcXmRel);
                    ++i;
                }
            } else {
                bdcXmRelList = new ArrayList();
                for (String yqlid : yqlids = project.getYqlid().split(",")) {
                    BdcXmRel bdcXmRel = new BdcXmRel();
                    bdcXmRel.setProid(project.getProid());
                    bdcXmRel.setQjid(project.getDjId());
                    bdcXmRel.setYproid(project.getYxmid());
                    bdcXmRel.setYqlid(yqlid);
                    bdcXmRel.setYdjxmly(project.getXmly());
                    bdcXmRel.setRelid(UUIDGenerator.generate18());
                    bdcXmRelList.add(bdcXmRel);
                }
            }
        } else if (project != null && StringUtils.isNotBlank((CharSequence)project.getGdproid()) && StringUtils.isNotBlank((CharSequence)project.getYqlid()) && StringUtils.indexOf((CharSequence)project.getYqlid(), (CharSequence)",") > -1) {
            if (StringUtils.split((String)project.getGdproid(), (String)",").length == StringUtils.split((String)project.getYqlid(), (String)",").length) {
                bdcXmRelList = new ArrayList();
                yproids = project.getGdproid().split(",");
                String[] yqlids3 = project.getYqlid().split(",");
                int i = 0;
                for (String proid : yproids) {
                    BdcXmRel bdcXmRel = new BdcXmRel();
                    bdcXmRel.setProid(project.getProid());
                    bdcXmRel.setQjid(project.getDjId());
                    bdcXmRel.setYproid(proid);
                    bdcXmRel.setYqlid(yqlids3[i]);
                    bdcXmRel.setYdjxmly(project.getXmly());
                    bdcXmRel.setRelid(UUIDGenerator.generate18());
                    bdcXmRelList.add(bdcXmRel);
                    ++i;
                }
            } else {
                bdcXmRelList = new ArrayList();
                for (String yqlid : yqlids = project.getYqlid().split(",")) {
                    BdcXmRel bdcXmRel = new BdcXmRel();
                    bdcXmRel.setProid(project.getProid());
                    bdcXmRel.setQjid(project.getDjId());
                    bdcXmRel.setYproid(project.getGdproid());
                    bdcXmRel.setYqlid(yqlid);
                    bdcXmRel.setYdjxmly(project.getXmly());
                    bdcXmRel.setRelid(UUIDGenerator.generate18());
                    bdcXmRelList.add(bdcXmRel);
                }
            }
        } else {
            bdcXmRelList = new ArrayList<BdcXmRel>();
            BdcXmRel bdcXmRel = new BdcXmRel();
            if (project != null) {
                bdcXmRel.setProid(project.getProid());
                bdcXmRel.setQjid(project.getDjId());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getYxmid()})) {
                    bdcXmRel.setYproid(project.getYxmid());
                } else {
                    bdcXmRel.setYproid(project.getGdproid());
                }
                bdcXmRel.setYqlid(project.getYqlid());
                bdcXmRel.setYdjxmly(project.getXmly());
            }
            bdcXmRel.setRelid(UUIDGenerator.generate18());
            bdcXmRelList.add(bdcXmRel);
        }
        return bdcXmRelList;
    }
}

