/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcLshService;
import cn.gtmap.estateplat.server.core.service.BdcSllshService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.service.server.BdcSlbhService;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.estateplat.utils.DateUtils;
import com.gtis.config.AppConfig;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BdcSlbhServiceImpl
implements BdcSlbhService {
    private static final Log log = LogFactory.getLog(BdcSlbhServiceImpl.class);
    private static final FastDateFormat SLBH_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMMdd");
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcSllshService bdcSllshService;
    @Autowired
    BdcLshService bdcLshService;

    public synchronized String generateBdcXmSlbh(BdcXm bdcXm) {
        if (StringUtils.isNotBlank((CharSequence)bdcXm.getWiid())) {
            String slbh = null;
            if (bdcXm.getCjsj() == null) {
                bdcXm.setCjsj(new Date());
            }
            if (AppConfig.getBooleanProperty((String)"xmbh.useMode.order", (boolean)false)) {
                Integer maxLsh = this.bdcSllshService.getSlbhLsh();
                log.info((Object)("\u83b7\u53d6\u53d7\u7406\u53f7\uff1a" + maxLsh));
                Integer lsh = maxLsh == null ? 1 : maxLsh + 1;
                bdcXm.setLsh(this.formatLsh(lsh));
                slbh = this.formatSlbh(bdcXm.getCjsj(), bdcXm.getLsh());
            } else {
                slbh = CommonUtil.getCurrentTimeMillisId();
            }
            if (this.isExistedSlbh(slbh, bdcXm.getWiid())) {
                log.info((Object)("\u5b58\u5728\uff1a" + slbh));
                throw new AppException(4002, new Object[0]);
            }
            bdcXm.setBh(slbh);
            BdcXm newBdcXm = new BdcXm();
            try {
                BeanUtils.copyProperties((Object)newBdcXm, (Object)bdcXm);
            }
            catch (Exception e) {
                throw new AppException(4002, new Object[0]);
            }
            if (AppConfig.getBooleanProperty((String)"xmbh.useMode.order", (boolean)false)) {
                log.info((Object)("\u4fdd\u5b58\uff1a" + bdcXm.getLsh()));
                this.bdcSllshService.saveBh(bdcXm.getLsh());
                log.info((Object)("\u4fdd\u5b58\u6210\u529f\uff1a" + bdcXm.getLsh()));
            }
            newBdcXm.setCjsj(new Date());
            return this.entityMapper.saveOrUpdate((Object)newBdcXm, (Object)newBdcXm.getProid()) > 0 ? slbh : null;
        }
        return null;
    }

    private synchronized String formatLsh(Integer lsh) {
        String slbhPattern = AppConfig.getProperty((String)"slbh.lsh.pattern");
        DecimalFormat df = StringUtils.isNotBlank((CharSequence)slbhPattern) ? new DecimalFormat(slbhPattern) : new DecimalFormat("0000");
        return df.format(lsh);
    }

    private synchronized String formatSlbh(Date slsj, String lsh) {
        return DateUtils.formatTime((Date)slsj, (FastDateFormat)SLBH_DATE_FORMAT) + lsh;
    }

    private synchronized boolean isExistedSlbh(String slbh, String wiid) {
        Example example = new Example(BdcXm.class);
        example.createCriteria().andEqualTo("bh", (Object)slbh);
        example.createCriteria().andNotEqualTo("wiid", (Object)wiid);
        int result = this.entityMapper.countByExample(example);
        return result > 0;
    }
}

