/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdCf;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;
import cn.gtmap.estateplat.model.server.core.GdQlr;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import cn.gtmap.estateplat.model.server.core.GdXm;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.server.BdcCfMapper;
import cn.gtmap.estateplat.server.core.service.BdcCfService;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcSpxxService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.GdBdcQlRelService;
import cn.gtmap.estateplat.server.core.service.GdCfService;
import cn.gtmap.estateplat.server.core.service.GdFwService;
import cn.gtmap.estateplat.server.core.service.GdQlrService;
import cn.gtmap.estateplat.server.core.service.GdTdService;
import cn.gtmap.estateplat.server.core.service.GdXmService;
import cn.gtmap.estateplat.server.core.service.QllxParentService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.enums.MapKeyEnum;
import cn.gtmap.estateplat.server.enums.MapKeyLowerCaseEnum;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcCfServiceImpl
implements BdcCfService {
    @Autowired
    BdcCfMapper bdcCfMapper;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcSpxxService bdcSpxxService;
    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdTdService gdTdService;
    @Autowired
    GdCfService gdCfService;
    @Autowired
    private GdXmService gdXmService;
    @Autowired
    private GdQlrService gdQlrService;
    @Autowired
    private GdBdcQlRelService gdBdcQlRelService;
    @Autowired
    private QllxParentService qllxParentService;

    @Transactional
    public void updateBdcCfForJfxx(BdcCf bdcCf) {
        if (bdcCf != null && StringUtils.isNotBlank((CharSequence)bdcCf.getQlid())) {
            this.bdcCfMapper.updateBdcCfForJfxx(bdcCf);
        }
    }

    public BdcCf selectCfByProid(String proid) {
        return this.bdcCfMapper.selectCfByProid(proid);
    }

    @Transactional(rollbackFor={Exception.class})
    public void ycfChangeCf(BdcXm bdcXm, BdcCf ycf) {
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getProid())) {
            BdcSpxx ybdcSpxx = null;
            String fj = "";
            if (ycf != null && StringUtils.isNotBlank((CharSequence)ycf.getProid())) {
                ybdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(ycf.getProid());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(MapKeyLowerCaseEnum.PROID.getMapKey(), bdcXm.getProid());
            List ybdcQlrList = null;
            ybdcQlrList = this.bdcQlrService.queryBdcQlrList(hashMap);
            if (ycf != null) {
                ycf.setQszt(Constants.QLLX_QSZT_HR);
                String sj = CalendarUtil.formatDateToString((Date)new Date());
                fj = ycf.getFj();
                if (StringUtils.isBlank((CharSequence)fj)) {
                    fj = "";
                }
                ycf.setFj(fj + sj + "\u9884\u67e5\u5c01\u8f6c\u67e5\u5c01");
                this.entityMapper.saveOrUpdate((Object)ycf, (Object)ycf.getQlid());
            }
            BdcXmRel bdcXmRel = new BdcXmRel();
            bdcXmRel.setYproid(bdcXm.getProid());
            bdcXm.setProid(UUIDGenerator.generate18());
            bdcXm.setSqlx("801");
            bdcXm.setQllx("21");
            bdcXm.setDjlx("800");
            bdcXm.setXmzt("1");
            bdcXm.setBh(CalendarUtil.getTimeMs());
            this.entityMapper.saveOrUpdate((Object)bdcXm, (Object)bdcXm.getProid());
            bdcXmRel.setRelid(UUIDGenerator.generate18());
            bdcXmRel.setProid(bdcXm.getProid());
            this.entityMapper.saveOrUpdate((Object)bdcXmRel, (Object)bdcXmRel.getRelid());
            BdcSpxx bdcSpxx = ybdcSpxx;
            if (bdcSpxx != null) {
                bdcSpxx.setProid(bdcXm.getProid());
                bdcSpxx.setSpxxid(UUIDGenerator.generate());
                this.entityMapper.saveOrUpdate((Object)bdcSpxx, (Object)bdcSpxx.getSpxxid());
            }
            List bdcQlrList = null;
            bdcQlrList = ybdcQlrList;
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                    bdcQlr.setProid(bdcXm.getProid());
                    this.entityMapper.saveOrUpdate((Object)bdcQlr, (Object)bdcQlr.getQlrid());
                }
            }
            if (ycf != null) {
                BdcCf bdcCf = ycf;
                bdcCf.setFj(fj);
                bdcCf.setQlid(UUIDGenerator.generate18());
                bdcCf.setProid(bdcXm.getProid());
                bdcCf.setDjsj(new Date());
                bdcCf.setCflx("1");
                bdcCf.setQszt(Constants.QLLX_QSZT_XS);
                this.entityMapper.saveOrUpdate((Object)bdcCf, (Object)bdcCf.getQlid());
            }
        }
    }

    public List<BdcCf> queryYcfByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.queryYcfByBdcdyh(bdcdyh);
    }

    public List<String> getBdcCflxMc() {
        return this.bdcCfMapper.getBdcCflxMc();
    }

    public List<Map> queryBdcCfByPage(Map map) {
        return this.bdcCfMapper.queryBdcCfByPage(map);
    }

    public List<Map> queryBdcGdCfByPage(Map map) {
        return this.bdcCfMapper.queryBdcGdCf(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public void turnLhcfToCf(BdcCf bdcCf, String bdcdyid) {
        if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put(MapKeyEnum.BDCDYID.getMapKey(), bdcdyid);
            map.put(MapKeyEnum.CFLX.getMapKey(), "1");
            map.put(MapKeyEnum.QSZT.getMapKey(), Constants.QLLX_QSZT_XS);
            List bdcCfListTemp = this.andEqualQueryCf(map, null);
            if (bdcCfListTemp == null || bdcCfListTemp.isEmpty()) {
                map = new HashMap(3);
                map.put(MapKeyEnum.BDCDYID.getMapKey(), bdcdyid);
                map.put(MapKeyEnum.CFLX.getMapKey(), "2");
                map.put(MapKeyEnum.QSZT.getMapKey(), Constants.QLLX_QSZT_XS);
                List bdcCfList = this.andEqualQueryCf(map, "to_number(lhsx)");
                if (bdcCfList != null && CollectionUtils.isNotEmpty((Collection)bdcCfList)) {
                    for (int i = 0; i < bdcCfList.size(); ++i) {
                        BdcCf bdcCfTemp = (BdcCf)bdcCfList.get(i);
                        if (i == 0) {
                            bdcCfTemp.setQszt(Constants.QLLX_QSZT_HR);
                            this.entityMapper.saveOrUpdate((Object)bdcCfTemp, (Object)bdcCfTemp.getQlid());
                            BdcXm ybdcXm = this.bdcXmService.getBdcXmByProid(bdcCfTemp.getProid());
                            String proid = UUIDGenerator.generate();
                            String yYwh = ybdcXm.getBh();
                            String ywh = UUIDGenerator.generate();
                            if (ybdcXm != null) {
                                List bdcQlrList;
                                BdcXm newXm = ybdcXm;
                                newXm.setProid(proid);
                                newXm.setBh(ywh);
                                newXm.setDjzx("1202");
                                newXm.setYbh(yYwh);
                                this.entityMapper.saveOrUpdate((Object)newXm, (Object)newXm.getProid());
                                BdcSpxx bdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(bdcCfTemp.getProid());
                                if (bdcSpxx != null) {
                                    BdcSpxx newBdcSpxx = bdcSpxx;
                                    newBdcSpxx.setSpxxid(UUIDGenerator.generate18());
                                    newBdcSpxx.setProid(proid);
                                    this.entityMapper.saveOrUpdate((Object)newBdcSpxx, (Object)newBdcSpxx.getSpxxid());
                                }
                                if ((bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(bdcCfTemp.getProid())) != null && CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
                                    for (int j = 0; j < bdcQlrList.size(); ++j) {
                                        BdcQlr bdcQlr = (BdcQlr)bdcQlrList.get(j);
                                        bdcQlr.setProid(proid);
                                        bdcQlr.setQlrid(UUIDGenerator.generate18());
                                        this.entityMapper.insertSelective((Object)bdcQlr);
                                    }
                                }
                            }
                            Date cfksqx = bdcCfTemp.getCfksqx();
                            Date cfjsqx = bdcCfTemp.getCfjsqx();
                            BdcCf newCf = bdcCfTemp;
                            boolean modifyLhqx = AppConfig.getBooleanProperty((String)"modifyLhqx", (boolean)true);
                            if (modifyLhqx) {
                                this.changeLhcfQx(cfksqx, cfjsqx, bdcCf, newCf);
                            }
                            newCf.setYwh(ywh);
                            newCf.setProid(proid);
                            newCf.setQlid(UUIDGenerator.generate());
                            if (bdcCf != null) {
                                newCf.setDbr(bdcCf.getJfdbr());
                            }
                            newCf.setCflx("1");
                            newCf.setQszt(Constants.QLLX_QSZT_XS);
                            newCf.setLhsx(null);
                            newCf.setFj(CalendarUtil.getCurChinaYMDStrDate() + "\u8f6e\u5019\u67e5\u5c01\u8f6c\u67e5\u5c01");
                            this.entityMapper.insertSelective((Object)bdcCfTemp);
                            continue;
                        }
                        Integer lhsx = bdcCfTemp.getLhsx() - 1;
                        bdcCfTemp.setLhsx(lhsx);
                        this.entityMapper.updateByPrimaryKeySelective((Object)bdcCfTemp);
                    }
                }
            }
        }
    }

    public BdcCf changeLhcfQx(Date cfksqx, Date cfjsqx, BdcCf bdcCf, BdcCf newCf) {
        if (cfksqx != null && cfjsqx != null) {
            Long days = CommonUtil.getDaySub((Date)cfksqx, (Date)cfjsqx);
            int daysI = days.intValue() - 1;
            Date today = new Date();
            if (bdcCf != null && bdcCf.getJfdjsj() != null) {
                String jsqx = CalendarUtil.addDay((String)CalendarUtil.formatDateTime((Date)bdcCf.getJfdjsj()), (int)daysI);
                newCf.setCfjsqx(CalendarUtil.formatDate((String)jsqx));
                newCf.setCfksqx(bdcCf.getJfdjsj());
            } else {
                Date jsqx = CommonUtil.plusDay((Date)today, (int)daysI);
                newCf.setCfjsqx(jsqx);
                newCf.setCfksqx(today);
            }
        }
        return newCf;
    }

    public List<BdcCf> andEqualQueryCf(Map map, String orderByClause) {
        List list = null;
        if (map != null) {
            Example qllxTemp = new Example(BdcCf.class);
            if (StringUtils.isNotBlank((CharSequence)orderByClause)) {
                qllxTemp.setOrderByClause(orderByClause);
            }
            if (!map.isEmpty()) {
                Iterator iter = map.entrySet().iterator();
                Example.Criteria criteria = qllxTemp.createCriteria();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (val == null) continue;
                    criteria.andEqualTo(key.toString(), val);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)qllxTemp.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)qllxTemp.getOredCriteria().get(0)).getAllCriteria())) {
                list = this.entityMapper.selectByExample(BdcCf.class, (Object)qllxTemp);
            }
        }
        return list;
    }

    public List<BdcCf> getCfByBdcdyid(String bdcdyid) {
        ArrayList<BdcCf> bdcCfList = new ArrayList<BdcCf>();
        if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("bdcdyid", bdcdyid);
            List cfList = this.andEqualQueryCf(map, "");
            if (CollectionUtils.isNotEmpty((Collection)cfList)) {
                for (BdcCf bdcCf : cfList) {
                    if (bdcCf.getQszt() != null && bdcCf.getQszt() != 0 && bdcCf.getQszt() != 1) continue;
                    bdcCfList.add(bdcCf);
                }
            }
        }
        return bdcCfList;
    }

    public List<BdcCf> getXsCfByBdcdyh(String bdcdyh) {
        List bdcCfList = null;
        if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
            hashMap.put("bdcdyh", bdcdyh);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS);
            hashMap.put("cflx", "1");
            bdcCfList = this.bdcCfMapper.getCfByMap(hashMap);
        }
        return bdcCfList;
    }

    public String getCfDjzx(Project project, BdcXm yBdcXm) {
        String djzx = "";
        List bdcCfList = null;
        List gdCfList = null;
        djzx = "1202";
        String sjppType = AppConfig.getProperty((String)"sjpp.type");
        if (StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"803") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"807") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"809")) {
            djzx = "";
        } else if (StringUtils.equals((CharSequence)project.getXmly(), (CharSequence)"1")) {
            if (StringUtils.isNotBlank((CharSequence)project.getDjId()) && StringUtils.isEmpty((CharSequence)project.getBdcqzh())) {
                djzx = "1201";
            } else if (yBdcXm != null) {
                if (StringUtils.equals((CharSequence)yBdcXm.getQllx(), (CharSequence)"21")) {
                    djzx = "1204";
                } else if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh()) && CollectionUtils.isNotEmpty((Collection)(bdcCfList = this.getXsCfByBdcdyh(project.getBdcdyh())))) {
                    djzx = "1203";
                }
            }
        } else if (StringUtils.equals((CharSequence)sjppType, (CharSequence)"cg")) {
            GdFwsyq gdFwsyq = null;
            GdTdsyq gdTdsyq = null;
            if (StringUtils.isNotBlank((CharSequence)project.getYqlid())) {
                if (StringUtils.equals((CharSequence)project.getBdclx(), (CharSequence)"TDFW")) {
                    gdFwsyq = this.gdFwService.getGdFwsyqByQlid(project.getYqlid());
                } else {
                    gdTdsyq = this.gdTdService.getGdTdsyqByQlid(project.getYqlid());
                }
                if (gdFwsyq != null || gdTdsyq != null) {
                    gdCfList = this.gdCfService.getGdCfListByQlid(project.getYqlid(), Integer.valueOf(0));
                    if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh())) {
                        bdcCfList = this.getXsCfByBdcdyh(project.getBdcdyh());
                    }
                    djzx = CollectionUtils.isNotEmpty((Collection)bdcCfList) || CollectionUtils.isNotEmpty((Collection)gdCfList) ? "1203" : "1202";
                } else {
                    djzx = "1204";
                }
            }
        } else {
            GdCf gdCf = this.gdFwService.getGdCfByCfid(project.getYqlid(), Integer.valueOf(0));
            if (gdCf != null) {
                if (StringUtils.isBlank((CharSequence)gdCf.getCflx()) || StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u67e5\u5c01")) {
                    djzx = "1202";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u8f6e\u5019\u67e5\u5c01")) {
                    djzx = "1203";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u7eed\u5c01")) {
                    djzx = "1204";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u9884\u67e5\u5c01") || StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u8f6e\u5019\u9884\u67e5\u5c01")) {
                    djzx = "1201";
                }
            }
        }
        return djzx;
    }

    public List<BdcXm> getCfXmByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.getCfXmByBdcdyh(bdcdyh);
    }

    public String checkCf() {
        String msg = "success";
        this.checkAllCfByCflx("3", new Date());
        this.checkAllCfByCflx("1", new Date());
        return msg;
    }

    private String checkAllCfByCflx(String cflx, Date sxtime) {
        String result = "success";
        if (StringUtils.isNotBlank((CharSequence)cflx)) {
            String lhcflx = "";
            lhcflx = StringUtils.equals((CharSequence)cflx, (CharSequence)"3") ? "4" : "2";
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("cflx", cflx);
            param.put("sxtime", sxtime);
            List data = this.bdcCfMapper.getAllBdccf(param);
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                String bdcdyid = "";
                for (Map sxcf : data) {
                    List wsxLhCfYcf;
                    List sxlhCfYcf;
                    if (sxcf == null || !sxcf.containsKey("BDCDYID") || !sxcf.containsKey("BDCDYH") || sxcf.get("BDCDYH") == null || !sxcf.containsKey("QLID") || sxcf.get("QLID") == null) continue;
                    String bdcdyh = sxcf.get("BDCDYH").toString();
                    String qlid = sxcf.get("QLID").toString();
                    if (sxcf.get("BDCDYID") != null) {
                        bdcdyid = sxcf.get("BDCDYID").toString();
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(sxlhCfYcf = this.getLhcfByBdcdyid(bdcdyid, bdcdyh, lhcflx, new Date(), null)))) {
                        this.changeSxcfQszt(sxcf);
                        for (Map sxlhcfYcfMap : sxlhCfYcf) {
                            if (sxlhcfYcfMap == null) continue;
                            this.changeSxcfQszt(sxlhcfYcfMap);
                        }
                    } else {
                        this.changeSxcfQszt(sxcf);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(wsxLhCfYcf = this.getLhcfByBdcdyid(bdcdyid, bdcdyh, lhcflx, null, new Date())))) continue;
                    this.turnLhcfYcfToCfYcf(lhcflx, cflx, bdcdyid, bdcdyh, qlid, wsxLhCfYcf);
                }
            }
        }
        return result;
    }

    private List<Map<String, Object>> getLhcfByBdcdyid(String bdcdyid, String bdcdyh, String cflx, Date sxtime, Date wsxtime) {
        List<Map<String, Object>> lhcf = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)cflx)) {
            if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("bdcdyid", bdcdyid);
                map.put("cflx", cflx);
                map.put("sxtime", sxtime);
                map.put("wsxtime", wsxtime);
                lhcf = this.bdcCfMapper.getAllBdccf(map);
            } else if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("bdcdyh", bdcdyh);
                map.put("cflx", cflx);
                map.put("sxtime", sxtime);
                map.put("wsxtime", wsxtime);
                lhcf = this.bdcCfMapper.getAllBdccf(map);
            }
        }
        return lhcf;
    }

    private void changeSxcfQszt(Map<String, Object> cfdata) {
        if (cfdata != null && cfdata.containsKey("QLID") && cfdata.get("QLID") != null && cfdata.containsKey("XMLY") && cfdata.get("XMLY") != null) {
            String qlid = cfdata.get("QLID").toString();
            String xmly = cfdata.get("XMLY").toString();
            if (StringUtils.isNotBlank((CharSequence)qlid) && StringUtils.isNotBlank((CharSequence)xmly)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date jfrq = new Date();
                if (StringUtils.equals((CharSequence)xmly, (CharSequence)"bdc")) {
                    BdcCf bdcCf = (BdcCf)this.entityMapper.selectByPrimaryKey(BdcCf.class, (Object)qlid);
                    if (bdcCf != null) {
                        bdcCf.setQszt(Constants.QLLX_QSZT_HR);
                        bdcCf.setIssx("1");
                        StringBuilder cffj = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)bdcCf.getFj())) {
                            cffj.append(bdcCf.getFj()).append("\n");
                        }
                        cffj.append("\u6b64\u67e5\u5c01\u7684\u67e5\u5c01\u671f\u9650\u662f\u4ece").append(sdf.format(bdcCf.getCfksqx())).append("\u81f3").append(sdf.format(bdcCf.getCfjsqx())).append("\u3002");
                        cffj.append("\u6839\u636e\u6cd5\u5f8b\u6cd5\u89c4").append(CalendarUtil.formateToStrChinaYMDDate((Date)jfrq)).append(",\u8be5\u67e5\u5c01\u671f\u9650\u5df2\u6ee1\u81ea\u52a8\u5931\u6548");
                        bdcCf.setFj(cffj.toString());
                        bdcCf.setJfdjsj(jfrq);
                        bdcCf.setJfdbr(null);
                        this.entityMapper.saveOrUpdate((Object)bdcCf, (Object)bdcCf.getQlid());
                    }
                } else {
                    GdCf gdCf = (GdCf)this.entityMapper.selectByPrimaryKey(GdCf.class, (Object)qlid);
                    if (gdCf != null) {
                        gdCf.setIsjf(Constants.QFZT_JF);
                        gdCf.setIssx("1");
                        StringBuilder cffj = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)gdCf.getFj())) {
                            cffj.append(gdCf.getFj()).append("\n");
                        }
                        cffj.append("\u6b64\u67e5\u5c01\u7684\u67e5\u5c01\u671f\u9650\u662f\u4ece").append(sdf.format(gdCf.getCfksrq())).append("\u81f3").append(sdf.format(gdCf.getCfjsrq())).append("\u3002");
                        cffj.append("\u6839\u636e\u6cd5\u5f8b\u6cd5\u89c4").append(CalendarUtil.formateToStrChinaYMDDate((Date)jfrq)).append(",\u8be5\u67e5\u5c01\u671f\u9650\u5df2\u6ee1\u81ea\u52a8\u5931\u6548");
                        gdCf.setFj(cffj.toString());
                        gdCf.setJfdbsj(jfrq);
                        gdCf.setJfrq(jfrq);
                        gdCf.setJfdbr("");
                        this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
                    }
                }
            }
        }
    }

    private void turnLhcfYcfToCfYcf(String lhcflx, String cflx, String bdcdyid, String bdcdyh, String qlid, List<Map<String, Object>> wsxLhCfYcf) {
        if (StringUtils.isNotBlank((CharSequence)lhcflx) && StringUtils.isNotBlank((CharSequence)qlid) && CollectionUtils.isNotEmpty(wsxLhCfYcf)) {
            BdcCf bdcCf = (BdcCf)this.entityMapper.selectByPrimaryKey(BdcCf.class, (Object)qlid);
            GdCf gdCf = (GdCf)this.entityMapper.selectByPrimaryKey(GdCf.class, (Object)qlid);
            if (bdcCf != null && StringUtils.isNotBlank((CharSequence)bdcdyid)) {
                this.turnLhcfToCf(lhcflx, cflx, bdcdyid, bdcdyh);
            } else if (gdCf != null && StringUtils.isNotBlank((CharSequence)bdcdyh)) {
                this.turnGdLhcfToCf(lhcflx, cflx, bdcdyh);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public String turnLhcfToCf(String lhcflx, String cflx, String bdcdyid, String bdcdyh) {
        String result = "success";
        if (StringUtils.isNotBlank((CharSequence)lhcflx) && StringUtils.isNotBlank((CharSequence)cflx)) {
            String lhycfmc = "";
            if (StringUtils.equals((CharSequence)lhcflx, (CharSequence)"3")) {
                lhycfmc = "\u9884";
            }
            if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put(MapKeyEnum.BDCDYID.getMapKey(), bdcdyid);
                map.put(MapKeyEnum.CFLX.getMapKey(), cflx);
                map.put(MapKeyEnum.QSZT.getMapKey(), Constants.QLLX_QSZT_XS);
                List bdcCfListTemp = this.andEqualQueryCf(map, null);
                if (CollectionUtils.isEmpty((Collection)bdcCfListTemp)) {
                    BdcCf bdcLhCf;
                    map = new HashMap(3);
                    map.put(MapKeyEnum.BDCDYID.getMapKey(), bdcdyid);
                    map.put(MapKeyEnum.CFLX.getMapKey(), lhcflx);
                    map.put(MapKeyEnum.QSZT.getMapKey(), Constants.QLLX_QSZT_XS);
                    List bdcLhCfListTemp = this.andEqualQueryCf(map, "to_number(lhsx)");
                    if (CollectionUtils.isNotEmpty((Collection)bdcLhCfListTemp) && (bdcLhCf = (BdcCf)bdcLhCfListTemp.get(0)) != null && StringUtils.isNotBlank((CharSequence)bdcLhCf.getProid()) && StringUtils.isNotBlank((CharSequence)bdcLhCf.getQlid())) {
                        String cfqlid = bdcLhCf.getQlid();
                        BdcXm ybdcXm = this.bdcXmService.getBdcXmByProid(bdcLhCf.getProid());
                        if (ybdcXm != null) {
                            List bdcQlrList;
                            String yYwh = ybdcXm.getBh();
                            String ywh = CommonUtil.getCurrentTimeMillisId();
                            String proid = UUIDGenerator.generate18();
                            ybdcXm.setBh(ywh);
                            ybdcXm.setProid(proid);
                            ybdcXm.setYbh(yYwh);
                            this.entityMapper.saveOrUpdate((Object)ybdcXm, (Object)ybdcXm.getProid());
                            BdcSpxx bdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(bdcLhCf.getProid());
                            if (bdcSpxx != null) {
                                bdcSpxx.setSpxxid(UUIDGenerator.generate18());
                                bdcSpxx.setProid(proid);
                                this.entityMapper.saveOrUpdate((Object)bdcSpxx, (Object)bdcSpxx.getSpxxid());
                            }
                            if (CollectionUtils.isNotEmpty((Collection)(bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(bdcLhCf.getProid())))) {
                                for (int i = 0; i < bdcQlrList.size(); ++i) {
                                    BdcQlr bdcQlr = (BdcQlr)bdcQlrList.get(i);
                                    bdcQlr.setProid(proid);
                                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                                    this.entityMapper.insertSelective((Object)bdcQlr);
                                }
                            }
                            BdcCf newCf = bdcLhCf;
                            newCf.setQlid(UUIDGenerator.generate18());
                            newCf.setProid(proid);
                            newCf.setYwh(ywh);
                            newCf.setCflx(cflx);
                            newCf.setQszt(Constants.QLLX_QSZT_XS);
                            newCf.setLhsx(null);
                            String newCfFj = "\u6839\u636e\u6cd5\u5f8b\u6cd5\u89c4," + CalendarUtil.getCurChinaYMDStrDate() + "," + lhycfmc + "\u67e5\u5c01\u5230\u671f\u5df2\u5931\u6548\uff0c\u8f6e\u5019" + lhycfmc + "\u67e5\u5c01\u8f6c" + lhycfmc + "\u67e5\u5c01";
                            newCf.setFj(newCfFj);
                            this.entityMapper.insertSelective((Object)newCf);
                            BdcCf ybdccf = (BdcCf)this.entityMapper.selectByPrimaryKey(BdcCf.class, (Object)cfqlid);
                            if (ybdccf != null) {
                                ybdccf.setQszt(Constants.QLLX_QSZT_HR);
                                StringBuilder lhcffj = new StringBuilder();
                                if (StringUtils.isNotBlank((CharSequence)ybdccf.getFj())) {
                                    lhcffj.append(ybdccf.getFj()).append("\n");
                                }
                                lhcffj.append("\u6839\u636e\u6cd5\u5f8b\u6cd5\u89c4\uff0c\u8be5\u4e0d\u52a8\u4ea7\u7684\u67e5\u5c01\u5df2\u7ecf\u5931\u6548\uff0c\u8f6e\u5019").append(lhycfmc).append("\u67e5\u5c01\u8f6c").append(lhycfmc).append("\u67e5\u5c01");
                                ybdccf.setFj(lhcffj.toString());
                                this.entityMapper.saveOrUpdate((Object)ybdccf, (Object)ybdccf.getQlid());
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public String turnGdLhcfToCf(String lhcflx, String cflx, String bdcdyh) {
        String result = "success";
        if (StringUtils.isNotBlank((CharSequence)lhcflx) && StringUtils.isNotBlank((CharSequence)cflx) && StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            String lhycfmc = "";
            if (StringUtils.equals((CharSequence)lhcflx, (CharSequence)"3")) {
                lhycfmc = "\u9884";
            }
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("cflx", cflx);
            param.put("bdcdyh", bdcdyh);
            List gdCfList = this.bdcCfMapper.getGdcfByMap(param);
            if (CollectionUtils.isEmpty((Collection)gdCfList)) {
                GdCf gdLhcfYcf;
                param.clear();
                param.put("cflx", lhcflx);
                param.put("bdcdyh", bdcdyh);
                List lhcfYcfList = this.bdcCfMapper.getGdcfByMap(param);
                if (CollectionUtils.isNotEmpty((Collection)lhcfYcfList) && (gdLhcfYcf = (GdCf)lhcfYcfList.get(0)) != null) {
                    String newCfid = UUIDGenerator.generate18();
                    String proid = UUIDGenerator.generate18();
                    String yproid = gdLhcfYcf.getProid();
                    String ycfid = gdLhcfYcf.getCfid();
                    GdXm gdXm = this.gdXmService.getGdXm(yproid);
                    if (gdXm != null && StringUtils.isNotBlank((CharSequence)ycfid)) {
                        List gdBdcQlRelList;
                        gdXm.setProid(proid);
                        this.entityMapper.insertSelective((Object)gdXm);
                        HashMap<String, String> qlrparam = new HashMap<String, String>(2);
                        qlrparam.put("qlid", ycfid);
                        qlrparam.put("proid", yproid);
                        ArrayList gdQlrList = this.gdQlrService.queryGdQlr(qlrparam);
                        if (CollectionUtils.isNotEmpty((Collection)gdQlrList)) {
                            for (GdQlr gdQlr : gdQlrList) {
                                if (gdQlr == null) continue;
                                gdQlr.setProid(proid);
                                gdQlr.setQlid(newCfid);
                                gdQlr.setQlrid(UUIDGenerator.generate18());
                                this.entityMapper.insertSelective((Object)gdQlr);
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(gdBdcQlRelList = this.gdBdcQlRelService.queryGdBdcQlListByQlid(ycfid)))) {
                            for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                                if (gdBdcQlRel == null) continue;
                                gdBdcQlRel.setRelid(UUIDGenerator.generate18());
                                gdBdcQlRel.setQlid(newCfid);
                                this.entityMapper.insertSelective((Object)gdBdcQlRel);
                            }
                        }
                        gdLhcfYcf.setCfid(newCfid);
                        gdLhcfYcf.setProid(proid);
                        gdLhcfYcf.setCflx(cflx);
                        gdLhcfYcf.setIsjf(null);
                        gdLhcfYcf.setCfsx(null);
                        gdLhcfYcf.setGxrq(new Date());
                        this.entityMapper.insertSelective((Object)gdLhcfYcf);
                        GdCf gdCf = (GdCf)this.entityMapper.selectByPrimaryKey(GdCf.class, (Object)ycfid);
                        gdCf.setIsjf(Constants.QFZT_JF);
                        StringBuilder gdLhcfYcfFj = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)gdCf.getFj())) {
                            gdLhcfYcfFj.append(gdCf.getFj()).append("\n");
                        }
                        gdLhcfYcfFj.append("\u6839\u636e\u6cd5\u5f8b\u6cd5\u89c4\uff0c").append(CalendarUtil.formateToStrChinaYMDDate((Date)new Date())).append(lhycfmc).append("\u67e5\u5c01\u5230\u671f\u81ea\u52a8\u5931\u6548");
                        gdLhcfYcfFj.append("\u8f6e\u5019").append(lhycfmc).append("\u67e5\u5c01\u8f6c\u4e3a").append(lhycfmc).append("\u67e5\u5c01");
                        gdCf.setFj(gdLhcfYcfFj.toString());
                        this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
                    }
                }
            }
        }
        return result;
    }

    public int countXsCf(Map map) {
        return this.bdcCfMapper.countXsCf(map);
    }

    public List<BdcCf> getBdcCfByMap(HashMap map) {
        return this.bdcCfMapper.getCfByMap(map);
    }

    public boolean querySfcf(String bdcdyh) {
        List list;
        String zdbdcdyh;
        boolean result = false;
        if (StringUtils.isBlank((CharSequence)bdcdyh)) {
            return result;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("bdcdyh", bdcdyh);
        hashMap.put("qszt", Constants.QLLX_QSZT_XS);
        List bdcCfList = this.bdcCfMapper.getCfByMap(hashMap);
        result = CollectionUtils.isNotEmpty((Collection)bdcCfList);
        if (result) {
            return result;
        }
        if (StringUtils.contains((CharSequence)bdcdyh, (CharSequence)"F") && StringUtils.isNotBlank((CharSequence)(zdbdcdyh = this.bdcdyService.getZdBdcdyh(bdcdyh))) && (result = CollectionUtils.isNotEmpty((Collection)(list = this.qllxParentService.queryLogcfQllxVo((QllxVo)new BdcCf(), bdcdyh, "", "all"))))) {
            return result;
        }
        hashMap.put("isjf", "0");
        List gdCfList = this.gdCfService.getGdCfListByMap(hashMap);
        result = CollectionUtils.isNotEmpty((Collection)gdCfList);
        return result;
    }
}

