/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.AliYunSmsService;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.utils.ArrayUtils;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AliYunSmsServiceImpl
implements AliYunSmsService {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String ACCESSID = AppConfig.getProperty((String)"accessId");
    private static final String ACCESSKEY = AppConfig.getProperty((String)"accessKey");
    private static final String ENDPOINT = AppConfig.getProperty((String)"endpoint");
    private static final String SIGNNAME = AppConfig.getProperty((String)"signName");
    private static final String SMSCODE = AppConfig.getProperty((String)"smsCode");
    private static final String DEFAULTCONNECTTIME = "10000";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void smsService(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
            BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
            String sqlxdm = "";
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getWiid()) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(bdcXm.getWiid())) != null && StringUtils.isNotBlank((CharSequence)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
                sqlxdm = this.bdcZdGlService.getBdcSqlxdmByWdid(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
            }
            String fsdxConifg = AppConfig.getProperty((String)"aliyun.fsdx.allqlr");
            boolean sendEveryBdcXmQlr = false;
            if (StringUtils.isNotBlank((CharSequence)fsdxConifg)) {
                Object[] fsdxArray = fsdxConifg.split(",");
                boolean bl = sendEveryBdcXmQlr = ArrayUtils.isNotEmpty((Object[])fsdxArray) && CommonUtil.indexOfStrs((String[])fsdxArray, (String)sqlxdm);
            }
            if (sendEveryBdcXmQlr) {
                this.sendSmsToEveryXmQlr(bdcXm);
            } else {
                this.sendSmsToSingleXmQlr(bdcXm);
            }
        }
    }

    public static SendSmsResponse sendSms(Map<String, String> paramMap, String phoneNumber) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)ENDPOINT, (String)ACCESSID, (String)ACCESSKEY);
        DefaultProfile.addEndpoint((String)ENDPOINT, (String)ENDPOINT, (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phoneNumber);
        request.setSignName(SIGNNAME);
        request.setTemplateCode(SMSCODE);
        if (MapUtils.isNotEmpty(paramMap)) {
            request.setTemplateParam(JSONObject.toJSONString(paramMap));
        }
        return (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
    }

    public static QuerySendDetailsResponse querySendDetails(String bizId, String phoneNumber) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)ENDPOINT, (String)ACCESSID, (String)ACCESSKEY);
        DefaultProfile.addEndpoint((String)ENDPOINT, (String)ENDPOINT, (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        QuerySendDetailsRequest request = new QuerySendDetailsRequest();
        request.setPhoneNumber(phoneNumber);
        request.setBizId(bizId);
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        request.setSendDate(ft.format(new Date()));
        request.setPageSize(Long.valueOf(10L));
        request.setCurrentPage(Long.valueOf(1L));
        return (QuerySendDetailsResponse)acsClient.getAcsResponse((AcsRequest)request);
    }

    public void sendSmsToQlr(List<BdcQlr> bdcQlrList) {
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            HashMap paramMap = Maps.newHashMap();
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (bdcQlr == null || !StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrmc()) || !StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrlxdh())) continue;
                paramMap.clear();
                paramMap.put("name", bdcQlr.getQlrmc());
                String phoneNumber = bdcQlr.getQlrlxdh();
                try {
                    SendSmsResponse response = AliYunSmsServiceImpl.sendSms((Map)paramMap, (String)phoneNumber);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info(response.toString());
                }
                catch (Exception e) {
                    this.logger.info(e.getMessage());
                }
            }
        }
    }

    public void sendSmsToEveryXmQlr(BdcXm bdcXm) {
        List bdcXms;
        if (bdcXm != null && CollectionUtils.isNotEmpty((Collection)(bdcXms = this.bdcXmService.getBdcXmListByWiid(bdcXm.getWiid())))) {
            for (BdcXm xm : bdcXms) {
                List bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(xm.getProid());
                this.sendSmsToQlr(bdcQlrList);
            }
        }
    }

    public void sendSmsToSingleXmQlr(BdcXm bdcXm) {
        if (bdcXm != null) {
            List bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(bdcXm.getProid());
            this.sendSmsToQlr(bdcQlrList);
        }
    }
}

