$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

var grid_selector = "#jqGrid";
$(document).ready(function () {
    initCxYzhtable(grid_selector);
});

//解决jqgrid水印不显示
function setJqgridSy(){
    $("#gview_jqGrid").css("background","none");
    //$(".jqgfirstrow").hide();
    $(".table thead th ,#jqGridPager_left").css("background","none");
    $(".ui-jqgrid .ui-jqgrid-btable tbody tr:nth-child(odd)> td").css("background","none");
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function searchYzhXx() {
    var yzh=$("#yzh").val();
    var url;
    if ("wuhu" == sysVersion){
        url = bankUrl + "/queryApplication/getGxYhYzhXxs";
    }else {
        url = bankUrl + "/queryApplication/getGxYhYzhXx";
    }
    tableReload("jqGrid", url, {yzh: yzh});
}

function zuoFei(id,bh,yzh) {
    bootbox.confirm("确认作废此印制号吗？",function(result) {
        if (result) {
            $.ajax({
                type: "POST",
                url: bankUrl + '/queryApplication/jcbdZmPrintYzhByDjInterface?yzh='+yzh+"&bh="+bh,
                success: function (data) {
                    if (data=="success") {
                        $.ajax({
                            type: "POST",
                            url: bankUrl + '/queryApplication/updateGxYhYzhXxByIdOrYzh?yzh=' + yzh + "&id=" + id,
                            dataType: "json",
                            traditional: true,
                            success: function (data) {
                                if (data > 0) {
                                    $("#jqGrid").trigger("reloadGrid");//重新加载JqGrid
                                } else {
                                    alert("操作失败，请重新操作！")
                                }
                            }
                        })
                    }else{
                        alert(data);
                    }
                },
                fail: function () {
                    alert("操作失败，请联系管理员！")
                },
                error: function (data) {
                    alert("操作失败，请联系管理员！")
                }
            })
        }
    })
}

function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
            'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}

function sfzfColour(id, sfzf, table) {
    var cellVal = "";
    if (sfzf == '正在使用') {
        cellVal = '<span class="label label-success">已使用</span>';
    } else if (sfzf == '已作废') {
        cellVal = '<span class="label label-important">已作废</span>';
    }else if (sfzf == '未使用') {
        cellVal = '<span class="label label-warning">未使用</span>';
    }
    table.setCell(id, "SFZF", cellVal);
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}

function initCxYzhtable(grid_selector) {
    var url;
    if ("wuhu" == sysVersion){
        url = bankUrl + "/queryApplication/getGxYhYzhXxs";
    }else {
        url = bankUrl + "/queryApplication/getGxYhYzhXx";
    }
    $(grid_selector).jqGrid({
        datatype: "json",
        url: url,
        autowidth: true,
        height: 'auto',
        jsonReader: {id: 'ID'},
        colNames: ['ID', '印制号','证明号', '银行申请编号','登记申请编号', '是否已作废','操作'],
        colModel: [
            {name: 'ID', index: 'ID', width: '0%', align: 'center', sortable: false, hidden: true},
            {name: 'YZH', index: 'YZH', width: '15%', align: 'center', sortable: false},
            {name: 'ZMH', index: 'ZMH', width: '20%', align: 'center', sortable: false},
            {name: 'YHSQBH', index: 'YHSQBH', width: '15%', align: 'center', sortable: false},
            {name: 'DJSQBH', index: 'DJSQBH', width: '20%', align: 'center', sortable: false},
            {name: 'SFZF', index: 'SFZF', width: '15%', align: 'center', sortable: false},
            {
                name: 'ZF', index: 'ZF', width: '15%', align: 'center', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    var ck = '<div style="margin-left: 45%">' +
                        '<div title="作废" style="float:left;cursor:pointer;" class="icon-edit icon-large" id="" onclick="zuoFei(\'' + rowObject.ID + '\',\'' + rowObject.YHSQBH + '\',\'' + rowObject.YZH + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class="fa  fa-crosshairs fa-lg green"></span>作废</div>';

                    ck += '</div>';
                    return ck;
                }
            }

        ],
        rowNum: 1,
        rowList: [1, 30, 50],
        //altRows: true ,//斑马线式样
        sortname: 'OrderDate',
        viewrecords: true,
        multiboxonly: true,
        multiselect: true,
        pager: "#jqGridPager",
        loadComplete: function () {
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
            //解决jqgrid遮挡水印
            if(isShowSy=='true'){
                setJqgridSy();
            }
            var jqData = $(grid_selector).jqGrid("getRowData");
            $.each(jqData, function (index, data) {
                sfzfColour(data.ID, data.SFZF, $(grid_selector));
            })
        }
    });
}


