$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

$(document).ready(function () {
    var grid_selector = "#jqGrid";
    var pager_selector = "#jqGridPager";
    initDyaqtable(grid_selector, pager_selector);
});

function initDyaqtable(grid_selector, pager_selector) {
    $(grid_selector).jqGrid({
        type: "POST",
        datatype: "json",
        height: 'auto',
        jsonReader: {id: 'BDCDYH'},
        colNames: ['不动产单元号', '业务号', '预告登记证明号', '权利人', '坐落', '状态', '操作', '建筑面积'],
        colModel: [
            {name: 'BDCDYH', index: 'BDCDYH', width: '0%', align: 'center', sortable: false, hidden: true},
            {name: 'YWH', index: 'YWH', width: '0%', align: 'center', sortable: false, hidden: true},
            {name: 'BDCQZH', index: 'BDCQZH', width: '30%', align: 'center', sortable: false},
            {name: 'QLRMC', index: 'QLRMC', width: '20%', align: 'center', sortable: false},
            {name: 'ZL', index: 'ZL', width: '25%', align: 'center', sortable: false},
            {name: 'STATUS', index: 'STATUS', width: '15%', align: 'center', sortable: false},
            {name: 'CZ', index: 'CZ', width: '10%', sortable: false},
            {name: 'JZMJ', index: 'JZMJ', width: '0%', align: 'center', sortable: false, hidden: true},
        ],
        viewrecords: true,
        rowNum: 10,
        rowList: [10, 20, 30],
        pager: pager_selector,
        pagerpos: "left",
        altRows: false,
        multiboxonly: false,
        multiselect: false,
        loadComplete: function () {
            //解决jqgrid遮挡水印
            if (isShowSy == 'true') {
                setJqgridSy();
            }
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
            var jqData = $(grid_selector).jqGrid("getRowData");
            $.each(jqData, function (index, data) {
                getStatus(data.BDCDYH, $(grid_selector), data.YWH, data.BDCQZH, data.ZL, data.JZMJ);
            });

            //如果7条设置宽度为auto,如果少于7条就设置固定高度
            if ($(grid_selector).jqGrid("getRowData").length == 7) {
                $(grid_selector).jqGrid("setGridHeight", "auto");
            } else {
                $(grid_selector).jqGrid("setGridHeight", "275px");
            }
        },
        editurl: "", //nothing is saved
        caption: "",
        autowidth: true
    });
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}

function getStatus(bdcdyh, table, ywh, bdcqzh, zl, jzmj) {
    //产权证验证
    var data1 = {'bdcdyh': bdcdyh};
    $.ajax({
        type: "POST",
        data: {json: JSON.stringify(data1)},
        url: bankUrl + "/action/bank/examineBdcqzh",
        dataType: "json",
        success: function (data) {
            if (data.result == 'success') {
                var cfList = '';
                var selfDyaList = '';
                var othersDyaList = '';
                var cqList = '';
                var ygList = '';
                var yyList = '';
                var sdList = '';
                var state = "false";

                if (data.selfDyaList != '' && data.selfDyaList != null && data.selfDyaList != 'undefined') {
                    selfDyaList = data.selfDyaList;
                }
                if (data.othersDyaList != '' && data.othersDyaList != null && data.othersDyaList != 'undefined') {
                    othersDyaList = data.othersDyaList;
                }
                if (data.ygList != '' && data.ygList != null && data.ygList != 'undefined') {
                    ygList = data.ygList;
                    state = "true";
                }
                if (data.cfList != '' && data.cfList != null && data.cfList != 'undefined') {
                    cfList = data.cfList;
                    state = "false";
                }
                if (data.yyList != '' && data.yyList != null && data.yyList != 'undefined') {
                    yyList = data.yyList;
                }
                if (data.sdList != '' && data.sdList != null && data.sdList != 'underfined') {
                    sdList = data.sdList;
                }
                var cellValue = '';
                var sfzx = "0";
                var sfdy = "0";
                var sfcf = "0";
                var sfyg = "0";
                var sfyy = "0";
                var sfsd = "0";

                if ((selfDyaList == "" || selfDyaList.length < 1)
                    && (othersDyaList == "" || othersDyaList.length < 1) && (cfList == "" || cfList.length < 1)
                    && (ygList == "" || ygList.length < 1)) {
                    cellValue = '<span class="label label-success">正常</span>';
                } else {
                    if (selfDyaList != "" && selfDyaList.length > 0) {
                        if (data.version == "danyang") {
                            cellValue += '<span class="label label-info">抵押</span>';
                        } else {
                            cellValue += '<span class="label label-info">本行抵押</span>';
                        }
                        sfdy = "1";
                    }
                    if (othersDyaList != "" && othersDyaList.length > 0) {
                        if (data.version == "danyang") {
                            cellValue += '<span class="label label-info">抵押</span>';
                        } else {
                            cellValue += '<span class="label label-info">他行抵押</span>';
                        }
                        sfdy = "1";
                    }
                    if (cfList != "" && cfList.length > 0) {
                        cellValue += '<span class="label label-warning">查封</span>';
                        sfcf = "1";
                    }
                    if (ygList != "" && ygList.length > 0) {
                        cellValue += '<span class="label label-warning">存在预告</span>';
                        sfyg = "1";
                    }
                    if (yyList != "" && yyList.length > 0) {
                        cellValue += '<span class="label label-warning">存在异议</span>';
                        sfyy = "1";
                    }
                    if (sdList != "" && sdList.length > 0) {
                        cellValue += '<span class="label label-warning">锁定</span>';
                        sfsd = "1";
                    }
                }
                table.setCell(bdcdyh, "STATUS", cellValue);
                if (state.indexOf("true") > -1) {
                    fwhsSq(bdcdyh, table, ywh, bdcqzh, zl, jzmj);
                }
            } else {
                document.getElementById("confirm_info").innerHTML = "验证失败";
                document.getElementById("title").innerHTML = "警告";
            }
        },
        fail: function () {
        }
    })
}

function fwhsSq(bdcdyh, table, ywh, bdcqzh, zl, jzmj) {
    var str = "";
    str = str = '<div style="margin-left:8px;"> ' +
        '<div title="申请" style="cursor:pointer;float: left;margin-left: 8px;"  id="" onclick="fwhsXxlr(\'' + bdcdyh + '\',\'' + bdcqzh + '\',\'' + zl + '\',\'' + jzmj + '\')"><span class="icon-cog  "></span> 申请 </div>';
    table.setCell(bdcdyh, "CZ", str);

}

function searchLpb() {
    var bdcdyh = $("#bdcdyh").val();
    var bdcdjzmh = $("#bdcdjzmh").val();
    var zl = $("#zl").val();
    var qlr = $("#qlr").val();
    var json = {json: JSON.stringify({'bdcdyh': bdcdyh, 'bdcqzh': bdcdjzmh, 'zl': zl, 'qlrmc': qlr})};
    var url = bankUrl + '/query/bank/queryYdyYg';
    tableReload("jqGrid", url, json);
}


function fwhsXxlr(bdcdyh, bdcqzh, zl, jzmj) {
    var url = bankUrl + "/query/bank/getYdysqQlr?bdcdyh=" + bdcdyh + "&bdcqzh=" + bdcqzh + "&xmly=" + 'bdcdy' + "&zl=" + zl.replace('#', '%23') + "&jzmj=" + jzmj;
    var flag = "true";
    //先通过登记的验证，验证不通过flag=false
    if (bank_submit_check == "true") {
        $.ajax({
            type: "POST",
            async: false,
            data: {
                json: JSON.stringify({
                    "bdcqzh": bdcqzh,
                    "fczh": '',
                    "tdzh": '',
                    "bdcdyh": bdcdyh
                })
            },
            url: bankUrl + "/action/bank/submitCheck",
            dataType: "json",
            success: function (data) {
                if (data != null && data.success == "success") {
                    //如果接口调用成功且存在checkMsg，那么给提示
                    if (typeof (data.checkMsg) != "undefined" && data.checkModel == "alert") {
                        alert(data.checkMsg);
                        flag = "false";

                    }
                    if (typeof (data.checkMsg) != "undefined" && data.checkModel == "confirm") {
                        if (confirm(data.checkMsg) == false) {
                            flag = "false";
                        }
                    }
                }
            },
            fail: function () {
            }
        });
    }
    if (flag == "true") {
        openWin(url, "预抵押申请");
    }
}

function openWin(url, name) {
    var w_width = screen.availWidth - 100;
    var w_height = screen.availHeight - 100;
    window.open(url, name, "left=30,top=20,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
}