$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

var grid_selector = "#jqGrid";
var pager_selector = "#jqGridPager";
$(function () {
    $(window).resize(function () {
        $(grid_selector).jqGrid('setGridWidth', $("#jqGridOut").width());
    });
    //默认初始化表格
    ljzInitTable(grid_selector);

    //搜索事件
    searchLjz();
});
//查询逻辑幢
function ljzInitTable(){
    jQuery(grid_selector).jqGrid({
        datatype:"json",
        height:'auto',
        jsonReader:{id:'LSZD'},
        colNames:[ '小区名称','坐落','宗地号','操作'],
        colModel:[
            {name:'FWMC', index:'FWMC', width:'10%', align: 'center', sortable:false},
            {name:'ZLDZ', index:'ZLDZ', width:'10%', align: 'center', sortable:false},
            {name:'LSZD', index:'LSZD', width:'10%', align: 'center', sortable:false},
            {name:'CZ', index:'', width:'10%', sortable:false,formatter:function (cellvalue, options, rowObject) {
                var ck = '<div style="margin-left:8px;">' +
                    '<div title="查看楼盘表" style="float:left;cursor:pointer;margin-left: 8px"  id="" onclick="LookLpb(\'' + rowObject.FW_DCB_INDEX + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class="icon-search  icon-large blue"></span>查看</div>';
                return ck;
            }}
        ],
        viewrecords:true,
        rowNum:7,
        rowList:[10, 20, 30],
        pager:pager_selector,
        pagerpos:"left",
        viewrecords: true,
        multiselect: true,
        loadComplete:function () {
            //解决jqgrid遮挡水印
            if(isShowSy=='true'){
                setJqgridSy();
            }
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
            //如果7条设置宽度为auto,如果少于7条就设置固定高度
            if($(grid_selector).jqGrid("getRowData").length==7){
                $(grid_selector).jqGrid("setGridHeight","auto");
            }else{
                $(grid_selector).jqGrid("setGridHeight","275px");
            }
        },
        editurl:"", //nothing is saved
        caption:"",
        autowidth:true
    });
    //绑定回车事件
    $('#djsj_search').keydown(function (event) {
        if (event.keyCode == 13) { //搜索绑定回车快捷键
            searchLjz();
        }
    });
    //解决jqgrid遮挡水印
    if(isShowSy=='true'){
        setJqgridSy();
    }
}
//搜索事件
function searchLjz() {
    var djsj_search = $("#djsj_search").val();
    var url = bankUrl + '/queryApplication/getLpbPagesJson';
    tableReload("jqGrid", url, {djsj_search: djsj_search});
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function LookLpb(id){
    //var fwmc =$("#lpb-grid-table").jqGrid('getRowData',id).FWMC;
    //var zl = $("#lpb-grid-table").jqGrid('getRowData',id).ZLDZ;
    //var lszd = $("#lpb-grid-table").jqGrid('getRowData'.id).LSZD;
    var url=bankUrl+'/queryApplication/lpb?id=' + id+"&xmly="+"bdcdy";
    openWin(url,"选择房屋");
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container:'body'});
    $(table).find('.ui-pg-div').tooltip({container:'body'});
}
function updatePagerIcons(table) {
    var replacement =
    {
        'ui-icon-seek-first':'ace-icon fa fa-angle-double-left bigger-140',
        'ui-icon-seek-prev':'ace-icon fa fa-angle-left bigger-140',
        'ui-icon-seek-next':'ace-icon fa fa-angle-right bigger-140',
        'ui-icon-seek-end':'ace-icon fa fa-angle-double-right bigger-140'
    };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}
function openWin(url, name) {
    var w_width = screen.availWidth - 100;
    var w_height = screen.availHeight - 100;
    window.open(url, name, "left=30,top=20,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
}