$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

$(document).ready(function () {
    $("#qlrzjh").hide();
    $("#qlrmc").hide();

    initJqGrid("#jqGrid");
    //读卡按钮
    $("#readCard").click(function () {
        try {
            var objTest = new ActiveXObject("GtMap.GxFrameActiveX.IDCard.IDCard");
            if (objTest.ReadCard()) {
                $("#qlrmc").val(objTest.Name);
                $("#qlrzjh").val(objTest.ID)
            }
        } catch (objError) {
            alert("Fail to create object. error:" + objError.description);
        }
    })

    //家庭查询
    $("#familyQuery").click(function () {
        var qlrmc = $("#qlrmc").val();
        var qlrzjh = $("#qlrzjh").val();
        var width = screen.availWidth * 0.72;
        var height = screen.availHeight * 0.42;
        showBstrapModelWithoutUrl("jtcxModal", "indexModalDiv", width, height, false);
        if (qlrmc != ""){
            $("#jtcx_qlrmc").val(qlrmc);
            $("#jtcx_qlrzjh").val(qlrzjh);
            jtcxQlrAddRow();
        }
    })

    $("#search").click(function () {
        var qlrmc = $("#qlrmc").val();
        var qlrzjh = $("#qlrzjh").val();
        // var qlrmc = "wuwei";
        // var qlrzjh = "3333";
        var url = bankUrl + "/queryApplication/queryZfslByQlrzjh";
        if (qlrzjh != ""){
            tableReload("jqGrid",url,{qlrmc:qlrmc,qlrzjh:qlrzjh});
        }else {
            bootbox.alert("请获取证件号！")
        }
    })

    $("#jtcx_search").click(function () {
        var qlrmc = "";
        var qlrzjh = "";
        var qlrRows = $("#jtcx").children("tr").length;
        for (var i = 0;i < qlrRows;i++){
            var tdArr =$("#jtcx").find("tr").children();
            qlrmc = qlrmc + tdArr.eq(0 + i * 4).find("input").val() + "$";
            qlrzjh = qlrzjh + tdArr.eq(1 + i * 4).find("input").val() + "$";
        }
        if (qlrmc.indexOf("$") > -1){
            qlrmc = qlrmc.substring(0,qlrmc.length-1);
            qlrzjh = qlrzjh.substring(0,qlrzjh.length-1);
        }
        var url = bankUrl + "/queryApplication/queryZfslByQlrzjh";
        if (qlrzjh != ""){
            tableReload("jqGrid",url,{qlrmc:qlrmc,qlrzjh:qlrzjh});
            $("#close").click();
        }else {
            bootbox.alert("请获取证件号！")
        }
    })
})

function initJqGrid(grid_selector) {
    $(grid_selector).jqGrid({
        caption: "",
        datatype: "json",
        // url: bankUrl + "/query/bank/queryZmh",
        autowidth: true,
        height: 'auto',
        jsonReader:{id:'qlrzjh'},
        colNames: ['权利人', '权利人证件号', '房屋数量', '操作'],
        colModel: [
            {name:'qlrmc',index:'qlrmc',width:'10%',align:'center',sortable:false},
            {name:'qlrzjh',index:'qlrzjh',width:'15%',align:'center',sortable:false},
            {name:'fwsl',index:'fwsl',width:'15%',align:'center',sortable:false},
            {
                name: 'ck', index: 'ck', width: '15%', align: 'center', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    var ck = '<div style="margin-left:8px;">' +
                        '<div title="打印" style="float:left;cursor:pointer;margin-left: 8px" class="icon-search icon-large" id="" onclick="printPdf(\'' + rowObject.qlrmc + '\',\'' + rowObject.qlrzjh + '\',\'' + rowObject.fwsl + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class="fa  fa-crosshairs fa-lg green"></span>打印</div>';
                    ck += '</div>';
                    return ck;
                }
            }
        ],
        //shrinkToFit:false,
        //loadonce: true,
        rowList: [20, 30, 50],
        sortname: 'OrderDate',
        viewrecords: true,
        multiboxonly: true,
        multiselect: true,
        pager: "#jqGridPager",
        beforeRequest:function () {
        },
        loadComplete: function () {
            //解决jqgrid遮挡水印
            if (isShowSy == 'true') {
                setJqgridSy();
            }
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
        },
        onSelectRow: function (rowid, status) {
        }
    });
}

function jtcxQlrAddRow() {
    $("#jtcx").append($("#jtcx_qlrxx").clone());
    var currentRows = $("#jtcx").children("tr").length;
    if (currentRows > 1) {
        var itr = document.getElementById("jtcx").lastChild;
        $(itr).find("#jtcx_qlrmc").val("");
        $(itr).find("#jtcx_qlrzjh").val("");
    }
}

function jtcxQlrClearRow(obj) {
    var currentRows = $("#jtcx").children("tr").length;
    if (currentRows > 1) {
        var c = obj.parentNode.parentNode.parentNode;
        c.parentNode.removeChild(c);
    }
}

function readCard(obj) {
    try {
        var objTest = new ActiveXObject("GtMap.GxFrameActiveX.IDCard.IDCard");
        if (objTest.ReadCard()) {
            var c = $(obj.parentNode.parentNode).find("td");
            c.eq(0).find("input").val(objTest.Name);
            c.eq(1).find("input").val(objTest.ID);
        }
    } catch (objError) {
        alert("Fail to create object. error:" + objError.description);
    }
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function printPdf(qlrmc,qlrzjh,fwsl) {
    if (fwsl == "无房"){
        fwsl = "0";
    }
    window.open(bankUrl + "/action/bank/printZfsl?qlrmc=" + qlrmc + "&qlrzjh=" + qlrzjh +"&fwsl=" + fwsl);
}

//解决jqgrid水印不显示
function setJqgridSy(){
    $("#gview_jqGrid").css("background","none");
    //$(".jqgfirstrow").hide();
    $(".table thead th ,#jqGridPager_left").css("background","none");
    $(".ui-jqgrid .ui-jqgrid-btable tbody tr:nth-child(odd)> td").css("background","none");
}

function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
            'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container:'body'});
    $(table).find('.ui-pg-div').tooltip({container:'body'});
}