$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

$(document).ready(function () {
    var grid_selector = "#jqGrid";
    initJqGrid(grid_selector);

    $("#search").click(function () {
        var qlrmc = $("#ygqlr").val();
        var qlrzjh = $("#ygqlrzjh").val();
        var zl = $("#zl").val();
        var bdcdyh = $("#bdcdyh").val();
        if (qlrmc == "" || qlrzjh == "") {
            bootbox.alert("请输入权利人相关信息！")
        }else {
            var data = {
                qlrmc: qlrmc,
                qlrzjh: qlrzjh,
                zl: zl,
                bdcdyh: bdcdyh
            }
            var json = JSON.stringify(data);
            var Url = bankUrl + "/queryApplication/queryScDjByPage";
            tableReload("jqGrid", Url, {json: json});
        }
    })
})

function initJqGrid(grid_selector) {
    $(grid_selector).jqGrid({
        caption: "",
        datatype: "json",
        // url: bankUrl + "/query/bank/queryZmh",
        autowidth: true,
        height: 'auto',
        rownumbers: true,
        jsonReader: {id:'PROID'},
        colNames: ['proid','银行受理编号', '预告转移权利人', '抵押权利人', '坐落', '不动产单元号', '是否办理首次登记', '首次登记证明号','首次登记权利人','首次登记流程登记时间'],
        colModel: [
            {name:'PROID',index:'PROID',width:'10%',align:'center',sortable:false, hidden:true},
            {name:'BH',index:'BH',width:'10%',align:'center',sortable:false},
            {name:'YGMFR',index:'YGMFR',width:'15%',align:'center',sortable:false},
            {name:'YGDYQR',index:'YGDYQR',width:'15%',align:'center',sortable:false},
            {name:'ZL',index:'ZL',width:'15%',align:'center',sortable:false},
            {name:'BDCDYH',index:'BDCDYH',width:'15%',align:'center',sortable:false},
            {name:'SFSCDJ',index:'SFSCDJ',width:'15%',align:'center',sortable:false},
            {name:'BDCQZH',index:'BDCQZH',width:'15%',align:'center',sortable:false},
            {name:'QLRMC',index:'QLRMC',width:'15%',align:'center',sortable:false},
            {name:'DJSJ',index:'SJSJ',width:'15%',align:'center',sortable:false}
        ],
        //shrinkToFit:false,
        //loadonce: true,
        rowList: [20, 30, 50],
        sortname: 'OrderDate',
        viewrecords: true,
        multiboxonly: true,
        multiselect: true,
        pager: "#jqGridPager",
        beforeRequest:function () {
            },
        loadComplete: function () {
            //解决jqgrid遮挡水印
            if (isShowSy == 'true') {
                setJqgridSy();
            }
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
        },
        onSelectRow: function (rowid, status) {
        }
    });
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}
function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
            'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}

//解决jqgrid水印不显示
function setJqgridSy(){
    $("#gview_jqGrid").css("background","none");
    //$(".jqgfirstrow").hide();
    $(".table thead th ,#jqGridPager_left").css("background","none");
    $(".ui-jqgrid .ui-jqgrid-btable tbody tr:nth-child(odd)> td").css("background","none");
}