$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';
$(function () {
    bdcdjzmTableInit();
});


function bdcdjzmTableInit() {
    var grid_selector = "#dya-grid-table";
    var pager_selector = "#dya-grid-pager";
    $(window).resize(function () {
        $("#jqGrid").jqGrid('setGridWidth', $("#jqGridOut").width());
    });
    $(grid_selector).jqGrid({
        datatype: "json",
        url: bankUrl + "/query/bank/queryBdcdjzs?bh=" + bh + "&dyr=" + encodeURI(encodeURI(dyr)) + "&dyqr=" + encodeURI(encodeURI(dyqr)),
        autowidth: true,
        height: 'auto',
        jsonReader: {id: 'ID'},
        colNames: ['ID', '不动产证明号', '证书编号', '抵押权人', '抵押人', '抵押金额', '抵押期限', '坐落'],
        colModel: [
            {name: 'ID', index: 'ID', width: '0%', align: 'center', sortable: false, hidden: true},
            {name: 'BDCZMH', index: 'BDCZMH', width: '35%', sortable: false},
            {name: 'ZSBH', index: 'ZSBH', width: '20%', sortable: false},
            {name: 'DYAQR', index: 'DYAQR', width: '25%', sortable: false},
            {name: 'DYR', index: 'DYR', width: '10%', sortable: false},
            {name: 'DYJE', index: 'DYJE', width: '10%', sortable: false},
            {name: 'DYQX', index: 'DYQX', width: '20%', sortable: false},
            {name: 'ZL', index: 'ZL', width: '20%', sortable: false}
        ],
        loadonce: true,
        rowList: [20, 30, 50],
        sortname: 'OrderDate',
        viewrecords: true,
        multiselect: false,
        loadComplete: function () {
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
        }
    });
}


/*调用jQueryUI实现拖动*/
$(function () {
    $('#draggable').draggable();

});
/*影藏显示*/
$(document).ready(function () {
    $("#hide").click(function () {
        $("#draggable").hide();
    });
    $("#show").click(function () {
        $("#draggable").show();
    });

});


function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}

function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
            'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}