$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

var grid_selector = "#jqGrid";
var pager_selector = "#jqGridPager";

$(function () {
    $(window).resize(function () {
        $(grid_selector).jqGrid('setGridWidth', $("#jqGridOut").width());
    });
    //默认初始化表格
    lpbInitTable(grid_selector);
    //搜索
    searchLpb();
});

function lpbInitTable() {
    jQuery(grid_selector).jqGrid({
        url: bankUrl + "/queryApplication/getLpbXxPagesJson?id=" + id + "&xmly=" + xmly,
        datatype: "json",
        height: 'auto',
        jsonReader: {id: 'FW_HS_INDEX'},
        colNames: ['不动产单元号', '坐落', '楼层', '房间号', '建筑面积', '状态', '操作', 'fw_hs_index'],
        colModel: [
            {name: 'BDCDYH', index: 'BDCDYH', width: '10%', align: 'center', sortable: false},
            {name: 'ZL', index: 'ZL', width: '10%', align: 'center', sortable: false},
            {name: 'WLCS', index: 'WLCS', width: '10%', align: 'center', sortable: false},
            {name: 'FJH', index: 'FJH', width: '10%', align: 'center', sortable: false},
            {name: 'JZMJ', index: 'JZMJ', width: '10%', align: 'center', sortable: false},
            {name: 'STATUS', index: 'STATUS', width: '10%', align: 'center', sortable: false},
            {name: 'CZ', index: 'CZ', width: '10%', sortable: false},
            {name: 'FW_HS_INDEX', index: 'FW_HS_INDEX', width: '10%', sortable: false, hidden: true}
        ],
        viewrecords: true,
        rowNum: 7,
        rowList: [10, 20, 30],
        pager: pager_selector,
        pagerpos: "left",
        altRows: false,
        multiboxonly: false,
        multiselect: false,
        loadComplete: function () {
            //解决jqgrid遮挡水印
            if (isShowSy == 'true') {
                setJqgridSy();
            }
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
            var jqData = $(grid_selector).jqGrid("getRowData");
            $.each(jqData, function (index, data) {
                getStatus(data.BDCDYH, data.FW_HS_INDEX, $(grid_selector), data.ZL, data.JZMJ);
            });

            //如果7条设置宽度为auto,如果少于7条就设置固定高度
            if ($(grid_selector).jqGrid("getRowData").length == 7) {
                $(grid_selector).jqGrid("setGridHeight", "auto");
            } else {
                $(grid_selector).jqGrid("setGridHeight", "275px");
            }
        },
        editurl: "", //nothing is saved
        caption: "",
        autowidth: true
    });
    //解决jqgrid遮挡水印
    if (isShowSy == 'true') {
        setJqgridSy();
    }
    //绑定回车事件
    $('#lpb_search').keydown(function (event) {
        if (event.keyCode == 13) { //搜索绑定回车快捷键
            searchLpb();
        }
    });
}

//搜索事件
function searchLpb() {
    var lpb_search = $("#lpb_search").val();
    var url = bankUrl + '/queryApplication/getLpbXxPagesJson';
    tableReload("jqGrid", url, {lpb_search: lpb_search, id: id, xmly: xmly});
}

function fwhsSq(bdcdyh, fw_hs_index, table, zl, jzmj) {
    $.ajax({
        type: "POST",
        data: {id: id},
        url: bankUrl + '/queryApplication/getLpbPagesJson',
        dataType: "json",
        async: false,
        success: function (data) {
            var str = "";
            if (bdcdyh == "null" || bdcdyh == "") {
                table.setCell(fw_hs_index, "CZ", str);
            } else {
                str = str = '<div style="margin-left:8px;"> ' +
                    '<div title="申请" style="cursor:pointer;float: left;margin-left: 8px;"  id="" onclick="fwhsXxlr(\'' + bdcdyh + '\',\'' + zl + '\',\'' + jzmj + '\')"><span class="icon-cog  "></span> 申请 </div>';
                table.setCell(fw_hs_index, "CZ", str);
            }
        }
    })
}

function fwhsXxlr(bdcdyh, zl, jzmj) {
    var param = {
        hasYgxx:"true",
        bdcdyh:bdcdyh,
        xmly:xmly,
        zl:zl,
        jzmj:jzmj
    };
    var json = new Array();
    json.push({name:"hasYgxx", value: "true"});
    json.push({name:"bdcdyh", value: bdcdyh});
    json.push({name:"xmly", value: xmly});
    json.push({name:"zl", value: zl});
    json.push({name:"jzmj", value: jzmj});
    var url = bankUrl + "/queryApplication/getBdcqzAndYwrForYgYdy";
    var flag = "true";
    //先通过登记的验证，验证不通过flag=false
    if (bank_submit_check == "true") {
        $.ajax({
            type: "POST",
            async: false,
            data: {
                json: JSON.stringify({
                    "bdcqzh": '',
                    "fczh": '',
                    "tdzh": '',
                    "bdcdyh": bdcdyh
                })
            },
            url: bankUrl + "/action/bank/submitCheck",
            dataType: "json",
            success: function (data) {
                if (data != null && data.success == "success") {
                    //如果接口调用成功且存在checkMsg，那么给提示
                    if (typeof (data.checkMsg) != "undefined" && data.checkModel == "alert") {
                        alert(data.checkMsg);
                        flag = "false";

                    }
                    if (typeof (data.checkMsg) != "undefined" && data.checkModel == "confirm") {
                        if (confirm(data.checkMsg) == false) {
                            flag = "false";
                        }
                    }
                }
            },
            fail: function () {
            }
        });
    }
    if (flag == "true") {
        Post(url,json);
    }
}

//模拟post表单提交
function Post(URL, PARAMTERS) {
    //创建form表单
    var temp_form = document.createElement("form");
    temp_form.action = URL;
    //如需打开新窗口，form的target属性要设置为'_blank'
    temp_form.target = "_blank";
    temp_form.method = "post";
    temp_form.style.display = "none";
    //添加参数
    for (var item in PARAMTERS) {
        var opt = document.createElement("textarea");
        opt.name = PARAMTERS[item].name;
        opt.value = PARAMTERS[item].value;
        temp_form.appendChild(opt);
    }
    document.body.appendChild(temp_form);
    //提交数据
    temp_form.submit();
}

function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}

function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function openWin(url, name) {
    var w_width = screen.availWidth - 100;
    var w_height = screen.availHeight - 100;
    window.open(url, name, "left=30,top=20,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
}

function getStatus(bdcdyh, fw_hs_index, table, zl, jzmj) {
    //产权证验证
    var data1 = {'bdcdyh': bdcdyh};
    $.ajax({
        type: "POST",
        data: {json: JSON.stringify(data1)},
        url: bankUrl + "/action/bank/examineBdcqzh",
        dataType: "json",
        success: function (data) {
            if (data.result == 'success') {
                var cfList = '';
                var selfDyaList = '';
                var othersDyaList = '';
                var cqList = '';
                var ygList = '';
                var state = "true";

                if (data.cfList != '' && data.cfList != null && data.cfList != 'undefined') {
                    cfList = data.cfList;
                    state = "false";
                }
                if (data.selfDyaList != '' && data.selfDyaList != null && data.selfDyaList != 'undefined') {
                    selfDyaList = data.selfDyaList;
                    state = "false";
                }
                if (data.othersDyaList != '' && data.othersDyaList != null && data.othersDyaList != 'undefined') {
                    othersDyaList = data.othersDyaList;
                    state = "false";
                }
                if (data.ygList != '' && data.ygList != null && data.ygList != 'undefined') {
                    ygList = data.ygList;
                    state = "false";
                }
                var cellValue = '';
                var sfzx = "0";
                var sfdy = "0";
                var sfcf = "0";
                var sfyg = "0";

                if ((selfDyaList == "" || selfDyaList.length < 1)
                    && (othersDyaList == "" || othersDyaList.length < 1) && (cfList == "" || cfList.length < 1)
                    && (ygList == "" || ygList.length < 1)) {
                    cellValue = '<span class="label label-success">正常</span>';
                } else {
                    if (selfDyaList != "" && selfDyaList.length > 0) {
                        if (data.version == "danyang") {
                            cellValue += '<span class="label label-info">抵押</span>';
                        } else {
                            cellValue += '<span class="label label-info">本行抵押</span>';
                        }
                        sfdy = "1";
                    }
                    if (othersDyaList != "" && othersDyaList.length > 0) {
                        if (data.version == "danyang") {
                            cellValue += '<span class="label label-info">抵押</span>';
                        } else {
                            cellValue += '<span class="label label-info">他行抵押</span>';
                        }
                        sfdy = "1";
                    }
                    if (cfList != "" && cfList.length > 0) {
                        cellValue += '<span class="label label-warning">查封</span>';
                        sfcf = "1";
                    }
                    if (ygList != "" && ygList.length > 0) {
                        cellValue += '<span class="label label-warning">存在预告</span>';
                        sfyg = "1";
                    }
                }
                if ("wuhu" == sysVersion || "bozhou" == sysVersion ){
                    if (data.cqList != "" && data.cqList.length > 0){
                        cellValue = '<span class="label label-warning">存在产权</span>';
                        state = "false";
                    }
                }
                if ("bozhou" == sysVersion || "jurong"==sysVersion ) {
                    //请求登记接口，判断该不动产单元是否存在产权
                    $.ajax({
                        type: "POST",
                        url: bankUrl + "/queryApplication/checkBdcdyExistCq?bdcdyh=" + bdcdyh,
                        async: false,
                        dataType: "json",
                        success: function (data) {
                            if (data != null && data.exist != null && data.exist != "" && data.exist == "exist") {
                                cellValue = '<span class="label label-warning">存在产权</span>';
                                state = "false";
                            }
                        },
                        fail: function () {
                        }
                    });
                }
                table.setCell(fw_hs_index, "STATUS", cellValue);
                table.setCell(fw_hs_index, "SFDY", sfdy);
                table.setCell(fw_hs_index, "SFCF", sfcf);
                table.setCell(fw_hs_index, "SFYG", sfyg);

                if (state.indexOf("true") > -1) {
                    fwhsSq(bdcdyh, fw_hs_index, table, zl, jzmj);
                }
            } else {
                document.getElementById("confirm_info").innerHTML = "验证失败";
                document.getElementById("title").innerHTML = "警告";
            }
        },
        fail: function () {
        }
    })
}