$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';

$(document).ready(function () {
    getDyaCftx();
    var grid_selector = "#jqGrid";
    $(window).resize(function () {
        var grid_selector = '#jqGrid';
        $(grid_selector).jqGrid('setGridWidth', $("#jqGridOut").width());
    });
    $("#save").click(function () {
        var proids = [];
        proids.push(proid);
        $.ajax({
            type: "POST",
            url: bankUrl + "/action/bank/bwyd",
            data: {json: JSON.stringify({proids: proids,txlx:txlx})},
            dataType: "json",
            success: function (result) {
                if (result.result == 'success') {
                    $(grid_selector).jqGrid("delRowData", proid);
                    $("#confirmTablePop").hide();
                } else {
                    $("#confirmTablePop").hide();
                }
            },
            fail: function () {
                $("#confirmTablePop").hide();
            }
        });
    });

    $("#saveAll").click(function () {
        var proidList;
        if (txlx == 'dya') {
            proidList = eval(dyaProids);
        } else {
            proidList = eval(cfProids);
        }
        if(proidList != null && proidList.length > 0){
            $.ajax({
                type: "POST",
                url: bankUrl + "/action/bank/bwyd",
                data: {json: JSON.stringify({proids: proidList,txlx:txlx})},
                dataType: "json",
                success: function (result) {
                    if (result.result == 'success') {
                        var len = proidList.length;
                        for(var i = 0;i < len ;i ++){
                            $(grid_selector).jqGrid("delRowData", proidList[i]);
                        }
                        $("#confirmTablePop").hide();
                    } else {
                        $("#confirmTablePop").hide();
                    }
                },
                fail: function () {
                    $("#confirmTablePop").hide();
                }
            });
        }

    });
    $("#close").click(function(){
        $("#confirmTablePop").hide();
    });
    /*   文字水印  */
    $(".watermarkText").watermark();
    initDyaqtable(grid_selector);


    //导出
    $("#exportAll").click(function () {
        if ("yangzhou"==sysVersion){
            var proidList;
            if (txlx == 'dya') {
                proidList = eval(dyaProids);
                if (proidList != null && proidList.length > 0) {
                    data = {'proids': proidList, 'qlr': 'allsub', 'order': 'order by dyksrq desc'};
                    var json = JSON.stringify(data);
                }
                var actionURL = bankUrl + "/action/bank/exportAllYz?json=" + json;
            } else {
                proidList = eval(cfProids);
                if (proidList != null && proidList.length > 0) {
                    data = {'proids': proidList, 'qlr': 'allsub', 'order': 'order by dyksrq desc'};
                    var json = JSON.stringify(data);
                }
                var actionURL = bankUrl + "/action/bank/exportAll?json=" + json;
            }
            window.open(actionURL, "exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no")
        } else {
            var proidList;
            if (txlx == 'dya') {
                proidList = eval(dyaProids);
            } else {
                proidList = eval(cfProids);
            }
            if (proidList != null && proidList.length > 0) {
                data = {'proids': proidList, 'qlr': 'allsub', 'order': 'order by dyksrq desc'};
                var json = JSON.stringify(data);
            }
            var actionURL = bankUrl + "/action/bank/exportAll?json=" + json;
            window.open(actionURL, "exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no")
        }
    });

});

function initDyaqtable(grid_selector) {
    var proidList;
    if (txlx == 'dya') {
        proidList = eval(dyaProids);
        document.title = '新增再次抵押提醒';
        document.getElementById("title").innerHTML="新增再次抵押提醒";
    } else {
        proidList = eval(cfProids);
        document.title = '新增查封提醒';
        document.getElementById("title").innerHTML="新增查封提醒";
    }
    var data;
    if(proidList != null && proidList.length > 0){
        data = {'proids': proidList, 'qlr': 'allsub','order' :'order by dyksrq desc'};
    }

    if ("yangzhou" == sysVersion && txlx == 'dya') {
        // var proids = eval(proids);
        $(grid_selector).jqGrid({
            caption: "",
            datatype: "json",
            url: bankUrl + "/query/bank/queryZmh",
            postData: {json: JSON.stringify(data)},
            mtype: 'POST',
            autowidth: true,
            height: 'auto',
            rownumbers: true,
            jsonReader: {id: 'PROID'},
            colNames: ['不动产权证号','不动产证明号', '权利人', '义务人', '坐落', '权利状态', '再押银行', '节点名称','办结时间', '查看', 'ZSID','YCQQLID', 'PROID'],
            colModel: [
                {name: 'YCQZH', index: 'YCQZH', width: '16%', align: 'center', sortable: false,hidden:true},
                {name: 'BDCDJZMH', index: 'BDCDJZMH', width: '16%', align: 'center', sortable: false},
                {name: 'QLR', index: 'QLR', width: '14%', align: 'center', sortable: false},
                {name: 'YWR', index: 'YWR', width: '12%', align: 'center', sortable: false},
                {name: 'ZL', index: 'ZL', width: '28%', align: 'center', sortable: false},
                {name: 'QLZT', index: 'QLZT', width: '5%', align: 'center', sortable: false},
                {name: 'ZYYH', index: 'ZYYH', width: '5%', align: 'center', sortable: false},
                {name: 'ACTIVITY', index: 'ACTIVITY', width: '5%', align: 'center', sortable: false},
                {name: 'BJSJ', index: 'BJSJ', width: '12%', align: 'center', sortable: false},
                {
                    name: 'ck',
                    index: '',
                    width: '6%',
                    align: 'center',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        var str = '<div style="margin-left:8px;">' +
                            '<div title="查看抵押详情" style="cursor:pointer;float: left;margin-left: 8px;"  id="" onclick="look(\'' + rowObject.PROID + '\')"><span class="icon-search  icon-large "></span></div>';
                        str += '<div title="标为已读" style="cursor:pointer;float: left;margin-left: 8px;" id="" onclick="bwyd(\'' + rowObject.PROID + '\',\'' + grid_selector + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class=" icon-bookmark-empty  icon-large"></span></div>';
                        str += '</div>'
                        return str;
                    }
                },
                {name: 'ZSID', index: 'ZSID', width: '0%', align: 'center', sortable: false, hidden: true},
                {name: 'YCQQLID', index: 'YCQQLID', width: '0%', align: 'center', sortable: false, hidden: true},
                {name: 'PROID', index: 'PROID', width: '10%', align: 'center', sortable: false, hidden: true}
            ],
            //shrinkToFit:false,

            //loadonce: true,
            rowList: [20, 30, 50],
            sortname: 'OrderDate',
            viewrecords: true,
            multiselect: false,
            pager: "#jqGridPager",
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                }, 0);
                var ids = $(this).jqGrid('getDataIDs');
                var cqzhs = new Array();
                var cqzh;
                var zmhs = new Array();
                var zmh;
                var ycqqlids = new Array();
                var ycqqlid;

                if (ids.length>0&&null != ids) {
                    for (var i = 0; i < ids.length; i++) {
                        cqzh = $(this).jqGrid('getRowData', ids[i]).YCQZH;
                        cqzhs.push(cqzh);
                        zmh = $(this).jqGrid('getRowData', ids[i]).BDCDJZMH;
                        zmhs.push(zmh);
                        ycqqlid = $(this).jqGrid('getRowData', ids[i]).YCQQLID;
                        ycqqlids.push(ycqqlid);
                    }

                    initDate(ids, $(grid_selector), cqzhs ,zmhs, ycqqlids);
                }
            }
        });
    }else {
        $(grid_selector).jqGrid({
            caption: "",
            datatype: "json",
            url: bankUrl + "/query/bank/queryZmh",
            postData: {json: JSON.stringify(data)},
            mtype: 'POST',
            autowidth: true,
            height: 'auto',
            rownumbers: true,
            jsonReader: {id: 'PROID'},
            colNames: ['不动产证明号', '权利人', '义务人', '坐落', '权利状态', '节点名称', '办结时间','查封信息', '查看', 'ZSID', 'PROID'],
            colModel: [
                {name: 'BDCDJZMH', index: 'BDCDJZMH', width: '16%', align: 'center', sortable: false},
                {name: 'QLR', index: 'QLR', width: '14%', align: 'center', sortable: false},
                {name: 'YWR', index: 'YWR', width: '12%', align: 'center', sortable: false},
                {name: 'ZL', index: 'ZL', width: '28%', align: 'center', sortable: false},
                {name: 'QLZT', index: 'QLZT', width: '5%', align: 'center', sortable: false},
                {name: 'ACTIVITY', index: 'ACTIVITY', width: '5%', align: 'center', sortable: false},
                {name: 'BJSJ', index: 'BJSJ', width: '12%', align: 'center', sortable: false},
                {name: 'cfxx', index: 'cfxx', width: '12%', align: 'center', sortable: false, hidden:false},
                {
                    name: 'ck',
                    index: '',
                    width: '6%',
                    align: 'center',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        var str = '<div style="margin-left:8px;">' +
                            '<div title="查看抵押详情" style="cursor:pointer;float: left;margin-left: 8px;"  id="" onclick="look(\'' + rowObject.PROID + '\')"><span class="icon-search  icon-large "></span></div>';
                        str += '<div title="标为已读" style="cursor:pointer;float: left;margin-left: 8px;" id="" onclick="bwyd(\'' + rowObject.PROID + '\',\'' + grid_selector + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class=" icon-bookmark-empty  icon-large"></span></div>';
                        str += '</div>'
                        return str;
                    }
                },
                {name: 'ZSID', index: 'ZSID', width: '0%', align: 'center', sortable: false, hidden: true},
                {name: 'PROID', index: 'PROID', width: '10%', align: 'center', sortable: false, hidden: true}
            ],
            //shrinkToFit:false,

            //loadonce: true,
            rowList: [20, 30, 50],
            sortname: 'OrderDate',
            viewrecords: true,
            multiselect: false,
            pager: "#jqGridPager",
            beforeRequest:function(){
                if ("yangzhou" != sysVersion) {
                    $(grid_selector).setGridParam().hideCol("cfxx");
                }
            },
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                }, 0);
                var ids = $(this).jqGrid('getDataIDs');
                //var allDatas =  $(this).jqGrid("getRowData");
                if (null != ids) {
                    initDate(ids, $(grid_selector));
                }


            }
        });
    }
}
function initDate(proids,table,cqzhs,zmhs,ycqqlids){
    //权利人义务人
    $.ajax({
        type: "POST",
        url: bankUrl + "/query/bank/getQlrAndYwrList",
        data: {json: JSON.stringify({proids: proids})},
        dataType: "json",
        success: function (result) {
            if(result!=null && result.length>0){
                for(var i=0;i<result.length;i++){
                    table.setCell(result[i].PROID, "QLR",  result[i].QLRMC);
                    table.setCell(result[i].PROID, "YWR",  result[i].YWRMC);
                }
            }
        }
    });

    if ("yangzhou" == sysVersion){
        $.ajax({
            url:bankUrl + "/query/bank/checkZySfBh",
            type:"POST",
            data:{json: JSON.stringify({proids:proids,zmhs:zmhs,ycqqlids:ycqqlids})},
            datatype:"json",
            success:function (result) {
                if(result!=null && result.length>0){
                    for(var i=0;i<result.length;i++){
                        table.setCell(result[i].proid, "ZYYH",  result[i].message);
                    }
                }
            }
        });
        $.ajax({
            url:bankUrl+"/query/bank/showCf",
            type:"POST",
            data:{json: JSON.stringify({bdcqzhs:cqzhs,proids:proids,zmhs:zmhs})},
            datatype:"json",
            success:function (result) {
                if(result!=null && result.length>0){
                    for(var i=0;i<result.length;i++){
                        table.setCell(result[i].proid, "cfxx",  result[i].message);
                    }
                }
            }
        })
    }

    //坐落
    $.ajax({
        type: "POST",
        url: bankUrl + "/query/bank/zlList",
        data: {json: JSON.stringify({proids: proids})},
        dataType: "json",
        success: function (result) {
            if(result!=null && result.length>0){
                for(var i=0;i<result.length;i++){
                    table.setCell(result[i].PROID, "ZL",  result[i].ZL);
                }
            }
        }

    });

    //权利状态
    $.ajax({
        type: "POST",
        url: bankUrl + "/query/bank/getQzltAndJd",
        data: {json: JSON.stringify({proids: proids})},
        dataType: "json",
        success: function (result) {

            if(result!=null && result.length>0){
                for(var i=0;i<result.length;i++){
                    var cellValue = '';
                    if (result[i].DYZT == '0' || result[i].DYZT == '现势') {
                        cellValue = '<span class="label label-success">现势</span>';
                    }
                    if (result[i].DYZT == '历史' || result[i].DYZT == '终止') {
                        cellValue = '<span class="label label-warning">已注销</span>';
                    }
                    if (result[i].DYZT == '临时') {
                        cellValue = '<span class="label label-gray">临时</span>';
                    }
                    if (result[i].CQZX == '1') {
                        cellValue = cellValue +'<span class="label label-warning">产权注销</span>';
                    }
                    if (result[i].ISCF == '1') {
                        cellValue = cellValue + ' <span class="label label-warning">查封</span>';
                    }

                    table.setCell(result[i].PROID, "QLZT", cellValue);
                    table.setCell(result[i].PROID, "ACTIVITY",  result[i].JDMC);
                }
            }

        }

    });




}

function look(proid) {

    var json = JSON.stringify({proids:new Array(proid)});
    var url = bankUrl + "/query/bank/queryQlxxV2";
    openPostWindow(url,"json", json);
}


//标为已读
function bwyd(id, grid_selector) {
    $("#confirmTablePop").hide();
    $("#confirmTablePop").show();
    var zmh = $(grid_selector).jqGrid("getCell",id,"BDCDJZMH");
    document.getElementById("confirm_info").innerHTML= "是否将: "+zmh+"抵押，标为已读";
    proid = id;
}

function openWin(url, name) {
    var w_width = screen.availWidth - 10;
    var w_height = screen.availHeight - 32;
    window.open(url, name, "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
}

function getDyaCftx() {
    $.ajax({
        cache: false,
        async: false,   // 同步和异步的参数
        type: "GET",
        url: bankUrl + "/query/bank/yhtx",
        dataType: "json",
        success: function (result) {
            dyaProids = result.dyaProids;
            cfProids = result.cfProids;
        }
    });
}

function openPostWindow(url,paramName, paramValue) {

    var newWin = window.open();
    formStr = '';
    //设置样式为隐藏，打开新标签再跳转页面前，如果有可现实的表单选项，用户会看到表单内容数据
    // formStr = '<form style="visibility:hidden;" method="POST" action="' + url + '">' +
    //     '<input type="hidden" name="'+paramName+'" value="' + paramValue + '" />' +
    //     '</form>';
    formStr = "<form style='visibility:hidden;' method='POST' action='" + url + "'>" +
        "<input type='hidden' name='"+paramName+"' value='" + paramValue + "' />" +
        "</form>";

    newWin.document.body.innerHTML = formStr;
    newWin.document.forms[0].submit();

    return newWin;
}



function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}
function updatePagerIcons(table) {
    var replacement =
    {
        'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
        'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
        'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
        'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
        'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
    };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}
