$.jgrid.defaults.responsive = true;
$.jgrid.defaults.styleUI = 'Bootstrap';


$(function(){
    var grid_selector = "#jqGrid";
    initDyaqtable(grid_selector);

    $("#search").click(function(){
        var beginTime = $("#beginTime").val();
        var endTime = $("#endTime").val();
        if(beginTime == '' ){
            var msg = "请选择起始时间";
            alert(msg);
        }else if(endTime==''){
            var msg = "请选择结束时间";
            alert(msg);
        }else{
            var qlr = $("#bankSelect  option:selected").val();
            var Url = bankUrl+"/query/bank/getYhBjyw";
            tableReload("jqGrid", Url, {beginTime:beginTime,endTime:endTime,qlr:qlr});
        }
    });
});

function tableReload(table, Url, data) {
    var jqgrid = $("#" + table);
    jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
    jqgrid.trigger("reloadGrid");//重新加载JqGrid
}

function initDyaqtable(grid_selector) {
    $(grid_selector).jqGrid({
        caption: "",
        datatype: "json",
        /*url: bankUrl + "/query/bank/getYhBjyw",*/
        autowidth: true,
        height: 'auto',
        rownumbers: true,
        jsonReader: {id: 'YWID'},
        colNames: ['银行业务号', '抵押权人', '抵押人', '担保债权数额', '是否申请电子证明','创建日期'],
        colModel: [
            {name: 'BH', index: 'BH', width: '15%', align: 'center', sortable: false},
            {name: 'DYQR', index: 'DYQR', width: '20%', align: 'center', sortable: false},
            {name: 'DYR', index: 'DYR', width: '25%', align: 'center', sortable: false},
            {name: 'BDBZZQSE', index: 'BDBZZQSE', width: '15%', align: 'center', sortable: false},
            {name: 'SFHCDZZZ', index: 'SFHCDZZZ', width: '15%', align: 'center', sortable: false},
            {name: 'CREATETIME', index: 'CREATETIME', width: '10%', align: 'center', sortable: false}
        ],
        loadonce: true,
        rowNum: 10,
        rowList: [10, 20, 30, 50],
        sortname: 'OrderDate',
        viewrecords: true,
        multiselect: false,
        pager: "#jqGridPager",
        loadComplete: function () {
            //解决jqgrid遮挡水印
            if(isShowSy=='true'){
                setJqgridSy();
            }
        }
    });
}


function enableTooltips(table) {
    $('.navtable .ui-pg-button').tooltip({container: 'body'});
    $(table).find('.ui-pg-div').tooltip({container: 'body'});
}
function updatePagerIcons(table) {
    var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140',
            'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
        };
    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
        var icon = $(this);
        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
    })
}