<@ui.html title="用户权限配置" import="bootstrap,jquery,public,zTree">
<style type="text/css">
    .modal-dialog {
        /*position: absolute;*/
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
    }

    .modal-body {
        overflow-y: scroll;
        max-height:600px;
        /*position: absolute;*/
        top: 0px;
        bottom: 0px;
        width: 100%-;
        /*height:600px!important;*/
    }

    .modal-header .close {
        margin-right: 15px;
        height: 50px;
    }
    .ztree li span.button.ico_docu{
        margin-right:2px;
        background:url(${bankUrl!}/static/thirdparty/bootstrap/img/glyphicons-halflings.png) no-repeat scroll 0 0 transparent;
        vertical-align:top;
        background-position: -168px 0px;
        vertical-align:top;
        *vertical-align:middle}
    .ztree li span.button.ico_close{
        margin-right:2px;
        background:url(${bankUrl!}/static/thirdparty/bootstrap/img/glyphicons-halflings.png) no-repeat scroll 0 0 transparent;
        vertical-align:top;
        background-position: -336px -48px;
        vertical-align:top;
        *vertical-align:middle}
    .ztree li span.button.ico_open{
        margin-right:2px;
        background:url(${bankUrl!}/static/thirdparty/bootstrap/img/glyphicons-halflings.png) no-repeat scroll 0 0 transparent;
        vertical-align:top;
        background-position: -360px -48px;
        vertical-align:top;
        *vertical-align:middle}

    .tableHeader ul{
        float: right;
        height: 40px;
        line-height: 40px;
        margin-right: 10px;
    }
    .tableHeader li{
        list-style: none;
        display: inline-block;//使li对象显示为一行
        margin-left: 15px;
    }
</style>
<script>
    $(document).ready(function(){


        $("#openAll").click(function(){
            var zTree = $.fn.zTree.getZTreeObj("tree");
            zTree.expandAll(true);
        });
        $("#closeAll").click(function(){
            var zTree = $.fn.zTree.getZTreeObj("tree");
            zTree.expandAll(false);
        });
        /*$("#subOpenAll").click(function(){
            var zTree = $.fn.zTree.getZTreeObj("subTree");
            zTree.expandAll(true);
        });
        $("#subCloseAll").click(function(){
            var zTree = $.fn.zTree.getZTreeObj("subTree");
            zTree.expandAll(false);
        });*/
        $("#save").click(function(){
            var zTree = $.fn.zTree.getZTreeObj("subTree");
            var selectNodes = zTree.getCheckedNodes(true);
            var userid = $("#userid").val();
            var organName = $("#userid").attr("name");
            if(selectNodes.length==0){
                bootbox.confirm("确认清除抵"+organName+"押权查询权限？",function(result){
                    if(result){
                        saveBankRel(null,userid);
                    }
                })
            }else if(selectNodes.length>0){

                bootbox.confirm("确认保存"+organName+"权限？",function(result){
                    if(result){
                        var bankNameList =new Array();
                        $.each(selectNodes,function(index, value, array){
                            bankNameList.push(value.name);
                        });
                        saveBankRel(bankNameList,userid);
                    }
                })
            }
        });

        resizeElementHeight(document.getElementById("orgn"));
        resizeElementHeight(document.getElementById("subOrgn"));
        initTree();

    });




    function initTree(){
        $.blockUI({message: "正在加载部门信息，请稍等……"});
        var setting = {
            view: {
                dblClickExpand: false
            },
            data: {
                simpleData: {
                    enable: true
                }
            },
            callback: {
                onClick: onClick
            }
        };
        $.ajax({
            type: "POST",
            url:"${bankUrl!}/user/loadTree",
            dataType: "json",
            success: function (zNodes) {
                //去掉遮罩
                setTimeout($.unblockUI, 10);

                $.fn.zTree.init($("#tree"), setting, zNodes);
            },
            error: function (data) {
                //去掉遮罩
                setTimeout($.unblockUI, 10);

            }

        });

    }
    function onClick(e,treeId, treeNode) {
        var zTree = $.fn.zTree.getZTreeObj("tree");
        zTree.expandNode(treeNode);
        if(!treeNode.isParent){
            initSubTree(treeNode.id);
            //赋值userid
            $("#userid").val(treeNode.id);
            $("#userid").attr("name",treeNode.name);
        }
    }
    function subTreeOnClick(e,treeId, treeNode) {
        var zTree = $.fn.zTree.getZTreeObj("subTree");
        zTree.expandNode(treeNode);
        if(!treeNode.isParent){
            initSubTree(treeNode.id);
        }
    }

    function initSubTree(treeId){
        $.blockUI({message: "正在加载子部门信息，请稍等……"});
        var setting = {
            check: {
                chkboxType:    { "Y" : "s", "N" : "" },
                enable: true
            },
            view: {
                dblClickExpand: false
            },
            data: {
                simpleData: {
                    enable: true
                }
            },
            async: {
                enable: true,
                url:"${bankUrl!}/user/loadSubTree?userid="+treeId,
                autoParam:["id"]
            },
            callback: {
                onAsyncError: closeBlockUI,
                onAsyncSuccess: closeBlockUI,
                onClick: subTreeOnClick
            }
        };
        $.fn.zTree.init($("#subTree"), setting);
    }

    function closeBlockUI(){
        //去掉遮罩
        setTimeout($.unblockUI, 10);
    }
    function resizeElementHeight(element) {
        var height = 0;
        var body = window.document.body;
        if (window.innerHeight) {
            height = window.innerHeight;
        } else if (body.parentElement.clientHeight) {
            height = body.parentElement.clientHeight;
        } else if (body && body.clientHeight) {
            height = body.clientHeight;
        }
        element.style.height = ((height - element.offsetTop-50) + "px");
    }

    function saveBankRel(bankNameList,userid){

        var paramData = {
            "userid":userid
        };
        if(bankNameList!=undefined && bankNameList!=null){
            paramData.json = JSON.stringify({"bankNameList":bankNameList});
        }
        var url = "${bankUrl!}/user/saveBankRel";

        $.blockUI({message: "正在保存数据，请稍等……"});
        $.ajax({
            type: "POST",
            url:url,
            dataType: "json",
            data: paramData,
            success: function (data) {
                //去掉遮罩
                setTimeout($.unblockUI, 10);
                bootbox.alert(data.msg);
            },
            error: function (data) {
                //去掉遮罩
                setTimeout($.unblockUI, 10);
                bootbox.alert(data.msg);
            }

        });
    }
</script>
<div id="main_section" class="Hui-article mainContent pd-10 " style="top:0px;">
    <div class="page-content" id="mainContent">
        <div class="row" id="asc">
            <div class="col-5 " style="BORDER: 1px solid #ddd ;overflow:auto;" id="orgn">
                <div class="tableHeader">
                    <span class="title"><i class="icon-edit icon-large">&nbsp;</i>部门用户配置</span>
                    <ul>
                        <li>
                            <button type="button" id="openAll" class="button">
                                <i class="ace-icon fa fa-file-o"></i>
                                <span>展开</span>
                            </button>
                        </li>
                        <li>
                            <button type="button" id="closeAll" class="button">
                                <span>折叠</span>
                            </button>
                        </li>
                    </ul>
                </div>
                <div class="">
                    <ul id="tree" class="ztree" ></ul>
                </div>
            </div>
            <div class="col-1 ">
            </div>
            <div class="col-6 " style="BORDER: 1px solid #ddd;overflow:auto;" id="subOrgn">
                <div class="tableHeader">
                    <span class="title"><i class="icon-exclamation-sign icon-large">&nbsp;</i>子部门配置</span>
                    <ul>
                        <li>
                            <button type="button" id="save" class="button">
                                <i class="ace-icon fa fa-file-o"></i>
                                <span>保存</span>
                            </button>
                        </li>
                        <#--<li>
                            <button type="button" id="subOpenAll" class="button">
                                <i class="ace-icon fa fa-file-o"></i>
                                <span>展开</span>
                            </button>
                        </li>
                        <li>
                            <button type="button" id="subCloseAll" class="button">
                                <span>折叠</span>
                            </button>
                        </li>-->
                    </ul>
                </div>
                <div class="">
                    <ul id="subTree" class="ztree" ></ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div style="display: none;">
    <input id="userid" value="" name=""></input>
</div>

</@ui.html>