/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.web.query;

import cn.gtmap.estateplat.bank.entity.BdcZdYhdz;
import cn.gtmap.estateplat.bank.entity.QueryXtLog;
import cn.gtmap.estateplat.bank.service.log.LogService;
import cn.gtmap.estateplat.bank.utils.Constants;
import cn.gtmap.estateplat.bank.utils.printexcel.access.ExcelBean;
import cn.gtmap.estateplat.bank.web.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/log"})
public class LogController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(LogController.class);
    @Autowired
    private LogService logService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    @Qualifier(value="serverEntityMapper")
    private EntityMapper serverEntityMapper;

    @RequestMapping(value={"/index"})
    public String index(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List tempOrganList = this.sysUserService.getOrganListByUser(userInfo.getId());
        List bankList = null;
        if (CollectionUtils.isNotEmpty((Collection)tempOrganList)) {
            Example example = new Example(BdcZdYhdz.class);
            example.createCriteria().andEqualTo("bankname", (Object)((PfOrganVo)tempOrganList.get(0)).getOrganName());
            example.setOrderByClause("xh");
            bankList = this.serverEntityMapper.selectByExample(example);
            model.addAttribute("bankList", (Object)bankList);
        }
        return "/query/log/search";
    }

    @ResponseBody
    @RequestMapping(value={"/queryinfo"})
    public Object search(Date beginTime, Date endTime, String czlx, String czyh) {
        List pfOrganVoList;
        HashMap parms = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)czlx)) {
            parms.put("czlx", czlx);
        }
        if (StringUtils.isNotBlank((CharSequence)czyh)) {
            PfOrganVo pfOrganVo = this.sysUserService.getOrganVoByName(czyh);
            List pfUserVos = this.sysUserService.getUserListByOragn(pfOrganVo.getOrganId());
            ArrayList<String> list = new ArrayList<String>();
            for (PfUserVo userVo : pfUserVos) {
                list.add(userVo.getUserName());
            }
            parms.put("username", list);
            parms.put("czr", pfUserVos);
        }
        parms.put("beginTime", beginTime);
        parms.put("endTime", endTime);
        if (StringUtils.equals((CharSequence)Constants.BANK_LOGINFO_CONTROL, (CharSequence)"true") && CollectionUtils.isNotEmpty((Collection)(pfOrganVoList = this.sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId())))) {
            String dwdms = "";
            for (int i = 0; i < pfOrganVoList.size(); ++i) {
                if (!StringUtils.isNotBlank((CharSequence)((PfOrganVo)pfOrganVoList.get(i)).getRegionCode())) continue;
                dwdms = dwdms + ((PfOrganVo)pfOrganVoList.get(i)).getRegionCode() + ",";
            }
            parms.put("dwdm", dwdms);
        }
        List result = (List)this.logService.queryInfo((Map)parms);
        return result;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public String export(HttpServletRequest request, Date beginTime, Date endTime, String czlx) throws Exception {
        HashMap parms = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)czlx) && !StringUtils.equals((CharSequence)czlx, (CharSequence)"undefined")) {
            parms.put("czlx", czlx);
        }
        parms.put("beginTime", beginTime);
        parms.put("endTime", endTime);
        List result = (List)this.logService.queryInfo((Map)parms);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            ArrayList<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < result.size(); ++i) {
                QueryXtLog xtLog = (QueryXtLog)result.get(i);
                if (xtLog == null) continue;
                String[] strs = new String[6];
                for (int j = 0; j < strs.length; ++j) {
                    strs[j] = "";
                }
                strs[0] = String.valueOf(i + 1);
                strs[1] = String.valueOf(xtLog.getUsername() == null ? "" : xtLog.getUsername());
                strs[2] = String.valueOf(xtLog.getController() == null ? "" : xtLog.getController());
                strs[3] = String.valueOf(xtLog.getIp() == null ? "" : xtLog.getIp());
                strs[4] = String.valueOf(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(xtLog.getCzrq()) == null ? "" : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(xtLog.getCzrq()));
                strs[5] = String.valueOf(xtLog.getParmjson() == null ? "" : xtLog.getParmjson().replaceAll("\\\\", ""));
                retList.add(strs);
            }
            HashMap<String, ArrayList<String[]>> map = new HashMap<String, ArrayList<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);
            eb.setGroupMap(map);
            eb.setExcelTemplate("shrzTzExport.xls");
            eb.setExcelXml("shrzTzExport.xml");
            eb.printExcel(request);
        }
        return "common/downExcel";
    }
}

