/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.web.evaluation;

import cn.gtmap.estateplat.bank.model.Fjxx;
import cn.gtmap.estateplat.bank.model.UseridMachine;
import cn.gtmap.estateplat.bank.service.server.ExportService;
import cn.gtmap.estateplat.bank.utils.Base64Util;
import cn.gtmap.estateplat.bank.utils.HttpClientUtil;
import cn.gtmap.estateplat.bank.utils.PublicUtil;
import cn.gtmap.estateplat.bank.web.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.web.SessionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/evaluation"})
public class EvaluationController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(EvaluationController.class);
    @Autowired
    @Qualifier(value="serverEntityMapper")
    private EntityMapper serverEntityMapper;
    @Autowired
    private ExportService exportService;
    @Resource(name="FileCenterNodeServiceImpl")
    private NodeService fileCenterNodeServiceImpl;
    @Autowired
    private FileService fileService;

    @ResponseBody
    @RequestMapping(value={"/httpFaceValidate"}, method={RequestMethod.GET})
    public HashMap httpFaceValidate(@RequestParam(value="ywid", required=false) String ywid, HttpServletRequest request, @RequestParam(value="userid", required=false) String userid) {
        String result = "false";
        String msg = "";
        String res = "";
        HashMap<String, String> map = new HashMap<String, String>();
        String zjhm = "";
        String name = "";
        String sysIp = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ywid})) {
            String data;
            userid = SessionUtil.getCurrentUserId();
            logger.error("userid:" + userid);
            if (StringUtils.isNotBlank((CharSequence)userid)) {
                Example example = new Example(UseridMachine.class);
                example.createCriteria().andEqualTo("userid", (Object)userid);
                List useridMachineList = this.serverEntityMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)useridMachineList)) {
                    sysIp = ((UseridMachine)useridMachineList.get(0)).getJqbm();
                }
            }
            String url = AppConfig.getProperty((String)"mokeNewUrl") + "?t=FaceValidateWithIdCard&ServiceId=" + ywid + "&timeout=60&sysIp=" + sysIp;
            try {
                logger.error("\u4eba\u8bc1\u5bf9\u6bd4\u63a5\u53e3\u8bf7\u6c42Url\uff1a" + url);
                res = HttpClientUtil.doGet((String)url, null);
                logger.error("\u4eba\u8bc1\u5bf9\u6bd4\u63a5\u53e3\u8fd4\u56de\uff1a" + res);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject objStr = JSONObject.parseObject((String)res);
            if (null != objStr && objStr.containsKey((Object)"data") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{data = objStr.getString("data")})) {
                JSONObject resStr = JSONObject.parseObject((String)data);
                if (null != resStr && resStr.containsKey((Object)"result")) {
                    result = resStr.getString("result");
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)result)) {
                    File file;
                    String path;
                    name = resStr.getString("name");
                    zjhm = resStr.getString("idNo");
                    String photoBase64 = resStr.getString("photoBase64");
                    String cameraPhotoBase64 = resStr.getString("cameraPhotoBase64");
                    if (StringUtils.isNotBlank((CharSequence)photoBase64)) {
                        path = "C:/TEMP/";
                        file = new File(path);
                        if (!file.exists()) {
                            file.mkdir();
                        }
                        path = path + "\u8eab\u4efd\u8bc1\u5934\u50cf\u7167\u7247" + name + ywid + ".jpg";
                        PublicUtil.generateImage((String)photoBase64, (String)path);
                        this.exportService.sendFileCenter(path, ywid, "\u8eab\u4efd\u8bc1\u5934\u50cf\u7167\u7247" + name + ".jpg", "\u7533\u8bf7\u4eba\u7167\u7247");
                        this.exportService.deleteDir(new File(path));
                    }
                    if (StringUtils.isNotBlank((CharSequence)cameraPhotoBase64)) {
                        path = "C:/TEMP/";
                        file = new File(path);
                        if (!file.exists()) {
                            file.mkdir();
                        }
                        path = path + "\u73b0\u573a\u7167\u7247" + name + ywid + "1.jpg";
                        PublicUtil.generateImage((String)cameraPhotoBase64, (String)path);
                        this.exportService.sendFileCenter(path, ywid, "\u73b0\u573a\u7167\u7247" + name + ".jpg", "\u7533\u8bf7\u4eba\u7167\u7247");
                        this.exportService.deleteDir(new File(path));
                    }
                }
            }
            if (null != objStr && objStr.containsKey((Object)"message")) {
                msg = objStr.getString("message");
            }
        }
        map.put("result", result);
        map.put("msg", msg);
        map.put("zjhm", zjhm);
        map.put("name", name);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/sendHighPhoto"}, method={RequestMethod.GET})
    public void sendHighPhoto(String userid, String ywid) {
        String url = AppConfig.getProperty((String)"mokeNewUrl") + "/sendHighPhoto";
        try {
            userid = SessionUtil.getCurrentUserId();
            logger.error("userid:" + userid);
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("id", ywid);
            String sysIp = "";
            if (StringUtils.isNotBlank((CharSequence)userid)) {
                Example example = new Example(UseridMachine.class);
                example.createCriteria().andEqualTo("userid", (Object)userid);
                List useridMachineList = this.serverEntityMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)useridMachineList)) {
                    sysIp = ((UseridMachine)useridMachineList.get(0)).getJqbm();
                }
            }
            paramMap.put("sysIp", sysIp);
            logger.error("\u89e6\u53d1\u9ad8\u62cd\u4eea\u63a5\u53e3\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)paramMap));
            String result = HttpClientUtil.sendPostRequest((String)url, (Map)paramMap);
            logger.error("\u89e6\u53d1\u9ad8\u62cd\u4eea\u63a5\u53e3\u8fd4\u56de\uff1a" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/uploadFj"}, method={RequestMethod.POST})
    public Map uploadFj(@RequestBody Fjxx fjxx) {
        HashMap<String, String> map = new HashMap<String, String>();
        logger.error("\u9ad8\u62cd\u4eea\u4e0a\u4f20\u9644\u4ef6\u7684\u63a5\u53e3\u63a5\u6536\uff1a" + JSON.toJSONString((Object)fjxx));
        if (fjxx != null && StringUtils.isNotBlank((CharSequence)fjxx.getYwh())) {
            Space space = this.fileCenterNodeServiceImpl.getWorkSpace("WORK_FLOW_STUFF");
            Integer proNodeId = this.exportService.createFileFolderByclmc(space.getId(), fjxx.getYwh());
            Integer nodeId = this.exportService.createFileFolderByclmc(proNodeId, "\u7167\u7247");
            try {
                byte[] fjxxnr = Base64Util.decodeBase64StrToByte((String)fjxx.getWjnr());
                this.fileService.uploadFile((InputStream)new ByteArrayInputStream(fjxxnr), nodeId, fjxx.getWjmc() + fjxx.getWjlx());
                map.put("info", "success");
                map.put("msg", "\u4e0a\u4f20\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u9644\u4ef6\u5f02\u5e38/uploadFj", (Throwable)e);
                map.put("info", "false");
                map.put("msg", "\u4e0a\u4f20\u5931\u8d25\uff0c\u9644\u4ef6\u5f02\u5e38");
            }
        } else {
            map.put("info", "false");
            map.put("msg", "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        return map;
    }
}

