/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.web;

import cn.gtmap.estateplat.bank.mapper.bank.CxsqMapper;
import cn.gtmap.estateplat.bank.web.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bdcspxxSign"})
public class BdcspxxSignController
extends BaseController {
    @Autowired
    private CxsqMapper cxsqMapper;
    @Autowired
    protected SysUserService sysUserService;
    @Autowired
    @Qualifier(value="entityMapper")
    private EntityMapper entityMapper;
    @Qualifier(value="GxSysSignService")
    @Autowired
    SysSignService signService;

    @ResponseBody
    @RequestMapping(value={"/addSign"})
    @Transactional(value="bank", rollbackFor={Exception.class})
    public HashMap addSign(String bh, String signAdvice, String sign) {
        HashMap<String, String> map = new HashMap<String, String>();
        String msg = "error";
        List ywxxList = null;
        String ywid = null;
        if (StringUtils.isNotBlank((CharSequence)bh)) {
            HashMap querymap = Maps.newHashMap();
            querymap.put("ywxxLsh", bh);
            ywxxList = this.cxsqMapper.getYwxx((Map)querymap);
            if (ywxxList != null && ywxxList.size() > 0) {
                ywid = MapUtils.getString((Map)((Map)ywxxList.get(0)), (Object)"ID", (String)"");
            }
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List user = this.sysUserService.getUserVoListByUserName(userInfo.getUsername());
        try {
            PfSignVo pfSignVo = new PfSignVo();
            pfSignVo.setProId(ywid);
            pfSignVo.setSignDate(new Date());
            pfSignVo.setSignKey(sign);
            pfSignVo.setSignId(ywid + sign);
            this.signService.deleteSign(ywid + sign);
            pfSignVo.setSignName(((PfUserVo)user.get(0)).getUserName());
            pfSignVo.setSignOpinion(signAdvice);
            pfSignVo.setUserId(userInfo.getId());
            this.signService.insertAutoSign(pfSignVo);
            msg = "success";
        }
        catch (Exception e) {
            msg = "error";
        }
        map.put("msg", msg);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteSign"})
    @Transactional(value="bank", rollbackFor={Exception.class})
    public HashMap deleteSign(String bh, String sign, String ywid) {
        HashMap<String, String> map = new HashMap<String, String>();
        String msg = "error";
        try {
            if (StringUtils.isNotEmpty((CharSequence)sign) && StringUtils.isNotEmpty((CharSequence)ywid)) {
                this.signService.deleteSign(ywid + sign);
            }
            msg = "success";
        }
        catch (Exception e) {
            msg = "error";
        }
        map.put("msg", msg);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/checkSign"}, method={RequestMethod.GET})
    public HashMap checkSign(HttpServletResponse response, HttpServletRequest request, String ywid, String sign) {
        HashMap<String, String> map = new HashMap<String, String>();
        String msg = "error";
        if (StringUtils.isNotBlank((CharSequence)sign)) {
            List pfSignCsr = this.signService.getSignList(sign, ywid);
            msg = CollectionUtils.isNotEmpty((Collection)pfSignCsr) ? "success" : "error";
        }
        map.put("msg", msg);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/checkSignList"}, method={RequestMethod.GET})
    public HashMap checkSignList(HttpServletResponse response, HttpServletRequest request, String ywid, String[] signList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String msg = "error";
        ArrayList resultList = new ArrayList();
        if (signList != null && signList.length > 0) {
            for (String sign : signList) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                List pfSignCsr = this.signService.getSignList(sign, ywid);
                resultMap.put("KEY", sign);
                if (CollectionUtils.isNotEmpty((Collection)pfSignCsr)) {
                    msg = "success";
                    resultMap.put("VALUE", "success");
                } else {
                    resultMap.put("VALUE", "error");
                }
                resultList.add(resultMap);
            }
        }
        map.put("result", resultList);
        map.put("msg", msg);
        return map;
    }
}

