/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils.printexcel.xmlparse;

import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Cell;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Group;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Sheet;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Single;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Border;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.CellStyle;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.ComeFrom;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Font;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Item;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.MergedCell;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Picture;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLParse {
    private static Logger logger = LoggerFactory.getLogger(XMLParse.class);
    Log log = LogFactory.getLog((String)this.getClass().getName());

    public List loadXml(String xmlPath) {
        List list = new ArrayList();
        Document doc = this.read(xmlPath);
        Element root = doc.getRootElement();
        list = this.parseRoot(root);
        return list;
    }

    private Document read(String xmlPath) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(new File(xmlPath));
        }
        catch (DocumentException e) {
            this.log.error((Object)("\u89e3\u6790 " + xmlPath + "\u6587\u4ef6\u51fa\u9519\uff01"));
            logger.error("errorMsg:", (Throwable)e);
        }
        return document;
    }

    private Element getRootElement(Document doc) {
        return doc.getRootElement();
    }

    private List parseRoot(Element root) {
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
        Iterator it = root.elementIterator("sheet");
        while (it.hasNext()) {
            sheetList.add(this.parseSheetElement((Element)it.next()));
        }
        this.log.info((Object)("sheet\u7684\u6570\u76ee\u4e3a:" + sheetList.size()));
        return sheetList;
    }

    private Sheet parseSheetElement(Element sheetElement) {
        Sheet sheet = new Sheet();
        String sheetName = sheetElement.attributeValue("name");
        sheet.setName(sheetName);
        Element sequenceElement = sheetElement.element("sequence");
        if (sequenceElement != null) {
            String sequence = sequenceElement.getText();
            sheet.setSequenceList(this.parseStringToList(sequence));
        } else {
            this.log.error((Object)("\u8be5xml\u4e2dsheet\u5b50\u8282\u70b9\u4e0b\u6ca1\u6709sequence\uff0c\u8bf7\u68c0\u67e5\uff01sheet=" + sheetName));
        }
        List groupElementList = sheetElement.elements("group");
        for (int i = 0; i < groupElementList.size(); ++i) {
            Group group = this.parseGroupElement((Element)groupElementList.get(i));
            sheet.getElementMap().put(group.getId(), group);
        }
        List singleElementList = sheetElement.elements("single");
        for (int i = 0; i < singleElementList.size(); ++i) {
            Single single = this.parseSingleElement((Element)singleElementList.get(i));
            sheet.getElementMap().put(single.getId(), single);
        }
        return sheet;
    }

    private Single parseSingleElement(Element singleElement) {
        Single single = new Single();
        String strId = singleElement.attributeValue("id");
        if (strId == null || strId.length() == 0) {
            this.log.error((Object)"Single\u7684ID\u503c\u4e3a\u7a7a\uff0c\u8be5Single\u7684\u5185\u5bb9\u5c06\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c");
        }
        single.setId(strId);
        List cellList = singleElement.elements("cell");
        for (int i = 0; i < cellList.size(); ++i) {
            Cell tempCell = this.parseCellElement((Element)cellList.get(i));
            if (tempCell == null) continue;
            single.getCellList().add(tempCell);
        }
        return single;
    }

    private Cell parseCellElement(Element cellElement) {
        Element cellStyleElement;
        Element comeFromElement;
        Element precisionElement;
        Element valueTypeElement;
        Element columnElement;
        if (cellElement == null) {
            return null;
        }
        Cell cell = new Cell();
        Element rowElement = cellElement.element("row");
        if (rowElement != null) {
            String strRow = rowElement.getTextTrim();
            try {
                cell.setRow(Integer.parseInt(strRow));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Row\u7684\u503c\u4e0d\u662f\u6570\u5b57!row=" + strRow));
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((columnElement = cellElement.element("column")) != null) {
            String strColumn = columnElement.getTextTrim();
            if (strColumn == null || strColumn.length() == 0) {
                this.log.error((Object)"column\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                cell.setColumn(Integer.parseInt(strColumn));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("column\u7684\u503c\u4e0d\u662f\u6570\u5b57!row=" + strColumn));
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((valueTypeElement = cellElement.element("valuetype")) != null) {
            cell.setValueType(valueTypeElement.getTextTrim());
        }
        if ((precisionElement = cellElement.element("precision")) != null) {
            try {
                cell.setPrecision(Integer.parseInt(precisionElement.getTextTrim()));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"\u5c0f\u6570\u70b9\u4fdd\u7559\u7684\u4e2a\u6570\u4e0d\u662f\u6709\u6548\u6570\u5b57\uff01");
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((comeFromElement = cellElement.element("comeFrom")) != null) {
            cell.setComeFrom(this.parseComeFromElement(comeFromElement));
        }
        if ((cellStyleElement = cellElement.element("style")) != null) {
            cell.setCellStyle(this.parseCellStyleElement(cellStyleElement));
        } else {
            this.log.error((Object)"\u6ca1\u6709\u914d\u7f6estyle\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return cell;
    }

    private CellStyle parseCellStyleElement(Element cellStyleElement) {
        String strWrapText;
        Element pictureElement;
        Element borderElement;
        if (cellStyleElement == null) {
            return null;
        }
        CellStyle cellStyle = new CellStyle();
        Element fontElement = cellStyleElement.element("font");
        if (fontElement != null) {
            String isBold;
            Element nameElement = fontElement.element("name");
            Element heightElement = fontElement.element("height");
            Element boldElement = fontElement.element("bold");
            if (nameElement != null) {
                String fontName = nameElement.getTextTrim();
                String fontHeight = heightElement.getTextTrim();
                if (fontName != null && fontName.length() > 0) {
                    if (cellStyle.getFont() == null) {
                        cellStyle.setFont(new Font());
                    }
                    cellStyle.getFont().setFontName(fontName);
                }
                if (fontHeight != null && fontHeight.length() > 0) {
                    if (cellStyle.getFont() == null) {
                        cellStyle.setFont(new Font());
                    }
                    try {
                        cellStyle.getFont().setFontHeight(Short.parseShort(fontHeight));
                    }
                    catch (NumberFormatException e) {
                        this.log.error((Object)("\u5b57\u4f53\u9ad8\u5ea6\u503c\u4e3a\u975e\u6cd5\u6570\u5b57\uff01" + fontHeight));
                        logger.error("errorMsg:", (Throwable)e);
                    }
                }
            }
            if (boldElement != null && (isBold = boldElement.getTextTrim()) != null && isBold.equalsIgnoreCase("true")) {
                cellStyle.getFont().setBold(true);
            }
        }
        if ((borderElement = cellStyleElement.element("border")) != null) {
            String strLeft = borderElement.elementTextTrim("left");
            String strRight = borderElement.elementTextTrim("right");
            String strTop = borderElement.elementTextTrim("top");
            String strBottom = borderElement.elementTextTrim("bottom");
            if (cellStyle.getBorder() == null) {
                cellStyle.setBorder(new Border());
            }
            if (strLeft != null && strLeft.length() > 0) {
                cellStyle.getBorder().setBorderLeft(Short.parseShort(strLeft));
            }
            if (strRight != null && strRight.length() > 0) {
                cellStyle.getBorder().setBorderRight(Short.parseShort(strRight));
            }
            if (strTop != null && strTop.length() > 0) {
                cellStyle.getBorder().setBorderTop(Short.parseShort(strTop));
            }
            if (strBottom != null && strBottom.length() > 0) {
                cellStyle.getBorder().setBorderBottom(Short.parseShort(strBottom));
            }
        }
        if ((pictureElement = cellStyleElement.element("picture")) != null) {
            String width = pictureElement.elementTextTrim("width");
            String height = pictureElement.elementTextTrim("height");
            if (width != null && width.length() > 0) {
                if (cellStyle.getPicture() == null) {
                    cellStyle.setPicture(new Picture());
                }
                cellStyle.getPicture().setWidth(Double.parseDouble(width));
            }
            if (height != null && height.length() > 0) {
                if (cellStyle.getPicture() == null) {
                    cellStyle.setPicture(new Picture());
                }
                cellStyle.getPicture().setHeight(Double.parseDouble(height));
            }
        } else {
            if (cellStyle.getPicture() == null) {
                cellStyle.setPicture(new Picture());
            }
            cellStyle.getPicture().setHeight(1.0);
            cellStyle.getPicture().setWidth(1.0);
        }
        String strAutoFill = cellStyleElement.elementTextTrim("autoFill");
        if (strAutoFill != null && strAutoFill.equalsIgnoreCase("true")) {
            cellStyle.setAutoFill(true);
        }
        if ((strWrapText = cellStyleElement.elementTextTrim("wrapText")) != null && strWrapText.equalsIgnoreCase("true")) {
            cellStyle.setWrapText(true);
        }
        cellStyle.setParalletAlignment(cellStyleElement.elementTextTrim("paralletAlignment"));
        cellStyle.setVerticalAlignment(cellStyleElement.elementTextTrim("verticalAlignment"));
        Element mergedCellElement = cellStyleElement.element("mergedCell");
        if (mergedCellElement != null) {
            String strToY;
            String strToX;
            String strFromY;
            String strFromX = mergedCellElement.elementTextTrim("fromx");
            if (strFromX != null && strFromX.length() > 0) {
                if (cellStyle.getMergedCell() == null) {
                    cellStyle.setMergedCell(new MergedCell());
                }
                cellStyle.getMergedCell().setFromX(strFromX);
            }
            if ((strFromY = mergedCellElement.elementTextTrim("fromy")) != null && strFromY.length() > 0) {
                if (cellStyle.getMergedCell() == null) {
                    cellStyle.setMergedCell(new MergedCell());
                }
                cellStyle.getMergedCell().setFromY(Short.parseShort(strFromY));
            }
            if ((strToX = mergedCellElement.elementTextTrim("tox")) != null && strToX.length() > 0) {
                if (cellStyle.getMergedCell() == null) {
                    cellStyle.setMergedCell(new MergedCell());
                }
                cellStyle.getMergedCell().setToX(strToX);
            }
            if ((strToY = mergedCellElement.elementTextTrim("toy")) != null && strToY.length() > 0) {
                if (cellStyle.getMergedCell() == null) {
                    cellStyle.setMergedCell(new MergedCell());
                }
                cellStyle.getMergedCell().setToY(Short.parseShort(strToY));
            }
        }
        return cellStyle;
    }

    private ComeFrom parseComeFromElement(Element comeFromElement) {
        Element attributeElement;
        ComeFrom comeFrom = new ComeFrom();
        Element pojoElement = comeFromElement.element("pojoName");
        if (pojoElement != null) {
            String strPojo = pojoElement.getTextTrim();
            if (strPojo == null || strPojo.equals("")) {
                this.log.error((Object)"\u914d\u7f6e\u6587\u4ef6\u4e2dcomeFrom\u4e0b\u7684pojoName\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                comeFrom.setPojoName(strPojo);
            }
        }
        if ((attributeElement = comeFromElement.element("attribute")) != null) {
            String strAttribute = attributeElement.getTextTrim();
            if (strAttribute == null || strAttribute.equals("")) {
                this.log.error((Object)"\u914d\u7f6e\u6587\u4ef6\u4e2dcomeFrom\u4e0b\u7684attribute\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                comeFrom.setAttribute(strAttribute);
            }
        }
        return comeFrom;
    }

    private Group parseGroupElement(Element groupElement) {
        String strInsert;
        if (groupElement == null) {
            return null;
        }
        Group group = new Group();
        String groupId = groupElement.attributeValue("id");
        if (groupId == null || groupId.length() == 0) {
            this.log.error((Object)"groupId\u4e3a\u7a7a\uff0c\u8fd9\u5c06\u5bfc\u81f4access\u8bfb\u5199\u51fa\u9519");
        }
        group.setId(groupId);
        String beginRow = groupElement.elementTextTrim("beginRow");
        if (beginRow != null && beginRow.length() > 0) {
            try {
                group.setBeginRow(Integer.parseInt(beginRow));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"group\u7684\u8d77\u59cb\u884c\u6216\u8d77\u59cb\u5217\u4e3a\u975e\u6cd5\u6570\u5b57\uff01");
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((strInsert = groupElement.elementTextTrim("insert")) != null && strInsert.equalsIgnoreCase("true")) {
            group.setInsert(true);
        }
        List itemList = groupElement.elements("item");
        for (int i = 0; i < itemList.size(); ++i) {
            Item tempItem = this.parseItemElement((Element)itemList.get(i));
            if (tempItem == null) continue;
            group.getItemList().add(tempItem);
        }
        return group;
    }

    private Item parseItemElement(Element itemElement) {
        Element cellStyleElement;
        Element precisionElement;
        Element valueTypeElement;
        Element fieldElement;
        if (itemElement == null) {
            return null;
        }
        Item item = new Item();
        Element rowElement = itemElement.element("beginColumn");
        if (rowElement != null) {
            String strColumn = rowElement.getTextTrim();
            try {
                item.setBeginColumn(Integer.parseInt(strColumn));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("beginColumn\u7684\u503c\u4e0d\u662f\u6570\u5b57!row=" + strColumn));
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((fieldElement = itemElement.element("field")) != null) {
            String strField = fieldElement.getTextTrim();
            if (strField == null || strField.length() == 0) {
                this.log.error((Object)"column\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                item.setField(Integer.parseInt(strField.substring(1, strField.length() - 1)));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("column\u7684\u503c\u65e0\u6548\uff01\u683c\u5f0f\u5e94\u8be5\u4e3a[5] =" + strField));
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((valueTypeElement = itemElement.element("valuetype")) != null) {
            item.setValueType(valueTypeElement.getTextTrim());
        }
        if ((precisionElement = itemElement.element("precision")) != null) {
            try {
                item.setPrecision(Integer.parseInt(precisionElement.getTextTrim()));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"\u5c0f\u6570\u70b9\u4fdd\u7559\u7684\u4e2a\u6570\u4e0d\u662f\u6709\u6548\u6570\u5b57\uff01");
                logger.error("errorMsg:", (Throwable)e);
            }
        }
        if ((cellStyleElement = itemElement.element("style")) != null) {
            item.setCellStyle(this.parseCellStyleElement(cellStyleElement));
        } else {
            this.log.error((Object)"\u6ca1\u6709\u914d\u7f6estyle\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return item;
    }

    private List parseStringToList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (str == null || str.length() == 0) {
            return list;
        }
        StringBuffer strBuf = new StringBuffer(str);
        while (strBuf.indexOf(",") != -1) {
            int index = strBuf.indexOf(",");
            String temp = strBuf.substring(0, index);
            if (temp.length() > 0) {
                list.add(temp);
            }
            strBuf.delete(0, index + 1);
        }
        if (strBuf.length() > 0) {
            list.add(strBuf.toString());
        }
        return list;
    }
}

