/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils.printexcel.access;

import cn.gtmap.estateplat.bank.utils.CommonUtil;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.XMLParse;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Cell;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Group;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Sheet;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.Single;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.CellStyle;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.ComeFrom;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Font;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Item;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.MergedCell;
import cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Picture;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.read.biff.BiffException;
import jxl.write.Border;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteSheet {
    private Logger logger = LoggerFactory.getLogger(WriteSheet.class);
    String xslPath = "\\static\\excel\\temp\\";
    String xmlPath = "\\static\\excel\\xml\\";

    public String execute(Map groupMap, Object[] pojos, String xls, String xml, HttpServletRequest request) {
        String XlsName = new Date().getTime() + ".xls";
        String url = request.getRealPath("/");
        WritableWorkbook writableworkbook = null;
        Workbook rw = null;
        WorkbookSettings setting = new WorkbookSettings();
        setting.setEncoding("ISO-8859-1");
        try {
            rw = Workbook.getWorkbook((File)new File(request.getRealPath("/static\\excel\\template"), xls), (WorkbookSettings)setting);
            writableworkbook = Workbook.createWorkbook((File)new File(url + this.xslPath + "\\" + XlsName), (Workbook)rw);
        }
        catch (BiffException e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        XMLParse xmlParse = new XMLParse();
        StringBuilder xmlBuff = new StringBuilder(url);
        xmlBuff.append(this.xmlPath);
        xmlBuff.append(xml);
        List xmlList = xmlParse.loadXml(xmlBuff.toString());
        for (int i = 0; i < xmlList.size(); ++i) {
            Sheet sheet = (Sheet)xmlList.get(i);
            String sheetName = sheet.getName();
            WritableSheet writablesheet = writableworkbook.getSheet(sheetName);
            List seqList = sheet.getSequenceList();
            for (int j = 0; j < seqList.size(); ++j) {
                String sq = (String)seqList.get(j);
                HashMap elementMap = (HashMap)sheet.getElementMap();
                if (!elementMap.containsKey(sq)) continue;
                Object elementObj = elementMap.get(sq);
                if (elementObj instanceof Single) {
                    Picture picture;
                    int column;
                    int row;
                    Cell cell;
                    Object value;
                    block63: {
                        Group preGroup;
                        String preGroupKey;
                        int t;
                        Single single = (Single)elementObj;
                        List cellist = single.getCellList();
                        if (!CollectionUtils.isNotEmpty((Collection)cellist)) continue;
                        value = null;
                        cell = (Cell)cellist.get(0);
                        row = cell.getRow();
                        if (row < 0) {
                            for (t = j - 1; t >= 0; --t) {
                                preGroupKey = (String)seqList.get(t);
                                if (!elementMap.containsKey(preGroupKey) || !(elementMap.get(preGroupKey) instanceof Group)) continue;
                                preGroup = (Group)elementMap.get(preGroupKey);
                                int endRow = preGroup.getEndRow();
                                row = Math.abs(row) + endRow - 1;
                                break;
                            }
                        }
                        if (row == 10000) {
                            for (t = j - 1; t >= 0; --t) {
                                preGroupKey = (String)seqList.get(t);
                                if (!elementMap.containsKey(preGroupKey) || !(elementMap.get(preGroupKey) instanceof Group)) continue;
                                preGroup = (Group)elementMap.get(preGroupKey);
                                int beginRow = preGroup.getBeginRow();
                                row = beginRow - 1;
                                break;
                            }
                        }
                        column = cell.getColumn();
                        ComeFrom cf = cell.getComeFrom();
                        String pojoName = cf.getPojoName();
                        String attribute = cf.getAttribute();
                        int v = attribute.indexOf(",");
                        if (v != -1) {
                            attribute = attribute.substring(0, v);
                        }
                        if (pojoName != null && pojoName.equalsIgnoreCase("request")) {
                            if (request.getAttribute(attribute) != null) {
                                value = request.getAttribute(attribute);
                            }
                        } else if (pojoName != null && pojoName.equalsIgnoreCase("template")) {
                            value = writablesheet.getCell(column, row).getContents();
                        } else {
                            try {
                                Class<?> c = Class.forName(pojoName);
                                if (pojos == null || pojos.length == 0) {
                                    this.logger.error("\u4f20\u9012\u8fc7\u6765\u7684pojo\u5bf9\u8c61\u6570\u7ec4\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff01");
                                    break block63;
                                }
                                for (int t2 = 0; t2 < pojos.length; ++t2) {
                                    if (!c.isInstance(pojos[t2])) continue;
                                    StringBuilder methodName = new StringBuilder("get");
                                    methodName.append(attribute.substring(0, 1).toUpperCase());
                                    methodName.append(attribute.substring(1));
                                    Method meth = c.getMethod(methodName.toString(), null);
                                    value = meth.invoke(pojos[t2], null);
                                    break;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (SecurityException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (NoSuchMethodException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (IllegalArgumentException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (InvocationTargetException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                        }
                    }
                    String valueType = cell.getValueType();
                    if (value == null) {
                        value = "";
                    } else if (valueType != null && valueType.equalsIgnoreCase("double")) {
                        int precision = cell.getPrecision();
                        if (!value.equals("")) {
                            value = CommonUtil.DoubleToString((Double)Double.parseDouble(value.toString()), (Integer)precision);
                        }
                    }
                    CellStyle cellStyle = cell.getCellStyle();
                    WritableCellFormat cellFormat = this.getCellFormat(cellStyle);
                    try {
                        cellFormat.setBackground(Colour.WHITE);
                    }
                    catch (WriteException e) {
                        this.logger.error("errorMsg:", (Throwable)e);
                    }
                    MergedCell mergedCell = cellStyle.getMergedCell();
                    if (mergedCell != null) {
                        String fromX = mergedCell.getFromX();
                        int fromY = mergedCell.getFromY();
                        String toX = mergedCell.getToX();
                        int toY = mergedCell.getToY();
                        int groupEndRow = 0;
                        for (int t = j - 1; t >= 0; --t) {
                            String preGroupKey = (String)seqList.get(t);
                            if (!elementMap.containsKey(preGroupKey) || !(elementMap.get(preGroupKey) instanceof Group)) continue;
                            Group preGroup = (Group)elementMap.get(preGroupKey);
                            groupEndRow = preGroup.getEndRow();
                            break;
                        }
                        if (fromY > 0) {
                            fromY = groupEndRow + fromY;
                            toY += groupEndRow;
                        }
                        try {
                            writablesheet.mergeCells(Integer.parseInt(fromX), fromY, Integer.parseInt(toX), toY);
                        }
                        catch (RowsExceededException e) {
                            this.logger.error("errorMsg:", (Throwable)e);
                        }
                        catch (NumberFormatException e) {
                            this.logger.error("errorMsg:", (Throwable)e);
                        }
                        catch (WriteException e) {
                            this.logger.error("errorMsg:", (Throwable)e);
                        }
                    }
                    if ((picture = cellStyle.getPicture()) != null && valueType != null && valueType.equalsIgnoreCase("jpeg")) {
                        this.logger.info("\u5f00\u59cb\u5199\u5165\u7b7e\u540d\u56fe\u7247...");
                        double imageHeight = picture.getHeight();
                        double imageWidth = picture.getWidth();
                        if (!(value instanceof Blob)) continue;
                        ByteArrayOutputStream image = this.getImage((Blob)value);
                        writablesheet.addImage(new WritableImage((double)column, (double)row, imageWidth, imageHeight, image.toByteArray()));
                        this.logger.info("\u6210\u529f\u5199\u5165\u7b7e\u540d\u56fe\u7247\uff01");
                        continue;
                    }
                    Label label = new Label(column, row, value.toString(), (CellFormat)cellFormat);
                    try {
                        writablesheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        this.logger.error("errorMsg:", (Throwable)e);
                    }
                    catch (WriteException e) {
                        this.logger.error("errorMsg:", (Throwable)e);
                    }
                    continue;
                }
                if (elementObj instanceof Group) {
                    Group group = (Group)elementObj;
                    String groupId = group.getId();
                    boolean insert = group.isInsert();
                    List pageList = (List)groupMap.get(groupId);
                    int groupSize = pageList.size();
                    int beginRow = group.getBeginRow();
                    if (beginRow < 0) {
                        for (int t = j - 1; t >= 0; --t) {
                            String preGroupKey = (String)seqList.get(t);
                            if (!elementMap.containsKey(preGroupKey) || !(elementMap.get(preGroupKey) instanceof Group)) continue;
                            Group preGroup = (Group)elementMap.get(preGroupKey);
                            int endRow = preGroup.getEndRow();
                            beginRow = Math.abs(beginRow) + endRow - 1;
                            break;
                        }
                    }
                    group.setGroupSize(groupSize);
                    group.setEndRow(beginRow + groupSize);
                    group.setBeginRow(beginRow);
                    List itemList = group.getItemList();
                    HashMap<String, WritableCellFormat> formatMap = new HashMap<String, WritableCellFormat>();
                    HashMap<String, Item> itemMap = new HashMap<String, Item>();
                    HashMap<String, String> mergedMap = new HashMap<String, String>();
                    for (int k = 0; k < itemList.size(); ++k) {
                        Item item = (Item)itemList.get(k);
                        int field = item.getField();
                        CellStyle cellStyle = item.getCellStyle();
                        WritableCellFormat cellFormat = this.getCellFormat(cellStyle);
                        MergedCell mergedCell = cellStyle.getMergedCell();
                        if (mergedCell != null) {
                            String fromX = mergedCell.getFromX();
                            String toX = mergedCell.getToX();
                            mergedMap.put(fromX, toX);
                        }
                        formatMap.put(field + "", cellFormat);
                        itemMap.put(field + "", item);
                    }
                    for (int m = 0; m < pageList.size(); ++m) {
                        String[] arrs = (String[])pageList.get(m);
                        if (insert) {
                            writablesheet.insertRow(beginRow + m);
                        }
                        for (int n = 0; n < arrs.length; ++n) {
                            int beginColumn;
                            if (!formatMap.containsKey(n + "")) continue;
                            String value = arrs[n];
                            Item tempItem = (Item)itemMap.get(n + "");
                            String valueType = tempItem.getValueType();
                            if (valueType.equalsIgnoreCase("Double")) {
                                int pricision = tempItem.getPrecision();
                                value = arrs[n] == null || arrs[n].equals("null") || arrs[n].equals("") ? "" : CommonUtil.DoubleToString((Double)Double.parseDouble(arrs[n]), (Integer)pricision);
                            }
                            if (valueType.equalsIgnoreCase("String")) {
                                value = arrs[n] + "";
                                value = value.replace("null", "").trim();
                            }
                            if (mergedMap.containsKey((beginColumn = tempItem.getBeginColumn()) + "")) {
                                try {
                                    writablesheet.mergeCells(beginColumn, beginRow + m, Integer.parseInt(mergedMap.get(beginColumn + "").toString()), beginRow + m);
                                }
                                catch (RowsExceededException e) {
                                    this.logger.error("errorMsg:", (Throwable)e);
                                }
                                catch (NumberFormatException e) {
                                    this.logger.error("errorMsg:", (Throwable)e);
                                }
                                catch (WriteException e) {
                                    this.logger.error("errorMsg:", (Throwable)e);
                                }
                            }
                            Label label = new Label(beginColumn, beginRow + m, value, (CellFormat)((WritableCellFormat)formatMap.get(n + "")));
                            try {
                                writablesheet.addCell((WritableCell)label);
                                continue;
                            }
                            catch (RowsExceededException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                                continue;
                            }
                            catch (WriteException e) {
                                this.logger.error("errorMsg:", (Throwable)e);
                            }
                        }
                    }
                    formatMap.clear();
                    itemMap.clear();
                    mergedMap.clear();
                    continue;
                }
                this.logger.error("\u8be5ElementObj\u76ee\u524d\u5c1a\u672a\u88ab\u652f\u6301=" + elementObj);
            }
        }
        try {
            writableworkbook.write();
            writableworkbook.close();
        }
        catch (Exception e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        rw.close();
        return request.getContextPath() + "/" + this.xslPath.replaceAll("\\\\", "/") + "" + XlsName;
    }

    private String JSforExcel(String url) {
        StringBuilder sb = new StringBuilder("<script language=javascript>");
        sb.append("openExcelWindow('");
        sb.append(url);
        sb.append("','excel');");
        sb.append("</script>");
        return sb.toString();
    }

    private void writeSingle(Single single) {
    }

    private void WriteGroup(Group group) {
    }

    private WritableCellFormat getCellFormat(CellStyle cellStyle) {
        short bottom = 0;
        short top = 0;
        short left = 0;
        short right = 0;
        Font font = cellStyle.getFont();
        String fontName = font.getFontName();
        short fontHeight = font.getFontHeight();
        boolean isBold = font.isBold();
        cn.gtmap.estateplat.bank.utils.printexcel.xmlparse.element.cellstyle.Border border = cellStyle.getBorder();
        if (border != null) {
            bottom = border.getBorderBottom();
            top = border.getBorderTop();
            left = border.getBorderLeft();
            right = border.getBorderRight();
        }
        String pa = cellStyle.getParalletAlignment();
        String va = cellStyle.getVerticalAlignment();
        boolean isAutoFill = cellStyle.isAutoFill();
        boolean isWrapText = cellStyle.isWrapText();
        WritableFont cellFont = isBold ? new WritableFont(WritableFont.createFont((String)fontName), (int)fontHeight, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK) : new WritableFont(WritableFont.createFont((String)fontName), (int)fontHeight, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
        try {
            cellFormat.setWrap(isWrapText);
            cellFormat.setShrinkToFit(isAutoFill);
            if (left == 1) {
                cellFormat.setBorder(Border.LEFT, BorderLineStyle.THIN);
            } else {
                cellFormat.setBorder(Border.LEFT, BorderLineStyle.NONE);
            }
            if (right == 1) {
                cellFormat.setBorder(Border.RIGHT, BorderLineStyle.THIN);
            } else {
                cellFormat.setBorder(Border.RIGHT, BorderLineStyle.NONE);
            }
            if (bottom == 1) {
                cellFormat.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
            } else {
                cellFormat.setBorder(Border.BOTTOM, BorderLineStyle.NONE);
            }
            if (top == 1) {
                cellFormat.setBorder(Border.TOP, BorderLineStyle.THIN);
            } else {
                cellFormat.setBorder(Border.TOP, BorderLineStyle.NONE);
            }
            if (pa != null) {
                if (pa.equalsIgnoreCase("left")) {
                    cellFormat.setAlignment(Alignment.LEFT);
                }
                if (pa.equalsIgnoreCase("center")) {
                    cellFormat.setAlignment(Alignment.CENTRE);
                }
                if (pa.equalsIgnoreCase("right")) {
                    cellFormat.setAlignment(Alignment.RIGHT);
                }
            }
            if (va != null) {
                if (va.equalsIgnoreCase("top")) {
                    cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
                }
                if (va.equalsIgnoreCase("bottom")) {
                    cellFormat.setVerticalAlignment(VerticalAlignment.BOTTOM);
                }
                if (va.equalsIgnoreCase("center")) {
                    cellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
                }
                if (va.equalsIgnoreCase("justify")) {
                    cellFormat.setVerticalAlignment(VerticalAlignment.JUSTIFY);
                }
            }
        }
        catch (WriteException e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        return cellFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteArrayOutputStream getImage(Blob blob) {
        ByteArrayOutputStream BOS = new ByteArrayOutputStream();
        if (blob == null) {
            return BOS;
        }
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is == null || blob.length() == 0L) {
                this.logger.info("--\u4e0d\u5b58\u5728\u7b7e\u540d\u56fe\u7247\uff01");
            } else {
                byte[] buf = new byte[8192];
                while (is.read(buf) != -1) {
                    BOS.write(buf);
                }
                is.close();
                BOS.close();
                buf = null;
            }
        }
        catch (Exception e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error("errorMsg:", (Throwable)e);
                }
            }
        }
        return BOS;
    }
}

