/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PDFAndBase64ConvertUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64StringToPDFToPage(String base64String, String fileName, HttpServletResponse httpServletResponse) {
        BASE64Decoder decoder = new BASE64Decoder();
        ByteArrayOutputStream baos = null;
        ServletOutputStream sos = null;
        try {
            byte[] bytes = decoder.decodeBuffer(base64String);
            baos = new ByteArrayOutputStream();
            baos.write(bytes);
            if (baos != null) {
                httpServletResponse.setContentType("application/pdf");
                httpServletResponse.setContentLength(baos.size());
                httpServletResponse.setHeader("Expires", "0");
                httpServletResponse.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                httpServletResponse.setHeader("Pragma", "public");
                fileName = fileName + ".pdf";
                fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                httpServletResponse.setHeader("Content-Disposition", "filename=" + fileName);
                sos = httpServletResponse.getOutputStream();
                baos.writeTo((OutputStream)sos);
                sos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                sos.close();
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64StringToPDF(String base64String, File file) {
        BASE64Decoder decoder = new BASE64Decoder();
        BufferedInputStream bin = null;
        FileOutputStream fout = null;
        FilterOutputStream bout = null;
        try {
            byte[] bytes = decoder.decodeBuffer(base64String);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            bin = new BufferedInputStream(bais);
            fout = new FileOutputStream(file);
            bout = new BufferedOutputStream(fout);
            byte[] buffers = new byte[1024];
            int len = bin.read(buffers);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffers, 0, len);
                len = bin.read(buffers);
            }
            ((BufferedOutputStream)bout).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bout.close();
                fout.close();
                bin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pdfToBase64(File file) {
        BASE64Encoder encoder = new BASE64Encoder();
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            String string = encoder.encodeBuffer(bytes).trim();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fin.close();
                bin.close();
                baos.close();
                bout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdf2png(String base64String, String fileName, HttpServletResponse httpServletResponse) {
        BASE64Decoder decoder = new BASE64Decoder();
        Object baos = null;
        ServletOutputStream sos = null;
        PDDocument doc = null;
        ByteArrayInputStream in = null;
        try {
            httpServletResponse.setContentType("image/png");
            fileName = fileName + ".png";
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            httpServletResponse.setHeader("Content-Disposition", "filename=" + fileName);
            sos = httpServletResponse.getOutputStream();
            byte[] bytes = decoder.decodeBuffer(base64String);
            in = new ByteArrayInputStream(bytes);
            doc = PDDocument.load((InputStream)in);
            int pageCount = doc.getNumberOfPages();
            PDFRenderer renderer = new PDFRenderer(doc);
            int width = 0;
            int shiftHeight = 0;
            BufferedImage imageResult = null;
            for (int i = 0; i < pageCount; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, 105.0f, ImageType.RGB);
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                if (i == 0) {
                    width = imageWidth;
                    imageResult = new BufferedImage(width, imageHeight * pageCount, 1);
                } else {
                    shiftHeight += imageHeight;
                }
                int[] singleImgRGB = image.getRGB(0, 0, width, imageHeight, null, 0, width);
                imageResult.setRGB(0, shiftHeight, width, imageHeight, singleImgRGB, 0, width);
            }
            ImageIO.write(imageResult, "PNG", (OutputStream)httpServletResponse.getOutputStream());
            doc.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
                if (in != null) {
                    in.close();
                }
                if (sos != null) {
                    sos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

