/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HttpsClientFactoryBean
implements FactoryBean<HttpClient>,
InitializingBean {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 100;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 30000;
    private static final int DEFAULT_TIME_TO_LIVE_MILLISECONDS = 30000;
    private int maxTotalConnections = 100;
    private int maxConnectionsPerRoute = 20;
    private int soTimeout = 30000;
    private int connectionTimeout = 30000;
    private int timeToLive = 30000;
    private HttpClient httpClient;

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeout(int timeout) {
        this.setSoTimeout(timeout);
        this.setConnectionTimeout(timeout);
    }

    public HttpClient getObject() throws Exception {
        return this.httpClient;
    }

    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build());
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, null, null, null, (long)this.timeToLive, TimeUnit.MILLISECONDS);
        connectionManager.setMaxTotal(this.maxTotalConnections);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(this.soTimeout).setConnectTimeout(this.connectionTimeout).build();
        this.httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
    }
}

