/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetQRcode {
    private static Logger logger = LoggerFactory.getLogger(GetQRcode.class);

    public static void encoderQRCode(String content, String imgPath, HttpServletResponse response) {
        try {
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            String s = URLDecoder.decode(content, "utf-8");
            byte[] contentBytes = s.getBytes("utf-8");
            int picSize = 0;
            if (contentBytes.length < 124) {
                qrcodeHandler.setQrcodeVersion(8);
                picSize = 148;
            }
            BufferedImage bufImg = new BufferedImage(picSize, picSize, 1);
            Graphics2D gs = bufImg.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, picSize, picSize);
            gs.setColor(Color.BLACK);
            int pixoff = 2;
            if (contentBytes.length > 0) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; ++i) {
                    for (int j = 0; j < codeOut.length; ++j) {
                        if (!codeOut[j][i]) continue;
                        gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                    }
                }
            } else {
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
            }
            gs.dispose();
            bufImg.flush();
            if (StringUtils.isNotBlank((CharSequence)imgPath)) {
                File imgFile = new File(imgPath);
                ImageIO.write((RenderedImage)bufImg, "jpg", imgFile);
            } else {
                ImageIO.write((RenderedImage)bufImg, "jpg", (OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            logger.error("errorMsg:", (Throwable)e);
        }
    }
}

