/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static Workbook ExportExcel(String excelName, List<Map<String, Object>> title, List<Map<String, Object>> rowsList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFCellStyle cellStyleString = workbook.createCellStyle();
        HSSFFont fontforString = workbook.createFont();
        cellStyleString.setAlignment((short)2);
        cellStyleString.setVerticalAlignment((short)1);
        cellStyleString.setAlignment((short)2);
        fontforString.setFontName("SimSun");
        fontforString.setFontHeightInPoints((short)12);
        cellStyleString.setFont((Font)fontforString);
        cellStyleString.setBorderBottom((short)1);
        cellStyleString.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleString.setBorderLeft((short)1);
        cellStyleString.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleString.setBorderRight((short)1);
        cellStyleString.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleString.setBorderTop((short)1);
        cellStyleString.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setAlignment((short)2);
        font.setFontName("SimSun");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont((Font)font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFRow row = sheet.createRow(0);
        if (title != null && title.size() > 0) {
            for (int i = 0; i < title.size(); ++i) {
                row.createCell(i).setCellValue((String)title.get(i).get("value"));
                row.getCell(i).setCellStyle((CellStyle)cellStyleString);
                sheet.setColumnWidth(i, 6400);
            }
        }
        if (rowsList != null && rowsList.size() > 0) {
            for (int j = 0; j < rowsList.size(); ++j) {
                HSSFRow datarow = sheet.createRow(j + 1);
                for (int m = 0; m < title.size(); ++m) {
                    String textValue = "";
                    if (rowsList.get(j).get((String)title.get(m).get("key")) != null) {
                        Object value = rowsList.get(j).get(title.get(m).get("key"));
                        if (value instanceof Date && value != null) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            textValue = sdf.format(date);
                        } else {
                            textValue = value instanceof String && value != null ? (String)value : (value instanceof BigDecimal && value != null ? String.valueOf(value) : "");
                        }
                    }
                    datarow.createCell(m).setCellValue(textValue);
                    datarow.getCell(m).setCellStyle((CellStyle)cellStyleString);
                }
            }
        }
        return workbook;
    }

    public static void outputExcel(HttpServletResponse response, List<Map<String, Object>> titleList, List<Map<String, Object>> rowsList, String excelName) {
        try {
            response.setContentType("application/x-download");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(excelName.getBytes("gbk"), "iso8859-1") + ".xls");
            Workbook wb = ExcelUtil.ExportExcel((String)excelName, titleList, rowsList);
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error("errorMsg:", (Throwable)e);
        }
    }
}

