/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.bank.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelReader {
    private static Logger logger = LoggerFactory.getLogger(ExcelReader.class);

    public static List<String> readExcelContent(InputStream is, int sheetAt) throws IOException, InvalidFormatException {
        Sheet sheet = null;
        Row row = null;
        ArrayList list = Lists.newArrayList();
        String str = "";
        Workbook wb = WorkbookFactory.create((InputStream)is);
        sheet = wb.getSheetAt(sheetAt);
        int rowNum = sheet.getLastRowNum();
        row = sheet.getRow(0);
        int colNum = row.getPhysicalNumberOfCells();
        for (int i = 1; i <= rowNum; ++i) {
            row = sheet.getRow(i);
            if (null == row.getCell(0) || !StringUtils.isNotBlank((CharSequence)String.valueOf(row.getCell(0))) || !StringUtils.isNotBlank((CharSequence)String.valueOf(row.getCell(1)))) continue;
            for (int j = 0; j < colNum; ++j) {
                str = str + ExcelReader.getCellFormatValue((Cell)row.getCell((int)((short)j))).trim() + "$";
            }
            str = StringUtils.substring((String)str, (int)0, (int)(str.length() - 1));
            list.add(str);
            str = "";
        }
        return list;
    }

    private static String getStringCellValue(Cell cell) {
        String strCell = "";
        switch (cell.getCellType()) {
            case 1: {
                strCell = cell.getStringCellValue();
                break;
            }
            case 0: {
                strCell = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 4: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                strCell = "";
                break;
            }
            default: {
                strCell = "";
            }
        }
        if (strCell.equals("") || strCell == null) {
            return "";
        }
        if (cell == null) {
            return "";
        }
        return strCell;
    }

    private static String getDateCellValue(Cell cell) {
        String result = "";
        try {
            int cellType = cell.getCellType();
            if (cellType == 0) {
                Date date = cell.getDateCellValue();
                result = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
            } else if (cellType == 1) {
                String date = ExcelReader.getStringCellValue((Cell)cell);
                result = date.replaceAll("[\u5e74\u6708]", "-").replace("\u65e5", "").trim();
            } else if (cellType == 3) {
                result = "";
            }
        }
        catch (Exception e) {
            System.out.println("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e!");
            logger.error("errorMsg:", (Throwable)e);
        }
        return result;
    }

    private static String getCellFormatValue(Cell cell) {
        String cellvalue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        cellvalue = sdf.format(date);
                        break;
                    }
                    cellvalue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellvalue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellvalue = " ";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

